/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-12-04 15:33:23 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=562 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=5154 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=1467 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_activities` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `agent_id` int(11) DEFAULT NULL,
  `booking_id` int(11) DEFAULT NULL,
  `service_id` int(11) DEFAULT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `location_id` int(11) DEFAULT NULL,
  `order_id` int(11) DEFAULT NULL,
  `order_item_id` int(11) DEFAULT NULL,
  `code` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `initiated_by` varchar(100) DEFAULT NULL,
  `initiated_by_id` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `coupon_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_agent_meta` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `object_id` mediumint(9) NOT NULL,
  `meta_key` varchar(110) NOT NULL,
  `meta_value` text DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key_index` (`meta_key`),
  KEY `object_id_index` (`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_agents` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `avatar_image_id` int(11) DEFAULT NULL,
  `bio_image_id` int(11) DEFAULT NULL,
  `first_name` varchar(255) NOT NULL,
  `last_name` varchar(255) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `bio` text DEFAULT NULL,
  `features` text DEFAULT NULL,
  `email` varchar(110) NOT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `custom_hours` tinyint(1) DEFAULT NULL,
  `wp_user_id` int(11) DEFAULT NULL,
  `status` varchar(20) NOT NULL,
  `extra_emails` text DEFAULT NULL,
  `extra_phones` text DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `email_index` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_agents_services` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `agent_id` int(11) NOT NULL,
  `service_id` int(11) NOT NULL,
  `location_id` int(11) DEFAULT NULL,
  `is_custom_hours` tinyint(1) DEFAULT NULL,
  `is_custom_price` tinyint(1) DEFAULT NULL,
  `is_custom_duration` tinyint(1) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `agent_id_index` (`agent_id`),
  KEY `service_id_index` (`service_id`),
  KEY `location_id_index` (`location_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_blocked_periods` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `summary` text DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `start_time` mediumint(9) DEFAULT NULL,
  `end_time` mediumint(9) DEFAULT NULL,
  `start_datetime_utc` datetime DEFAULT NULL,
  `end_datetime_utc` datetime DEFAULT NULL,
  `service_id` mediumint(9) DEFAULT NULL,
  `agent_id` mediumint(9) DEFAULT NULL,
  `location_id` mediumint(9) DEFAULT NULL,
  `server_timezone` varchar(100) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `start_date_index` (`start_date`),
  KEY `end_date_index` (`end_date`),
  KEY `service_id_index` (`service_id`),
  KEY `agent_id_index` (`agent_id`),
  KEY `location_id_index` (`location_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_booking_meta` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `object_id` mediumint(9) NOT NULL,
  `meta_key` varchar(110) NOT NULL,
  `meta_value` text DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key_index` (`meta_key`),
  KEY `object_id_index` (`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_bookings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `booking_code` varchar(10) DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `start_time` mediumint(9) DEFAULT NULL,
  `end_time` mediumint(9) DEFAULT NULL,
  `start_datetime_utc` datetime DEFAULT NULL,
  `end_datetime_utc` datetime DEFAULT NULL,
  `buffer_before` mediumint(9) NOT NULL,
  `buffer_after` mediumint(9) NOT NULL,
  `duration` mediumint(9) DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT 'pending',
  `customer_id` mediumint(9) NOT NULL,
  `service_id` mediumint(9) NOT NULL,
  `agent_id` mediumint(9) NOT NULL,
  `location_id` mediumint(9) DEFAULT NULL,
  `order_item_id` mediumint(9) DEFAULT NULL,
  `recurrence_id` mediumint(9) DEFAULT NULL,
  `total_attendees` mediumint(4) DEFAULT NULL,
  `customer_timezone` varchar(100) DEFAULT NULL,
  `server_timezone` varchar(100) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `start_date_index` (`start_date`),
  KEY `end_date_index` (`end_date`),
  KEY `status_index` (`status`),
  KEY `customer_id_index` (`customer_id`),
  KEY `service_id_index` (`service_id`),
  KEY `agent_id_index` (`agent_id`),
  KEY `location_id_index` (`location_id`),
  KEY `recurrence_id_index` (`recurrence_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_bundle_meta` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `object_id` mediumint(9) NOT NULL,
  `meta_key` varchar(110) NOT NULL,
  `meta_value` text DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key_index` (`meta_key`),
  KEY `object_id_index` (`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_bundles` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `short_description` text DEFAULT NULL,
  `charge_amount` decimal(20,4) DEFAULT NULL,
  `deposit_amount` decimal(20,4) DEFAULT NULL,
  `status` varchar(20) NOT NULL,
  `visibility` varchar(20) NOT NULL,
  `order_number` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `order_number_index` (`order_number`),
  KEY `status_index` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_bundles_services` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `bundle_id` mediumint(9) DEFAULT NULL,
  `service_id` mediumint(9) DEFAULT NULL,
  `total_attendees` mediumint(4) DEFAULT NULL,
  `duration` int(11) DEFAULT NULL,
  `quantity` mediumint(4) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bundle_id_index` (`bundle_id`),
  KEY `service_id_index` (`service_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_cart_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `cart_id` int(11) NOT NULL,
  `variant` varchar(55) DEFAULT NULL,
  `item_data` text DEFAULT NULL,
  `connected_cart_item_id` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `connected_cart_item_id_index` (`connected_cart_item_id`),
  KEY `cart_id_index` (`cart_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_cart_meta` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `object_id` mediumint(9) NOT NULL,
  `meta_key` varchar(110) NOT NULL,
  `meta_value` text DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key_index` (`meta_key`),
  KEY `object_id_index` (`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_carts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) DEFAULT NULL,
  `order_intent_id` int(11) DEFAULT NULL,
  `order_id` int(11) DEFAULT NULL,
  `coupon_code` varchar(100) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `uuid_index` (`uuid`),
  KEY `order_id_index` (`order_id`),
  KEY `order_intent_id_index` (`order_intent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_custom_prices` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `agent_id` int(11) NOT NULL,
  `service_id` int(11) NOT NULL,
  `location_id` int(11) NOT NULL,
  `is_price_variable` tinyint(1) DEFAULT NULL,
  `price_min` decimal(20,4) DEFAULT NULL,
  `price_max` decimal(20,4) DEFAULT NULL,
  `charge_amount` decimal(20,4) DEFAULT NULL,
  `is_deposit_required` tinyint(1) DEFAULT NULL,
  `deposit_amount` decimal(20,4) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `agent_id_index` (`agent_id`),
  KEY `service_id_index` (`service_id`),
  KEY `location_id_index` (`location_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_customer_meta` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `object_id` mediumint(9) NOT NULL,
  `meta_key` varchar(110) NOT NULL,
  `meta_value` text DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key_index` (`meta_key`),
  KEY `object_id_index` (`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_customer_otp_codes` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `contact_value` varchar(255) NOT NULL,
  `contact_type` varchar(30) NOT NULL,
  `delivery_method` varchar(30) NOT NULL,
  `otp_hash` varchar(255) NOT NULL,
  `expires_at` datetime NOT NULL,
  `status` varchar(30) NOT NULL DEFAULT 'active',
  `attempts` int(11) DEFAULT 0,
  `used_at` datetime DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_contact_status` (`contact_value`,`status`),
  KEY `idx_expires_status` (`expires_at`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_customers` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `first_name` varchar(255) DEFAULT NULL,
  `last_name` varchar(255) DEFAULT NULL,
  `email` varchar(320) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `avatar_image_id` int(11) DEFAULT NULL,
  `status` varchar(50) NOT NULL,
  `password` varchar(255) DEFAULT NULL,
  `activation_key` varchar(255) DEFAULT NULL,
  `account_nonse` varchar(255) DEFAULT NULL,
  `google_user_id` varchar(255) DEFAULT NULL,
  `facebook_user_id` varchar(255) DEFAULT NULL,
  `wordpress_user_id` int(11) DEFAULT NULL,
  `is_guest` tinyint(1) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `admin_notes` text DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `uuid` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid_index` (`uuid`),
  KEY `email_index` (`email`),
  KEY `status_index` (`status`),
  KEY `wordpress_user_id_index` (`wordpress_user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_location_categories` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `short_description` text DEFAULT NULL,
  `parent_id` mediumint(9) DEFAULT NULL,
  `selection_image_id` int(11) DEFAULT NULL,
  `order_number` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `order_number_index` (`order_number`),
  KEY `parent_id_index` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_locations` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `full_address` text DEFAULT NULL,
  `status` varchar(20) NOT NULL,
  `category_id` int(11) DEFAULT NULL,
  `order_number` int(11) DEFAULT NULL,
  `selection_image_id` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `status_index` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_order_intents` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `intent_key` varchar(55) NOT NULL,
  `customer_id` int(11) NOT NULL,
  `cart_items_data` text DEFAULT NULL,
  `restrictions_data` text DEFAULT NULL,
  `presets_data` text DEFAULT NULL,
  `payment_data` text DEFAULT NULL,
  `other_data` text DEFAULT NULL,
  `order_id` int(11) DEFAULT NULL,
  `booking_form_page_url` text DEFAULT NULL,
  `total` decimal(20,4) DEFAULT NULL,
  `subtotal` decimal(20,4) DEFAULT NULL,
  `coupon_code` varchar(100) DEFAULT NULL,
  `coupon_discount` decimal(20,4) DEFAULT NULL,
  `tax_total` decimal(20,4) DEFAULT NULL,
  `charge_amount` decimal(20,4) DEFAULT NULL,
  `specs_charge_amount` varchar(55) DEFAULT NULL,
  `price_breakdown` text DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT 'new',
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `intent_key_index` (`intent_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_order_invoices` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL,
  `invoice_number` varchar(10) DEFAULT NULL,
  `data` text DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT 'open',
  `charge_amount` decimal(20,4) DEFAULT NULL,
  `due_at` datetime DEFAULT NULL,
  `payment_portion` varchar(55) DEFAULT NULL,
  `access_key` varchar(36) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `invoice_number_index` (`invoice_number`),
  KEY `order_id_index` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_order_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL,
  `variant` varchar(55) DEFAULT NULL,
  `item_data` text DEFAULT NULL,
  `subtotal` decimal(20,4) DEFAULT NULL,
  `total` decimal(20,4) DEFAULT NULL,
  `coupon_code` varchar(100) DEFAULT NULL,
  `coupon_discount` decimal(20,4) DEFAULT NULL,
  `tax_total` decimal(20,4) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `order_id_index` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_order_meta` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `object_id` mediumint(9) NOT NULL,
  `meta_key` varchar(110) NOT NULL,
  `meta_value` text DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key_index` (`meta_key`),
  KEY `object_id_index` (`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_orders` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `subtotal` decimal(20,4) DEFAULT NULL,
  `total` decimal(20,4) DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT 'open',
  `fulfillment_status` varchar(30) NOT NULL DEFAULT 'not_fulfilled',
  `payment_status` varchar(30) NOT NULL DEFAULT 'not_paid',
  `source_id` varchar(100) DEFAULT NULL,
  `source_url` text DEFAULT NULL,
  `ip_address` varchar(55) DEFAULT NULL,
  `customer_id` int(11) NOT NULL,
  `customer_comment` text DEFAULT NULL,
  `confirmation_code` varchar(10) DEFAULT NULL,
  `price_breakdown` text DEFAULT NULL,
  `coupon_code` varchar(100) DEFAULT NULL,
  `coupon_discount` decimal(20,4) DEFAULT NULL,
  `tax_total` decimal(20,4) DEFAULT NULL,
  `initial_payment_data` text DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id_index` (`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_payment_requests` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL,
  `invoice_id` int(11) NOT NULL,
  `charge_amount` decimal(20,4) DEFAULT NULL,
  `due_at` datetime DEFAULT NULL,
  `portion` varchar(55) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_id_index` (`invoice_id`),
  KEY `order_id_index` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_process_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `process_id` int(11) NOT NULL,
  `object_id` int(11) NOT NULL,
  `object_model_type` varchar(55) DEFAULT NULL,
  `settings` text DEFAULT NULL,
  `to_run_after_utc` datetime DEFAULT NULL,
  `status` varchar(30) DEFAULT 'scheduled',
  `run_result` text DEFAULT NULL,
  `process_info` text DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_processes` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(110) NOT NULL,
  `event_type` varchar(110) NOT NULL,
  `actions_json` text DEFAULT NULL,
  `status` varchar(30) DEFAULT 'active',
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_recurrences` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `rules` text DEFAULT NULL,
  `overrides` text DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_service_categories` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `short_description` text DEFAULT NULL,
  `parent_id` mediumint(9) DEFAULT NULL,
  `selection_image_id` int(11) DEFAULT NULL,
  `order_number` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `order_number_index` (`order_number`),
  KEY `parent_id_index` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_service_meta` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `object_id` mediumint(9) NOT NULL,
  `meta_key` varchar(110) NOT NULL,
  `meta_value` text DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key_index` (`meta_key`),
  KEY `object_id_index` (`object_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_services` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `short_description` text DEFAULT NULL,
  `is_price_variable` tinyint(1) DEFAULT NULL,
  `price_min` decimal(20,4) DEFAULT NULL,
  `price_max` decimal(20,4) DEFAULT NULL,
  `charge_amount` decimal(20,4) DEFAULT NULL,
  `deposit_amount` decimal(20,4) DEFAULT NULL,
  `is_deposit_required` tinyint(1) DEFAULT NULL,
  `duration_name` varchar(255) DEFAULT NULL,
  `override_default_booking_status` varchar(255) DEFAULT NULL,
  `duration` int(11) NOT NULL,
  `buffer_before` int(11) DEFAULT NULL,
  `buffer_after` int(11) DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL,
  `order_number` int(11) DEFAULT NULL,
  `selection_image_id` int(11) DEFAULT NULL,
  `description_image_id` int(11) DEFAULT NULL,
  `bg_color` varchar(20) DEFAULT NULL,
  `timeblock_interval` int(11) DEFAULT NULL,
  `capacity_min` int(4) DEFAULT NULL,
  `capacity_max` int(4) DEFAULT NULL,
  `status` varchar(20) NOT NULL,
  `visibility` varchar(20) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `earliest_possible_booking` varchar(50) DEFAULT NULL,
  `latest_possible_booking` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `category_id_index` (`category_id`),
  KEY `order_number_index` (`order_number`),
  KEY `status_index` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_sessions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` varchar(55) NOT NULL,
  `session_value` longtext NOT NULL,
  `expiration` bigint(20) unsigned NOT NULL,
  `hash` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_settings` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(110) NOT NULL,
  `value` longtext DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `name_index` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_step_settings` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `label` varchar(50) NOT NULL,
  `value` text DEFAULT NULL,
  `step` varchar(50) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `step_index` (`step`),
  KEY `label_index` (`label`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_steps` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` text DEFAULT NULL,
  `before_content` text DEFAULT NULL,
  `after_content` text DEFAULT NULL,
  `side_title` text DEFAULT NULL,
  `side_description` text DEFAULT NULL,
  `use_custom_image` tinyint(1) DEFAULT NULL,
  `custom_image_id` int(11) DEFAULT NULL,
  `code` varchar(100) DEFAULT NULL,
  `parent_step_id` smallint(6) DEFAULT NULL,
  `position` smallint(6) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_transaction_intents` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `intent_key` varchar(55) NOT NULL,
  `order_id` int(11) NOT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `invoice_id` int(11) DEFAULT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `payment_data` text DEFAULT NULL,
  `charge_amount` decimal(20,4) DEFAULT NULL,
  `specs_charge_amount` varchar(55) DEFAULT NULL,
  `order_form_page_url` text DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT 'new',
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `intent_key_index` (`intent_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_transaction_refunds` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `token` text DEFAULT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `amount` decimal(20,4) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_transactions` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `token` text DEFAULT NULL,
  `invoice_id` int(11) DEFAULT NULL,
  `order_id` int(11) DEFAULT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `processor` varchar(100) DEFAULT NULL,
  `payment_method` varchar(55) DEFAULT NULL,
  `payment_portion` varchar(55) DEFAULT NULL,
  `kind` varchar(40) DEFAULT NULL,
  `status` varchar(100) NOT NULL,
  `amount` decimal(20,4) DEFAULT NULL,
  `receipt_number` varchar(10) DEFAULT NULL,
  `access_key` varchar(36) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_work_periods` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `agent_id` int(11) NOT NULL,
  `service_id` int(11) NOT NULL,
  `location_id` int(11) NOT NULL,
  `start_time` smallint(6) NOT NULL,
  `end_time` smallint(6) NOT NULL,
  `week_day` tinyint(3) NOT NULL,
  `custom_date` date DEFAULT NULL,
  `chain_id` varchar(20) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `agent_id_index` (`agent_id`),
  KEY `service_id_index` (`service_id`),
  KEY `location_id_index` (`location_id`),
  KEY `week_day_index` (`week_day`),
  KEY `custom_date_index` (`custom_date`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_litespeed_url` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `url` varchar(500) NOT NULL,
  `cache_tags` varchar(1000) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `url` (`url`(191)),
  KEY `cache_tags` (`cache_tags`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_litespeed_url_file` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `url_id` bigint(20) NOT NULL,
  `vary` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'md5 of final vary',
  `filename` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'md5 of file content',
  `type` tinyint(4) NOT NULL COMMENT 'css=1,js=2,ccss=3,ucss=4',
  `mobile` tinyint(4) NOT NULL COMMENT 'mobile=1',
  `webp` tinyint(4) NOT NULL COMMENT 'webp=1',
  `expired` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `filename` (`filename`),
  KEY `type` (`type`),
  KEY `url_id_2` (`url_id`,`vary`,`type`),
  KEY `filename_2` (`filename`,`expired`),
  KEY `url_id` (`url_id`,`expired`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=24267 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=2188 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=2074 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_suremails_email_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `email_from` varchar(100) NOT NULL,
  `email_to` longtext NOT NULL,
  `subject` varchar(255) NOT NULL,
  `body` longtext NOT NULL,
  `headers` longtext NOT NULL,
  `attachments` longtext NOT NULL,
  `status` enum('failed','sent','pending','blocked') NOT NULL DEFAULT 'pending',
  `response` longtext NOT NULL,
  `meta` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`meta`)),
  `connection` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `email_from` (`email_from`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=282 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpforms_logs` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `message` longtext NOT NULL,
  `types` varchar(255) NOT NULL,
  `create_at` datetime NOT NULL,
  `form_id` bigint(20) DEFAULT NULL,
  `entry_id` bigint(20) DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpforms_payment_meta` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `payment_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `payment_id` (`payment_id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `meta_value` (`meta_value`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpforms_payments` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `form_id` bigint(20) NOT NULL,
  `status` varchar(10) NOT NULL DEFAULT '',
  `subtotal_amount` decimal(26,8) NOT NULL DEFAULT 0.00000000,
  `discount_amount` decimal(26,8) NOT NULL DEFAULT 0.00000000,
  `total_amount` decimal(26,8) NOT NULL DEFAULT 0.00000000,
  `currency` varchar(3) NOT NULL DEFAULT '',
  `entry_id` bigint(20) NOT NULL DEFAULT 0,
  `gateway` varchar(20) NOT NULL DEFAULT '',
  `type` varchar(12) NOT NULL DEFAULT '',
  `mode` varchar(4) NOT NULL DEFAULT '',
  `transaction_id` varchar(40) NOT NULL DEFAULT '',
  `customer_id` varchar(40) NOT NULL DEFAULT '',
  `subscription_id` varchar(40) NOT NULL DEFAULT '',
  `subscription_status` varchar(10) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `date_created_gmt` datetime NOT NULL,
  `date_updated_gmt` datetime NOT NULL,
  `is_published` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `form_id` (`form_id`),
  KEY `status` (`status`(8)),
  KEY `total_amount` (`total_amount`),
  KEY `type` (`type`(8)),
  KEY `transaction_id` (`transaction_id`(32)),
  KEY `customer_id` (`customer_id`(32)),
  KEY `subscription_id` (`subscription_id`(32)),
  KEY `subscription_status` (`subscription_status`(8)),
  KEY `title` (`title`(64))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpforms_tasks_meta` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `action` varchar(255) NOT NULL,
  `data` longtext NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES("488", "wpforms_email_summaries_fetch_info_blocks", "complete", "2025-11-09 01:58:38", "2025-11-09 01:58:38", "10", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762653518;s:18:\"\0*\0first_timestamp\";i:1744089714;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762653518;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2025-11-09 02:06:49", "2025-11-09 02:06:49", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("491", "wpforms_process_forms_locator_scan", "complete", "2025-11-04 02:01:17", "2025-11-04 02:01:17", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762221677;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762221677;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-04 03:34:34", "2025-11-04 03:34:34", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("492", "wpforms_process_purge_spam", "complete", "2025-11-04 02:01:17", "2025-11-04 02:01:17", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762221677;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762221677;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-04 03:34:34", "2025-11-04 03:34:34", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("493", "wpforms_process_forms_locator_scan", "complete", "2025-11-05 03:34:34", "2025-11-05 03:34:34", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762313674;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762313674;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-05 05:13:29", "2025-11-05 05:13:29", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("494", "wpforms_process_purge_spam", "complete", "2025-11-05 03:34:34", "2025-11-05 03:34:34", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762313674;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762313674;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-05 05:13:29", "2025-11-05 05:13:29", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("495", "wpforms_process_forms_locator_scan", "complete", "2025-11-06 05:13:29", "2025-11-06 05:13:29", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762406009;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762406009;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-06 08:57:53", "2025-11-06 08:57:53", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("496", "wpforms_process_purge_spam", "complete", "2025-11-06 05:13:29", "2025-11-06 05:13:29", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762406009;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762406009;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-06 08:57:53", "2025-11-06 08:57:53", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("497", "wpforms_process_forms_locator_scan", "complete", "2025-11-07 08:57:53", "2025-11-07 08:57:53", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762505873;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762505873;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-07 15:26:59", "2025-11-07 15:26:59", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("498", "wpforms_process_purge_spam", "complete", "2025-11-07 08:57:53", "2025-11-07 08:57:53", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762505873;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762505873;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-07 15:26:59", "2025-11-07 15:26:59", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("499", "wpforms_process_forms_locator_scan", "complete", "2025-11-08 15:26:59", "2025-11-08 15:26:59", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762615619;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762615619;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-08 15:58:11", "2025-11-08 15:58:11", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("500", "wpforms_process_purge_spam", "complete", "2025-11-08 15:26:59", "2025-11-08 15:26:59", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762615619;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762615619;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-08 15:58:11", "2025-11-08 15:58:11", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("501", "wpforms_process_forms_locator_scan", "complete", "2025-11-09 15:58:11", "2025-11-09 15:58:11", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762703891;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762703891;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-09 19:47:56", "2025-11-09 19:47:56", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("502", "wpforms_process_purge_spam", "complete", "2025-11-09 15:58:11", "2025-11-09 15:58:11", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762703891;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762703891;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-09 19:47:56", "2025-11-09 19:47:56", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("503", "wpforms_email_summaries_fetch_info_blocks", "complete", "2025-11-16 02:06:49", "2025-11-16 02:06:49", "10", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763258809;s:18:\"\0*\0first_timestamp\";i:1744089714;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763258809;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2025-11-16 02:15:35", "2025-11-16 02:15:35", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("504", "wpforms_process_forms_locator_scan", "complete", "2025-11-10 19:47:56", "2025-11-10 19:47:56", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762804076;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762804076;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-10 20:11:24", "2025-11-10 20:11:24", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("505", "wpforms_process_purge_spam", "complete", "2025-11-10 19:47:56", "2025-11-10 19:47:56", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762804076;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762804076;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-10 20:11:24", "2025-11-10 20:11:24", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("506", "wpforms_process_forms_locator_scan", "complete", "2025-11-11 20:11:24", "2025-11-11 20:11:24", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762891884;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762891884;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-11 20:23:57", "2025-11-11 20:23:57", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("507", "wpforms_process_purge_spam", "complete", "2025-11-11 20:11:24", "2025-11-11 20:11:24", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762891884;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762891884;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-11 20:23:57", "2025-11-11 20:23:57", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("508", "wpforms_process_forms_locator_scan", "complete", "2025-11-12 20:23:57", "2025-11-12 20:23:57", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762979037;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762979037;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-12 21:05:29", "2025-11-12 21:05:29", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("509", "wpforms_process_purge_spam", "complete", "2025-11-12 20:23:57", "2025-11-12 20:23:57", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762979037;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762979037;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-12 21:05:29", "2025-11-12 21:05:29", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("510", "wpforms_process_forms_locator_scan", "complete", "2025-11-13 21:05:29", "2025-11-13 21:05:29", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763067929;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763067929;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-13 22:25:21", "2025-11-13 22:25:21", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("511", "wpforms_process_purge_spam", "complete", "2025-11-13 21:05:29", "2025-11-13 21:05:29", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763067929;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763067929;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-13 22:25:21", "2025-11-13 22:25:21", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("512", "wpforms_process_forms_locator_scan", "complete", "2025-11-14 22:25:21", "2025-11-14 22:25:21", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763159121;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763159121;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-14 22:31:17", "2025-11-14 22:31:17", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("513", "wpforms_process_purge_spam", "complete", "2025-11-14 22:25:21", "2025-11-14 22:25:21", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763159121;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763159121;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-14 22:31:17", "2025-11-14 22:31:17", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("514", "wpforms_process_forms_locator_scan", "complete", "2025-11-15 22:31:17", "2025-11-15 22:31:17", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763245877;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763245877;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-15 23:41:39", "2025-11-15 23:41:39", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("515", "wpforms_process_purge_spam", "complete", "2025-11-15 22:31:17", "2025-11-15 22:31:17", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763245877;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763245877;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-15 23:41:39", "2025-11-15 23:41:39", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("516", "wpforms_process_forms_locator_scan", "complete", "2025-11-16 23:41:39", "2025-11-16 23:41:39", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763336499;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763336499;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-17 01:48:05", "2025-11-17 01:48:05", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("517", "wpforms_process_purge_spam", "complete", "2025-11-16 23:41:39", "2025-11-16 23:41:39", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763336499;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763336499;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-17 01:48:05", "2025-11-17 01:48:05", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("518", "wpforms_email_summaries_fetch_info_blocks", "complete", "2025-11-23 02:15:35", "2025-11-23 02:15:35", "10", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763864135;s:18:\"\0*\0first_timestamp\";i:1744089714;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763864135;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2025-11-23 02:24:56", "2025-11-23 02:24:56", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("519", "wpforms_process_forms_locator_scan", "complete", "2025-11-18 01:48:05", "2025-11-18 01:48:05", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763430485;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763430485;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-18 02:19:00", "2025-11-18 02:19:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("520", "wpforms_process_purge_spam", "complete", "2025-11-18 01:48:05", "2025-11-18 01:48:05", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763430485;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763430485;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-18 02:19:00", "2025-11-18 02:19:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("521", "wpforms_process_forms_locator_scan", "complete", "2025-11-19 02:19:00", "2025-11-19 02:19:00", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763518740;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763518740;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-19 02:35:52", "2025-11-19 02:35:52", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("522", "wpforms_process_purge_spam", "complete", "2025-11-19 02:19:00", "2025-11-19 02:19:00", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763518740;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763518740;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-19 02:35:52", "2025-11-19 02:35:52", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("523", "wpforms_process_forms_locator_scan", "complete", "2025-11-20 02:35:52", "2025-11-20 02:35:52", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763606152;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763606152;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-20 03:28:41", "2025-11-20 03:28:41", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("524", "wpforms_process_purge_spam", "complete", "2025-11-20 02:35:52", "2025-11-20 02:35:52", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763606152;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763606152;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-20 03:28:41", "2025-11-20 03:28:41", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("525", "wpforms_process_forms_locator_scan", "complete", "2025-11-21 03:28:41", "2025-11-21 03:28:41", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763695721;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763695721;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-21 04:18:50", "2025-11-21 04:18:50", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("526", "wpforms_process_purge_spam", "complete", "2025-11-21 03:28:41", "2025-11-21 03:28:41", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763695721;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763695721;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-21 04:18:50", "2025-11-21 04:18:50", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("527", "wpforms_process_forms_locator_scan", "complete", "2025-11-22 04:18:50", "2025-11-22 04:18:50", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763785130;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763785130;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-22 06:17:40", "2025-11-22 06:17:40", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("528", "wpforms_process_purge_spam", "complete", "2025-11-22 04:18:50", "2025-11-22 04:18:50", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763785130;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763785130;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-22 06:17:40", "2025-11-22 06:17:40", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("529", "wpforms_admin_notifications_update", "complete", "2025-11-21 10:42:34", "2025-11-21 10:42:34", "10", "{\"tasks_meta_id\":6}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2025-11-21 10:42:34", "2025-11-21 10:42:34", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("530", "wpforms_admin_addons_cache_update", "complete", "2025-11-28 11:07:51", "2025-11-28 11:07:51", "10", "{\"tasks_meta_id\":7}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764328071;s:18:\"\0*\0first_timestamp\";i:1764328071;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764328071;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2025-11-28 11:20:20", "2025-11-28 11:20:20", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("531", "wpforms_admin_builder_templates_cache_update", "complete", "2025-11-28 11:07:51", "2025-11-28 11:07:51", "10", "{\"tasks_meta_id\":8}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764328071;s:18:\"\0*\0first_timestamp\";i:1764328071;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764328071;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2025-11-28 11:20:20", "2025-11-28 11:20:20", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("532", "wpforms_process_forms_locator_scan", "complete", "2025-11-23 06:17:40", "2025-11-23 06:17:40", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763878660;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763878660;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-23 09:35:28", "2025-11-23 09:35:28", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("533", "wpforms_process_purge_spam", "complete", "2025-11-23 06:17:40", "2025-11-23 06:17:40", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763878660;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763878660;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-23 09:35:28", "2025-11-23 09:35:28", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("534", "wpforms_email_summaries_fetch_info_blocks", "complete", "2025-11-30 02:24:56", "2025-11-30 02:24:56", "10", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764469496;s:18:\"\0*\0first_timestamp\";i:1744089714;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764469496;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2025-11-30 02:33:40", "2025-11-30 02:33:40", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("535", "wpforms_process_forms_locator_scan", "complete", "2025-11-24 09:35:28", "2025-11-24 09:35:28", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763976928;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763976928;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-24 12:00:03", "2025-11-24 12:00:03", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("536", "wpforms_process_purge_spam", "complete", "2025-11-24 09:35:28", "2025-11-24 09:35:28", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763976928;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763976928;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-24 12:00:03", "2025-11-24 12:00:03", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("537", "wpforms_process_forms_locator_scan", "complete", "2025-11-25 12:00:03", "2025-11-25 12:00:03", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764072003;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764072003;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-25 12:24:00", "2025-11-25 12:24:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("538", "wpforms_process_purge_spam", "complete", "2025-11-25 12:00:03", "2025-11-25 12:00:03", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764072003;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764072003;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-25 12:24:00", "2025-11-25 12:24:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("539", "wpforms_process_forms_locator_scan", "complete", "2025-11-26 12:24:00", "2025-11-26 12:24:00", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764159840;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764159840;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-26 12:27:25", "2025-11-26 12:27:25", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("540", "wpforms_process_purge_spam", "complete", "2025-11-26 12:24:00", "2025-11-26 12:24:00", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764159840;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764159840;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-26 12:27:25", "2025-11-26 12:27:25", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("541", "wpforms_process_forms_locator_scan", "complete", "2025-11-27 12:27:25", "2025-11-27 12:27:25", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764246445;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764246445;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-27 13:06:26", "2025-11-27 13:06:26", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("542", "wpforms_process_purge_spam", "complete", "2025-11-27 12:27:25", "2025-11-27 12:27:25", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764246445;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764246445;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-27 13:06:26", "2025-11-27 13:06:26", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("543", "wpforms_process_forms_locator_scan", "complete", "2025-11-28 13:06:26", "2025-11-28 13:06:26", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764335186;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764335186;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-28 13:28:25", "2025-11-28 13:28:25", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("544", "wpforms_process_purge_spam", "complete", "2025-11-28 13:06:26", "2025-11-28 13:06:26", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764335186;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764335186;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-28 13:28:25", "2025-11-28 13:28:25", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("545", "wpforms_admin_addons_cache_update", "pending", "2025-12-05 11:20:20", "2025-12-05 11:20:20", "10", "{\"tasks_meta_id\":7}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764933620;s:18:\"\0*\0first_timestamp\";i:1764328071;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764933620;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("546", "wpforms_admin_builder_templates_cache_update", "pending", "2025-12-05 11:20:20", "2025-12-05 11:20:20", "10", "{\"tasks_meta_id\":8}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764933620;s:18:\"\0*\0first_timestamp\";i:1764328071;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764933620;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("547", "wpforms_process_forms_locator_scan", "complete", "2025-11-29 13:28:25", "2025-11-29 13:28:25", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764422905;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764422905;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-29 15:24:42", "2025-11-29 15:24:42", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("548", "wpforms_process_purge_spam", "complete", "2025-11-29 13:28:25", "2025-11-29 13:28:25", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764422905;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764422905;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-29 15:24:42", "2025-11-29 15:24:42", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("549", "wpforms_admin_notifications_update", "complete", "2025-11-28 13:29:07", "2025-11-28 13:29:07", "10", "{\"tasks_meta_id\":9}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2025-11-28 13:29:07", "2025-11-28 13:29:07", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("550", "wpforms_process_forms_locator_scan", "complete", "2025-11-30 15:24:42", "2025-11-30 15:24:42", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764516282;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764516282;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-30 17:27:24", "2025-11-30 17:27:24", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("551", "wpforms_process_purge_spam", "complete", "2025-11-30 15:24:42", "2025-11-30 15:24:42", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764516282;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764516282;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-30 17:27:24", "2025-11-30 17:27:24", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("552", "wpforms_email_summaries_fetch_info_blocks", "pending", "2025-12-07 02:33:40", "2025-12-07 02:33:40", "10", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765074820;s:18:\"\0*\0first_timestamp\";i:1744089714;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765074820;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("553", "wpforms_process_forms_locator_scan", "complete", "2025-12-01 17:27:24", "2025-12-01 17:27:24", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764610044;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764610044;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-01 17:56:19", "2025-12-01 17:56:19", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("554", "wpforms_process_purge_spam", "complete", "2025-12-01 17:27:24", "2025-12-01 17:27:24", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764610044;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764610044;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-01 17:56:19", "2025-12-01 17:56:19", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("555", "wpforms_process_forms_locator_scan", "complete", "2025-12-02 17:56:19", "2025-12-02 17:56:19", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764698179;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764698179;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-02 20:55:25", "2025-12-02 20:55:25", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("556", "wpforms_process_purge_spam", "complete", "2025-12-02 17:56:19", "2025-12-02 17:56:19", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764698179;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764698179;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-02 20:55:25", "2025-12-02 20:55:25", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("557", "wpforms_process_forms_locator_scan", "complete", "2025-12-03 20:55:25", "2025-12-03 20:55:25", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764795325;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764795325;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-03 22:31:56", "2025-12-03 22:31:56", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("558", "wpforms_process_purge_spam", "complete", "2025-12-03 20:55:25", "2025-12-03 20:55:25", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764795325;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764795325;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-03 22:31:56", "2025-12-03 22:31:56", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("559", "wpforms_process_forms_locator_scan", "pending", "2025-12-04 22:31:56", "2025-12-04 22:31:56", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764887516;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764887516;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("560", "wpforms_process_purge_spam", "pending", "2025-12-04 22:31:56", "2025-12-04 22:31:56", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764887516;s:18:\"\0*\0first_timestamp\";i:1744460894;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764887516;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("561", "wpforms_admin_notifications_update", "complete", "2025-12-04 15:20:35", "2025-12-04 15:20:35", "10", "{\"tasks_meta_id\":10}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2025-12-04 15:20:36", "2025-12-04 15:20:36", "0", NULL);

/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("2", "wpforms");

/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES("1251", "488", "action created", "2025-11-02 01:58:38", "2025-11-02 01:58:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("1260", "491", "action created", "2025-11-03 02:01:17", "2025-11-03 02:01:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1263", "492", "action created", "2025-11-03 02:01:17", "2025-11-03 02:01:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1264", "491", "action started via WP Cron", "2025-11-04 03:34:34", "2025-11-04 03:34:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("1265", "491", "action complete via WP Cron", "2025-11-04 03:34:34", "2025-11-04 03:34:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("1266", "493", "action created", "2025-11-04 03:34:34", "2025-11-04 03:34:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("1267", "492", "action started via WP Cron", "2025-11-04 03:34:34", "2025-11-04 03:34:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("1268", "492", "action complete via WP Cron", "2025-11-04 03:34:34", "2025-11-04 03:34:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("1269", "494", "action created", "2025-11-04 03:34:34", "2025-11-04 03:34:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("1270", "493", "action started via WP Cron", "2025-11-05 05:13:29", "2025-11-05 05:13:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("1271", "493", "action complete via WP Cron", "2025-11-05 05:13:29", "2025-11-05 05:13:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("1272", "495", "action created", "2025-11-05 05:13:29", "2025-11-05 05:13:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("1273", "494", "action started via WP Cron", "2025-11-05 05:13:29", "2025-11-05 05:13:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("1274", "494", "action complete via WP Cron", "2025-11-05 05:13:29", "2025-11-05 05:13:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("1275", "496", "action created", "2025-11-05 05:13:29", "2025-11-05 05:13:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("1276", "495", "action started via WP Cron", "2025-11-06 08:57:53", "2025-11-06 08:57:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1277", "495", "action complete via WP Cron", "2025-11-06 08:57:53", "2025-11-06 08:57:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1278", "497", "action created", "2025-11-06 08:57:53", "2025-11-06 08:57:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1279", "496", "action started via WP Cron", "2025-11-06 08:57:53", "2025-11-06 08:57:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1280", "496", "action complete via WP Cron", "2025-11-06 08:57:53", "2025-11-06 08:57:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1281", "498", "action created", "2025-11-06 08:57:53", "2025-11-06 08:57:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1282", "497", "action started via WP Cron", "2025-11-07 15:26:59", "2025-11-07 15:26:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("1283", "497", "action complete via WP Cron", "2025-11-07 15:26:59", "2025-11-07 15:26:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("1284", "499", "action created", "2025-11-07 15:26:59", "2025-11-07 15:26:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("1285", "498", "action started via WP Cron", "2025-11-07 15:26:59", "2025-11-07 15:26:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("1286", "498", "action complete via WP Cron", "2025-11-07 15:26:59", "2025-11-07 15:26:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("1287", "500", "action created", "2025-11-07 15:26:59", "2025-11-07 15:26:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("1288", "499", "action started via WP Cron", "2025-11-08 15:58:11", "2025-11-08 15:58:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("1289", "499", "action complete via WP Cron", "2025-11-08 15:58:11", "2025-11-08 15:58:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("1290", "501", "action created", "2025-11-08 15:58:11", "2025-11-08 15:58:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("1291", "500", "action started via WP Cron", "2025-11-08 15:58:11", "2025-11-08 15:58:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("1292", "500", "action complete via WP Cron", "2025-11-08 15:58:11", "2025-11-08 15:58:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("1293", "502", "action created", "2025-11-08 15:58:11", "2025-11-08 15:58:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("1294", "488", "action started via WP Cron", "2025-11-09 02:06:49", "2025-11-09 02:06:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("1295", "488", "action complete via WP Cron", "2025-11-09 02:06:49", "2025-11-09 02:06:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("1296", "503", "action created", "2025-11-09 02:06:49", "2025-11-09 02:06:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("1297", "501", "action started via WP Cron", "2025-11-09 19:47:56", "2025-11-09 19:47:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("1298", "501", "action complete via WP Cron", "2025-11-09 19:47:56", "2025-11-09 19:47:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("1299", "504", "action created", "2025-11-09 19:47:56", "2025-11-09 19:47:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("1300", "502", "action started via WP Cron", "2025-11-09 19:47:56", "2025-11-09 19:47:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("1301", "502", "action complete via WP Cron", "2025-11-09 19:47:56", "2025-11-09 19:47:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("1302", "505", "action created", "2025-11-09 19:47:56", "2025-11-09 19:47:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("1303", "504", "action started via WP Cron", "2025-11-10 20:11:24", "2025-11-10 20:11:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("1304", "504", "action complete via WP Cron", "2025-11-10 20:11:24", "2025-11-10 20:11:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("1305", "506", "action created", "2025-11-10 20:11:24", "2025-11-10 20:11:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("1306", "505", "action started via WP Cron", "2025-11-10 20:11:24", "2025-11-10 20:11:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("1307", "505", "action complete via WP Cron", "2025-11-10 20:11:24", "2025-11-10 20:11:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("1308", "507", "action created", "2025-11-10 20:11:24", "2025-11-10 20:11:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("1309", "506", "action started via WP Cron", "2025-11-11 20:23:57", "2025-11-11 20:23:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("1310", "506", "action complete via WP Cron", "2025-11-11 20:23:57", "2025-11-11 20:23:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("1311", "508", "action created", "2025-11-11 20:23:57", "2025-11-11 20:23:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("1312", "507", "action started via WP Cron", "2025-11-11 20:23:57", "2025-11-11 20:23:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("1313", "507", "action complete via WP Cron", "2025-11-11 20:23:57", "2025-11-11 20:23:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("1314", "509", "action created", "2025-11-11 20:23:57", "2025-11-11 20:23:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("1315", "508", "action started via WP Cron", "2025-11-12 21:05:29", "2025-11-12 21:05:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("1316", "508", "action complete via WP Cron", "2025-11-12 21:05:29", "2025-11-12 21:05:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("1317", "510", "action created", "2025-11-12 21:05:29", "2025-11-12 21:05:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("1318", "509", "action started via WP Cron", "2025-11-12 21:05:29", "2025-11-12 21:05:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("1319", "509", "action complete via WP Cron", "2025-11-12 21:05:29", "2025-11-12 21:05:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("1320", "511", "action created", "2025-11-12 21:05:29", "2025-11-12 21:05:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("1321", "510", "action started via WP Cron", "2025-11-13 22:25:21", "2025-11-13 22:25:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("1322", "510", "action complete via WP Cron", "2025-11-13 22:25:21", "2025-11-13 22:25:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("1323", "512", "action created", "2025-11-13 22:25:21", "2025-11-13 22:25:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("1324", "511", "action started via WP Cron", "2025-11-13 22:25:21", "2025-11-13 22:25:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("1325", "511", "action complete via WP Cron", "2025-11-13 22:25:21", "2025-11-13 22:25:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("1326", "513", "action created", "2025-11-13 22:25:21", "2025-11-13 22:25:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("1327", "512", "action started via WP Cron", "2025-11-14 22:31:17", "2025-11-14 22:31:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1328", "512", "action complete via WP Cron", "2025-11-14 22:31:17", "2025-11-14 22:31:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1329", "514", "action created", "2025-11-14 22:31:17", "2025-11-14 22:31:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1330", "513", "action started via WP Cron", "2025-11-14 22:31:17", "2025-11-14 22:31:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1331", "513", "action complete via WP Cron", "2025-11-14 22:31:17", "2025-11-14 22:31:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1332", "515", "action created", "2025-11-14 22:31:17", "2025-11-14 22:31:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1333", "514", "action started via WP Cron", "2025-11-15 23:41:39", "2025-11-15 23:41:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("1334", "514", "action complete via WP Cron", "2025-11-15 23:41:39", "2025-11-15 23:41:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("1335", "516", "action created", "2025-11-15 23:41:39", "2025-11-15 23:41:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("1336", "515", "action started via WP Cron", "2025-11-15 23:41:39", "2025-11-15 23:41:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("1337", "515", "action complete via WP Cron", "2025-11-15 23:41:39", "2025-11-15 23:41:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("1338", "517", "action created", "2025-11-15 23:41:39", "2025-11-15 23:41:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("1339", "503", "action started via WP Cron", "2025-11-16 02:15:35", "2025-11-16 02:15:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("1340", "503", "action complete via WP Cron", "2025-11-16 02:15:35", "2025-11-16 02:15:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("1341", "518", "action created", "2025-11-16 02:15:35", "2025-11-16 02:15:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("1342", "516", "action started via WP Cron", "2025-11-17 01:48:05", "2025-11-17 01:48:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1343", "516", "action complete via WP Cron", "2025-11-17 01:48:05", "2025-11-17 01:48:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1344", "519", "action created", "2025-11-17 01:48:05", "2025-11-17 01:48:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1345", "517", "action started via WP Cron", "2025-11-17 01:48:05", "2025-11-17 01:48:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1346", "517", "action complete via WP Cron", "2025-11-17 01:48:05", "2025-11-17 01:48:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1347", "520", "action created", "2025-11-17 01:48:05", "2025-11-17 01:48:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1348", "519", "action started via WP Cron", "2025-11-18 02:19:00", "2025-11-18 02:19:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("1349", "519", "action complete via WP Cron", "2025-11-18 02:19:00", "2025-11-18 02:19:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("1350", "521", "action created", "2025-11-18 02:19:00", "2025-11-18 02:19:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("1351", "520", "action started via WP Cron", "2025-11-18 02:19:00", "2025-11-18 02:19:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("1352", "520", "action complete via WP Cron", "2025-11-18 02:19:00", "2025-11-18 02:19:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("1353", "522", "action created", "2025-11-18 02:19:00", "2025-11-18 02:19:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("1354", "521", "action started via WP Cron", "2025-11-19 02:35:52", "2025-11-19 02:35:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("1355", "521", "action complete via WP Cron", "2025-11-19 02:35:52", "2025-11-19 02:35:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("1356", "523", "action created", "2025-11-19 02:35:52", "2025-11-19 02:35:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("1357", "522", "action started via WP Cron", "2025-11-19 02:35:52", "2025-11-19 02:35:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("1358", "522", "action complete via WP Cron", "2025-11-19 02:35:52", "2025-11-19 02:35:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("1359", "524", "action created", "2025-11-19 02:35:52", "2025-11-19 02:35:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("1360", "523", "action started via WP Cron", "2025-11-20 03:28:41", "2025-11-20 03:28:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("1361", "523", "action complete via WP Cron", "2025-11-20 03:28:41", "2025-11-20 03:28:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("1362", "525", "action created", "2025-11-20 03:28:41", "2025-11-20 03:28:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("1363", "524", "action started via WP Cron", "2025-11-20 03:28:41", "2025-11-20 03:28:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("1364", "524", "action complete via WP Cron", "2025-11-20 03:28:41", "2025-11-20 03:28:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("1365", "526", "action created", "2025-11-20 03:28:41", "2025-11-20 03:28:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("1366", "525", "action started via WP Cron", "2025-11-21 04:18:50", "2025-11-21 04:18:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1367", "525", "action complete via WP Cron", "2025-11-21 04:18:50", "2025-11-21 04:18:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1368", "527", "action created", "2025-11-21 04:18:50", "2025-11-21 04:18:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1369", "526", "action started via WP Cron", "2025-11-21 04:18:50", "2025-11-21 04:18:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1370", "526", "action complete via WP Cron", "2025-11-21 04:18:50", "2025-11-21 04:18:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1371", "528", "action created", "2025-11-21 04:18:50", "2025-11-21 04:18:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("1372", "529", "action created", "2025-11-21 10:42:34", "2025-11-21 10:42:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("1373", "529", "action started via Async Request", "2025-11-21 10:42:34", "2025-11-21 10:42:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("1374", "529", "action complete via Async Request", "2025-11-21 10:42:34", "2025-11-21 10:42:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("1375", "530", "action created", "2025-11-21 11:07:51", "2025-11-21 11:07:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("1376", "531", "action created", "2025-11-21 11:07:51", "2025-11-21 11:07:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("1377", "527", "action started via WP Cron", "2025-11-22 06:17:40", "2025-11-22 06:17:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("1378", "527", "action complete via WP Cron", "2025-11-22 06:17:40", "2025-11-22 06:17:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("1379", "532", "action created", "2025-11-22 06:17:40", "2025-11-22 06:17:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("1380", "528", "action started via WP Cron", "2025-11-22 06:17:40", "2025-11-22 06:17:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("1381", "528", "action complete via WP Cron", "2025-11-22 06:17:40", "2025-11-22 06:17:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("1382", "533", "action created", "2025-11-22 06:17:40", "2025-11-22 06:17:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("1383", "518", "action started via WP Cron", "2025-11-23 02:24:56", "2025-11-23 02:24:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("1384", "518", "action complete via WP Cron", "2025-11-23 02:24:56", "2025-11-23 02:24:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("1385", "534", "action created", "2025-11-23 02:24:56", "2025-11-23 02:24:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("1386", "532", "action started via WP Cron", "2025-11-23 09:35:28", "2025-11-23 09:35:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1387", "532", "action complete via WP Cron", "2025-11-23 09:35:28", "2025-11-23 09:35:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1388", "535", "action created", "2025-11-23 09:35:28", "2025-11-23 09:35:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1389", "533", "action started via WP Cron", "2025-11-23 09:35:28", "2025-11-23 09:35:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1390", "533", "action complete via WP Cron", "2025-11-23 09:35:28", "2025-11-23 09:35:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1391", "536", "action created", "2025-11-23 09:35:28", "2025-11-23 09:35:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1392", "535", "action started via WP Cron", "2025-11-24 12:00:03", "2025-11-24 12:00:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("1393", "535", "action complete via WP Cron", "2025-11-24 12:00:03", "2025-11-24 12:00:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("1394", "537", "action created", "2025-11-24 12:00:03", "2025-11-24 12:00:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("1395", "536", "action started via WP Cron", "2025-11-24 12:00:03", "2025-11-24 12:00:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("1396", "536", "action complete via WP Cron", "2025-11-24 12:00:03", "2025-11-24 12:00:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("1397", "538", "action created", "2025-11-24 12:00:03", "2025-11-24 12:00:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("1398", "537", "action started via WP Cron", "2025-11-25 12:24:00", "2025-11-25 12:24:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("1399", "537", "action complete via WP Cron", "2025-11-25 12:24:00", "2025-11-25 12:24:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("1400", "539", "action created", "2025-11-25 12:24:00", "2025-11-25 12:24:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("1401", "538", "action started via WP Cron", "2025-11-25 12:24:00", "2025-11-25 12:24:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("1402", "538", "action complete via WP Cron", "2025-11-25 12:24:00", "2025-11-25 12:24:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("1403", "540", "action created", "2025-11-25 12:24:00", "2025-11-25 12:24:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("1404", "539", "action started via WP Cron", "2025-11-26 12:27:25", "2025-11-26 12:27:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("1405", "539", "action complete via WP Cron", "2025-11-26 12:27:25", "2025-11-26 12:27:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("1406", "541", "action created", "2025-11-26 12:27:25", "2025-11-26 12:27:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("1407", "540", "action started via WP Cron", "2025-11-26 12:27:25", "2025-11-26 12:27:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("1408", "540", "action complete via WP Cron", "2025-11-26 12:27:25", "2025-11-26 12:27:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("1409", "542", "action created", "2025-11-26 12:27:25", "2025-11-26 12:27:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("1410", "541", "action started via WP Cron", "2025-11-27 13:06:26", "2025-11-27 13:06:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1411", "541", "action complete via WP Cron", "2025-11-27 13:06:26", "2025-11-27 13:06:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1412", "543", "action created", "2025-11-27 13:06:26", "2025-11-27 13:06:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1413", "542", "action started via WP Cron", "2025-11-27 13:06:26", "2025-11-27 13:06:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1414", "542", "action complete via WP Cron", "2025-11-27 13:06:26", "2025-11-27 13:06:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1415", "544", "action created", "2025-11-27 13:06:26", "2025-11-27 13:06:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1416", "530", "action started via WP Cron", "2025-11-28 11:20:20", "2025-11-28 11:20:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("1417", "530", "action complete via WP Cron", "2025-11-28 11:20:20", "2025-11-28 11:20:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("1418", "545", "action created", "2025-11-28 11:20:20", "2025-11-28 11:20:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("1419", "531", "action started via WP Cron", "2025-11-28 11:20:20", "2025-11-28 11:20:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("1420", "531", "action complete via WP Cron", "2025-11-28 11:20:20", "2025-11-28 11:20:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("1421", "546", "action created", "2025-11-28 11:20:20", "2025-11-28 11:20:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("1422", "543", "action started via WP Cron", "2025-11-28 13:28:25", "2025-11-28 13:28:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("1423", "543", "action complete via WP Cron", "2025-11-28 13:28:25", "2025-11-28 13:28:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("1424", "547", "action created", "2025-11-28 13:28:25", "2025-11-28 13:28:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("1425", "544", "action started via WP Cron", "2025-11-28 13:28:25", "2025-11-28 13:28:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("1426", "544", "action complete via WP Cron", "2025-11-28 13:28:25", "2025-11-28 13:28:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("1427", "548", "action created", "2025-11-28 13:28:25", "2025-11-28 13:28:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("1428", "549", "action created", "2025-11-28 13:29:07", "2025-11-28 13:29:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("1429", "549", "action started via Async Request", "2025-11-28 13:29:07", "2025-11-28 13:29:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("1430", "549", "action complete via Async Request", "2025-11-28 13:29:07", "2025-11-28 13:29:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("1431", "547", "action started via WP Cron", "2025-11-29 15:24:42", "2025-11-29 15:24:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("1432", "547", "action complete via WP Cron", "2025-11-29 15:24:42", "2025-11-29 15:24:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("1433", "550", "action created", "2025-11-29 15:24:42", "2025-11-29 15:24:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("1434", "548", "action started via WP Cron", "2025-11-29 15:24:42", "2025-11-29 15:24:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("1435", "548", "action complete via WP Cron", "2025-11-29 15:24:42", "2025-11-29 15:24:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("1436", "551", "action created", "2025-11-29 15:24:42", "2025-11-29 15:24:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("1437", "534", "action started via WP Cron", "2025-11-30 02:33:40", "2025-11-30 02:33:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("1438", "534", "action complete via WP Cron", "2025-11-30 02:33:40", "2025-11-30 02:33:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("1439", "552", "action created", "2025-11-30 02:33:40", "2025-11-30 02:33:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("1440", "550", "action started via WP Cron", "2025-11-30 17:27:24", "2025-11-30 17:27:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("1441", "550", "action complete via WP Cron", "2025-11-30 17:27:24", "2025-11-30 17:27:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("1442", "553", "action created", "2025-11-30 17:27:24", "2025-11-30 17:27:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("1443", "551", "action started via WP Cron", "2025-11-30 17:27:24", "2025-11-30 17:27:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("1444", "551", "action complete via WP Cron", "2025-11-30 17:27:24", "2025-11-30 17:27:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("1445", "554", "action created", "2025-11-30 17:27:24", "2025-11-30 17:27:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("1446", "553", "action started via WP Cron", "2025-12-01 17:56:19", "2025-12-01 17:56:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("1447", "553", "action complete via WP Cron", "2025-12-01 17:56:19", "2025-12-01 17:56:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("1448", "555", "action created", "2025-12-01 17:56:19", "2025-12-01 17:56:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("1449", "554", "action started via WP Cron", "2025-12-01 17:56:19", "2025-12-01 17:56:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("1450", "554", "action complete via WP Cron", "2025-12-01 17:56:19", "2025-12-01 17:56:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("1451", "556", "action created", "2025-12-01 17:56:19", "2025-12-01 17:56:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("1452", "555", "action started via WP Cron", "2025-12-02 20:55:25", "2025-12-02 20:55:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("1453", "555", "action complete via WP Cron", "2025-12-02 20:55:25", "2025-12-02 20:55:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("1454", "557", "action created", "2025-12-02 20:55:25", "2025-12-02 20:55:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("1455", "556", "action started via WP Cron", "2025-12-02 20:55:25", "2025-12-02 20:55:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("1456", "556", "action complete via WP Cron", "2025-12-02 20:55:25", "2025-12-02 20:55:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("1457", "558", "action created", "2025-12-02 20:55:25", "2025-12-02 20:55:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("1458", "557", "action started via WP Cron", "2025-12-03 22:31:56", "2025-12-03 22:31:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("1459", "557", "action complete via WP Cron", "2025-12-03 22:31:56", "2025-12-03 22:31:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("1460", "559", "action created", "2025-12-03 22:31:56", "2025-12-03 22:31:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("1461", "558", "action started via WP Cron", "2025-12-03 22:31:56", "2025-12-03 22:31:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("1462", "558", "action complete via WP Cron", "2025-12-03 22:31:56", "2025-12-03 22:31:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("1463", "560", "action created", "2025-12-03 22:31:56", "2025-12-03 22:31:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("1464", "561", "action created", "2025-12-04 15:20:35", "2025-12-04 15:20:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("1465", "561", "action started via Async Request", "2025-12-04 15:20:36", "2025-12-04 15:20:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("1466", "561", "action complete via Async Request", "2025-12-04 15:20:36", "2025-12-04 15:20:36");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("1", "20251204_zaynventures", "08785d8d32ba99ce1476_20251204153307", "20", "2025-12-04 15:33:23", "ali.talha3358@gmail.com", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-12-04 15:33:07\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:5:\"6.7.4\";s:9:\"VersionDB\";s:6:\"11.8.3\";s:10:\"VersionPHP\";s:6:\"8.2.27\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:1;s:4:\"Name\";s:21:\"20251204_zaynventures\";s:4:\"Hash\";s:35:\"08785d8d32ba99ce1476_20251204153307\";s:8:\"NameHash\";s:57:\"20251204_zaynventures_08785d8d32ba99ce1476_20251204153307\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:67:\"20251204_zaynventures_08785d8d32ba99ce1476_20251204153307_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"20.9\";s:6:\"WPUser\";s:23:\"ali.talha3358@gmail.com\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:69:\"20251204_zaynventures_08785d8d32ba99ce1476_20251204153307_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:53:\"/home/u577685627/domains/zaynventures.com/public_html\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:2744;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:15637;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-12-04 15:33:07\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:5:\"6.7.4\";s:9:\"VersionDB\";s:6:\"11.8.3\";s:10:\"VersionPHP\";s:6:\"8.2.27\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:21:\"20251204_zaynventures\";s:4:\"Hash\";s:35:\"08785d8d32ba99ce1476_20251204153307\";s:8:\"NameHash\";s:57:\"20251204_zaynventures_08785d8d32ba99ce1476_20251204153307\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:75:\"20251204_zaynventures_08785d8d32ba99ce1476_20251204153307_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:67:\"/home/u577685627/domains/zaynventures.com/public_html/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:70:\"20251204_zaynventures_08785d8d32ba99ce1476_20251204153307_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:156:\"/home/u577685627/domains/zaynventures.com/public_html/wp-content/backups-dup-lite/tmp/20251204_zaynventures_08785d8d32ba99ce1476_20251204153307_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:62:\"/home/u577685627/domains/zaynventures.com/public_html/wp-admin\";i:1;s:65:\"/home/u577685627/domains/zaynventures.com/public_html/wp-includes\";i:2;s:74:\"/home/u577685627/domains/zaynventures.com/public_html/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:53:\"/home/u577685627/domains/zaynventures.com/public_html\";i:1;s:53:\"/home/u577685627/domains/zaynventures.com/public_html\";i:2;s:64:\"/home/u577685627/domains/zaynventures.com/public_html/wp-content\";i:3;s:72:\"/home/u577685627/domains/zaynventures.com/public_html/wp-content/uploads\";i:4;s:72:\"/home/u577685627/domains/zaynventures.com/public_html/wp-content/plugins\";i:5;s:75:\"/home/u577685627/domains/zaynventures.com/public_html/wp-content/mu-plugins\";i:6;s:71:\"/home/u577685627/domains/zaynventures.com/public_html/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:85:\"/home/u577685627/domains/zaynventures.com/public_html/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_latepoint_agents */
INSERT INTO `wp_latepoint_agents` VALUES("1", NULL, NULL, "John ", "Smith", NULL, NULL, NULL, "null", "test@gmail.com", "+12347891234", "$P$BUQ88AeyP.dUkB0o6/siSPr9rCjaa9/", NULL, NULL, "active", NULL, NULL, "2025-04-03 12:48:26", "2025-04-03 12:52:00");

/* INSERT TABLE DATA: wp_latepoint_agents_services */
INSERT INTO `wp_latepoint_agents_services` VALUES("1", "1", "1", "1", "0", "0", "0", "2025-04-03 12:56:23", "2025-04-03 12:56:23");
INSERT INTO `wp_latepoint_agents_services` VALUES("2", "1", "2", "1", "0", "0", "0", "2025-04-03 12:57:16", "2025-04-03 12:57:16");
INSERT INTO `wp_latepoint_agents_services` VALUES("3", "1", "3", "1", "0", "0", "0", "2025-04-03 12:58:04", "2025-04-03 12:58:04");

/* INSERT TABLE DATA: wp_latepoint_locations */
INSERT INTO `wp_latepoint_locations` VALUES("1", "Main Location", NULL, "active", "0", NULL, NULL, "2025-04-03 12:45:57", "2025-04-03 12:45:57");

/* INSERT TABLE DATA: wp_latepoint_processes */
INSERT INTO `wp_latepoint_processes` VALUES("1", "New Booking Notification", "booking_created", "[{\"type\":\"group\",\"trigger_condition\":false,\"items\":[{\"type\":\"action\",\"id\":\"pa_SZTXDV\",\"settings\":{\"status\":\"active\",\"type\":\"send_email\",\"settings\":{\"to_email\":\"{{agent_full_name}} <{{agent_email}}>\",\"subject\":\"New Appointment Received\",\"content\":\"<div style=\\\"padding: 20px; background-color: #f0f0f0; font-family: -apple-system, system-ui, BlinkMacSystemFont, \\\"Segoe UI\\\", Roboto, \\\"Helvetica Neue\\\", Arial, sans-serif;\\\">\\n\\t<div style=\\\"background-color: #fff; padding: 30px; margin: 0px auto; max-width: 450px; box-shadow: 0px 2px 6px -1px rgba(0,0,0,0.2); border-radius: 6px;\\\">\\n\\t\\t<div style=\\\"margin: 0px auto 30px auto; border-bottom: 1px solid #eee; padding-bottom: 20px;\\\">\\n\\t\\t\\t<table style=\\\"width: 100%;\\\">\\n\\t\\t\\t\\t<tr>\\n\\t\\t\\t\\t\\t<td>{{business_logo_image}}<\\/td>\\n\\t\\t\\t\\t\\t<td style=\\\"text-align: right;\\\"><span style=\\\"color: #7b7b7b;\\\">Questions?<\\/span><br\\/><strong>{{business_phone}}<\\/strong><\\/td>\\n\\t\\t\\t\\t<\\/tr>\\n\\t\\t\\t<\\/table>\\n\\t\\t<\\/div>\\n\\t\\t<div style=\\\"font-size: 16px; line-height: 1.5;\\\">\\n\\t\\t\\t<div style=\\\"font-size: 16px; margin-bottom: 20px; line-height: 1.6;\\\">\\n\\tHi {{agent_full_name}},\\n\\t<br\\/><br\\/>\\n\\tYou have received a new appointment request from {{customer_full_name}}\\n<\\/div>\\n<h4 style=\\\"margin-bottom: 10px; margin-top: 0px; font-size: 16px; font-weight: bold;\\\">Customer Information<\\/h4>\\n<ul>\\n\\t<li>\\n\\t\\t<span>Full Name:<\\/span> <strong>{{customer_full_name}}<\\/strong>\\n\\t<\\/li>\\n\\t<li>\\n\\t\\t<span>Email Address:<\\/span> <strong>{{customer_email}}<\\/strong>\\n\\t<\\/li>\\n\\t<li>\\n\\t\\t<span>Phone:<\\/span> <strong>{{customer_phone}}<\\/strong>\\n\\t<\\/li>\\n\\t<li>\\n\\t\\t<span>Comments:<\\/span> <strong>{{customer_notes}}<\\/strong>\\n\\t<\\/li>\\n<\\/ul>\\n<h4 style=\\\"margin-bottom: 10px; margin-top: 0px; font-size: 16px; font-weight: bold;\\\">Appointment Information<\\/h4>\\n<ul>\\n\\t<li>\\n\\t\\t<span>Service:<\\/span> <strong>{{service_name}}<\\/strong>\\n\\t<\\/li>\\n\\t<li>\\n\\t\\t<span>Date, Time:<\\/span> <strong>{{start_date}}, {{start_time}} - {{end_time}}<\\/strong>\\n\\t<\\/li>\\n<\\/ul>\\n<h4 style=\\\"margin-bottom: 10px; margin-top: 0px; font-size: 16px; font-weight: bold;\\\">Order Summary<\\/h4>\\n<div style=\\\"margin-bottom: 20px;\\\">{{order_summary_breakdown}}<\\/div>\\n<div style=\\\"margin-top: 25px;\\\">\\n\\t<a href=\\\"{{manage_booking_url_agent}}\\\" style=\\\"display: block; text-decoration: none; padding: 10px; border-radius: 6px; text-align: center; font-size: 18px; color: #fff; background-color: #1e7bff; font-weight: 700;\\\">Manage This Appointment<\\/a>\\n<\\/div>\\n\\t\\t<\\/div>\\n\\t<\\/div>\\n\\t<div style=\\\"max-width: 450px; margin: 10px auto; text-align: center;\\\">{{business_address}}<\\/div>\\n<\\/div>\"}}},{\"type\":\"action\",\"id\":\"pa_51ZT9j\",\"settings\":{\"status\":\"active\",\"type\":\"send_email\",\"settings\":{\"to_email\":\"{{customer_full_name}} <{{customer_email}}>\",\"subject\":\"Appointment Confirmation\",\"content\":\"<div style=\\\"padding: 20px; background-color: #f0f0f0; font-family: -apple-system, system-ui, BlinkMacSystemFont, \\\"Segoe UI\\\", Roboto, \\\"Helvetica Neue\\\", Arial, sans-serif;\\\">\\n\\t<div style=\\\"background-color: #fff; padding: 30px; margin: 0px auto; max-width: 450px; box-shadow: 0px 2px 6px -1px rgba(0,0,0,0.2); border-radius: 6px;\\\">\\n\\t\\t<div style=\\\"margin: 0px auto 30px auto; border-bottom: 1px solid #eee; padding-bottom: 20px;\\\">\\n\\t\\t\\t<table style=\\\"width: 100%;\\\">\\n\\t\\t\\t\\t<tr>\\n\\t\\t\\t\\t\\t<td>{{business_logo_image}}<\\/td>\\n\\t\\t\\t\\t\\t<td style=\\\"text-align: right;\\\"><span style=\\\"color: #7b7b7b;\\\">Questions?<\\/span><br\\/><strong>{{business_phone}}<\\/strong><\\/td>\\n\\t\\t\\t\\t<\\/tr>\\n\\t\\t\\t<\\/table>\\n\\t\\t<\\/div>\\n\\t\\t<div style=\\\"font-size: 16px; line-height: 1.5;\\\">\\n\\t\\t\\t<div style=\\\"font-size: 16px; margin-bottom: 20px; line-height: 1.6;\\\">\\n\\tHi {{customer_full_name}},\\n\\t<br>\\n\\t<br>\\n\\tYour {{service_name}} appointment with <strong>{{agent_full_name}}<\\/strong> is <strong>{{booking_status}}<\\/strong>.\\n<\\/div>\\n<h4 style=\\\"margin-bottom: 10px; margin-top: 0px; font-size: 16px; font-weight: bold;\\\">Appointment Details:<\\/h4>\\n<ul>\\n\\t<li>\\n\\t\\t<span>Agent:<\\/span> <strong>{{agent_full_name}}<\\/strong>\\n\\t<\\/li>\\n\\t<li>\\n\\t\\t<span>Service:<\\/span> <strong>{{service_name}}<\\/strong>\\n\\t<\\/li>\\n\\t<li>\\n\\t\\t<span>Date, Time:<\\/span> <strong>{{start_date}}, {{start_time}} - {{end_time}}<\\/strong>\\n\\t<\\/li>\\n<\\/ul>\\n<h4 style=\\\"margin-bottom: 10px; margin-top: 0px; font-size: 16px; font-weight: bold;\\\">Order Summary<\\/h4>\\n<div style=\\\"margin-bottom: 20px;\\\">{{order_summary_breakdown}}<\\/div>\\n<div style=\\\"margin-top: 25px;\\\">\\n\\t<a href=\\\"{{manage_booking_url_customer}}\\\" style=\\\"display: block; text-decoration: none; padding: 10px; border-radius: 6px; text-align: center; font-size: 18px; color: #fff; background-color: #1e7bff; font-weight: 700;\\\">Manage This Appointment<\\/a>\\n<\\/div>\\n\\t\\t<\\/div>\\n\\t<\\/div>\\n\\t<div style=\\\"max-width: 450px; margin: 10px auto; text-align: center;\\\">{{business_address}}<\\/div>\\n<\\/div>\"}}}],\"time_offset\":[]}]", "active", "2025-04-03 12:45:57", "2025-04-03 12:45:57");

/* INSERT TABLE DATA: wp_latepoint_service_meta */
INSERT INTO `wp_latepoint_service_meta` VALUES("1", "1", "durations", "[]", "2025-04-03 12:56:23", "2025-04-03 12:56:23");
INSERT INTO `wp_latepoint_service_meta` VALUES("2", "2", "durations", "[]", "2025-04-03 12:57:16", "2025-04-03 12:57:16");
INSERT INTO `wp_latepoint_service_meta` VALUES("3", "3", "durations", "[]", "2025-04-03 12:58:04", "2025-04-03 12:58:04");

/* INSERT TABLE DATA: wp_latepoint_services */
INSERT INTO `wp_latepoint_services` VALUES("1", "Pathologycam Testing", "", NULL, "60.0000", "70.0000", "70.0000", "0.0000", NULL, "", "", "60", "60", "60", "0", NULL, "56", "0", "#2752E4", "60", "1", "1", "active", "visible", "2025-04-03 12:56:23", "2025-04-03 12:56:23", NULL, NULL);
INSERT INTO `wp_latepoint_services` VALUES("2", "Mineral Assay", "", NULL, "70.0000", "80.0000", "80.0000", "0.0000", NULL, "", "", "60", "60", "60", "0", NULL, "54", "0", "#C066F1", "60", "1", "1", "active", "visible", "2025-04-03 12:57:16", "2025-04-03 12:57:16", NULL, NULL);
INSERT INTO `wp_latepoint_services` VALUES("3", "Pharmaceutical Research", "", NULL, "90.0000", "100.0000", "100.0000", "0.0000", NULL, "", "", "60", "60", "60", "0", NULL, "55", "0", "#26B7DD", "60", "1", "1", "active", "visible", "2025-04-03 12:58:04", "2025-04-03 12:58:04", NULL, NULL);

/* INSERT TABLE DATA: wp_latepoint_settings */
INSERT INTO `wp_latepoint_settings` VALUES("1", "default_booking_status", "approved", "2025-04-03 12:45:57", "2025-04-03 12:45:57");
INSERT INTO `wp_latepoint_settings` VALUES("2", "timeslot_blocking_statuses", "approved", "2025-04-03 12:45:57", "2025-04-03 12:45:57");
INSERT INTO `wp_latepoint_settings` VALUES("3", "calendar_hidden_statuses", "cancelled", "2025-04-03 12:45:57", "2025-04-03 12:45:57");
INSERT INTO `wp_latepoint_settings` VALUES("4", "need_action_statuses", "pending,payment_pending", "2025-04-03 12:45:57", "2025-04-03 12:45:57");
INSERT INTO `wp_latepoint_settings` VALUES("5", "is_database_seeded", "1", "2025-04-03 12:45:57", "2025-04-03 12:45:57");
INSERT INTO `wp_latepoint_settings` VALUES("6", "page_url_customer_dashboard", "/customer-cabinet", "2025-04-03 12:45:57", "2025-04-03 12:45:57");
INSERT INTO `wp_latepoint_settings` VALUES("7", "page_url_customer_login", "/customer-cabinet", "2025-04-03 12:45:57", "2025-04-03 12:45:57");
INSERT INTO `wp_latepoint_settings` VALUES("8", "step_codes_in_order", "booking__services,booking__agents,booking__datepicker,customer,verify,payment__times,payment__portions,payment__methods,payment__processors,payment__pay,confirmation", "2025-04-03 12:52:11", "2025-04-03 12:52:11");
INSERT INTO `wp_latepoint_settings` VALUES("9", "steps_settings", "a:12:{s:6:\"shared\";a:1:{s:18:\"steps_support_text\";s:54:\"<h5>Questions?</h5><p>Call (858) 939-3746 for help</p>\";}s:17:\"booking__services\";a:3:{s:18:\"side_panel_heading\";s:17:\"Service Selection\";s:22:\"side_panel_description\";s:69:\"Please select a service for which you want to schedule an appointment\";s:18:\"main_panel_heading\";s:18:\"Available Services\";}s:15:\"booking__agents\";a:3:{s:18:\"side_panel_heading\";s:15:\"Agent Selection\";s:22:\"side_panel_description\";s:59:\"Please select an agent that will be providing you a service\";s:18:\"main_panel_heading\";s:16:\"Available Agents\";}s:19:\"booking__datepicker\";a:3:{s:18:\"side_panel_heading\";s:18:\"Select Date & Time\";s:22:\"side_panel_description\";s:48:\"Please select date and time for your appointment\";s:18:\"main_panel_heading\";s:21:\"Date & Time Selection\";}s:8:\"customer\";a:3:{s:18:\"side_panel_heading\";s:22:\"Enter Your Information\";s:22:\"side_panel_description\";s:37:\"Please enter your contact information\";s:18:\"main_panel_heading\";s:20:\"Customer Information\";}s:6:\"verify\";a:3:{s:18:\"side_panel_heading\";s:20:\"Verify Order Details\";s:22:\"side_panel_description\";s:86:\"Double check your reservation details and click submit button if everything is correct\";s:18:\"main_panel_heading\";s:20:\"Verify Order Details\";}s:14:\"payment__times\";a:3:{s:18:\"side_panel_heading\";s:22:\"Payment Time Selection\";s:22:\"side_panel_description\";s:61:\"Please choose when you would like to pay for your appointment\";s:18:\"main_panel_heading\";s:27:\"When would you like to pay?\";}s:17:\"payment__portions\";a:3:{s:18:\"side_panel_heading\";s:25:\"Payment Portion Selection\";s:22:\"side_panel_description\";s:48:\"Please select how much you would like to pay now\";s:18:\"main_panel_heading\";s:35:\"How much would you like to pay now?\";}s:16:\"payment__methods\";a:3:{s:18:\"side_panel_heading\";s:24:\"Payment Method Selection\";s:22:\"side_panel_description\";s:68:\"Please select a payment method you would like to make a payment with\";s:18:\"main_panel_heading\";s:21:\"Select payment method\";}s:19:\"payment__processors\";a:3:{s:18:\"side_panel_heading\";s:27:\"Payment Processor Selection\";s:22:\"side_panel_description\";s:70:\"Please select a payment processor you want to process the payment with\";s:18:\"main_panel_heading\";s:24:\"Select payment processor\";}s:12:\"payment__pay\";a:3:{s:18:\"side_panel_heading\";s:14:\"Make a Payment\";s:22:\"side_panel_description\";s:67:\"Please enter your payment information so we can process the payment\";s:18:\"main_panel_heading\";s:30:\"Enter your payment information\";}s:12:\"confirmation\";a:3:{s:18:\"side_panel_heading\";s:12:\"Confirmation\";s:22:\"side_panel_description\";s:76:\"Your order has been placed. Please retain this confirmation for your record.\";s:18:\"main_panel_heading\";s:18:\"Order Confirmation\";}}", "2025-04-03 12:52:11", "2025-04-03 12:52:11");
INSERT INTO `wp_latepoint_settings` VALUES("10", "selected_customer_authentication_field_type", "email", "2025-10-01 23:36:37", "2025-10-01 23:36:37");

/* INSERT TABLE DATA: wp_latepoint_work_periods */
INSERT INTO `wp_latepoint_work_periods` VALUES("1", "0", "0", "0", "480", "1020", "1", NULL, NULL, "2025-04-03 12:46:24", "2025-04-03 12:46:24");
INSERT INTO `wp_latepoint_work_periods` VALUES("2", "0", "0", "0", "480", "1020", "2", NULL, NULL, "2025-04-03 12:46:24", "2025-04-03 12:46:24");
INSERT INTO `wp_latepoint_work_periods` VALUES("3", "0", "0", "0", "480", "1020", "3", NULL, NULL, "2025-04-03 12:46:24", "2025-04-03 12:46:24");
INSERT INTO `wp_latepoint_work_periods` VALUES("4", "0", "0", "0", "480", "1020", "4", NULL, NULL, "2025-04-03 12:46:24", "2025-04-03 12:46:24");
INSERT INTO `wp_latepoint_work_periods` VALUES("5", "0", "0", "0", "480", "1020", "5", NULL, NULL, "2025-04-03 12:46:24", "2025-04-03 12:46:24");
INSERT INTO `wp_latepoint_work_periods` VALUES("6", "0", "0", "0", "480", "1020", "6", NULL, NULL, "2025-04-03 12:46:24", "2025-04-03 12:46:24");
INSERT INTO `wp_latepoint_work_periods` VALUES("7", "0", "0", "0", "480", "1020", "7", NULL, NULL, "2025-04-03 12:46:24", "2025-04-03 12:46:24");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "cron", "a:21:{i:1764862430;a:2:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}s:27:\"litespeed_task_imgoptm_pull\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:16:\"litespeed_filter\";s:4:\"args\";a:0:{}s:8:\"interval\";i:60;}}}i:1764862433;a:1:{s:19:\"litespeed_task_lqip\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:16:\"litespeed_filter\";s:4:\"args\";a:0:{}s:8:\"interval\";i:60;}}}i:1764864510;a:2:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1764866310;a:1:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1764868110;a:1:{s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1764868813;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1764904152;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1764917925;a:1:{s:24:\"suremails_weekly_summary\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1764937573;a:1:{s:22:\"suremails_cleanup_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1764939355;a:2:{s:42:\"latepoint_check_if_addons_update_available\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:33:\"latepoint_clear_old_activity_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1764947310;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1764947352;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1764948004;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1765018858;a:1:{s:24:\"astra_delete_docs_folder\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1765152000;a:2:{s:28:\"wpforms_email_summaries_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}s:33:\"wpforms_weekly_entries_count_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1765171681;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1765202400;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1765292914;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1765292951;a:1:{s:24:\"run_weekly_partner_astra\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1765379310;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `wp_options` VALUES("2", "siteurl", "https://zaynventures.com", "on");
INSERT INTO `wp_options` VALUES("3", "home", "https://zaynventures.com", "on");
INSERT INTO `wp_options` VALUES("4", "blogname", "Zayn Ventures", "on");
INSERT INTO `wp_options` VALUES("5", "blogdescription", "", "on");
INSERT INTO `wp_options` VALUES("6", "users_can_register", "0", "on");
INSERT INTO `wp_options` VALUES("7", "admin_email", "ali.talha3358@gmail.com", "on");
INSERT INTO `wp_options` VALUES("8", "start_of_week", "1", "on");
INSERT INTO `wp_options` VALUES("9", "use_balanceTags", "0", "on");
INSERT INTO `wp_options` VALUES("10", "use_smilies", "1", "on");
INSERT INTO `wp_options` VALUES("11", "require_name_email", "1", "on");
INSERT INTO `wp_options` VALUES("12", "comments_notify", "1", "on");
INSERT INTO `wp_options` VALUES("13", "posts_per_rss", "10", "on");
INSERT INTO `wp_options` VALUES("14", "rss_use_excerpt", "0", "on");
INSERT INTO `wp_options` VALUES("15", "mailserver_url", "mail.example.com", "on");
INSERT INTO `wp_options` VALUES("16", "mailserver_login", "login@example.com", "on");
INSERT INTO `wp_options` VALUES("17", "mailserver_pass", "", "on");
INSERT INTO `wp_options` VALUES("18", "mailserver_port", "110", "on");
INSERT INTO `wp_options` VALUES("19", "default_category", "1", "on");
INSERT INTO `wp_options` VALUES("20", "default_comment_status", "open", "on");
INSERT INTO `wp_options` VALUES("21", "default_ping_status", "open", "on");
INSERT INTO `wp_options` VALUES("22", "default_pingback_flag", "1", "on");
INSERT INTO `wp_options` VALUES("23", "posts_per_page", "10", "on");
INSERT INTO `wp_options` VALUES("24", "date_format", "F j, Y", "on");
INSERT INTO `wp_options` VALUES("25", "time_format", "g:i a", "on");
INSERT INTO `wp_options` VALUES("26", "links_updated_date_format", "F j, Y g:i a", "on");
INSERT INTO `wp_options` VALUES("27", "comment_moderation", "0", "on");
INSERT INTO `wp_options` VALUES("28", "moderation_notify", "1", "on");
INSERT INTO `wp_options` VALUES("29", "permalink_structure", "/%postname%/", "on");
INSERT INTO `wp_options` VALUES("30", "rewrite_rules", "a:146:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:46:\"e-floating-buttons/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:56:\"e-floating-buttons/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:76:\"e-floating-buttons/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:52:\"e-floating-buttons/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"e-floating-buttons/([^/]+)/embed/?$\";s:51:\"index.php?e-floating-buttons=$matches[1]&embed=true\";s:39:\"e-floating-buttons/([^/]+)/trackback/?$\";s:45:\"index.php?e-floating-buttons=$matches[1]&tb=1\";s:47:\"e-floating-buttons/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&paged=$matches[2]\";s:54:\"e-floating-buttons/([^/]+)/comment-page-([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&cpage=$matches[2]\";s:43:\"e-floating-buttons/([^/]+)(?:/([0-9]+))?/?$\";s:57:\"index.php?e-floating-buttons=$matches[1]&page=$matches[2]\";s:35:\"e-floating-buttons/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"e-floating-buttons/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"e-floating-buttons/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"e-floating-buttons/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:40:\"elementor-hf/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"elementor-hf/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"elementor-hf/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"elementor-hf/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"elementor-hf/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"elementor-hf/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"elementor-hf/([^/]+)/embed/?$\";s:45:\"index.php?elementor-hf=$matches[1]&embed=true\";s:33:\"elementor-hf/([^/]+)/trackback/?$\";s:39:\"index.php?elementor-hf=$matches[1]&tb=1\";s:41:\"elementor-hf/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?elementor-hf=$matches[1]&paged=$matches[2]\";s:48:\"elementor-hf/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?elementor-hf=$matches[1]&cpage=$matches[2]\";s:37:\"elementor-hf/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?elementor-hf=$matches[1]&page=$matches[2]\";s:29:\"elementor-hf/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"elementor-hf/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"elementor-hf/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"elementor-hf/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"elementor-hf/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"elementor-hf/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:41:\"spectra-popup/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:51:\"spectra-popup/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:71:\"spectra-popup/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"spectra-popup/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"spectra-popup/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:47:\"spectra-popup/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:30:\"spectra-popup/([^/]+)/embed/?$\";s:46:\"index.php?spectra-popup=$matches[1]&embed=true\";s:34:\"spectra-popup/([^/]+)/trackback/?$\";s:40:\"index.php?spectra-popup=$matches[1]&tb=1\";s:42:\"spectra-popup/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?spectra-popup=$matches[1]&paged=$matches[2]\";s:49:\"spectra-popup/([^/]+)/comment-page-([0-9]{1,})/?$\";s:53:\"index.php?spectra-popup=$matches[1]&cpage=$matches[2]\";s:38:\"spectra-popup/([^/]+)(?:/([0-9]+))?/?$\";s:52:\"index.php?spectra-popup=$matches[1]&page=$matches[2]\";s:30:\"spectra-popup/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:40:\"spectra-popup/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:60:\"spectra-popup/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"spectra-popup/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"spectra-popup/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:36:\"spectra-popup/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:12:\"sitemap\\.xml\";s:24:\"index.php??sitemap=index\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:40:\"index.php?&page_id=319&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "on");
INSERT INTO `wp_options` VALUES("31", "hack_file", "0", "on");
INSERT INTO `wp_options` VALUES("32", "blog_charset", "UTF-8", "on");
INSERT INTO `wp_options` VALUES("33", "moderation_keys", "", "off");
INSERT INTO `wp_options` VALUES("34", "active_plugins", "a:10:{i:0;s:41:\"1-click-migration/one-click-migration.php\";i:1;s:27:\"astra-sites/astra-sites.php\";i:2;s:25:\"duplicator/duplicator.php\";i:3;s:23:\"elementor/elementor.php\";i:4;s:51:\"header-footer-elementor/header-footer-elementor.php\";i:5;s:23:\"latepoint/latepoint.php\";i:6;s:35:\"litespeed-cache/litespeed-cache.php\";i:7;s:23:\"suremails/suremails.php\";i:8;s:63:\"ultimate-addons-for-gutenberg/ultimate-addons-for-gutenberg.php\";i:9;s:24:\"wpforms-lite/wpforms.php\";}", "on");
INSERT INTO `wp_options` VALUES("35", "category_base", "", "on");
INSERT INTO `wp_options` VALUES("36", "ping_sites", "http://rpc.pingomatic.com/", "on");
INSERT INTO `wp_options` VALUES("37", "comment_max_links", "2", "on");
INSERT INTO `wp_options` VALUES("38", "gmt_offset", "0", "on");
INSERT INTO `wp_options` VALUES("39", "default_email_category", "1", "on");
INSERT INTO `wp_options` VALUES("40", "recently_edited", "", "off");
INSERT INTO `wp_options` VALUES("41", "template", "astra", "on");
INSERT INTO `wp_options` VALUES("42", "stylesheet", "astra", "on");
INSERT INTO `wp_options` VALUES("43", "comment_registration", "0", "on");
INSERT INTO `wp_options` VALUES("44", "html_type", "text/html", "on");
INSERT INTO `wp_options` VALUES("45", "use_trackback", "0", "on");
INSERT INTO `wp_options` VALUES("46", "default_role", "subscriber", "on");
INSERT INTO `wp_options` VALUES("47", "db_version", "58975", "on");
INSERT INTO `wp_options` VALUES("48", "uploads_use_yearmonth_folders", "1", "on");
INSERT INTO `wp_options` VALUES("49", "upload_path", "", "on");
INSERT INTO `wp_options` VALUES("50", "blog_public", "1", "on");
INSERT INTO `wp_options` VALUES("51", "default_link_category", "2", "on");
INSERT INTO `wp_options` VALUES("52", "show_on_front", "page", "on");
INSERT INTO `wp_options` VALUES("53", "tag_base", "", "on");
INSERT INTO `wp_options` VALUES("54", "show_avatars", "1", "on");
INSERT INTO `wp_options` VALUES("55", "avatar_rating", "G", "on");
INSERT INTO `wp_options` VALUES("56", "upload_url_path", "", "on");
INSERT INTO `wp_options` VALUES("57", "thumbnail_size_w", "150", "on");
INSERT INTO `wp_options` VALUES("58", "thumbnail_size_h", "150", "on");
INSERT INTO `wp_options` VALUES("59", "thumbnail_crop", "1", "on");
INSERT INTO `wp_options` VALUES("60", "medium_size_w", "300", "on");
INSERT INTO `wp_options` VALUES("61", "medium_size_h", "300", "on");
INSERT INTO `wp_options` VALUES("62", "avatar_default", "mystery", "on");
INSERT INTO `wp_options` VALUES("63", "large_size_w", "1024", "on");
INSERT INTO `wp_options` VALUES("64", "large_size_h", "1024", "on");
INSERT INTO `wp_options` VALUES("65", "image_default_link_type", "none", "on");
INSERT INTO `wp_options` VALUES("66", "image_default_size", "", "on");
INSERT INTO `wp_options` VALUES("67", "image_default_align", "", "on");
INSERT INTO `wp_options` VALUES("68", "close_comments_for_old_posts", "0", "on");
INSERT INTO `wp_options` VALUES("69", "close_comments_days_old", "14", "on");
INSERT INTO `wp_options` VALUES("70", "thread_comments", "1", "on");
INSERT INTO `wp_options` VALUES("71", "thread_comments_depth", "5", "on");
INSERT INTO `wp_options` VALUES("72", "page_comments", "0", "on");
INSERT INTO `wp_options` VALUES("73", "comments_per_page", "50", "on");
INSERT INTO `wp_options` VALUES("74", "default_comments_page", "newest", "on");
INSERT INTO `wp_options` VALUES("75", "comment_order", "asc", "on");
INSERT INTO `wp_options` VALUES("76", "sticky_posts", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("77", "widget_categories", "a:3:{i:1;a:0:{}i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("78", "widget_text", "a:3:{i:1;a:0:{}i:2;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:503:\"<p data-pm-slice=\"1 1 []\"><img class=\"alignnone wp-image-1938\" src=\"https://zaynventures.com/wp-content/uploads/2025/04/Zayn-Ventures-01-1-300x150.png\" alt=\"\" width=\"155\" height=\"78\" /></p>\n<p data-pm-slice=\"1 1 []\">Zayn Ventures is a healthcare-focused venture capital firm dedicated to supporting bold startups in biotech, digital health, and AI-driven medical innovation. As a subsidiary of Zayn Health Group, we combine strategic funding with healthcare expertise to accelerate impactful change.</p>\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}s:12:\"_multiwidget\";i:1;}", "on");
INSERT INTO `wp_options` VALUES("79", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("80", "uninstall_plugins", "a:2:{s:35:\"litespeed-cache/litespeed-cache.php\";s:47:\"LiteSpeed\\Activation::uninstall_litespeed_cache\";s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}}", "off");
INSERT INTO `wp_options` VALUES("81", "timezone_string", "", "on");
INSERT INTO `wp_options` VALUES("82", "page_for_posts", "0", "on");
INSERT INTO `wp_options` VALUES("83", "page_on_front", "319", "on");
INSERT INTO `wp_options` VALUES("84", "default_post_format", "0", "on");
INSERT INTO `wp_options` VALUES("85", "link_manager_enabled", "0", "on");
INSERT INTO `wp_options` VALUES("86", "finished_splitting_shared_terms", "1", "on");
INSERT INTO `wp_options` VALUES("87", "site_icon", "0", "on");
INSERT INTO `wp_options` VALUES("88", "medium_large_size_w", "768", "on");
INSERT INTO `wp_options` VALUES("89", "medium_large_size_h", "0", "on");
INSERT INTO `wp_options` VALUES("90", "wp_page_for_privacy_policy", "3", "on");
INSERT INTO `wp_options` VALUES("91", "show_comments_cookies_opt_in", "1", "on");
INSERT INTO `wp_options` VALUES("92", "admin_email_lifespan", "1763982899", "on");
INSERT INTO `wp_options` VALUES("93", "disallowed_keys", "", "off");
INSERT INTO `wp_options` VALUES("94", "comment_previously_approved", "1", "on");
INSERT INTO `wp_options` VALUES("95", "auto_plugin_theme_update_emails", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("96", "auto_update_core_dev", "enabled", "on");
INSERT INTO `wp_options` VALUES("97", "auto_update_core_minor", "enabled", "on");
INSERT INTO `wp_options` VALUES("98", "auto_update_core_major", "enabled", "on");
INSERT INTO `wp_options` VALUES("100", "wp_attachment_pages_enabled", "0", "on");
INSERT INTO `wp_options` VALUES("101", "initial_db_version", "58975", "on");
INSERT INTO `wp_options` VALUES("102", "wp_user_roles", "a:6:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:63:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:23:\"manage_zip_ai_assistant\";b:1;s:26:\"manage_ast_block_templates\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:35:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:23:\"manage_zip_ai_assistant\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:15:\"latepoint_agent\";a:2:{s:4:\"name\";s:15:\"LatePoint Agent\";s:12:\"capabilities\";a:3:{s:4:\"read\";b:1;s:12:\"upload_files\";b:1;s:13:\"edit_bookings\";b:1;}}}", "on");
INSERT INTO `wp_options` VALUES("103", "fresh_site", "0", "off");
INSERT INTO `wp_options` VALUES("104", "user_count", "2", "off");
INSERT INTO `wp_options` VALUES("105", "widget_block", "a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:154:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:227:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("106", "sidebars_widgets", "a:11:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-1\";i:1;s:14:\"recent-posts-1\";i:2;s:17:\"recent-comments-1\";i:3;s:10:\"archives-1\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-1\";}s:15:\"footer-widget-1\";a:1:{i:0;s:6:\"text-2\";}s:15:\"footer-widget-2\";a:1:{i:0;s:10:\"nav_menu-1\";}s:24:\"advanced-footer-widget-1\";a:0:{}s:24:\"advanced-footer-widget-2\";a:0:{}s:24:\"advanced-footer-widget-3\";a:0:{}s:24:\"advanced-footer-widget-4\";a:0:{}s:13:\"array_version\";i:3;s:15:\"footer-widget-3\";a:1:{i:0;s:10:\"nav_menu-2\";}s:15:\"footer-widget-4\";a:1:{i:0;s:10:\"nav_menu-3\";}}", "on");
INSERT INTO `wp_options` VALUES("107", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("108", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("109", "widget_archives", "a:2:{i:1;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("110", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("111", "widget_media_image", "a:2:{i:1;a:15:{s:4:\"size\";s:6:\"custom\";s:5:\"width\";i:150;s:6:\"height\";i:75;s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:9:\"link_type\";s:6:\"custom\";s:8:\"link_url\";s:0:\"\";s:13:\"image_classes\";s:0:\"\";s:12:\"link_classes\";s:0:\"\";s:8:\"link_rel\";s:0:\"\";s:17:\"link_target_blank\";b:0;s:11:\"image_title\";s:0:\"\";s:13:\"attachment_id\";i:1938;s:3:\"url\";s:74:\"https://zaynventures.com/wp-content/uploads/2025/04/Zayn-Ventures-01-1.png\";s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "on");
INSERT INTO `wp_options` VALUES("112", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("113", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("114", "widget_meta", "a:2:{i:1;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("115", "widget_search", "a:2:{i:1;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("116", "widget_recent-posts", "a:2:{i:1;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("117", "widget_recent-comments", "a:2:{i:1;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("118", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("119", "widget_nav_menu", "a:4:{i:1;a:2:{s:5:\"title\";s:7:\"Connect\";s:8:\"nav_menu\";i:6;}i:2;a:2:{s:5:\"title\";s:12:\"Useful Links\";s:8:\"nav_menu\";i:5;}i:3;a:2:{s:5:\"title\";s:5:\"Legal\";s:8:\"nav_menu\";i:7;}s:12:\"_multiwidget\";i:1;}", "on");
INSERT INTO `wp_options` VALUES("120", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("125", "recovery_keys", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("126", "theme_mods_twentytwentyfive", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1739891327;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "off");
INSERT INTO `wp_options` VALUES("134", "hostinger_show_onboarding", "1", "auto");
INSERT INTO `wp_options` VALUES("135", "optin_monster_api_activation_redirect_disabled", "true", "auto");
INSERT INTO `wp_options` VALUES("136", "wpforms_activation_redirect", "true", "auto");
INSERT INTO `wp_options` VALUES("137", "aioseo_activation_redirect", "false", "auto");
INSERT INTO `wp_options` VALUES("138", "hts_new_installation", "new", "auto");
INSERT INTO `wp_options` VALUES("140", "external_updates-hostinger-easy-onboarding", "O:8:\"stdClass\":5:{s:9:\"lastCheck\";i:1744124349;s:14:\"checkedVersion\";s:6:\"2.0.65\";s:6:\"update\";O:8:\"stdClass\":11:{s:4:\"slug\";s:25:\"hostinger-easy-onboarding\";s:7:\"version\";s:6:\"2.0.71\";s:12:\"download_url\";s:89:\"https://wp-update.hostinger.io/?action=download&slug=hostinger-easy-onboarding&ver=2.0.71\";s:12:\"translations\";a:0:{}s:2:\"id\";i:0;s:8:\"homepage\";s:21:\"https://hostinger.com\";s:6:\"tested\";s:5:\"6.7.2\";s:12:\"requires_php\";s:3:\"8.0\";s:14:\"upgrade_notice\";N;s:5:\"icons\";a:0:{}s:8:\"filename\";s:55:\"hostinger-easy-onboarding/hostinger-easy-onboarding.php\";}s:11:\"updateClass\";s:50:\"YahnisElsts\\PluginUpdateChecker\\v5p5\\Plugin\\Update\";s:15:\"updateBaseClass\";s:13:\"Plugin\\Update\";}", "off");
INSERT INTO `wp_options` VALUES("142", "hostinger_tools", "a:6:{s:16:\"maintenance_mode\";b:0;s:11:\"bypass_code\";s:16:\"CnPAFrjlbQYIurrI\";s:15:\"disable_xml_rpc\";b:0;s:11:\"force_https\";b:0;s:9:\"force_www\";b:0;s:31:\"disable_authentication_password\";b:1;}", "off");
INSERT INTO `wp_options` VALUES("148", "external_updates-hostinger-ai-assistant", "O:8:\"stdClass\":5:{s:9:\"lastCheck\";i:1744124349;s:14:\"checkedVersion\";s:6:\"2.0.31\";s:6:\"update\";O:8:\"stdClass\":11:{s:4:\"slug\";s:22:\"hostinger-ai-assistant\";s:7:\"version\";s:6:\"2.0.34\";s:12:\"download_url\";s:86:\"https://wp-update.hostinger.io/?action=download&slug=hostinger-ai-assistant&ver=2.0.34\";s:12:\"translations\";a:0:{}s:2:\"id\";i:0;s:8:\"homepage\";s:21:\"https://hostinger.com\";s:6:\"tested\";s:7:\"6.5.999\";s:12:\"requires_php\";s:3:\"8.0\";s:14:\"upgrade_notice\";N;s:5:\"icons\";a:0:{}s:8:\"filename\";s:49:\"hostinger-ai-assistant/hostinger-ai-assistant.php\";}s:11:\"updateClass\";s:50:\"YahnisElsts\\PluginUpdateChecker\\v5p5\\Plugin\\Update\";s:15:\"updateBaseClass\";s:13:\"Plugin\\Update\";}", "off");
INSERT INTO `wp_options` VALUES("149", "hostinger_subscription_id", "AzqRyKUdATOsR3qeT", "on");
INSERT INTO `wp_options` VALUES("150", "hostinger_hosting_plan", "hostinger_business", "on");
INSERT INTO `wp_options` VALUES("153", "current_theme", "Astra", "auto");
INSERT INTO `wp_options` VALUES("154", "theme_mods_hostinger-ai-theme", "a:4:{s:19:\"wp_classic_sidebars\";a:0:{}s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1744132765;s:4:\"data\";a:1:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}}}}", "off");
INSERT INTO `wp_options` VALUES("155", "theme_switched", "", "auto");
INSERT INTO `wp_options` VALUES("156", "hostinger_client_type", "managed", "off");
INSERT INTO `wp_options` VALUES("157", "hostinger_builder_type", "ai", "off");
INSERT INTO `wp_options` VALUES("158", "hostinger_theme", "hostinger-ai-theme", "off");
INSERT INTO `wp_options` VALUES("159", "hostinger_appearance", "themes", "off");
INSERT INTO `wp_options` VALUES("160", "hostinger_ai_builder", "1", "off");
INSERT INTO `wp_options` VALUES("161", "hostinger_website_id", "1840e0662fc6620b13179295e7161d1f", "off");
INSERT INTO `wp_options` VALUES("162", "hostinger_created_at", "2025-02-18 15:08:33", "off");
INSERT INTO `wp_options` VALUES("165", "litespeed.conf.__activation", "-1", "auto");
INSERT INTO `wp_options` VALUES("166", "hostinger_reseller", "hostinger.com", "off");
INSERT INTO `wp_options` VALUES("167", "recently_activated", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("168", "litespeed.cloud._summary", "{\"curr_request.ver_check\":0,\"last_request.ver_check\":1761882448,\"ips_ts\":1740556976,\"ips_ts_runner\":1740556976,\"ips\":[\"102.221.36.98\",\"103.106.229.82\",\"103.106.229.94\",\"103.146.63.42\",\"103.152.118.219\",\"103.152.118.72\",\"103.164.203.163\",\"103.188.22.12\",\"103.28.90.190\",\"103.75.117.169\",\"104.225.142.116\",\"104.244.77.37\",\"108.61.158.223\",\"108.61.200.94\",\"109.248.43.195\",\"135.148.120.32\",\"136.243.106.228\",\"139.84.230.39\",\"141.164.38.65\",\"145.239.252.65\",\"146.88.239.197\",\"147.78.0.165\",\"147.78.3.13\",\"147.78.3.161\",\"149.28.136.245\",\"149.28.47.113\",\"149.28.85.239\",\"152.228.171.66\",\"152.53.36.14\",\"152.53.38.14\",\"154.205.144.192\",\"155.138.221.81\",\"156.67.218.140\",\"157.90.154.114\",\"158.51.123.249\",\"162.254.117.80\",\"162.254.118.29\",\"163.182.174.161\",\"163.47.21.168\",\"164.52.202.100\",\"167.71.185.204\",\"167.88.61.211\",\"170.249.218.98\",\"178.17.171.177\",\"178.22.124.247\",\"178.22.124.251\",\"178.255.220.12\",\"18.192.146.200\",\"185.116.60.231\",\"185.116.60.232\",\"185.126.237.51\",\"185.212.169.91\",\"185.228.26.40\",\"185.53.57.40\",\"185.53.57.89\",\"188.172.228.182\",\"188.172.229.113\",\"188.64.184.71\",\"190.92.176.5\",\"191.96.101.140\",\"192.248.156.201\",\"192.248.191.135\",\"192.99.38.117\",\"193.203.191.189\",\"194.163.134.104\",\"194.36.144.221\",\"195.231.17.141\",\"198.38.89.73\",\"199.247.28.91\",\"199.59.247.242\",\"201.182.97.70\",\"202.61.226.253\",\"204.10.163.237\",\"209.124.84.191\",\"209.208.26.218\",\"211.23.143.87\",\"213.159.1.75\",\"213.183.48.170\",\"213.184.85.245\",\"216.238.104.48\",\"216.238.71.13\",\"23.95.73.167\",\"27.131.75.41\",\"31.131.4.244\",\"31.22.115.186\",\"31.40.212.152\",\"34.247.229.180\",\"34.249.110.197\",\"38.101.149.196\",\"38.114.121.40\",\"38.54.30.228\",\"38.54.79.187\",\"38.60.253.237\",\"41.185.29.210\",\"41.223.52.170\",\"45.124.65.86\",\"45.248.77.61\",\"45.32.123.201\",\"45.32.183.112\",\"45.32.210.159\",\"45.32.67.144\",\"45.32.77.223\",\"45.63.67.181\",\"45.76.247.71\",\"45.76.252.131\",\"45.77.148.74\",\"45.77.165.216\",\"45.77.51.171\",\"46.250.220.133\",\"49.12.102.29\",\"5.134.119.103\",\"5.134.119.194\",\"5.188.183.13\",\"5.189.146.228\",\"51.81.186.219\",\"51.81.33.156\",\"54.246.224.74\",\"54.36.103.97\",\"61.219.247.87\",\"61.219.247.90\",\"64.176.163.166\",\"64.176.4.251\",\"64.227.16.93\",\"64.31.63.160\",\"65.108.104.232\",\"65.20.76.133\",\"65.21.81.50\",\"65.21.81.51\",\"66.42.124.101\",\"66.42.75.121\",\"67.219.99.102\",\"69.50.95.216\",\"70.34.205.229\",\"79.172.239.249\",\"81.31.156.245\",\"81.31.156.246\",\"86.105.14.231\",\"86.105.14.232\",\"89.147.110.130\",\"89.58.38.4\",\"91.148.135.53\",\"91.201.67.57\",\"91.228.7.67\",\"92.118.205.75\",\"94.75.232.90\",\"95.179.145.87\",\"95.179.245.162\",\"95.216.116.209\"],\"news.utime\":1764336582,\"curr_request.news\":0,\"last_request.news\":1764336582}", "auto");
INSERT INTO `wp_options` VALUES("170", "litespeed.conf.hash", "Uf4pD19hOdcOwRnLNBu5ROaAzuvBfGF7", "auto");
INSERT INTO `wp_options` VALUES("171", "litespeed.conf.auto_upgrade", "", "auto");
INSERT INTO `wp_options` VALUES("172", "litespeed.conf.api_key", "", "auto");
INSERT INTO `wp_options` VALUES("173", "litespeed.conf.server_ip", "", "auto");
INSERT INTO `wp_options` VALUES("174", "litespeed.conf.guest", "", "auto");
INSERT INTO `wp_options` VALUES("175", "litespeed.conf.guest_optm", "", "auto");
INSERT INTO `wp_options` VALUES("176", "litespeed.conf.news", "1", "auto");
INSERT INTO `wp_options` VALUES("177", "litespeed.conf.guest_uas", "[\"Lighthouse\",\"GTmetrix\",\"Google\",\"Pingdom\",\"bot\",\"spider\",\"PTST\",\"HeadlessChrome\"]", "auto");
INSERT INTO `wp_options` VALUES("178", "litespeed.conf.guest_ips", "[\"208.70.247.157\",\"172.255.48.130\",\"172.255.48.131\",\"172.255.48.132\",\"172.255.48.133\",\"172.255.48.134\",\"172.255.48.135\",\"172.255.48.136\",\"172.255.48.137\",\"172.255.48.138\",\"172.255.48.139\",\"172.255.48.140\",\"172.255.48.141\",\"172.255.48.142\",\"172.255.48.143\",\"172.255.48.144\",\"172.255.48.145\",\"172.255.48.146\",\"172.255.48.147\",\"52.229.122.240\",\"104.214.72.101\",\"13.66.7.11\",\"13.85.24.83\",\"13.85.24.90\",\"13.85.82.26\",\"40.74.242.253\",\"40.74.243.13\",\"40.74.243.176\",\"104.214.48.247\",\"157.55.189.189\",\"104.214.110.135\",\"70.37.83.240\",\"65.52.36.250\",\"13.78.216.56\",\"52.162.212.163\",\"23.96.34.105\",\"65.52.113.236\",\"172.255.61.34\",\"172.255.61.35\",\"172.255.61.36\",\"172.255.61.37\",\"172.255.61.38\",\"172.255.61.39\",\"172.255.61.40\",\"104.41.2.19\",\"191.235.98.164\",\"191.235.99.221\",\"191.232.194.51\",\"52.237.235.185\",\"52.237.250.73\",\"52.237.236.145\",\"104.211.143.8\",\"104.211.165.53\",\"52.172.14.87\",\"40.83.89.214\",\"52.175.57.81\",\"20.188.63.151\",\"20.52.36.49\",\"52.246.165.153\",\"51.144.102.233\",\"13.76.97.224\",\"102.133.169.66\",\"52.231.199.170\",\"13.53.162.7\",\"40.123.218.94\"]", "auto");
INSERT INTO `wp_options` VALUES("179", "litespeed.conf.cache", "1", "auto");
INSERT INTO `wp_options` VALUES("180", "litespeed.conf.cache-priv", "1", "auto");
INSERT INTO `wp_options` VALUES("181", "litespeed.conf.cache-commenter", "1", "auto");
INSERT INTO `wp_options` VALUES("182", "litespeed.conf.cache-rest", "1", "auto");
INSERT INTO `wp_options` VALUES("183", "litespeed.conf.cache-page_login", "1", "auto");
INSERT INTO `wp_options` VALUES("184", "litespeed.conf.cache-resources", "1", "auto");
INSERT INTO `wp_options` VALUES("185", "litespeed.conf.cache-mobile", "", "auto");
INSERT INTO `wp_options` VALUES("186", "litespeed.conf.cache-mobile_rules", "[\"Mobile\",\"Android\",\"Silk\\/\",\"Kindle\",\"BlackBerry\",\"Opera Mini\",\"Opera Mobi\"]", "auto");
INSERT INTO `wp_options` VALUES("187", "litespeed.conf.cache-browser", "", "auto");
INSERT INTO `wp_options` VALUES("188", "litespeed.conf.cache-exc_useragents", "[]", "auto");
INSERT INTO `wp_options` VALUES("189", "litespeed.conf.cache-exc_cookies", "[]", "auto");
INSERT INTO `wp_options` VALUES("190", "litespeed.conf.cache-exc_qs", "[]", "auto");
INSERT INTO `wp_options` VALUES("191", "litespeed.conf.cache-exc_cat", "[]", "auto");
INSERT INTO `wp_options` VALUES("192", "litespeed.conf.cache-exc_tag", "[]", "auto");
INSERT INTO `wp_options` VALUES("193", "litespeed.conf.cache-force_uri", "[]", "auto");
INSERT INTO `wp_options` VALUES("194", "litespeed.conf.cache-force_pub_uri", "[]", "auto");
INSERT INTO `wp_options` VALUES("195", "litespeed.conf.cache-priv_uri", "[]", "auto");
INSERT INTO `wp_options` VALUES("196", "litespeed.conf.cache-exc", "[]", "auto");
INSERT INTO `wp_options` VALUES("197", "litespeed.conf.cache-exc_roles", "[]", "auto");
INSERT INTO `wp_options` VALUES("198", "litespeed.conf.cache-drop_qs", "[\"fbclid\",\"gclid\",\"utm*\",\"_ga\"]", "auto");
INSERT INTO `wp_options` VALUES("199", "litespeed.conf.cache-ttl_pub", "604800", "auto");
INSERT INTO `wp_options` VALUES("200", "litespeed.conf.cache-ttl_priv", "1800", "auto");
INSERT INTO `wp_options` VALUES("201", "litespeed.conf.cache-ttl_frontpage", "604800", "auto");
INSERT INTO `wp_options` VALUES("202", "litespeed.conf.cache-ttl_feed", "604800", "auto");
INSERT INTO `wp_options` VALUES("203", "litespeed.conf.cache-ttl_rest", "604800", "auto");
INSERT INTO `wp_options` VALUES("204", "litespeed.conf.cache-ttl_browser", "31557600", "auto");
INSERT INTO `wp_options` VALUES("205", "litespeed.conf.cache-ttl_status", "[\"404 3600\",\"500 600\"]", "auto");
INSERT INTO `wp_options` VALUES("206", "litespeed.conf.cache-login_cookie", "", "auto");
INSERT INTO `wp_options` VALUES("207", "litespeed.conf.cache-ajax_ttl", "[]", "auto");
INSERT INTO `wp_options` VALUES("208", "litespeed.conf.cache-vary_cookies", "[]", "auto");
INSERT INTO `wp_options` VALUES("209", "litespeed.conf.cache-vary_group", "[]", "auto");
INSERT INTO `wp_options` VALUES("210", "litespeed.conf.purge-upgrade", "1", "auto");
INSERT INTO `wp_options` VALUES("211", "litespeed.conf.purge-stale", "", "auto");
INSERT INTO `wp_options` VALUES("212", "litespeed.conf.purge-post_all", "", "auto");
INSERT INTO `wp_options` VALUES("213", "litespeed.conf.purge-post_f", "1", "auto");
INSERT INTO `wp_options` VALUES("214", "litespeed.conf.purge-post_h", "1", "auto");
INSERT INTO `wp_options` VALUES("215", "litespeed.conf.purge-post_p", "1", "auto");
INSERT INTO `wp_options` VALUES("216", "litespeed.conf.purge-post_pwrp", "1", "auto");
INSERT INTO `wp_options` VALUES("217", "litespeed.conf.purge-post_a", "1", "auto");
INSERT INTO `wp_options` VALUES("218", "litespeed.conf.purge-post_y", "", "auto");
INSERT INTO `wp_options` VALUES("219", "litespeed.conf.purge-post_m", "1", "auto");
INSERT INTO `wp_options` VALUES("220", "litespeed.conf.purge-post_d", "", "auto");
INSERT INTO `wp_options` VALUES("221", "litespeed.conf.purge-post_t", "1", "auto");
INSERT INTO `wp_options` VALUES("222", "litespeed.conf.purge-post_pt", "1", "auto");
INSERT INTO `wp_options` VALUES("223", "litespeed.conf.purge-timed_urls", "[]", "auto");
INSERT INTO `wp_options` VALUES("224", "litespeed.conf.purge-timed_urls_time", "", "auto");
INSERT INTO `wp_options` VALUES("225", "litespeed.conf.purge-hook_all", "[\"switch_theme\",\"wp_create_nav_menu\",\"wp_update_nav_menu\",\"wp_delete_nav_menu\",\"create_term\",\"edit_terms\",\"delete_term\",\"add_link\",\"edit_link\",\"delete_link\"]", "auto");
INSERT INTO `wp_options` VALUES("226", "litespeed.conf.esi", "", "auto");
INSERT INTO `wp_options` VALUES("227", "litespeed.conf.esi-cache_admbar", "1", "auto");
INSERT INTO `wp_options` VALUES("228", "litespeed.conf.esi-cache_commform", "1", "auto");
INSERT INTO `wp_options` VALUES("229", "litespeed.conf.esi-nonce", "[\"stats_nonce\",\"subscribe_nonce\"]", "auto");
INSERT INTO `wp_options` VALUES("230", "litespeed.conf.util-instant_click", "", "auto");
INSERT INTO `wp_options` VALUES("231", "litespeed.conf.util-no_https_vary", "", "auto");
INSERT INTO `wp_options` VALUES("232", "litespeed.conf.debug-disable_all", "", "auto");
INSERT INTO `wp_options` VALUES("233", "litespeed.conf.debug", "", "auto");
INSERT INTO `wp_options` VALUES("234", "litespeed.conf.debug-ips", "[\"127.0.0.1\"]", "auto");
INSERT INTO `wp_options` VALUES("235", "litespeed.conf.debug-level", "", "auto");
INSERT INTO `wp_options` VALUES("236", "litespeed.conf.debug-filesize", "3", "auto");
INSERT INTO `wp_options` VALUES("237", "litespeed.conf.debug-collapse_qs", "", "auto");
INSERT INTO `wp_options` VALUES("238", "litespeed.conf.debug-inc", "[]", "auto");
INSERT INTO `wp_options` VALUES("239", "litespeed.conf.debug-exc", "[]", "auto");
INSERT INTO `wp_options` VALUES("240", "litespeed.conf.debug-exc_strings", "[]", "auto");
INSERT INTO `wp_options` VALUES("241", "litespeed.conf.db_optm-revisions_max", "0", "auto");
INSERT INTO `wp_options` VALUES("242", "litespeed.conf.db_optm-revisions_age", "0", "auto");
INSERT INTO `wp_options` VALUES("243", "litespeed.conf.optm-css_min", "", "auto");
INSERT INTO `wp_options` VALUES("244", "litespeed.conf.optm-css_comb", "", "auto");
INSERT INTO `wp_options` VALUES("245", "litespeed.conf.optm-css_comb_ext_inl", "1", "auto");
INSERT INTO `wp_options` VALUES("246", "litespeed.conf.optm-ucss", "", "auto");
INSERT INTO `wp_options` VALUES("247", "litespeed.conf.optm-ucss_inline", "", "auto");
INSERT INTO `wp_options` VALUES("248", "litespeed.conf.optm-ucss_whitelist", "[]", "auto");
INSERT INTO `wp_options` VALUES("249", "litespeed.conf.optm-ucss_file_exc_inline", "[]", "auto");
INSERT INTO `wp_options` VALUES("250", "litespeed.conf.optm-ucss_exc", "[]", "auto");
INSERT INTO `wp_options` VALUES("251", "litespeed.conf.optm-css_exc", "[]", "auto");
INSERT INTO `wp_options` VALUES("252", "litespeed.conf.optm-js_min", "", "auto");
INSERT INTO `wp_options` VALUES("253", "litespeed.conf.optm-js_comb", "", "auto");
INSERT INTO `wp_options` VALUES("254", "litespeed.conf.optm-js_comb_ext_inl", "1", "auto");
INSERT INTO `wp_options` VALUES("255", "litespeed.conf.optm-js_delay_inc", "[]", "auto");
INSERT INTO `wp_options` VALUES("256", "litespeed.conf.optm-js_exc", "[\"jquery.js\",\"jquery.min.js\"]", "auto");
INSERT INTO `wp_options` VALUES("257", "litespeed.conf.optm-html_min", "", "auto");
INSERT INTO `wp_options` VALUES("258", "litespeed.conf.optm-html_lazy", "[]", "auto");
INSERT INTO `wp_options` VALUES("259", "litespeed.conf.optm-html_skip_comment", "[]", "auto");
INSERT INTO `wp_options` VALUES("260", "litespeed.conf.optm-qs_rm", "", "auto");
INSERT INTO `wp_options` VALUES("261", "litespeed.conf.optm-ggfonts_rm", "", "auto");
INSERT INTO `wp_options` VALUES("262", "litespeed.conf.optm-css_async", "", "auto");
INSERT INTO `wp_options` VALUES("263", "litespeed.conf.optm-ccss_per_url", "", "auto");
INSERT INTO `wp_options` VALUES("264", "litespeed.conf.optm-ccss_sep_posttype", "[\"page\"]", "auto");
INSERT INTO `wp_options` VALUES("265", "litespeed.conf.optm-ccss_sep_uri", "[]", "auto");
INSERT INTO `wp_options` VALUES("266", "litespeed.conf.optm-css_async_inline", "1", "auto");
INSERT INTO `wp_options` VALUES("267", "litespeed.conf.optm-css_font_display", "", "auto");
INSERT INTO `wp_options` VALUES("268", "litespeed.conf.optm-js_defer", "", "auto");
INSERT INTO `wp_options` VALUES("269", "litespeed.conf.optm-emoji_rm", "", "auto");
INSERT INTO `wp_options` VALUES("270", "litespeed.conf.optm-noscript_rm", "", "auto");
INSERT INTO `wp_options` VALUES("271", "litespeed.conf.optm-ggfonts_async", "", "auto");
INSERT INTO `wp_options` VALUES("272", "litespeed.conf.optm-exc_roles", "[]", "auto");
INSERT INTO `wp_options` VALUES("273", "litespeed.conf.optm-ccss_con", "", "auto");
INSERT INTO `wp_options` VALUES("274", "litespeed.conf.optm-js_defer_exc", "[\"jquery.js\",\"jquery.min.js\",\"gtm.js\",\"analytics.js\"]", "auto");
INSERT INTO `wp_options` VALUES("275", "litespeed.conf.optm-gm_js_exc", "[]", "auto");
INSERT INTO `wp_options` VALUES("276", "litespeed.conf.optm-dns_prefetch", "[]", "auto");
INSERT INTO `wp_options` VALUES("277", "litespeed.conf.optm-dns_prefetch_ctrl", "", "auto");
INSERT INTO `wp_options` VALUES("278", "litespeed.conf.optm-dns_preconnect", "[]", "auto");
INSERT INTO `wp_options` VALUES("279", "litespeed.conf.optm-exc", "[]", "auto");
INSERT INTO `wp_options` VALUES("280", "litespeed.conf.optm-guest_only", "1", "auto");
INSERT INTO `wp_options` VALUES("281", "litespeed.conf.object", "1", "auto");
INSERT INTO `wp_options` VALUES("282", "litespeed.conf.object-kind", "", "auto");
INSERT INTO `wp_options` VALUES("283", "litespeed.conf.object-host", "::1", "auto");
INSERT INTO `wp_options` VALUES("284", "litespeed.conf.object-port", "11211", "auto");
INSERT INTO `wp_options` VALUES("285", "litespeed.conf.object-life", "360", "auto");
INSERT INTO `wp_options` VALUES("286", "litespeed.conf.object-persistent", "1", "auto");
INSERT INTO `wp_options` VALUES("287", "litespeed.conf.object-admin", "1", "auto");
INSERT INTO `wp_options` VALUES("288", "litespeed.conf.object-transients", "1", "auto");
INSERT INTO `wp_options` VALUES("289", "litespeed.conf.object-db_id", "0", "auto");
INSERT INTO `wp_options` VALUES("290", "litespeed.conf.object-user", "", "auto");
INSERT INTO `wp_options` VALUES("291", "litespeed.conf.object-pswd", "", "auto");
INSERT INTO `wp_options` VALUES("292", "litespeed.conf.object-global_groups", "[\"users\",\"userlogins\",\"useremail\",\"userslugs\",\"usermeta\",\"user_meta\",\"site-transient\",\"site-options\",\"site-lookup\",\"site-details\",\"blog-lookup\",\"blog-details\",\"blog-id-cache\",\"rss\",\"global-posts\",\"global-cache-test\"]", "auto");
INSERT INTO `wp_options` VALUES("293", "litespeed.conf.object-non_persistent_groups", "[\"comment\",\"counts\",\"plugins\",\"wc_session_id\"]", "auto");
INSERT INTO `wp_options` VALUES("294", "litespeed.conf.discuss-avatar_cache", "", "auto");
INSERT INTO `wp_options` VALUES("295", "litespeed.conf.discuss-avatar_cron", "", "auto");
INSERT INTO `wp_options` VALUES("296", "litespeed.conf.discuss-avatar_cache_ttl", "604800", "auto");
INSERT INTO `wp_options` VALUES("297", "litespeed.conf.optm-localize", "", "auto");
INSERT INTO `wp_options` VALUES("298", "litespeed.conf.optm-localize_domains", "[\"### Popular scripts ###\",\"https:\\/\\/platform.twitter.com\\/widgets.js\",\"https:\\/\\/connect.facebook.net\\/en_US\\/fbevents.js\"]", "auto");
INSERT INTO `wp_options` VALUES("299", "litespeed.conf.media-lazy", "", "auto");
INSERT INTO `wp_options` VALUES("300", "litespeed.conf.media-lazy_placeholder", "", "auto");
INSERT INTO `wp_options` VALUES("301", "litespeed.conf.media-placeholder_resp", "", "auto");
INSERT INTO `wp_options` VALUES("302", "litespeed.conf.media-placeholder_resp_color", "#cfd4db", "auto");
INSERT INTO `wp_options` VALUES("303", "litespeed.conf.media-placeholder_resp_svg", "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"{width}\" height=\"{height}\" viewBox=\"0 0 {width} {height}\"><rect width=\"100%\" height=\"100%\" style=\"fill:{color};fill-opacity: 0.1;\"/></svg>", "auto");
INSERT INTO `wp_options` VALUES("304", "litespeed.conf.media-lqip", "", "auto");
INSERT INTO `wp_options` VALUES("305", "litespeed.conf.media-lqip_qual", "4", "auto");
INSERT INTO `wp_options` VALUES("306", "litespeed.conf.media-lqip_min_w", "150", "auto");
INSERT INTO `wp_options` VALUES("307", "litespeed.conf.media-lqip_min_h", "150", "auto");
INSERT INTO `wp_options` VALUES("308", "litespeed.conf.media-placeholder_resp_async", "1", "auto");
INSERT INTO `wp_options` VALUES("309", "litespeed.conf.media-iframe_lazy", "", "auto");
INSERT INTO `wp_options` VALUES("310", "litespeed.conf.media-add_missing_sizes", "", "auto");
INSERT INTO `wp_options` VALUES("311", "litespeed.conf.media-lazy_exc", "[]", "auto");
INSERT INTO `wp_options` VALUES("312", "litespeed.conf.media-lazy_cls_exc", "[\"wmu-preview-img\"]", "auto");
INSERT INTO `wp_options` VALUES("313", "litespeed.conf.media-lazy_parent_cls_exc", "[]", "auto");
INSERT INTO `wp_options` VALUES("314", "litespeed.conf.media-iframe_lazy_cls_exc", "[]", "auto");
INSERT INTO `wp_options` VALUES("315", "litespeed.conf.media-iframe_lazy_parent_cls_exc", "[]", "auto");
INSERT INTO `wp_options` VALUES("316", "litespeed.conf.media-lazy_uri_exc", "[]", "auto");
INSERT INTO `wp_options` VALUES("317", "litespeed.conf.media-lqip_exc", "[]", "auto");
INSERT INTO `wp_options` VALUES("318", "litespeed.conf.media-vpi", "", "auto");
INSERT INTO `wp_options` VALUES("319", "litespeed.conf.media-vpi_cron", "", "auto");
INSERT INTO `wp_options` VALUES("320", "litespeed.conf.img_optm-auto", "", "auto");
INSERT INTO `wp_options` VALUES("321", "litespeed.conf.img_optm-cron", "1", "auto");
INSERT INTO `wp_options` VALUES("322", "litespeed.conf.img_optm-ori", "1", "auto");
INSERT INTO `wp_options` VALUES("323", "litespeed.conf.img_optm-rm_bkup", "", "auto");
INSERT INTO `wp_options` VALUES("324", "litespeed.conf.img_optm-webp", "", "auto");
INSERT INTO `wp_options` VALUES("325", "litespeed.conf.img_optm-lossless", "", "auto");
INSERT INTO `wp_options` VALUES("326", "litespeed.conf.img_optm-exif", "1", "auto");
INSERT INTO `wp_options` VALUES("327", "litespeed.conf.img_optm-webp_attr", "[\"img.src\",\"div.data-thumb\",\"img.data-src\",\"img.data-lazyload\",\"div.data-large_image\",\"img.retina_logo_url\",\"div.data-parallax-image\",\"div.data-vc-parallax-image\",\"video.poster\"]", "auto");
INSERT INTO `wp_options` VALUES("328", "litespeed.conf.img_optm-webp_replace_srcset", "", "auto");
INSERT INTO `wp_options` VALUES("329", "litespeed.conf.img_optm-jpg_quality", "82", "auto");
INSERT INTO `wp_options` VALUES("330", "litespeed.conf.crawler", "", "auto");
INSERT INTO `wp_options` VALUES("331", "litespeed.conf.crawler-usleep", "500", "auto");
INSERT INTO `wp_options` VALUES("332", "litespeed.conf.crawler-run_duration", "400", "auto");
INSERT INTO `wp_options` VALUES("333", "litespeed.conf.crawler-run_interval", "600", "auto");
INSERT INTO `wp_options` VALUES("334", "litespeed.conf.crawler-crawl_interval", "302400", "auto");
INSERT INTO `wp_options` VALUES("335", "litespeed.conf.crawler-threads", "3", "auto");
INSERT INTO `wp_options` VALUES("336", "litespeed.conf.crawler-timeout", "30", "auto");
INSERT INTO `wp_options` VALUES("337", "litespeed.conf.crawler-load_limit", "1", "auto");
INSERT INTO `wp_options` VALUES("338", "litespeed.conf.crawler-sitemap", "", "auto");
INSERT INTO `wp_options` VALUES("339", "litespeed.conf.crawler-drop_domain", "1", "auto");
INSERT INTO `wp_options` VALUES("340", "litespeed.conf.crawler-map_timeout", "120", "auto");
INSERT INTO `wp_options` VALUES("341", "litespeed.conf.crawler-roles", "[]", "auto");
INSERT INTO `wp_options` VALUES("342", "litespeed.conf.crawler-cookies", "[]", "auto");
INSERT INTO `wp_options` VALUES("343", "litespeed.conf.misc-heartbeat_front", "", "auto");
INSERT INTO `wp_options` VALUES("344", "litespeed.conf.misc-heartbeat_front_ttl", "60", "auto");
INSERT INTO `wp_options` VALUES("345", "litespeed.conf.misc-heartbeat_back", "", "auto");
INSERT INTO `wp_options` VALUES("346", "litespeed.conf.misc-heartbeat_back_ttl", "60", "auto");
INSERT INTO `wp_options` VALUES("347", "litespeed.conf.misc-heartbeat_editor", "", "auto");
INSERT INTO `wp_options` VALUES("348", "litespeed.conf.misc-heartbeat_editor_ttl", "15", "auto");
INSERT INTO `wp_options` VALUES("349", "litespeed.conf.cdn", "", "auto");
INSERT INTO `wp_options` VALUES("350", "litespeed.conf.cdn-ori", "[]", "auto");
INSERT INTO `wp_options` VALUES("351", "litespeed.conf.cdn-ori_dir", "[\"wp-content\",\"wp-includes\"]", "auto");
INSERT INTO `wp_options` VALUES("352", "litespeed.conf.cdn-exc", "[]", "auto");
INSERT INTO `wp_options` VALUES("353", "litespeed.conf.cdn-quic", "", "auto");
INSERT INTO `wp_options` VALUES("354", "litespeed.conf.cdn-cloudflare", "", "auto");
INSERT INTO `wp_options` VALUES("355", "litespeed.conf.cdn-cloudflare_email", "", "auto");
INSERT INTO `wp_options` VALUES("356", "litespeed.conf.cdn-cloudflare_key", "", "auto");
INSERT INTO `wp_options` VALUES("357", "litespeed.conf.cdn-cloudflare_name", "", "auto");
INSERT INTO `wp_options` VALUES("358", "litespeed.conf.cdn-cloudflare_zone", "", "auto");
INSERT INTO `wp_options` VALUES("359", "litespeed.conf.cdn-mapping", "[{\"url\":\"\",\"inc_img\":\"1\",\"inc_css\":\"1\",\"inc_js\":\"1\",\"filetype\":[\".aac\",\".css\",\".eot\",\".gif\",\".jpeg\",\".jpg\",\".js\",\".less\",\".mp3\",\".mp4\",\".ogg\",\".otf\",\".pdf\",\".png\",\".svg\",\".ttf\",\".webp\",\".woff\",\".woff2\"]}]", "auto");
INSERT INTO `wp_options` VALUES("360", "litespeed.conf.cdn-attr", "[\".src\",\".data-src\",\".href\",\".poster\",\"source.srcset\"]", "auto");
INSERT INTO `wp_options` VALUES("361", "litespeed.conf.qc-token", "", "auto");
INSERT INTO `wp_options` VALUES("362", "litespeed.conf.qc-nameservers", "", "auto");
INSERT INTO `wp_options` VALUES("366", "litespeed.purge.queue", "-1", "auto");
INSERT INTO `wp_options` VALUES("367", "litespeed.purge.queue2", "-1", "auto");
INSERT INTO `wp_options` VALUES("369", "hostinger_first_login_at", "2025-02-18 15:08:54", "auto");
INSERT INTO `wp_options` VALUES("370", "litespeed.admin_display.thirdparty_litespeed_check", "1", "auto");
INSERT INTO `wp_options` VALUES("371", "litespeed.optimize.timestamp_purge_css", "1764861930", "auto");
INSERT INTO `wp_options` VALUES("372", "litespeed.admin_display.messages", "-1", "auto");
INSERT INTO `wp_options` VALUES("373", "wp_calendar_block_has_published_posts", "1", "auto");
INSERT INTO `wp_options` VALUES("378", "litespeed.gui.lscwp_whm_install", "-1", "auto");
INSERT INTO `wp_options` VALUES("379", "litespeed.gui.dismiss", "-1", "auto");
INSERT INTO `wp_options` VALUES("380", "litespeed.gui._summary", "{\"new_version\":1740496152,\"score\":1741100952,\"new_version.last_check\":1746450297,\"new_version.v\":\"6.5.4\"}", "auto");
INSERT INTO `wp_options` VALUES("381", "litespeed.data.upgrading", "-1", "auto");
INSERT INTO `wp_options` VALUES("388", "can_compress_scripts", "0", "on");
INSERT INTO `wp_options` VALUES("391", "finished_updating_comment_type", "1", "auto");
INSERT INTO `wp_options` VALUES("398", "hostinger_ai_brand_name", "Zayn Ventures", "auto");
INSERT INTO `wp_options` VALUES("399", "hostinger_ai_website_type", "business", "auto");
INSERT INTO `wp_options` VALUES("400", "hostinger_ai_description", "Zayn Ventures is a forward-thinking venture capital firm dedicated to empowering innovative startups. We invest in early-stage companies across diverse industries, providing strategic funding, mentorship, and resources to drive growth and success. Our mission is to identify groundbreaking ideas, support visionary entrepreneurs, and shape the future of technology and business.", "auto");
INSERT INTO `wp_options` VALUES("401", "hostinger_ai_version", "67b4a3adbeb1b", "on");
INSERT INTO `wp_options` VALUES("402", "hostinger_ai_colors", "a:1:{s:13:\"color_palette\";a:7:{s:6:\"color1\";s:7:\"#A8E6CF\";s:6:\"color2\";s:7:\"#1A1A2E\";s:6:\"color3\";s:7:\"#4A90E2\";s:5:\"light\";s:7:\"#ffffff\";s:4:\"dark\";s:7:\"#0d141a\";s:4:\"grey\";s:7:\"#B8C0CC\";s:9:\"gradients\";a:1:{s:5:\"z48lj\";a:1:{s:8:\"gradient\";s:23:\"#A8E6CF,#4A90E2,#FFC1A1\";}}}}", "on");
INSERT INTO `wp_options` VALUES("403", "hostinger_ai_website_structure", "a:4:{i:0;a:2:{s:4:\"page\";s:4:\"home\";s:8:\"sections\";a:4:{i:0;a:2:{s:2:\"id\";s:13:\"67b4a3b279863\";s:7:\"section\";s:8:\"about-us\";}i:1;a:2:{s:2:\"id\";s:13:\"67b4a3b279865\";s:7:\"section\";s:8:\"services\";}i:2;a:2:{s:2:\"id\";s:13:\"67b4a3b279866\";s:7:\"section\";s:14:\"call-to-action\";}i:3;a:2:{s:2:\"id\";s:13:\"67b4a3b279867\";s:7:\"section\";s:16:\"customer-reviews\";}}}i:1;a:2:{s:4:\"page\";s:5:\"about\";s:8:\"sections\";a:3:{i:0;a:2:{s:2:\"id\";s:13:\"67b4a3b279868\";s:7:\"section\";s:13:\"my-background\";}i:1;a:2:{s:2:\"id\";s:13:\"67b4a3b279869\";s:7:\"section\";s:16:\"customer-reviews\";}i:2;a:2:{s:2:\"id\";s:13:\"67b4a3b27986a\";s:7:\"section\";s:14:\"call-to-action\";}}}i:2;a:2:{s:4:\"page\";s:9:\"portfolio\";s:8:\"sections\";a:3:{i:0;a:2:{s:2:\"id\";s:13:\"67b4a3b27986b\";s:7:\"section\";s:8:\"projects\";}i:1;a:2:{s:2:\"id\";s:13:\"67b4a3b27986c\";s:7:\"section\";s:7:\"gallery\";}i:2;a:2:{s:2:\"id\";s:13:\"67b4a3b27986d\";s:7:\"section\";s:16:\"customer-reviews\";}}}i:3;a:2:{s:4:\"page\";s:7:\"contact\";s:8:\"sections\";a:3:{i:0;a:2:{s:2:\"id\";s:13:\"67b4a3b27986e\";s:7:\"section\";s:7:\"contact\";}i:1;a:2:{s:2:\"id\";s:13:\"67b4a3b27986f\";s:7:\"section\";s:8:\"location\";}i:2;a:2:{s:2:\"id\";s:13:\"67b4a3b279870\";s:7:\"section\";s:14:\"call-to-action\";}}}}", "auto");
INSERT INTO `wp_options` VALUES("406", "hostinger_ai_website_content", "a:6:{s:10:\"brand_name\";s:13:\"zayn ventures\";s:11:\"description\";s:378:\"zayn ventures is a forward-thinking venture capital firm dedicated to empowering innovative startups. we invest in early-stage companies across diverse industries, providing strategic funding, mentorship, and resources to drive growth and success. our mission is to identify groundbreaking ideas, support visionary entrepreneurs, and shape the future of technology and business.\";s:17:\"image_with_prompt\";b:0;s:12:\"website_type\";s:8:\"business\";s:8:\"language\";s:2:\"en\";s:5:\"pages\";a:4:{s:4:\"home\";a:1:{s:8:\"sections\";a:4:{s:13:\"67b4a3b279863\";a:3:{s:4:\"type\";s:8:\"about-us\";s:8:\"elements\";a:5:{s:13:\"67b4a3b58aeea\";a:6:{s:5:\"class\";s:18:\"hostinger-ai-title\";s:4:\"type\";s:5:\"Title\";s:9:\"max_words\";i:3;s:4:\"tone\";s:10:\"buissiness\";s:5:\"index\";s:1:\"0\";s:7:\"content\";s:21:\"Empowering Innovation\";}s:13:\"67b4a3b58aeeb\";a:5:{s:5:\"class\";s:24:\"hostinger-ai-description\";s:4:\"type\";s:11:\"Description\";s:9:\"max_words\";i:25;s:5:\"index\";s:1:\"0\";s:7:\"content\";s:177:\"Zayn Ventures is a forward-thinking venture capital firm dedicated to empowering innovative startups through strategic funding, mentorship, and resources for growth and success.\";}s:13:\"67b4a3b58aeec\";a:5:{s:5:\"class\";s:23:\"hostinger-ai-cta-button\";s:4:\"type\";s:10:\"CTA Button\";s:9:\"max_words\";i:2;s:5:\"index\";s:1:\"0\";s:7:\"content\";s:10:\"Learn More\";}s:13:\"67b4a3b58aeed\";a:6:{s:5:\"class\";s:18:\"hostinger-ai-image\";s:4:\"type\";s:5:\"Image\";s:5:\"index\";s:1:\"6\";s:9:\"max_words\";i:5;s:10:\"image_size\";a:3:{s:5:\"width\";i:350;s:6:\"height\";i:300;s:4:\"crop\";b:1;}s:7:\"content\";s:15:\"venture capital\";}s:13:\"67b4a3b58aeee\";a:6:{s:5:\"class\";s:18:\"hostinger-ai-image\";s:4:\"type\";s:5:\"Image\";s:5:\"index\";s:1:\"7\";s:9:\"max_words\";i:5;s:10:\"image_size\";a:3:{s:5:\"width\";i:750;s:6:\"height\";i:300;s:4:\"crop\";b:1;}s:7:\"content\";s:15:\"venture capital\";}}s:4:\"html\";s:4328:\"<!-- wp:group {\"align\":\"wide\",\"className\":\"hostinger-ai-about-us-4\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group alignwide hostinger-ai-about-us-4 hostinger-ai-fade-up\" style=\"padding-top:0;padding-bottom:0\"><!-- wp:group {\"align\":\"wide\",\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0\"},\"padding\":{\"top\":\"0\",\"bottom\":\"var:preset|spacing|30\"}}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\n    <div class=\"wp-block-group alignwide hostinger-ai-fade-up\" style=\"margin-bottom:0;padding-top:0;padding-bottom:var(--wp--preset--spacing--30)\"><!-- wp:columns -->\n        <div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"50%\"} -->\n            <div class=\"wp-block-column\" style=\"flex-basis:50%\"><!-- wp:heading {\"className\":\"hostinger-ai-title\",\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0\"}}},\"fontSize\":\"x-large\"} -->\n                <h2 class=\"wp-block-heading hostinger-ai-title has-x-large-font-size\" style=\"margin-bottom:0\">About us section<br>about owners</h2>\n                <!-- /wp:heading --></div>\n            <!-- /wp:column -->\n\n            <!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"50%\",\"fontSize\":\"small\",\"layout\":{\"type\":\"constrained\"}} -->\n            <div class=\"wp-block-column is-vertically-aligned-center has-small-font-size\" style=\"flex-basis:50%\"><!-- wp:paragraph {\"className\":\"hostinger-ai-description\",\"fontSize\":\"medium\"} -->\n                <p class=\"hostinger-ai-description has-medium-font-size\">We have made quality our habit. It’s not something that we just strive for – we live by this principle every day. While most of the things about the creative process will be forgotten, the excellence of our products and services will be remembered.&nbsp;</p>\n                <!-- /wp:paragraph -->\n\n                <!-- wp:buttons {\"style\":{\"spacing\":{\"margin\":{\"top\":\"var:preset|spacing|50\"}}}} -->\n                <div class=\"wp-block-buttons\" style=\"margin-top:var(--wp--preset--spacing--50)\"><!-- wp:button {\"textColor\":\"dark\",\"className\":\"hostinger-ai-cta-button hostinger-index-0\",\"style\":{\"spacing\":{\"padding\":{\"left\":\"var:preset|spacing|70\",\"right\":\"var:preset|spacing|70\",\"top\":\"var:preset|spacing|30\",\"bottom\":\"var:preset|spacing|30\"}},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|dark\"}}}},\"fontSize\":\"medium\",\"borderColor\":\"dark\"} -->\n                    <div class=\"wp-block-button has-custom-font-size hostinger-ai-cta-button hostinger-index-0 has-medium-font-size\"><a class=\"wp-block-button__link has-dark-color has-text-color has-link-color has-border-color has-dark-border-color wp-element-button\" style=\"padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--70)\">Button</a></div>\n                    <!-- /wp:button --></div>\n                <!-- /wp:buttons --></div>\n            <!-- /wp:column --></div>\n        <!-- /wp:columns --></div>\n    <!-- /wp:group -->\n\n    <!-- wp:group {\"align\":\"wide\",\"className\":\"image-row\",\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0\"},\"padding\":{\"top\":\"var:preset|spacing|30\"}}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\"}} -->\n    <div class=\"wp-block-group alignwide image-row hostinger-ai-fade-up\"  style=\"margin-bottom:0;padding-top:var(--wp--preset--spacing--30)\"><!-- wp:image {\"id\":487,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"hostinger-ai-image hostinger-index-6\",\"style\":{\"border\":{\"radius\":\"8px\"}}} -->\n        <figure class=\"wp-block-image size-full has-custom-border hostinger-ai-image hostinger-index-6\"><img src=\"https://hostinger-wp-blocks.com/wp-content/uploads/2024/11/about-4-2.png\" alt=\"\" class=\"wp-image-487\" style=\"border-radius:8px\"/></figure>\n        <!-- /wp:image -->\n\n        <!-- wp:image {\"id\":486,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"align\":\"full\",\"className\":\"hostinger-ai-image hostinger-index-7\",\"style\":{\"border\":{\"radius\":\"8px\"}}} -->\n        <figure class=\"wp-block-image alignfull size-full has-custom-border hostinger-ai-image hostinger-index-7\"><img src=\"https://hostinger-wp-blocks.com/wp-content/uploads/2024/11/about-4-1.png\" alt=\"\" class=\"wp-image-486\" style=\"border-radius:8px\"/></figure>\n        <!-- /wp:image --></div>\n    <!-- /wp:group --></div>\n<!-- /wp:group -->\";}s:13:\"67b4a3b279865\";a:3:{s:4:\"type\";s:8:\"services\";s:8:\"elements\";a:7:{s:13:\"67b4a3b58afe6\";a:6:{s:5:\"class\";s:18:\"hostinger-ai-title\";s:4:\"type\";s:5:\"Title\";s:9:\"max_words\";i:3;s:4:\"tone\";s:10:\"buissiness\";s:5:\"index\";s:1:\"0\";s:7:\"content\";s:30:\"Empowering Innovative Startups\";}s:13:\"67b4a3b58afe8\";a:6:{s:5:\"class\";s:26:\"hostinger-ai-service-image\";s:4:\"type\";s:5:\"Image\";s:5:\"index\";s:1:\"0\";s:9:\"max_words\";i:5;s:10:\"image_size\";a:3:{s:5:\"width\";i:340;s:6:\"height\";i:340;s:4:\"crop\";b:1;}s:7:\"content\";s:15:\"venture capital\";}s:13:\"67b4a3b58afe9\";a:5:{s:5:\"class\";s:32:\"hostinger-ai-service-description\";s:4:\"type\";s:11:\"Description\";s:9:\"max_words\";i:15;s:5:\"index\";s:1:\"0\";s:7:\"content\";s:104:\"We provide strategic funding and mentorship to drive growth for early-stage companies across industries.\";}s:13:\"67b4a3b58afea\";a:6:{s:5:\"class\";s:26:\"hostinger-ai-service-image\";s:4:\"type\";s:5:\"Image\";s:5:\"index\";s:1:\"1\";s:9:\"max_words\";i:5;s:10:\"image_size\";a:3:{s:5:\"width\";i:340;s:6:\"height\";i:340;s:4:\"crop\";b:1;}s:7:\"content\";s:15:\"venture capital\";}s:13:\"67b4a3b58afeb\";a:5:{s:5:\"class\";s:32:\"hostinger-ai-service-description\";s:4:\"type\";s:11:\"Description\";s:9:\"max_words\";i:15;s:5:\"index\";s:1:\"1\";s:7:\"content\";s:96:\"Our mission is to identify groundbreaking ideas and support visionary entrepreneurs for success.\";}s:13:\"67b4a3b58afec\";a:6:{s:5:\"class\";s:26:\"hostinger-ai-service-image\";s:4:\"type\";s:5:\"Image\";s:5:\"index\";s:1:\"2\";s:9:\"max_words\";i:5;s:10:\"image_size\";a:3:{s:5:\"width\";i:340;s:6:\"height\";i:340;s:4:\"crop\";b:1;}s:7:\"content\";s:15:\"venture capital\";}s:13:\"67b4a3b58afed\";a:5:{s:5:\"class\";s:32:\"hostinger-ai-service-description\";s:4:\"type\";s:11:\"Description\";s:9:\"max_words\";i:15;s:5:\"index\";s:1:\"2\";s:7:\"content\";s:99:\"We shape the future of technology and business through dedicated investment in innovative startups.\";}}s:4:\"html\";s:5711:\"<!-- wp:group {\"align\":\"full\",\"className\":\"hostinger-ai-our-services-2\",\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0\"},\"padding\":{\"top\":\"var:preset|spacing|60\",\"bottom\":\"var:preset|spacing|60\"}}},\"backgroundColor\":\"color2\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group alignfull hostinger-ai-our-services-2 has-color-2-background-color has-background hostinger-ai-fade-up\" style=\"margin-bottom:0;padding-top:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60)\"><!-- wp:group {\"align\":\"wide\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"left\"}} -->\n    <div class=\"wp-block-group alignwide hostinger-ai-fade-up\"><!-- wp:heading {\"className\":\"is-style-default hostinger-ai-title\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|light\"}}},\"spacing\":{\"margin\":{\"bottom\":\"var:preset|spacing|50\"}}},\"textColor\":\"light\",\"fontSize\":\"x-large\"} -->\n        <h2 class=\"wp-block-heading is-style-default hostinger-ai-title has-light-color has-text-color has-link-color has-x-large-font-size\" style=\"margin-bottom:var(--wp--preset--spacing--50)\">Our services</h2>\n        <!-- /wp:heading -->\n\n        <!-- wp:group {\"align\":\"wide\",\"layout\":{\"type\":\"grid\",\"minimumColumnWidth\":\"18rem\"}} -->\n        <div class=\"wp-block-group alignwide hostinger-ai-fade-up\"><!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"bottom\":\"0\",\"left\":\"var:preset|spacing|20\",\"right\":\"var:preset|spacing|20\"}}},\"layout\":{\"type\":\"constrained\"}} -->\n            <div class=\"wp-block-group hostinger-ai-fade-up\" style=\"padding-top:0;padding-right:var(--wp--preset--spacing--20);padding-bottom:0;padding-left:var(--wp--preset--spacing--20)\"><!-- wp:image {\"id\":160,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"hostinger-ai-service-image\",\"style\":{\"border\":{\"radius\":\"8px\"}}} -->\n                <figure class=\"wp-block-image size-full has-custom-border hostinger-ai-service-image\"><img src=\"https://hostinger-wp-blocks.com/wp-content/uploads/2024/07/photo-1622547748225-3fc4abd2cca0-4.avif\" alt=\"\" class=\"wp-image-160\" style=\"border-radius:8px\"/></figure>\n                <!-- /wp:image -->\n\n                <!-- wp:paragraph {\"className\":\"hostinger-ai-service-description\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|light\"}}},\"spacing\":{\"margin\":{\"top\":\"var:preset|spacing|40\"}}},\"textColor\":\"light\",\"fontSize\":\"medium\"} -->\n                <p class=\"hostinger-ai-service-description has-light-color has-text-color has-link-color has-medium-font-size\" style=\"margin-top:var(--wp--preset--spacing--40)\">Experience luxurious accommodation in the breathtaking Alps, perfect for your ski getaway.</p>\n                <!-- /wp:paragraph --></div>\n            <!-- /wp:group -->\n\n            <!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"right\":\"var:preset|spacing|20\",\"left\":\"var:preset|spacing|20\"}}},\"layout\":{\"type\":\"constrained\"}} -->\n            <div class=\"wp-block-group hostinger-ai-fade-up\" style=\"padding-right:var(--wp--preset--spacing--20);padding-left:var(--wp--preset--spacing--20)\"><!-- wp:image {\"id\":160,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"hostinger-ai-service-image hostinger-index-1\",\"style\":{\"border\":{\"radius\":\"8px\"}}} -->\n                <figure class=\"wp-block-image size-full has-custom-border hostinger-ai-service-image hostinger-index-1\"><img src=\"https://hostinger-wp-blocks.com/wp-content/uploads/2024/07/photo-1622547748225-3fc4abd2cca0-4.avif\" alt=\"\" class=\"wp-image-160\" style=\"border-radius:8px\"/></figure>\n                <!-- /wp:image -->\n\n                <!-- wp:paragraph {\"className\":\"hostinger-ai-service-description hostinger-index-1\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|light\"}}},\"spacing\":{\"margin\":{\"top\":\"var:preset|spacing|40\"}}},\"textColor\":\"light\",\"fontSize\":\"medium\"} -->\n                <p class=\"hostinger-ai-service-description hostinger-index-1 has-light-color has-text-color has-link-color has-medium-font-size\" style=\"margin-top:var(--wp--preset--spacing--40)\">Enjoy stunning views and cozy lodgings at our premier ski resort in the Alps.</p>\n                <!-- /wp:paragraph --></div>\n            <!-- /wp:group -->\n\n            <!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"right\":\"var:preset|spacing|20\",\"left\":\"var:preset|spacing|20\"}}},\"layout\":{\"type\":\"constrained\"}} -->\n            <div class=\"wp-block-group hostinger-ai-fade-up\" style=\"padding-right:var(--wp--preset--spacing--20);padding-left:var(--wp--preset--spacing--20)\"><!-- wp:image {\"id\":160,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"hostinger-ai-service-image hostinger-index-2\",\"style\":{\"border\":{\"radius\":\"8px\"}}} -->\n                <figure class=\"wp-block-image size-full has-custom-border hostinger-ai-service-image hostinger-index-2\"><img src=\"https://hostinger-wp-blocks.com/wp-content/uploads/2024/07/photo-1622547748225-3fc4abd2cca0-4.avif\" alt=\"\" class=\"wp-image-160\" style=\"border-radius:8px\"/></figure>\n                <!-- /wp:image -->\n\n                <!-- wp:paragraph {\"className\":\"hostinger-ai-service-description hostinger-index-2\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|light\"}}},\"spacing\":{\"margin\":{\"top\":\"var:preset|spacing|40\"}}},\"textColor\":\"light\",\"fontSize\":\"medium\"} -->\n                <p class=\"hostinger-ai-service-description hostinger-index-2 has-light-color has-text-color has-link-color has-medium-font-size\" style=\"margin-top:var(--wp--preset--spacing--40)\">Unwind after a day on the slopes in our comfortable and inviting alpine accommodations.</p>\n                <!-- /wp:paragraph --></div>\n            <!-- /wp:group --></div>\n        <!-- /wp:group --></div>\n    <!-- /wp:group --></div>\n<!-- /wp:group -->\";}s:13:\"67b4a3b279866\";a:3:{s:4:\"type\";s:14:\"call-to-action\";s:8:\"elements\";a:3:{s:13:\"67b4a3b58b0a0\";a:6:{s:5:\"class\";s:18:\"hostinger-ai-title\";s:4:\"type\";s:5:\"Title\";s:9:\"max_words\";i:3;s:4:\"tone\";s:10:\"buissiness\";s:5:\"index\";s:1:\"0\";s:7:\"content\";s:19:\"Empower Your Vision\";}s:13:\"67b4a3b58b0a1\";a:5:{s:5:\"class\";s:24:\"hostinger-ai-description\";s:4:\"type\";s:11:\"Description\";s:9:\"max_words\";i:20;s:5:\"index\";s:1:\"0\";s:7:\"content\";s:128:\"Join us in transforming innovative ideas into successful ventures. Let’s shape the future of technology and business together.\";}s:13:\"67b4a3b58b0a2\";a:5:{s:5:\"class\";s:23:\"hostinger-ai-cta-button\";s:4:\"type\";s:10:\"CTA Button\";s:9:\"max_words\";i:1;s:5:\"index\";s:1:\"0\";s:7:\"content\";s:6:\"Invest\";}}s:4:\"html\";s:3443:\"<!-- wp:group {\"align\":\"full\",\"className\":\"hostinger-ai-solid-block\",\"style\":{\"dimensions\":{\"minHeight\":\"\"},\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|60\",\"bottom\":\"var:preset|spacing|60\"}}},\"backgroundColor\":\"color1\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group alignfull hostinger-ai-solid-block has-color-1-background-color has-background hostinger-ai-fade-up\"  style=\"padding-top:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60)\"><!-- wp:group {\"align\":\"wide\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"bottom\":\"0\"}},\"dimensions\":{\"minHeight\":\"0px\"}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"justifyContent\":\"center\",\"verticalAlignment\":\"center\",\"flexWrap\":\"nowrap\"}} -->\n    <div class=\"wp-block-group alignwide hostinger-ai-fade-up\" style=\"min-height:0px;padding-top:0;padding-bottom:0\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"0px\"},\"layout\":{\"columnSpan\":1,\"rowSpan\":1}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n        <div class=\"wp-block-group hostinger-ai-fade-up\"><!-- wp:heading {\"textAlign\":\"center\",\"className\":\"hostinger-ai-title\",\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"right\":\"0\"}},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|dark\"}}}},\"textColor\":\"dark\",\"fontSize\":\"x-large\"} -->\n            <h2 class=\"wp-block-heading has-text-align-center hostinger-ai-title has-dark-color has-text-color has-link-color has-x-large-font-size\" style=\"margin-top:0;margin-right:0;margin-bottom:0;margin-left:0\">Make a reservation</h2>\n            <!-- /wp:heading -->\n\n            <!-- wp:paragraph {\"align\":\"center\",\"className\":\"hostinger-ai-description\",\"style\":{\"spacing\":{\"margin\":{\"top\":\"var:preset|spacing|20\",\"bottom\":\"var:preset|spacing|50\"}},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|dark\"}}}},\"textColor\":\"dark\",\"fontSize\":\"medium\"} -->\n            <p class=\"has-text-align-center hostinger-ai-description has-dark-color has-text-color has-link-color has-medium-font-size\" style=\"margin-top:var(--wp--preset--spacing--20);margin-bottom:var(--wp--preset--spacing--50)\">Florsity is a restaurant that serves authentic Italian cuisine. We serve freshly prepared pasta, expertly paired with Italian wines.</p>\n            <!-- /wp:paragraph -->\n\n            <!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n            <div class=\"wp-block-buttons\"><!-- wp:button {\"backgroundColor\":\"contrast\",\"textColor\":\"dark\",\"className\":\"hostinger-ai-cta-button\",\"style\":{\"spacing\":{\"padding\":{\"left\":\"var:preset|spacing|70\",\"right\":\"var:preset|spacing|70\",\"top\":\"var:preset|spacing|30\",\"bottom\":\"var:preset|spacing|30\"}},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|dark\"}}}},\"fontSize\":\"medium\",\"borderColor\":\"dark\"} -->\n                <div class=\"wp-block-button has-custom-font-size hostinger-ai-cta-button has-medium-font-size\"><a class=\"wp-block-button__link has-dark-color has-contrast-background-color has-text-color has-background has-link-color has-border-color has-dark-border-color wp-element-button\" style=\"padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--70)\">Button</a></div>\n                <!-- /wp:button --></div>\n            <!-- /wp:buttons --></div>\n        <!-- /wp:group --></div>\n    <!-- /wp:group --></div>\n<!-- /wp:group -->\";}s:13:\"67b4a3b279867\";a:3:{s:4:\"type\";s:16:\"customer-reviews\";s:8:\"elements\";a:5:{s:13:\"67b4a3b58b16f\";a:5:{s:5:\"class\";s:21:\"hostinger-ai-subtitle\";s:4:\"type\";s:8:\"Subtitle\";s:9:\"max_words\";i:2;s:5:\"index\";s:1:\"0\";s:7:\"content\";s:15:\"Client Feedback\";}s:13:\"67b4a3b58b171\";a:7:{s:5:\"class\";s:30:\"hostinger-ai-testimonial-image\";s:4:\"type\";s:5:\"Image\";s:5:\"index\";s:1:\"3\";s:9:\"max_words\";i:5;s:10:\"image_size\";a:3:{s:5:\"width\";i:180;s:6:\"height\";i:200;s:4:\"crop\";b:1;}s:15:\"default_content\";s:8:\"man face\";s:7:\"content\";s:15:\"venture capital\";}s:13:\"67b4a3b58b172\";a:7:{s:5:\"class\";s:29:\"hostinger-ai-testimonial-text\";s:4:\"type\";s:11:\"Testimonial\";s:5:\"index\";s:1:\"1\";s:9:\"max_words\";i:14;s:6:\"prefix\";s:3:\"”\";s:6:\"suffix\";s:3:\"”\";s:7:\"content\";s:102:\"Zayn Ventures transformed our startup with invaluable support and strategic funding. Highly recommend!\";}s:13:\"67b4a3b58b173\";a:7:{s:5:\"class\";s:30:\"hostinger-ai-testimonial-image\";s:4:\"type\";s:5:\"Image\";s:5:\"index\";s:1:\"4\";s:9:\"max_words\";i:5;s:10:\"image_size\";a:3:{s:5:\"width\";i:180;s:6:\"height\";i:200;s:4:\"crop\";b:1;}s:15:\"default_content\";s:10:\"woman face\";s:7:\"content\";s:15:\"venture capital\";}s:13:\"67b4a3b58b174\";a:7:{s:5:\"class\";s:29:\"hostinger-ai-testimonial-text\";s:4:\"type\";s:11:\"Testimonial\";s:5:\"index\";s:1:\"0\";s:9:\"max_words\";i:14;s:6:\"prefix\";s:3:\"”\";s:6:\"suffix\";s:3:\"”\";s:7:\"content\";s:94:\"Their mentorship and resources propelled our growth beyond expectations. Truly a game changer!\";}}s:4:\"html\";s:4466:\"<!-- wp:group {\"align\":\"wide\",\"className\":\"hostinger-ai-fade-up hostinger-ai-customer-reviews-3\",\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignwide hostinger-ai-fade-up hostinger-ai-customer-reviews-3\"><!-- wp:group {\"align\":\"wide\",\"className\":\"hostinger-ai-fade-up\",\"layout\":{\"type\":\"default\"}} -->\n    <div class=\"wp-block-group alignwide hostinger-ai-fade-up\"><!-- wp:columns -->\n        <div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"40%\"} -->\n            <div class=\"wp-block-column\" style=\"flex-basis:40%\"><!-- wp:heading {\"textAlign\":\"left\",\"align\":\"full\",\"className\":\"hostinger-ai-subtitle\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|dark\"}}},\"spacing\":{\"margin\":{\"bottom\":\"var:preset|spacing|50\"}}},\"textColor\":\"dark\",\"fontSize\":\"x-large\"} -->\n                <h2 class=\"wp-block-heading alignfull has-text-align-left hostinger-ai-subtitle has-dark-color has-text-color has-link-color has-x-large-font-size\" style=\"margin-bottom:var(--wp--preset--spacing--50)\">Customer reviews</h2>\n                <!-- /wp:heading --></div>\n            <!-- /wp:column -->\n\n            <!-- wp:column {\"width\":\"60%\"} -->\n            <div class=\"wp-block-column\" style=\"flex-basis:60%\"><!-- wp:group {\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} -->\n                <div class=\"wp-block-group\"><!-- wp:group {\"className\":\"hostinger-ai-fade-up\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|40\"}}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\n                    <div class=\"wp-block-group hostinger-ai-fade-up\" style=\"padding-bottom:var(--wp--preset--spacing--40)\"><!-- wp:image {\"id\":266,\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"hostinger-ai-testimonial-image hostinger-index-3\",\"style\":{\"border\":{\"radius\":\"8px\"}}} -->\n                        <figure class=\"wp-block-image size-full has-custom-border hostinger-ai-testimonial-image hostinger-index-3\"><img src=\"https://hostinger-wp-blocks.com/wp-content/uploads/2024/08/testimonial-d95lQjEGjlir2kka.avif\" alt=\"\" class=\"wp-image-266\" style=\"border-radius:8px;object-fit:cover\"/></figure>\n                        <!-- /wp:image -->\n\n                        <!-- wp:paragraph {\"className\":\"hostinger-ai-testimonial-text hostinger-index-1\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|dark\"}}},\"layout\":{\"columnSpan\":1,\"rowSpan\":1},\"spacing\":{\"padding\":{\"left\":\"var:preset|spacing|20\"}}},\"textColor\":\"dark\",\"fontSize\":\"medium\"} -->\n                        <p class=\"hostinger-ai-testimonial-text hostinger-index-1 has-dark-color has-text-color has-link-color has-medium-font-size\" style=\"padding-left:var(--wp--preset--spacing--20)\">Beautiful location in the Alps. Highly recommend for a cozy ski getaway!</p>\n                        <!-- /wp:paragraph --></div>\n                    <!-- /wp:group -->\n\n                    <!-- wp:group {\"className\":\"hostinger-ai-fade-up\",\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\n                    <div class=\"wp-block-group hostinger-ai-fade-up\"><!-- wp:image {\"id\":265,\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"hostinger-ai-testimonial-image hostinger-index-4\",\"style\":{\"border\":{\"radius\":\"8px\"}}} -->\n                        <figure class=\"wp-block-image size-full has-custom-border hostinger-ai-testimonial-image hostinger-index-4\"><img src=\"https://hostinger-wp-blocks.com/wp-content/uploads/2024/08/photo-1573515159471-0eb7ec72912c.avif\" alt=\"\" class=\"wp-image-265\" style=\"border-radius:8px;object-fit:cover\"/></figure>\n                        <!-- /wp:image -->\n\n                        <!-- wp:paragraph {\"className\":\"hostinger-ai-testimonial-text\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|dark\"}}},\"layout\":{\"columnSpan\":1,\"rowSpan\":1},\"spacing\":{\"padding\":{\"left\":\"var:preset|spacing|20\"}}},\"textColor\":\"dark\",\"fontSize\":\"medium\"} -->\n                        <p class=\"hostinger-ai-testimonial-text has-dark-color has-text-color has-link-color has-medium-font-size\" style=\"padding-left:var(--wp--preset--spacing--20)\">Amazing stay at Skialps! The accommodation was perfect for our ski trip.</p>\n                        <!-- /wp:paragraph --></div>\n                    <!-- /wp:group --></div>\n                <!-- /wp:group --></div>\n            <!-- /wp:column --></div>\n        <!-- /wp:columns --></div>\n    <!-- /wp:group --></div>\n<!-- /wp:group -->\";}}}s:5:\"about\";a:1:{s:8:\"sections\";a:3:{s:13:\"67b4a3b279868\";a:3:{s:4:\"type\";s:13:\"my-background\";s:8:\"elements\";a:8:{s:13:\"67b4a3b58b23d\";a:6:{s:5:\"class\";s:18:\"hostinger-ai-image\";s:4:\"type\";s:5:\"Image\";s:5:\"index\";s:1:\"0\";s:9:\"max_words\";i:5;s:10:\"image_size\";a:3:{s:5:\"width\";i:584;s:6:\"height\";i:650;s:4:\"crop\";b:1;}s:7:\"content\";s:15:\"venture capital\";}s:13:\"67b4a3b58b23e\";a:5:{s:5:\"class\";s:18:\"hostinger-ai-title\";s:4:\"type\";s:5:\"Title\";s:9:\"max_words\";i:2;s:5:\"index\";s:1:\"0\";s:7:\"content\";s:11:\"Our Journey\";}s:13:\"67b4a3b58b23f\";a:5:{s:5:\"class\";s:24:\"hostinger-ai-description\";s:4:\"type\";s:11:\"Description\";s:9:\"max_words\";i:29;s:5:\"index\";s:1:\"0\";s:7:\"content\";s:90:\"Zayn Ventures empowers startups with strategic funding and mentorship to drive innovation.\";}s:13:\"67b4a3b58b240\";a:5:{s:5:\"class\";s:18:\"hostinger-ai-title\";s:4:\"type\";s:5:\"Title\";s:9:\"max_words\";i:2;s:5:\"index\";s:1:\"1\";s:7:\"content\";s:11:\"Our Mission\";}s:13:\"67b4a3b58b241\";a:5:{s:5:\"class\";s:21:\"hostinger-ai-subtitle\";s:4:\"type\";s:8:\"Subtitle\";s:9:\"max_words\";i:4;s:5:\"index\";s:1:\"1\";s:7:\"content\";s:34:\"Empowering Visionary Entrepreneurs\";}s:13:\"67b4a3b58b242\";a:5:{s:5:\"class\";s:24:\"hostinger-ai-description\";s:4:\"type\";s:11:\"Description\";s:9:\"max_words\";i:14;s:5:\"index\";s:1:\"1\";s:7:\"content\";s:80:\"We support groundbreaking ideas and shape the future of technology and business.\";}s:13:\"67b4a3b58b243\";a:5:{s:5:\"class\";s:21:\"hostinger-ai-subtitle\";s:4:\"type\";s:8:\"Subtitle\";s:9:\"max_words\";i:4;s:5:\"index\";s:1:\"2\";s:7:\"content\";s:9:\"Our Focus\";}s:13:\"67b4a3b58b244\";a:5:{s:5:\"class\";s:21:\"hostinger-ai-subtitle\";s:4:\"type\";s:8:\"Subtitle\";s:9:\"max_words\";i:4;s:5:\"index\";s:1:\"2\";s:7:\"content\";s:27:\"Diverse Industry Investment\";}}s:4:\"html\";s:4415:\"<!-- wp:group {\"align\":\"full\",\"className\":\"hostinger-ai-resume-1 hostinger-ai-fade-up\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group alignfull hostinger-ai-resume-1 hostinger-ai-fade-up\"><!-- wp:group {\"align\":\"wide\",\"className\":\"hostinger-ai-fade-up\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|60\",\"bottom\":\"var:preset|spacing|60\"}}},\"layout\":{\"type\":\"grid\",\"columnCount\":2,\"minimumColumnWidth\":null}} -->\n    <div class=\"wp-block-group alignwide hostinger-ai-fade-up\" style=\"padding-top:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60)\"><!-- wp:group {\"className\":\"hostinger-ai-fade-up\",\"layout\":{\"type\":\"constrained\"}} -->\n        <div class=\"wp-block-group hostinger-ai-fade-up\"><!-- wp:image {\"id\":18,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"hostinger-ai-image\",\"style\":{\"border\":{\"radius\":\"8px\"}}} -->\n            <figure class=\"wp-block-image size-full has-custom-border hostinger-ai-image\"><img src=\"https://hostinger-wp-blocks.com/wp-content/uploads/2024/07/photo-1622547748225-3fc4abd2cca0.avif\" alt=\"\" class=\"wp-image-18\" style=\"border-radius:8px\"/></figure>\n            <!-- /wp:image --></div>\n        <!-- /wp:group -->\n\n        <!-- wp:group {\"className\":\"hostinger-ai-fade-up\",\"style\":{\"spacing\":{\"blockGap\":\"0px\",\"padding\":{\"right\":\"var:preset|spacing|60\",\"left\":\"var:preset|spacing|60\"}},\"layout\":{\"columnSpan\":1,\"rowSpan\":1}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"justifyContent\":\"left\",\"flexWrap\":\"nowrap\",\"verticalAlignment\":\"center\"}} -->\n        <div class=\"wp-block-group hostinger-ai-fade-up\" style=\"padding-right:var(--wp--preset--spacing--60);padding-left:var(--wp--preset--spacing--60)\"><!-- wp:heading {\"className\":\"hostinger-ai-title\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|dark\"}}},\"spacing\":{\"margin\":{\"bottom\":\"var:preset|spacing|20\"}}},\"textColor\":\"dark\",\"fontSize\":\"x-large\"} -->\n            <h2 class=\"wp-block-heading hostinger-ai-title has-dark-color has-text-color has-link-color has-x-large-font-size\" style=\"margin-bottom:var(--wp--preset--spacing--20)\">Work Experience</h2>\n            <!-- /wp:heading -->\n\n            <!-- wp:paragraph {\"className\":\"hostinger-ai-description\",\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"var:preset|spacing|70\"}},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|dark\"}}}},\"textColor\":\"dark\",\"fontSize\":\"medium\"} -->\n            <p class=\"hostinger-ai-description has-dark-color has-text-color has-link-color has-medium-font-size\" style=\"margin-top:0;margin-bottom:var(--wp--preset--spacing--70)\">As a web developer, I have crafted numerous resumes showcasing my skills and projects effectively.</p>\n            <!-- /wp:paragraph -->\n\n            <!-- wp:heading {\"className\":\"hostinger-ai-title hostinger-index-1\",\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"var:preset|spacing|30\"}}},\"fontSize\":\"x-large\"} -->\n            <h2 class=\"wp-block-heading hostinger-ai-title hostinger-index-1 has-x-large-font-size\" style=\"margin-bottom:var(--wp--preset--spacing--30)\">Portfolio</h2>\n            <!-- /wp:heading -->\n\n            <!-- wp:paragraph {\"className\":\"hostinger-ai-subtitle hostinger-index-1 hostinger-ai-font-bold\"} -->\n            <p class=\"hostinger-ai-subtitle hostinger-index-1 hostinger-ai-font-bold\">My Professional Journey</p>\n            <!-- /wp:paragraph -->\n\n            <!-- wp:paragraph {\"className\":\"hostinger-ai-description hostinger-index-1\",\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"var:preset|spacing|50\"}}}} -->\n            <p class=\"hostinger-ai-description hostinger-index-1\" style=\"margin-bottom:var(--wp--preset--spacing--50)\">Explore my work experience and projects that highlight my web development expertise.</p>\n            <!-- /wp:paragraph -->\n\n            <!-- wp:paragraph {\"className\":\"hostinger-ai-subtitle hostinger-index-2 hostinger-ai-font-bold\"} -->\n            <p class=\"hostinger-ai-subtitle hostinger-index-2 hostinger-ai-font-bold\">Skills and Projects</p>\n            <!-- /wp:paragraph -->\n\n            <!-- wp:paragraph {\"className\":\"hostinger-ai-subtitle hostinger-index-2\"} -->\n            <p class=\"hostinger-ai-subtitle hostinger-index-2\">Experience. With our intuitive design and user-friendly interface, your website will captivate visitors.</p>\n            <!-- /wp:paragraph --></div>\n        <!-- /wp:group --></div>\n    <!-- /wp:group --></div>\n<!-- /wp:group -->\";}s:13:\"67b4a3b279869\";a:3:{s:4:\"type\";s:16:\"customer-reviews\";s:8:\"elements\";a:3:{s:13:\"67b4a3b58b2ea\";a:7:{s:5:\"class\";s:30:\"hostinger-ai-testimonial-image\";s:4:\"type\";s:5:\"Image\";s:5:\"index\";s:1:\"2\";s:9:\"max_words\";i:5;s:10:\"image_size\";a:3:{s:5:\"width\";i:400;s:6:\"height\";i:450;s:4:\"crop\";b:1;}s:15:\"default_content\";s:8:\"man face\";s:7:\"content\";s:15:\"venture capital\";}s:13:\"67b4a3b58b2eb\";a:5:{s:5:\"class\";s:21:\"hostinger-ai-subtitle\";s:4:\"type\";s:8:\"Subtitle\";s:9:\"max_words\";i:2;s:5:\"index\";s:1:\"0\";s:7:\"content\";s:15:\"Client Feedback\";}s:13:\"67b4a3b58b2ec\";a:7:{s:5:\"class\";s:29:\"hostinger-ai-testimonial-text\";s:4:\"type\";s:11:\"Testimonial\";s:5:\"index\";s:1:\"2\";s:9:\"max_words\";i:24;s:6:\"prefix\";s:3:\"”\";s:6:\"suffix\";s:3:\"”\";s:7:\"content\";s:158:\"Zayn Ventures has been instrumental in our growth. Their strategic funding and mentorship have empowered us to innovate and thrive in a competitive landscape.\";}}s:4:\"html\";s:3122:\"<!-- wp:group {\"align\":\"full\",\"className\":\"hostinger-ai-customer-reviews-2 hostinger-ai-fade-up\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|60\",\"bottom\":\"var:preset|spacing|60\"}}},\"backgroundColor\":\"color2\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group alignfull hostinger-ai-customer-reviews-2 hostinger-ai-fade-up has-color-2-background-color has-background\" style=\"padding-top:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60)\"><!-- wp:columns {\"verticalAlignment\":null,\"align\":\"wide\"} -->\n    <div class=\"wp-block-columns alignwide\"><!-- wp:column -->\n        <div class=\"wp-block-column\"><!-- wp:image {\"id\":715,\"width\":\"412px\",\"height\":\"auto\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"align\":\"center\",\"className\":\"hostinger-ai-testimonial-image hostinger-index-2\",\"style\":{\"border\":{\"radius\":\"8px\"}}} -->\n            <figure class=\"wp-block-image aligncenter size-full is-resized has-custom-border hostinger-ai-testimonial-image hostinger-index-2\"><img src=\"https://hostinger-wp-blocks.com/wp-content/uploads/2024/11/400x450.png\" alt=\"\" class=\"wp-image-715\" style=\"border-radius:8px;width:412px;height:auto\"/></figure>\n            <!-- /wp:image --></div>\n        <!-- /wp:column -->\n\n        <!-- wp:column {\"verticalAlignment\":\"center\"} -->\n        <div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:group {\"className\":\"hostinger-ai-fade-up\",\"style\":{\"spacing\":{\"blockGap\":\"0px\",\"padding\":{\"right\":\"0\",\"left\":\"0\"}},\"layout\":{\"columnSpan\":1,\"rowSpan\":1}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"justifyContent\":\"left\",\"flexWrap\":\"nowrap\",\"verticalAlignment\":\"center\"}} -->\n            <div class=\"wp-block-group hostinger-ai-fade-up\" style=\"padding-right:0;padding-left:0\"><!-- wp:paragraph {\"className\":\"hostinger-ai-subtitle\",\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"var:preset|spacing|20\"}},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|light\"}}}},\"textColor\":\"light\",\"fontSize\":\"medium\"} -->\n                <p class=\"hostinger-ai-subtitle has-light-color has-text-color has-link-color has-medium-font-size\" style=\"margin-top:0;margin-bottom:var(--wp--preset--spacing--20)\">Our customer review</p>\n                <!-- /wp:paragraph -->\n\n                <!-- wp:paragraph {\"className\":\"hostinger-ai-testimonial-text hostinger-ai-font-bold hostinger-index-2\",\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"var:preset|spacing|50\"}},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|light\"}}},\"typography\":{\"fontSize\":\"21px\"}},\"textColor\":\"light\"} -->\n                <p class=\"hostinger-ai-testimonial-text hostinger-ai-font-bold hostinger-index-2 has-light-color has-text-color has-link-color\" style=\"margin-top:0;margin-bottom:var(--wp--preset--spacing--50);font-size:21px\">Syrup oozed slowly from the bottle, forming a sweet, sticky puddle n the tabletop. The room was filled with a warm, inviting aroma, adn the packages sizzled.</p>\n                <!-- /wp:paragraph --></div>\n            <!-- /wp:group --></div>\n        <!-- /wp:column --></div>\n    <!-- /wp:columns --></div>\n<!-- /wp:group -->\";}s:13:\"67b4a3b27986a\";a:3:{s:4:\"type\";s:14:\"call-to-action\";s:8:\"elements\";a:3:{s:13:\"67b4a3b58b376\";a:6:{s:5:\"class\";s:18:\"hostinger-ai-title\";s:4:\"type\";s:5:\"Title\";s:9:\"max_words\";i:3;s:4:\"tone\";s:10:\"buissiness\";s:5:\"index\";s:1:\"0\";s:7:\"content\";s:18:\"Empower Innovation\";}s:13:\"67b4a3b58b377\";a:5:{s:5:\"class\";s:24:\"hostinger-ai-description\";s:4:\"type\";s:11:\"Description\";s:9:\"max_words\";i:20;s:5:\"index\";s:1:\"0\";s:7:\"content\";s:123:\"Join us in shaping the future by investing in groundbreaking ideas and supporting visionary entrepreneurs to drive success.\";}s:13:\"67b4a3b58b378\";a:5:{s:5:\"class\";s:23:\"hostinger-ai-cta-button\";s:4:\"type\";s:10:\"CTA Button\";s:9:\"max_words\";i:1;s:5:\"index\";s:1:\"0\";s:7:\"content\";s:6:\"Invest\";}}s:4:\"html\";s:3443:\"<!-- wp:group {\"align\":\"full\",\"className\":\"hostinger-ai-solid-block\",\"style\":{\"dimensions\":{\"minHeight\":\"\"},\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|60\",\"bottom\":\"var:preset|spacing|60\"}}},\"backgroundColor\":\"color1\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group alignfull hostinger-ai-solid-block has-color-1-background-color has-background hostinger-ai-fade-up\"  style=\"padding-top:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60)\"><!-- wp:group {\"align\":\"wide\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"bottom\":\"0\"}},\"dimensions\":{\"minHeight\":\"0px\"}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"justifyContent\":\"center\",\"verticalAlignment\":\"center\",\"flexWrap\":\"nowrap\"}} -->\n    <div class=\"wp-block-group alignwide hostinger-ai-fade-up\" style=\"min-height:0px;padding-top:0;padding-bottom:0\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"0px\"},\"layout\":{\"columnSpan\":1,\"rowSpan\":1}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n        <div class=\"wp-block-group hostinger-ai-fade-up\"><!-- wp:heading {\"textAlign\":\"center\",\"className\":\"hostinger-ai-title\",\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"right\":\"0\"}},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|dark\"}}}},\"textColor\":\"dark\",\"fontSize\":\"x-large\"} -->\n            <h2 class=\"wp-block-heading has-text-align-center hostinger-ai-title has-dark-color has-text-color has-link-color has-x-large-font-size\" style=\"margin-top:0;margin-right:0;margin-bottom:0;margin-left:0\">Make a reservation</h2>\n            <!-- /wp:heading -->\n\n            <!-- wp:paragraph {\"align\":\"center\",\"className\":\"hostinger-ai-description\",\"style\":{\"spacing\":{\"margin\":{\"top\":\"var:preset|spacing|20\",\"bottom\":\"var:preset|spacing|50\"}},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|dark\"}}}},\"textColor\":\"dark\",\"fontSize\":\"medium\"} -->\n            <p class=\"has-text-align-center hostinger-ai-description has-dark-color has-text-color has-link-color has-medium-font-size\" style=\"margin-top:var(--wp--preset--spacing--20);margin-bottom:var(--wp--preset--spacing--50)\">Florsity is a restaurant that serves authentic Italian cuisine. We serve freshly prepared pasta, expertly paired with Italian wines.</p>\n            <!-- /wp:paragraph -->\n\n            <!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n            <div class=\"wp-block-buttons\"><!-- wp:button {\"backgroundColor\":\"contrast\",\"textColor\":\"dark\",\"className\":\"hostinger-ai-cta-button\",\"style\":{\"spacing\":{\"padding\":{\"left\":\"var:preset|spacing|70\",\"right\":\"var:preset|spacing|70\",\"top\":\"var:preset|spacing|30\",\"bottom\":\"var:preset|spacing|30\"}},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|dark\"}}}},\"fontSize\":\"medium\",\"borderColor\":\"dark\"} -->\n                <div class=\"wp-block-button has-custom-font-size hostinger-ai-cta-button has-medium-font-size\"><a class=\"wp-block-button__link has-dark-color has-contrast-background-color has-text-color has-background has-link-color has-border-color has-dark-border-color wp-element-button\" style=\"padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--70)\">Button</a></div>\n                <!-- /wp:button --></div>\n            <!-- /wp:buttons --></div>\n        <!-- /wp:group --></div>\n    <!-- /wp:group --></div>\n<!-- /wp:group -->\";}}}s:9:\"portfolio\";a:1:{s:8:\"sections\";a:3:{s:13:\"67b4a3b27986b\";a:3:{s:4:\"type\";s:8:\"projects\";s:8:\"elements\";a:13:{s:13:\"67b4a3b58b4a7\";a:6:{s:5:\"class\";s:18:\"hostinger-ai-title\";s:4:\"type\";s:5:\"Title\";s:9:\"max_words\";i:3;s:4:\"tone\";s:10:\"buissiness\";s:5:\"index\";s:1:\"0\";s:7:\"content\";s:33:\"Empowering Startups Strategically\";}s:13:\"67b4a3b58b4a9\";a:6:{s:5:\"class\";s:26:\"hostinger-ai-project-image\";s:4:\"type\";s:5:\"Image\";s:5:\"index\";s:1:\"6\";s:9:\"max_words\";i:5;s:10:\"image_size\";a:3:{s:5:\"width\";i:500;s:6:\"height\";i:500;s:4:\"crop\";b:1;}s:7:\"content\";s:15:\"venture capital\";}s:13:\"67b4a3b58b4aa\";a:6:{s:5:\"class\";s:26:\"hostinger-ai-project-title\";s:4:\"type\";s:5:\"Title\";s:9:\"max_words\";i:3;s:4:\"tone\";s:10:\"buissiness\";s:5:\"index\";s:1:\"0\";s:7:\"content\";s:30:\"Innovative Company Development\";}s:13:\"67b4a3b58b4ab\";a:5:{s:5:\"class\";s:32:\"hostinger-ai-project-description\";s:4:\"type\";s:11:\"Description\";s:9:\"max_words\";i:32;s:5:\"index\";s:1:\"0\";s:7:\"content\";s:202:\"We specialize in early-stage investments, providing startups with essential funding, strategic mentorship, and resources to foster innovation and propel growth in today\'s competitive business landscape.\";}s:13:\"67b4a3b58b4ac\";a:6:{s:5:\"class\";s:26:\"hostinger-ai-project-image\";s:4:\"type\";s:5:\"Image\";s:5:\"index\";s:1:\"7\";s:9:\"max_words\";i:5;s:10:\"image_size\";a:3:{s:5:\"width\";i:500;s:6:\"height\";i:550;s:4:\"crop\";b:1;}s:7:\"content\";s:15:\"venture capital\";}s:13:\"67b4a3b58b4ad\";a:6:{s:5:\"class\";s:26:\"hostinger-ai-project-title\";s:4:\"type\";s:5:\"Title\";s:9:\"max_words\";i:3;s:4:\"tone\";s:10:\"buissiness\";s:5:\"index\";s:1:\"1\";s:7:\"content\";s:26:\"Investment Growth Catalyst\";}s:13:\"67b4a3b58b4ae\";a:5:{s:5:\"class\";s:32:\"hostinger-ai-project-description\";s:4:\"type\";s:11:\"Description\";s:9:\"max_words\";i:32;s:5:\"index\";s:1:\"1\";s:7:\"content\";s:202:\"Our firm identifies promising ideas and visionary entrepreneurs, enabling them with the necessary support to transform their concepts into successful, scalable businesses that can lead their industries.\";}s:13:\"67b4a3b58b4af\";a:6:{s:5:\"class\";s:26:\"hostinger-ai-project-image\";s:4:\"type\";s:5:\"Image\";s:5:\"index\";s:1:\"8\";s:9:\"max_words\";i:5;s:10:\"image_size\";a:3:{s:5:\"width\";i:500;s:6:\"height\";i:500;s:4:\"crop\";b:1;}s:7:\"content\";s:15:\"venture capital\";}s:13:\"67b4a3b58b4b0\";a:6:{s:5:\"class\";s:26:\"hostinger-ai-project-title\";s:4:\"type\";s:5:\"Title\";s:9:\"max_words\";i:3;s:4:\"tone\";s:10:\"buissiness\";s:5:\"index\";s:1:\"2\";s:7:\"content\";s:29:\"Visionary Funding Initiatives\";}s:13:\"67b4a3b58b4b1\";a:5:{s:5:\"class\";s:32:\"hostinger-ai-project-description\";s:4:\"type\";s:11:\"Description\";s:9:\"max_words\";i:32;s:5:\"index\";s:1:\"2\";s:7:\"content\";s:204:\"Zayn Ventures connects startups with invaluable resources and mentorship, fostering an ecosystem where innovative ideas can thrive, ultimately shaping the future of technology and business for the better.\";}s:13:\"67b4a3b58b4b3\";a:6:{s:5:\"class\";s:26:\"hostinger-ai-project-image\";s:4:\"type\";s:5:\"Image\";s:5:\"index\";s:1:\"9\";s:9:\"max_words\";i:5;s:10:\"image_size\";a:3:{s:5:\"width\";i:500;s:6:\"height\";i:550;s:4:\"crop\";b:1;}s:7:\"content\";s:15:\"venture capital\";}s:13:\"67b4a3b58b4b4\";a:6:{s:5:\"class\";s:26:\"hostinger-ai-project-title\";s:4:\"type\";s:5:\"Title\";s:9:\"max_words\";i:3;s:4:\"tone\";s:10:\"buissiness\";s:5:\"index\";s:1:\"1\";s:7:\"content\";s:33:\"Strategic Entrepreneurial Support\";}s:13:\"67b4a3b58b4b5\";a:5:{s:5:\"class\";s:32:\"hostinger-ai-project-description\";s:4:\"type\";s:11:\"Description\";s:9:\"max_words\";i:32;s:5:\"index\";s:1:\"3\";s:7:\"content\";s:201:\"We empower entrepreneurs not just with capital, but also with expert guidance and a network of connections that are essential for navigating the challenges of launching and growing successful startups.\";}}s:4:\"html\";s:10746:\"<!-- wp:group {\"align\":\"full\",\"className\":\"hostinger-ai-our-projects-4\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group alignfull hostinger-ai-our-projects-4 hostinger-ai-fade-up\"><!-- wp:group {\"align\":\"wide\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"left\"}} -->\n    <div class=\"wp-block-group alignwide hostinger-ai-fade-up\"><!-- wp:heading {\"className\":\"is-style-default hostinger-ai-title\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|dark\"}}},\"spacing\":{\"margin\":{\"bottom\":\"var:preset|spacing|50\"}}},\"textColor\":\"dark\",\"fontSize\":\"x-large\"} -->\n        <h2 class=\"wp-block-heading is-style-default hostinger-ai-title has-dark-color has-text-color has-link-color has-x-large-font-size\" style=\"margin-bottom:var(--wp--preset--spacing--50)\">Our projects</h2>\n        <!-- /wp:heading -->\n\n        <!-- wp:columns {\"align\":\"wide\"} -->\n        <div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"50%\"} -->\n            <div class=\"wp-block-column\" style=\"flex-basis:50%\"><!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"bottom\":\"0\",\"left\":\"var:preset|spacing|20\",\"right\":\"var:preset|spacing|20\"}}},\"layout\":{\"type\":\"constrained\"}} -->\n                <div class=\"wp-block-group hostinger-ai-fade-up\" style=\"padding-top:0;padding-right:var(--wp--preset--spacing--20);padding-bottom:0;padding-left:var(--wp--preset--spacing--20)\"><!-- wp:image {\"id\":629,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"hostinger-ai-project-image hostinger-index-6\",\"style\":{\"border\":{\"radius\":\"8px\"}}} -->\n                    <figure class=\"wp-block-image size-full has-custom-border hostinger-ai-project-image hostinger-index-6\"><img src=\"https://hostinger-wp-blocks.com/wp-content/uploads/2024/11/500x500.png\" alt=\"\" class=\"wp-image-629\" style=\"border-radius:8px\"/></figure>\n                    <!-- /wp:image -->\n\n                    <!-- wp:paragraph {\"align\":\"left\",\"className\":\"hostinger-ai-project-title hostinger-ai-font-bold\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|dark\"}}},\"spacing\":{\"margin\":{\"top\":\"var:preset|spacing|40\"}}},\"textColor\":\"dark\",\"fontSize\":\"medium\"} -->\n                    <p class=\"has-text-align-left hostinger-ai-project-title hostinger-ai-font-bold has-dark-color has-text-color has-link-color has-medium-font-size\" style=\"margin-top:var(--wp--preset--spacing--40)\"><strong>Title 1</strong></p>\n                    <!-- /wp:paragraph -->\n\n                    <!-- wp:paragraph {\"align\":\"left\",\"className\":\"hostinger-ai-project-description\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|dark\"}}},\"spacing\":{\"margin\":{\"top\":\"var:preset|spacing|40\"},\"padding\":{\"right\":\"var:preset|spacing|60\"}}},\"textColor\":\"dark\",\"fontSize\":\"medium\"} -->\n                    <p class=\"has-text-align-left hostinger-ai-project-description has-dark-color has-text-color has-link-color has-medium-font-size\" style=\"margin-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--60)\">Experience luxurious accommodation in the breathtaking Alps, perfect for your ski getaway.</p>\n                    <!-- /wp:paragraph --></div>\n                <!-- /wp:group --></div>\n            <!-- /wp:column -->\n\n            <!-- wp:column {\"width\":\"50%\"} -->\n            <div class=\"wp-block-column\" style=\"flex-basis:50%\"><!-- wp:group {\"className\":\"project-item\",\"style\":{\"spacing\":{\"padding\":{\"right\":\"var:preset|spacing|20\",\"left\":\"var:preset|spacing|20\",\"top\":\"var:preset|spacing|80\"}}},\"layout\":{\"type\":\"constrained\"}} -->\n                <div class=\"wp-block-group project-item hostinger-ai-fade-up\" style=\"padding-top:var(--wp--preset--spacing--80);padding-right:var(--wp--preset--spacing--20);padding-left:var(--wp--preset--spacing--20)\"><!-- wp:image {\"id\":630,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"hostinger-ai-project-image hostinger-index-7\",\"style\":{\"border\":{\"radius\":\"8px\"}}} -->\n                    <figure class=\"wp-block-image size-full has-custom-border hostinger-ai-project-image hostinger-index-7\"><img src=\"https://hostinger-wp-blocks.com/wp-content/uploads/2024/11/500x550.png\" alt=\"\" class=\"wp-image-630\" style=\"border-radius:8px\"/></figure>\n                    <!-- /wp:image -->\n\n                    <!-- wp:paragraph {\"align\":\"left\",\"className\":\"hostinger-ai-project-title hostinger-index-1 hostinger-ai-font-bold\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|dark\"}}},\"spacing\":{\"margin\":{\"top\":\"var:preset|spacing|40\"}}},\"textColor\":\"dark\",\"fontSize\":\"medium\"} -->\n                    <p class=\"has-text-align-left hostinger-ai-project-title hostinger-index-1 hostinger-ai-font-bold has-dark-color has-text-color has-link-color has-medium-font-size\" style=\"margin-top:var(--wp--preset--spacing--40)\"><strong>Title 2</strong></p>\n                    <!-- /wp:paragraph -->\n\n                    <!-- wp:paragraph {\"className\":\"hostinger-ai-project-description hostinger-index-1\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|dark\"}}},\"spacing\":{\"margin\":{\"top\":\"var:preset|spacing|40\"},\"padding\":{\"right\":\"var:preset|spacing|60\"}}},\"textColor\":\"dark\",\"fontSize\":\"medium\"} -->\n                    <p class=\"hostinger-ai-project-description hostinger-index-1 has-dark-color has-text-color has-link-color has-medium-font-size\" style=\"margin-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--60)\">Enjoy stunning views and cozy lodgings at our premier ski resort in the Alps.</p>\n                    <!-- /wp:paragraph --></div>\n                <!-- /wp:group --></div>\n            <!-- /wp:column --></div>\n        <!-- /wp:columns -->\n\n        <!-- wp:columns {\"align\":\"wide\",\"className\":\"project-column\",\"style\":{\"spacing\":{\"margin\":{\"top\":\"-40px\"}}}} -->\n        <div class=\"wp-block-columns alignwide project-column\" style=\"margin-top:-40px\"><!-- wp:column {\"width\":\"50%\"} -->\n            <div class=\"wp-block-column\" style=\"flex-basis:50%\"><!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"bottom\":\"0\",\"left\":\"var:preset|spacing|20\",\"right\":\"var:preset|spacing|20\"}}},\"layout\":{\"type\":\"constrained\"}} -->\n                <div class=\"wp-block-group hostinger-ai-fade-up\" style=\"padding-top:0;padding-right:var(--wp--preset--spacing--20);padding-bottom:0;padding-left:var(--wp--preset--spacing--20)\"><!-- wp:image {\"id\":629,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"hostinger-ai-project-image hostinger-index-8\",\"style\":{\"border\":{\"radius\":\"8px\"}}} -->\n                    <figure class=\"wp-block-image size-full has-custom-border hostinger-ai-project-image hostinger-index-8\"><img src=\"https://hostinger-wp-blocks.com/wp-content/uploads/2024/11/500x500.png\" alt=\"\" class=\"wp-image-629\" style=\"border-radius:8px\"/></figure>\n                    <!-- /wp:image -->\n\n                    <!-- wp:paragraph {\"align\":\"left\",\"className\":\"hostinger-ai-project-title hostinger-index-2 hostinger-ai-font-bold\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|dark\"}}},\"spacing\":{\"margin\":{\"top\":\"var:preset|spacing|40\"}}},\"textColor\":\"dark\",\"fontSize\":\"medium\"} -->\n                    <p class=\"has-text-align-left hostinger-ai-project-title hostinger-index-2 hostinger-ai-font-bold has-dark-color has-text-color has-link-color has-medium-font-size\" style=\"margin-top:var(--wp--preset--spacing--40)\"><strong>Title 3</strong></p>\n                    <!-- /wp:paragraph -->\n\n                    <!-- wp:paragraph {\"align\":\"left\",\"className\":\"hostinger-ai-project-description hostinger-index-2\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|dark\"}}},\"spacing\":{\"margin\":{\"top\":\"var:preset|spacing|40\"},\"padding\":{\"right\":\"var:preset|spacing|60\"}}},\"textColor\":\"dark\",\"fontSize\":\"medium\"} -->\n                    <p class=\"has-text-align-left hostinger-ai-project-description hostinger-index-2 has-dark-color has-text-color has-link-color has-medium-font-size\" style=\"margin-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--60)\">Experience luxurious accommodation in the breathtaking Alps, perfect for your ski getaway.</p>\n                    <!-- /wp:paragraph --></div>\n                <!-- /wp:group --></div>\n            <!-- /wp:column -->\n\n            <!-- wp:column {\"width\":\"50%\"} -->\n            <div class=\"wp-block-column\" style=\"flex-basis:50%\"><!-- wp:group {\"className\":\"project-item\",\"style\":{\"spacing\":{\"padding\":{\"right\":\"var:preset|spacing|20\",\"left\":\"var:preset|spacing|20\",\"top\":\"var:preset|spacing|80\"}}},\"layout\":{\"type\":\"constrained\"}} -->\n                <div class=\"wp-block-group project-item hostinger-ai-fade-up\" style=\"padding-top:var(--wp--preset--spacing--80);padding-right:var(--wp--preset--spacing--20);padding-left:var(--wp--preset--spacing--20)\"><!-- wp:image {\"id\":630,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"hostinger-ai-project-image hostinger-index-9\",\"style\":{\"border\":{\"radius\":\"8px\"}}} -->\n                    <figure class=\"wp-block-image size-full has-custom-border hostinger-ai-project-image hostinger-index-9\"><img src=\"https://hostinger-wp-blocks.com/wp-content/uploads/2024/11/500x550.png\" alt=\"\" class=\"wp-image-630\" style=\"border-radius:8px\"/></figure>\n                    <!-- /wp:image -->\n\n                    <!-- wp:paragraph {\"align\":\"left\",\"className\":\"hostinger-ai-project-title hostinger-index-1 hostinger-ai-font-bold hostinger-index-3\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|dark\"}}},\"spacing\":{\"margin\":{\"top\":\"var:preset|spacing|40\"}}},\"textColor\":\"dark\",\"fontSize\":\"medium\"} -->\n                    <p class=\"has-text-align-left hostinger-ai-project-title hostinger-index-1 hostinger-ai-font-bold hostinger-index-3 has-dark-color has-text-color has-link-color has-medium-font-size\" style=\"margin-top:var(--wp--preset--spacing--40)\"><strong>Title 4</strong></p>\n                    <!-- /wp:paragraph -->\n\n                    <!-- wp:paragraph {\"className\":\"hostinger-ai-project-description hostinger-index-3\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|dark\"}}},\"spacing\":{\"margin\":{\"top\":\"var:preset|spacing|40\"},\"padding\":{\"right\":\"var:preset|spacing|60\"}}},\"textColor\":\"dark\",\"fontSize\":\"medium\"} -->\n                    <p class=\"hostinger-ai-project-description hostinger-index-3 has-dark-color has-text-color has-link-color has-medium-font-size\" style=\"margin-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--60)\">Enjoy stunning views and cozy lodgings at our premier ski resort in the Alps.</p>\n                    <!-- /wp:paragraph --></div>\n                <!-- /wp:group --></div>\n            <!-- /wp:column --></div>\n        <!-- /wp:columns --></div>\n    <!-- /wp:group --></div>\n<!-- /wp:group -->\";}s:13:\"67b4a3b27986c\";a:3:{s:4:\"type\";s:7:\"gallery\";s:8:\"elements\";a:6:{s:13:\"67b4a3b58b59a\";a:6:{s:5:\"class\";s:18:\"hostinger-ai-title\";s:4:\"type\";s:5:\"Title\";s:9:\"max_words\";i:2;s:4:\"tone\";s:10:\"buissiness\";s:5:\"index\";s:1:\"0\";s:7:\"content\";s:22:\"Innovative Investments\";}s:13:\"67b4a3b58b59b\";a:5:{s:5:\"class\";s:24:\"hostinger-ai-description\";s:4:\"type\";s:11:\"Description\";s:9:\"max_words\";i:14;s:5:\"index\";s:1:\"0\";s:7:\"content\";s:98:\"Empowering startups with funding, mentorship, and resources for transformative growth and success.\";}s:13:\"67b4a3b58b59d\";a:6:{s:5:\"class\";s:18:\"hostinger-ai-image\";s:4:\"type\";s:5:\"Image\";s:5:\"index\";s:1:\"2\";s:9:\"max_words\";i:5;s:10:\"image_size\";a:3:{s:5:\"width\";i:800;s:6:\"height\";i:400;s:4:\"crop\";b:1;}s:7:\"content\";s:15:\"venture capital\";}s:13:\"67b4a3b58b59e\";a:6:{s:5:\"class\";s:18:\"hostinger-ai-image\";s:4:\"type\";s:5:\"Image\";s:5:\"index\";s:1:\"3\";s:9:\"max_words\";i:5;s:10:\"image_size\";a:3:{s:5:\"width\";i:300;s:6:\"height\";i:400;s:4:\"crop\";b:1;}s:7:\"content\";s:15:\"venture capital\";}s:13:\"67b4a3b58b59f\";a:6:{s:5:\"class\";s:18:\"hostinger-ai-image\";s:4:\"type\";s:5:\"Image\";s:5:\"index\";s:1:\"0\";s:9:\"max_words\";i:5;s:10:\"image_size\";a:3:{s:5:\"width\";i:300;s:6:\"height\";i:400;s:4:\"crop\";b:1;}s:7:\"content\";s:15:\"venture capital\";}s:13:\"67b4a3b58b5a0\";a:6:{s:5:\"class\";s:18:\"hostinger-ai-image\";s:4:\"type\";s:5:\"Image\";s:5:\"index\";s:1:\"1\";s:9:\"max_words\";i:5;s:10:\"image_size\";a:3:{s:5:\"width\";i:800;s:6:\"height\";i:400;s:4:\"crop\";b:1;}s:7:\"content\";s:15:\"venture capital\";}}s:4:\"html\";s:4109:\"<!-- wp:group {\"align\":\"full\",\"className\":\"hostinger-ai-gallery-1\",\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group alignfull hostinger-ai-gallery-1 hostinger-ai-fade-up\"><!-- wp:group {\"align\":\"wide\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|60\",\"bottom\":\"var:preset|spacing|60\"}}},\"layout\":{\"type\":\"constrained\"}} -->\n    <div class=\"wp-block-group alignwide hostinger-ai-fade-up\" style=\"padding-top:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60)\"><!-- wp:heading {\"textAlign\":\"center\",\"className\":\"hostinger-ai-title\",\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"var:preset|spacing|20\",\"left\":\"0\",\"right\":\"0\"}},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|dark\"}}}},\"textColor\":\"dark\",\"fontSize\":\"x-large\"} -->\n        <h2 class=\"wp-block-heading has-text-align-center hostinger-ai-title has-dark-color has-text-color has-link-color has-x-large-font-size\" style=\"margin-top:0;margin-right:0;margin-bottom:var(--wp--preset--spacing--20);margin-left:0\">Photography Gallery</h2>\n        <!-- /wp:heading -->\n\n        <!-- wp:paragraph {\"align\":\"center\",\"className\":\"hostinger-ai-description\",\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|dark\"}}}},\"textColor\":\"dark\",\"fontSize\":\"medium\"} -->\n        <p class=\"has-text-align-center hostinger-ai-description has-dark-color has-text-color has-link-color has-medium-font-size\" style=\"margin-top:0;margin-bottom:0\"><br>Explore my collection of stunning photographs showcasing diverse moments.</p>\n        <!-- /wp:paragraph --></div>\n    <!-- /wp:group -->\n\n    <!-- wp:group {\"layout\":{\"type\":\"constrained\"}} -->\n    <div class=\"wp-block-group hostinger-ai-fade-up\"><!-- wp:group {\"align\":\"wide\",\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"center\"}} -->\n        <div class=\"wp-block-group alignwide hostinger-ai-fade-up\"><!-- wp:image {\"id\":503,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"hostinger-ai-image hostinger-index-2\",\"style\":{\"border\":{\"radius\":\"8px\"}}} -->\n            <figure class=\"wp-block-image size-full has-custom-border hostinger-ai-image hostinger-index-2\"><img src=\"https://hostinger-wp-blocks.com/wp-content/uploads/2024/11/300x400.jpg\" alt=\"\" class=\"wp-image-503\" style=\"border-radius:8px\"/></figure>\n            <!-- /wp:image -->\n\n            <!-- wp:image {\"id\":504,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"hostinger-ai-image hostinger-index-3\",\"style\":{\"border\":{\"radius\":\"8px\"}}} -->\n            <figure class=\"wp-block-image size-full has-custom-border hostinger-ai-image hostinger-index-3\"><img src=\"https://hostinger-wp-blocks.com/wp-content/uploads/2024/11/800x400.jpg\" alt=\"\" class=\"wp-image-504\" style=\"border-radius:8px\"/></figure>\n            <!-- /wp:image --></div>\n        <!-- /wp:group -->\n\n        <!-- wp:group {\"align\":\"wide\",\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"var:preset|spacing|20\"}}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"center\"}} -->\n        <div class=\"wp-block-group alignwide hostinger-ai-fade-up\" style=\"margin-bottom:var(--wp--preset--spacing--20)\"><!-- wp:image {\"id\":504,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"hostinger-ai-image\",\"style\":{\"border\":{\"radius\":\"8px\"}}} -->\n            <figure class=\"wp-block-image size-full has-custom-border hostinger-ai-image\"><img src=\"https://hostinger-wp-blocks.com/wp-content/uploads/2024/11/800x400.jpg\" alt=\"\" class=\"wp-image-504\" style=\"border-radius:8px\"/></figure>\n            <!-- /wp:image -->\n\n            <!-- wp:image {\"id\":503,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"hostinger-ai-image hostinger-index-1\",\"style\":{\"border\":{\"radius\":\"8px\"}}} -->\n            <figure class=\"wp-block-image size-full has-custom-border hostinger-ai-image hostinger-index-1\"><img src=\"https://hostinger-wp-blocks.com/wp-content/uploads/2024/11/300x400.jpg\" alt=\"\" class=\"wp-image-503\" style=\"border-radius:8px\"/></figure>\n            <!-- /wp:image --></div>\n        <!-- /wp:group --></div>\n    <!-- /wp:group --></div>\n<!-- /wp:group -->\";}s:13:\"67b4a3b27986d\";a:3:{s:4:\"type\";s:16:\"customer-reviews\";s:8:\"elements\";a:5:{s:13:\"67b4a3b58b65b\";a:5:{s:5:\"class\";s:21:\"hostinger-ai-subtitle\";s:4:\"type\";s:8:\"Subtitle\";s:9:\"max_words\";i:2;s:5:\"index\";s:1:\"0\";s:7:\"content\";s:15:\"Client Feedback\";}s:13:\"67b4a3b58b65d\";a:7:{s:5:\"class\";s:30:\"hostinger-ai-testimonial-image\";s:4:\"type\";s:5:\"Image\";s:5:\"index\";s:1:\"3\";s:9:\"max_words\";i:5;s:10:\"image_size\";a:3:{s:5:\"width\";i:180;s:6:\"height\";i:200;s:4:\"crop\";b:1;}s:15:\"default_content\";s:8:\"man face\";s:7:\"content\";s:15:\"venture capital\";}s:13:\"67b4a3b58b65e\";a:7:{s:5:\"class\";s:29:\"hostinger-ai-testimonial-text\";s:4:\"type\";s:11:\"Testimonial\";s:5:\"index\";s:1:\"1\";s:9:\"max_words\";i:14;s:6:\"prefix\";s:3:\"”\";s:6:\"suffix\";s:3:\"”\";s:7:\"content\";s:99:\"Zayn Ventures transformed our startup with their invaluable guidance and strategic funding support.\";}s:13:\"67b4a3b58b65f\";a:7:{s:5:\"class\";s:30:\"hostinger-ai-testimonial-image\";s:4:\"type\";s:5:\"Image\";s:5:\"index\";s:1:\"4\";s:9:\"max_words\";i:5;s:10:\"image_size\";a:3:{s:5:\"width\";i:180;s:6:\"height\";i:200;s:4:\"crop\";b:1;}s:15:\"default_content\";s:10:\"woman face\";s:7:\"content\";s:15:\"venture capital\";}s:13:\"67b4a3b58b660\";a:7:{s:5:\"class\";s:29:\"hostinger-ai-testimonial-text\";s:4:\"type\";s:11:\"Testimonial\";s:5:\"index\";s:1:\"0\";s:9:\"max_words\";i:14;s:6:\"prefix\";s:3:\"”\";s:6:\"suffix\";s:3:\"”\";s:7:\"content\";s:98:\"Their mentorship and resources propelled our growth beyond expectations in the competitive market.\";}}s:4:\"html\";s:4466:\"<!-- wp:group {\"align\":\"wide\",\"className\":\"hostinger-ai-fade-up hostinger-ai-customer-reviews-3\",\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignwide hostinger-ai-fade-up hostinger-ai-customer-reviews-3\"><!-- wp:group {\"align\":\"wide\",\"className\":\"hostinger-ai-fade-up\",\"layout\":{\"type\":\"default\"}} -->\n    <div class=\"wp-block-group alignwide hostinger-ai-fade-up\"><!-- wp:columns -->\n        <div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"40%\"} -->\n            <div class=\"wp-block-column\" style=\"flex-basis:40%\"><!-- wp:heading {\"textAlign\":\"left\",\"align\":\"full\",\"className\":\"hostinger-ai-subtitle\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|dark\"}}},\"spacing\":{\"margin\":{\"bottom\":\"var:preset|spacing|50\"}}},\"textColor\":\"dark\",\"fontSize\":\"x-large\"} -->\n                <h2 class=\"wp-block-heading alignfull has-text-align-left hostinger-ai-subtitle has-dark-color has-text-color has-link-color has-x-large-font-size\" style=\"margin-bottom:var(--wp--preset--spacing--50)\">Customer reviews</h2>\n                <!-- /wp:heading --></div>\n            <!-- /wp:column -->\n\n            <!-- wp:column {\"width\":\"60%\"} -->\n            <div class=\"wp-block-column\" style=\"flex-basis:60%\"><!-- wp:group {\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} -->\n                <div class=\"wp-block-group\"><!-- wp:group {\"className\":\"hostinger-ai-fade-up\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|40\"}}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\n                    <div class=\"wp-block-group hostinger-ai-fade-up\" style=\"padding-bottom:var(--wp--preset--spacing--40)\"><!-- wp:image {\"id\":266,\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"hostinger-ai-testimonial-image hostinger-index-3\",\"style\":{\"border\":{\"radius\":\"8px\"}}} -->\n                        <figure class=\"wp-block-image size-full has-custom-border hostinger-ai-testimonial-image hostinger-index-3\"><img src=\"https://hostinger-wp-blocks.com/wp-content/uploads/2024/08/testimonial-d95lQjEGjlir2kka.avif\" alt=\"\" class=\"wp-image-266\" style=\"border-radius:8px;object-fit:cover\"/></figure>\n                        <!-- /wp:image -->\n\n                        <!-- wp:paragraph {\"className\":\"hostinger-ai-testimonial-text hostinger-index-1\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|dark\"}}},\"layout\":{\"columnSpan\":1,\"rowSpan\":1},\"spacing\":{\"padding\":{\"left\":\"var:preset|spacing|20\"}}},\"textColor\":\"dark\",\"fontSize\":\"medium\"} -->\n                        <p class=\"hostinger-ai-testimonial-text hostinger-index-1 has-dark-color has-text-color has-link-color has-medium-font-size\" style=\"padding-left:var(--wp--preset--spacing--20)\">Beautiful location in the Alps. Highly recommend for a cozy ski getaway!</p>\n                        <!-- /wp:paragraph --></div>\n                    <!-- /wp:group -->\n\n                    <!-- wp:group {\"className\":\"hostinger-ai-fade-up\",\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\n                    <div class=\"wp-block-group hostinger-ai-fade-up\"><!-- wp:image {\"id\":265,\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"hostinger-ai-testimonial-image hostinger-index-4\",\"style\":{\"border\":{\"radius\":\"8px\"}}} -->\n                        <figure class=\"wp-block-image size-full has-custom-border hostinger-ai-testimonial-image hostinger-index-4\"><img src=\"https://hostinger-wp-blocks.com/wp-content/uploads/2024/08/photo-1573515159471-0eb7ec72912c.avif\" alt=\"\" class=\"wp-image-265\" style=\"border-radius:8px;object-fit:cover\"/></figure>\n                        <!-- /wp:image -->\n\n                        <!-- wp:paragraph {\"className\":\"hostinger-ai-testimonial-text\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|dark\"}}},\"layout\":{\"columnSpan\":1,\"rowSpan\":1},\"spacing\":{\"padding\":{\"left\":\"var:preset|spacing|20\"}}},\"textColor\":\"dark\",\"fontSize\":\"medium\"} -->\n                        <p class=\"hostinger-ai-testimonial-text has-dark-color has-text-color has-link-color has-medium-font-size\" style=\"padding-left:var(--wp--preset--spacing--20)\">Amazing stay at Skialps! The accommodation was perfect for our ski trip.</p>\n                        <!-- /wp:paragraph --></div>\n                    <!-- /wp:group --></div>\n                <!-- /wp:group --></div>\n            <!-- /wp:column --></div>\n        <!-- /wp:columns --></div>\n    <!-- /wp:group --></div>\n<!-- /wp:group -->\";}}}s:7:\"contact\";a:1:{s:8:\"sections\";a:3:{s:13:\"67b4a3b27986e\";a:3:{s:4:\"type\";s:7:\"contact\";s:8:\"elements\";a:1:{s:13:\"67b4a3b58b6f8\";a:6:{s:5:\"class\";s:18:\"hostinger-ai-title\";s:4:\"type\";s:5:\"Title\";s:9:\"max_words\";i:3;s:4:\"tone\";s:10:\"buissiness\";s:5:\"index\";s:1:\"0\";s:7:\"content\";s:12:\"Get in Touch\";}}s:4:\"html\";s:1850:\"<!-- wp:group {\"metadata\":{\"name\":\"Contact form\"},\"align\":\"full\",\"className\":\"hostinger-ai-contact-form-4 hostinger-ai-fade-up\",\"style\":{\"dimensions\":{\"minHeight\":\"\"}},\"backgroundColor\":\"color1\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group alignfull hostinger-ai-contact-form-4 hostinger-ai-fade-up has-color-1-background-color has-background\"><!-- wp:group {\"align\":\"wide\",\"className\":\"hostinger-ai-fade-up\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|40\",\"bottom\":\"var:preset|spacing|40\"}},\"dimensions\":{\"minHeight\":\"400px\"}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"justifyContent\":\"center\",\"verticalAlignment\":\"center\",\"flexWrap\":\"nowrap\"}} -->\n    <div class=\"wp-block-group alignwide hostinger-ai-fade-up\" style=\"min-height:400px;padding-top:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--40)\"><!-- wp:group {\"className\":\"hostinger-ai-fade-up\",\"style\":{\"spacing\":{\"blockGap\":\"0px\"},\"layout\":{\"columnSpan\":1,\"rowSpan\":1}},\"layout\":{\"type\":\"default\"}} -->\n        <div class=\"wp-block-group hostinger-ai-fade-up\"><!-- wp:heading {\"textAlign\":\"center\",\"className\":\"hostinger-ai-subtitle\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|dark\"}}},\"spacing\":{\"margin\":{\"top\":\"var:preset|spacing|60\",\"bottom\":\"var:preset|spacing|60\"}}},\"textColor\":\"dark\",\"fontSize\":\"x-large\"} -->\n            <h2 class=\"wp-block-heading has-text-align-center hostinger-ai-title has-dark-color has-text-color has-link-color has-x-large-font-size\" style=\"margin-top:var(--wp--preset--spacing--60);margin-bottom:var(--wp--preset--spacing--60)\">Get in touch</h2>\n            <!-- /wp:heading -->\n\n            <!-- wp:shortcode -->\n            [hostinger_contact_form]\n            <!-- /wp:shortcode --></div>\n        <!-- /wp:group --></div>\n    <!-- /wp:group --></div>\n<!-- /wp:group -->\";}s:13:\"67b4a3b27986f\";a:3:{s:4:\"type\";s:8:\"location\";s:8:\"elements\";a:4:{s:13:\"67b4a3b58b7b1\";a:5:{s:5:\"class\";s:18:\"hostinger-ai-title\";s:4:\"type\";s:5:\"Title\";s:9:\"max_words\";i:2;s:5:\"index\";s:1:\"0\";s:7:\"content\";s:12:\"Our Location\";}s:13:\"67b4a3b58b7b2\";a:5:{s:5:\"class\";s:24:\"hostinger-ai-description\";s:4:\"type\";s:11:\"Description\";s:9:\"max_words\";i:8;s:5:\"index\";s:1:\"0\";s:7:\"content\";s:45:\"Visit us to discuss innovative opportunities.\";}s:13:\"67b4a3b58b7b3\";a:5:{s:5:\"class\";s:18:\"hostinger-ai-title\";s:4:\"type\";s:5:\"Title\";s:9:\"max_words\";i:2;s:5:\"index\";s:1:\"1\";s:7:\"content\";s:10:\"Contact Us\";}s:13:\"67b4a3b58b7b4\";a:5:{s:5:\"class\";s:18:\"hostinger-ai-title\";s:4:\"type\";s:5:\"Title\";s:9:\"max_words\";i:2;s:5:\"index\";s:1:\"2\";s:7:\"content\";s:14:\"Get Directions\";}}s:4:\"html\";s:4138:\"<!-- wp:group {\"align\":\"wide\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group alignwide hostinger-ai-fade-up\" style=\"padding-top:0;padding-bottom:0\"><!-- wp:group {\"align\":\"wide\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"left\"}} -->\n    <div class=\"wp-block-group alignwide hostinger-ai-fade-up\"><!-- wp:heading {\"textAlign\":\"left\",\"className\":\"hostinger-ai-title\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|dark\"}}},\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"var:preset|spacing|40\",\"left\":\"0\",\"right\":\"0\"}}},\"textColor\":\"dark\",\"fontSize\":\"x-large\"} -->\n        <h2 class=\"wp-block-heading has-text-align-left hostinger-ai-title has-dark-color has-text-color has-link-color has-x-large-font-size\" style=\"margin-top:0;margin-right:0;margin-bottom:var(--wp--preset--spacing--40);margin-left:0\">Our location</h2>\n        <!-- /wp:heading -->\n\n        <!-- wp:paragraph {\"align\":\"left\",\"className\":\"hostinger-ai-description\",\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"var:preset|spacing|40\"}}},\"fontSize\":\"medium\"} -->\n        <p class=\"has-text-align-left hostinger-ai-description has-medium-font-size\" style=\"margin-bottom:var(--wp--preset--spacing--40)\">Experience unforgettable stays in the stunning Alps.</p>\n        <!-- /wp:paragraph -->\n\n        <!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\"},\"padding\":{\"bottom\":\"var:preset|spacing|40\"}}}} -->\n        <div class=\"wp-block-columns alignwide\" style=\"margin-top:0;margin-bottom:0;padding-bottom:var(--wp--preset--spacing--40)\"><!-- wp:column -->\n            <div class=\"wp-block-column\"><!-- wp:paragraph {\"className\":\"hostinger-ai-title hostinger-index-1 hostinger-ai-font-bold\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|dark\"}}}},\"textColor\":\"dark\",\"fontSize\":\"medium\"} -->\n                <p class=\"hostinger-ai-title hostinger-index-1 hostinger-ai-font-bold has-dark-color has-text-color has-link-color has-medium-font-size\"><strong>Address</strong></p>\n                <!-- /wp:paragraph -->\n\n                <!-- wp:paragraph {\"style\":{\"spacing\":{\"margin\":{\"top\":\"var:preset|spacing|20\"}}},\"fontSize\":\"medium\"} -->\n                <p class=\"has-medium-font-size\" style=\"margin-top:var(--wp--preset--spacing--20)\">697 Hilltop Street, Springfield, MA, USA</p>\n                <!-- /wp:paragraph --></div>\n            <!-- /wp:column -->\n\n            <!-- wp:column -->\n            <div class=\"wp-block-column\"><!-- wp:paragraph {\"className\":\"hostinger-ai-title hostinger-index-2 hostinger-ai-font-bold\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|dark\"}}}},\"textColor\":\"dark\",\"fontSize\":\"medium\"} -->\n                <p class=\"hostinger-ai-title hostinger-index-2 hostinger-ai-font-bold has-dark-color has-text-color has-link-color has-medium-font-size\"><strong>Hours</strong></p>\n                <!-- /wp:paragraph -->\n\n                <!-- wp:paragraph {\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|dark\"}}},\"spacing\":{\"margin\":{\"top\":\"var:preset|spacing|20\"}}},\"textColor\":\"dark\",\"fontSize\":\"medium\"} -->\n                <p class=\"has-dark-color has-text-color has-link-color has-medium-font-size\" style=\"margin-top:var(--wp--preset--spacing--20)\">9am - 6pm</p>\n                <!-- /wp:paragraph --></div>\n            <!-- /wp:column --></div>\n        <!-- /wp:columns -->\n\n        <!-- wp:group {\"align\":\"full\",\"layout\":{\"type\":\"default\"}} -->\n        <div class=\"wp-block-group alignfull hostinger-ai-fade-up\"><!-- wp:html -->\n            <iframe src=\"https://www.google.com/maps/embed?pb=!1m14!1m8!1m3!1d47368.39682225005!2d-72.489385!3d42.09623!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x89e6e85bbff73363%3A0x5241d930e1909b8f!2sHilltop%20St%2C%20Springfield%2C%20MA%2001128!5e0!3m2!1sen!2sus!4v1722498156021!5m2!1sen!2sus\" height=\"450\" style=\"width: 100%; min-width: 100%; border:0;\" allowfullscreen=\"\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>\n            <!-- /wp:html --></div>\n        <!-- /wp:group --></div>\n    <!-- /wp:group --></div>\n<!-- /wp:group -->\";}s:13:\"67b4a3b279870\";a:3:{s:4:\"type\";s:14:\"call-to-action\";s:8:\"elements\";a:3:{s:13:\"67b4a3b58b844\";a:6:{s:5:\"class\";s:18:\"hostinger-ai-title\";s:4:\"type\";s:5:\"Title\";s:9:\"max_words\";i:3;s:4:\"tone\";s:10:\"buissiness\";s:5:\"index\";s:1:\"0\";s:7:\"content\";s:12:\"Get in Touch\";}s:13:\"67b4a3b58b845\";a:5:{s:5:\"class\";s:24:\"hostinger-ai-description\";s:4:\"type\";s:11:\"Description\";s:9:\"max_words\";i:20;s:5:\"index\";s:1:\"0\";s:7:\"content\";s:136:\"Connect with Zayn Ventures to explore funding opportunities and mentorship for your innovative startup. Let\'s shape the future together!\";}s:13:\"67b4a3b58b846\";a:5:{s:5:\"class\";s:23:\"hostinger-ai-cta-button\";s:4:\"type\";s:10:\"CTA Button\";s:9:\"max_words\";i:1;s:5:\"index\";s:1:\"0\";s:7:\"content\";s:7:\"Contact\";}}s:4:\"html\";s:3443:\"<!-- wp:group {\"align\":\"full\",\"className\":\"hostinger-ai-solid-block\",\"style\":{\"dimensions\":{\"minHeight\":\"\"},\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|60\",\"bottom\":\"var:preset|spacing|60\"}}},\"backgroundColor\":\"color1\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group alignfull hostinger-ai-solid-block has-color-1-background-color has-background hostinger-ai-fade-up\"  style=\"padding-top:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60)\"><!-- wp:group {\"align\":\"wide\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"bottom\":\"0\"}},\"dimensions\":{\"minHeight\":\"0px\"}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"justifyContent\":\"center\",\"verticalAlignment\":\"center\",\"flexWrap\":\"nowrap\"}} -->\n    <div class=\"wp-block-group alignwide hostinger-ai-fade-up\" style=\"min-height:0px;padding-top:0;padding-bottom:0\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"0px\"},\"layout\":{\"columnSpan\":1,\"rowSpan\":1}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n        <div class=\"wp-block-group hostinger-ai-fade-up\"><!-- wp:heading {\"textAlign\":\"center\",\"className\":\"hostinger-ai-title\",\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"right\":\"0\"}},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|dark\"}}}},\"textColor\":\"dark\",\"fontSize\":\"x-large\"} -->\n            <h2 class=\"wp-block-heading has-text-align-center hostinger-ai-title has-dark-color has-text-color has-link-color has-x-large-font-size\" style=\"margin-top:0;margin-right:0;margin-bottom:0;margin-left:0\">Make a reservation</h2>\n            <!-- /wp:heading -->\n\n            <!-- wp:paragraph {\"align\":\"center\",\"className\":\"hostinger-ai-description\",\"style\":{\"spacing\":{\"margin\":{\"top\":\"var:preset|spacing|20\",\"bottom\":\"var:preset|spacing|50\"}},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|dark\"}}}},\"textColor\":\"dark\",\"fontSize\":\"medium\"} -->\n            <p class=\"has-text-align-center hostinger-ai-description has-dark-color has-text-color has-link-color has-medium-font-size\" style=\"margin-top:var(--wp--preset--spacing--20);margin-bottom:var(--wp--preset--spacing--50)\">Florsity is a restaurant that serves authentic Italian cuisine. We serve freshly prepared pasta, expertly paired with Italian wines.</p>\n            <!-- /wp:paragraph -->\n\n            <!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n            <div class=\"wp-block-buttons\"><!-- wp:button {\"backgroundColor\":\"contrast\",\"textColor\":\"dark\",\"className\":\"hostinger-ai-cta-button\",\"style\":{\"spacing\":{\"padding\":{\"left\":\"var:preset|spacing|70\",\"right\":\"var:preset|spacing|70\",\"top\":\"var:preset|spacing|30\",\"bottom\":\"var:preset|spacing|30\"}},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|dark\"}}}},\"fontSize\":\"medium\",\"borderColor\":\"dark\"} -->\n                <div class=\"wp-block-button has-custom-font-size hostinger-ai-cta-button has-medium-font-size\"><a class=\"wp-block-button__link has-dark-color has-contrast-background-color has-text-color has-background has-link-color has-border-color has-dark-border-color wp-element-button\" style=\"padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--70)\">Button</a></div>\n                <!-- /wp:button --></div>\n            <!-- /wp:buttons --></div>\n        <!-- /wp:group --></div>\n    <!-- /wp:group --></div>\n<!-- /wp:group -->\";}}}}}", "auto");
INSERT INTO `wp_options` VALUES("409", "hostinger_ai_used_images", "a:3:{s:15:\"venture-capital\";a:14:{s:60:\"https://images.unsplash.com/photo-1591522810896-cb5f45acb9a1\";O:8:\"stdClass\":2:{s:5:\"image\";s:60:\"https://images.unsplash.com/photo-1591522810896-cb5f45acb9a1\";s:15:\"alt_description\";s:190:\"A vintage typewriter with a piece of paper displaying the text \'STARTUP INVESTMENTS\'. The typewriter is a classic model with keys in focus and the paper neatly inserted into the ribbon area.\";}s:60:\"https://images.unsplash.com/photo-1689330306004-8c72d2399132\";O:8:\"stdClass\":2:{s:5:\"image\";s:60:\"https://images.unsplash.com/photo-1689330306004-8c72d2399132\";s:15:\"alt_description\";s:350:\"A person is looking at a computer screen displaying a document titled \'Overview - All Private Equity - Fundraising, Investments, & D\'. The document contains statistical charts and graphs related to private equity market statistics from 2007 to 2022. Various tabs and functions like \'File\', \'Home\', \'Insert\', and \'Design\' are visible in the interface.\";}s:60:\"https://images.unsplash.com/photo-1642142785011-4a00c34c4a36\";O:8:\"stdClass\":2:{s:5:\"image\";s:60:\"https://images.unsplash.com/photo-1642142785011-4a00c34c4a36\";s:15:\"alt_description\";s:285:\"A hand holding a smartphone in front of a wooden background. The phone screen displays a financial investment application with the text \'The smartest thing to do with your money\'. Below it, there are illustrations of stacked coins and a call-to-action button labeled \'Start investing\'.\";}s:60:\"https://images.unsplash.com/photo-1644995520656-e9b9a807ffbe\";O:8:\"stdClass\":2:{s:5:\"image\";s:60:\"https://images.unsplash.com/photo-1644995520656-e9b9a807ffbe\";s:15:\"alt_description\";s:270:\"A person is typing on a MacBook Pro, viewing a website titled \'Personalize your portfolio.\' The webpage displays three sections related to investing, each with different images and text. The laptop is on a grey table with a dark sofa and indoor plants in the background.\";}s:60:\"https://images.unsplash.com/photo-1651129521731-6f6ea5ea0caa\";O:8:\"stdClass\":2:{s:5:\"image\";s:60:\"https://images.unsplash.com/photo-1651129521731-6f6ea5ea0caa\";s:15:\"alt_description\";s:311:\"A hand is holding a smartphone displaying a financial application. The screen shows a chart with a growth prediction in percentage, and sections labeled Personal, Retirement, and Custodial. The chart predicts cash invested and saved over a period of time, with specific dollar values provided for future growth.\";}s:60:\"https://images.unsplash.com/photo-1695805700851-3dce7ee9509f\";O:8:\"stdClass\":2:{s:5:\"image\";s:60:\"https://images.unsplash.com/photo-1695805700851-3dce7ee9509f\";s:15:\"alt_description\";s:264:\"A book titled \'Private Equity at Work\' is positioned prominently on a wooden surface in the foreground. In the background, a group of people in business attire are engaged in conversation, suggesting a professional setting such as a conference or networking event.\";}s:60:\"https://images.unsplash.com/photo-1646156262396-8287aeba5e39\";O:8:\"stdClass\":2:{s:5:\"image\";s:60:\"https://images.unsplash.com/photo-1646156262396-8287aeba5e39\";s:15:\"alt_description\";s:137:\"Two business cards placed on a white sheet. The cards are orange and dark blue, each with the text \'CASTRO CAPITAL\' printed in uppercase.\";}s:60:\"https://images.unsplash.com/photo-1579532582937-16c108930bf6\";O:8:\"stdClass\":2:{s:5:\"image\";s:60:\"https://images.unsplash.com/photo-1579532582937-16c108930bf6\";s:15:\"alt_description\";s:280:\"A newspaper page focused on financial information, including stock market data, recent issues, rates, major price changes, and investment fund details. Columns of numbers are interspersed with headings and small charts, printed on plain paper with a slightly off-white background.\";}s:60:\"https://images.unsplash.com/photo-1613442368680-a30262ad8b3b\";O:8:\"stdClass\":2:{s:5:\"image\";s:60:\"https://images.unsplash.com/photo-1613442368680-a30262ad8b3b\";s:15:\"alt_description\";s:256:\"A hand is holding a smartphone displaying a stock market app. The screen shows financial data, including stock prices, a line graph, and trading volume. The background is blurred, featuring some indistinct indoor elements with natural light coming through.\";}s:60:\"https://images.unsplash.com/photo-1579621970563-ebec7560ff3e\";O:8:\"stdClass\":2:{s:5:\"image\";s:60:\"https://images.unsplash.com/photo-1579621970563-ebec7560ff3e\";s:15:\"alt_description\";s:191:\"A small plant with green leaves sprouting from a pile of coins, symbolizing growth and investment. The setting is minimalistic, with a neutral background and the focus on the plant and coins.\";}s:60:\"https://images.unsplash.com/photo-1682514149196-e75fe2d1b899\";O:8:\"stdClass\":2:{s:5:\"image\";s:60:\"https://images.unsplash.com/photo-1682514149196-e75fe2d1b899\";s:15:\"alt_description\";s:252:\"A graphic with text reading \'Exploring Opportunities for D2C Startups in the Post-COVID-19 World.\' It features a target with an arrow, a computer monitor displaying an upward graph, a calendar, a rocket icon, and a clipboard with colorful sticky notes.\";}s:60:\"https://images.unsplash.com/photo-1646156262471-a37c4a8eddb2\";O:8:\"stdClass\":2:{s:5:\"image\";s:60:\"https://images.unsplash.com/photo-1646156262471-a37c4a8eddb2\";s:15:\"alt_description\";s:404:\"Several business cards are displayed in various colors and patterns. A dark blue card with white text reading \'Castro Capital\' is prominently positioned in the background. In the foreground, there are numerous cards with woven red and orange designs, along with others featuring architectural imagery. Behind the blue card, a textured rock provides a contrasting natural element against the smooth cards.\";}s:60:\"https://images.unsplash.com/photo-1642132652860-471b4228023e\";O:8:\"stdClass\":2:{s:5:\"image\";s:60:\"https://images.unsplash.com/photo-1642132652860-471b4228023e\";s:15:\"alt_description\";s:358:\"A web page from Razorpay displaying marketing content about financial services. The page includes a 3D illustration of a cube surrounded by floating labels with financial terms like \'Virtual Account\' and \'Vendor Payouts\'. The text encourages business growth through automated financial solutions. Navigation links for various services are visible at the top.\";}s:60:\"https://images.unsplash.com/photo-1633158829875-e5316a358c6f\";O:8:\"stdClass\":2:{s:5:\"image\";s:60:\"https://images.unsplash.com/photo-1633158829875-e5316a358c6f\";s:15:\"alt_description\";s:160:\"A glass jar filled with coins is placed on a wooden surface. Emerging from the top of the jar is a small green plant, signifying growth or financial investment.\";}}s:8:\"man-face\";a:3:{s:60:\"https://images.unsplash.com/photo-1573162274701-6f12588e35b3\";O:8:\"stdClass\":2:{s:5:\"image\";s:60:\"https://images.unsplash.com/photo-1573162274701-6f12588e35b3\";s:15:\"alt_description\";s:285:\"A collection of grooming products is arranged on a marble countertop. Items include a black box with grooming scissors, a tin labeled \'Beard Balm,\' a bottle labeled \'Beard Oil,\' a wooden brush, and a wooden comb. Decorative ceramic jars with intricate patterns stand in the background.\";}s:60:\"https://images.unsplash.com/photo-1494474636013-a90fe1540959\";O:8:\"stdClass\":2:{s:5:\"image\";s:60:\"https://images.unsplash.com/photo-1494474636013-a90fe1540959\";s:15:\"alt_description\";s:249:\"A close-up of the lower half of a person\'s face, showing a well-groomed, thick beard and moustache. The lips are slightly closed, and the skin appears textured. The lighting is dim, creating shadows and emphasizing the contours of the person\'s face.\";}s:60:\"https://images.unsplash.com/photo-1675516490928-e8fdfdf65ca8\";O:8:\"stdClass\":2:{s:5:\"image\";s:60:\"https://images.unsplash.com/photo-1675516490928-e8fdfdf65ca8\";s:15:\"alt_description\";s:236:\"A wooden surface is adorned with grooming tools including a comb, a pair of scissors, a trimmer, and a jar labeled \'Daily Grind Knuckle Cream.\' A smartphone displaying a social media page for \'Daily Grind Beard Co.\' is centrally placed.\";}}s:10:\"woman-face\";a:2:{s:60:\"https://images.unsplash.com/photo-1692395957107-f76aac3d0645\";O:8:\"stdClass\":2:{s:5:\"image\";s:60:\"https://images.unsplash.com/photo-1692395957107-f76aac3d0645\";s:15:\"alt_description\";s:268:\"A black and white image featuring a close-up of a woman\'s face in profile, positioned opposite a dark, expressionless mask. The woman\'s hair is loose and wavy, partially covering her face, and the lighting creates dramatic shadows, enhancing the mysterious atmosphere.\";}s:60:\"https://images.unsplash.com/photo-1671797022975-965f4d335e47\";O:8:\"stdClass\":2:{s:5:\"image\";s:60:\"https://images.unsplash.com/photo-1671797022975-965f4d335e47\";s:15:\"alt_description\";s:270:\"A close-up black and white portrait capturing the thoughtful expression of a woman. Her face is slightly angled, with one hand gently placed near her lips, highlighting her delicate features and well-groomed eyebrows. Her eyes are soft, adding to the introspective mood.\";}}}", "off");
INSERT INTO `wp_options` VALUES("414", "hostinger_amplitude_event_data", "a:1:{s:10:\"2025-02-18\";a:2:{s:5:\"count\";i:2;s:10:\"last_reset\";i:0;}}", "auto");
INSERT INTO `wp_options` VALUES("415", "hostinger_amplitude_edit_count", "2", "auto");
INSERT INTO `wp_options` VALUES("416", "hostinger_ai_created_pages", "a:4:{s:4:\"home\";a:2:{s:5:\"title\";s:4:\"Home\";s:7:\"page_id\";i:5;}s:5:\"about\";a:2:{s:5:\"title\";s:5:\"About\";s:7:\"page_id\";i:6;}s:9:\"portfolio\";a:2:{s:5:\"title\";s:9:\"Portfolio\";s:7:\"page_id\";i:7;}s:7:\"contact\";a:2:{s:5:\"title\";s:7:\"Contact\";s:7:\"page_id\";i:8;}}", "auto");
INSERT INTO `wp_options` VALUES("417", "hostinger_ai_template_part_options", "a:2:{s:17:\"theme_taxonomy_id\";i:2;s:16:\"part_taxonomy_id\";i:3;}", "auto");
INSERT INTO `wp_options` VALUES("2734", "hostinger_easy_onboarding_steps", "a:1:{s:13:\"website_setup\";a:1:{s:14:\"connect_domain\";b:1;}}", "off");
INSERT INTO `wp_options` VALUES("2765", "litespeed.conf.qc-cname", "", "auto");
INSERT INTO `wp_options` VALUES("2843", "theme_mods_astra", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:7:\"primary\";i:5;s:14:\"secondary_menu\";i:8;}s:18:\"custom_css_post_id\";i:54;s:11:\"custom_logo\";i:1939;}", "on");
INSERT INTO `wp_options` VALUES("2846", "astra-settings", "a:2342:{s:17:\"blog-single-width\";s:7:\"default\";s:21:\"blog-single-max-width\";i:1200;s:17:\"page-single-width\";s:7:\"default\";s:21:\"page-single-max-width\";i:1200;s:28:\"single-content-images-shadow\";b:0;s:30:\"single-post-ast-content-layout\";s:7:\"default\";s:25:\"single-post-sidebar-style\";s:7:\"default\";s:36:\"ast-dynamic-single-post-elements-gap\";i:10;s:38:\"ast-dynamic-single-post-meta-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:40:\"ast-dynamic-single-post-meta-font-weight\";s:0:\"\";s:32:\"ast-dynamic-single-post-metadata\";a:3:{i:0;s:8:\"comments\";i:1;s:32:\"ast-dynamic-single-post-taxonomy\";i:2;s:6:\"author\";}s:35:\"section-search-page-title-structure\";a:1:{i:0;s:31:\"section-search-page-title-title\";}s:38:\"section-search-page-title-custom-title\";s:19:\"Search Results for:\";s:50:\"section-search-page-title-found-custom-description\";s:44:\"Here are the search results for your search.\";s:54:\"section-search-page-title-not-found-custom-description\";s:85:\"Sorry, but we could not find anything related to your search terms. Please try again.\";s:43:\"section-search-page-title-title-font-weight\";s:0:\"\";s:41:\"section-search-page-title-title-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"ast-search-results-per-page\";i:10;s:46:\"section-search-page-title-horizontal-alignment\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"ast-search-live-search\";b:0;s:33:\"ast-search-live-search-post-types\";a:2:{s:4:\"post\";i:1;s:4:\"page\";i:1;}s:19:\"blog-post-structure\";a:5:{i:0;s:5:\"image\";i:1;s:5:\"title\";i:2;s:10:\"title-meta\";i:3;s:7:\"excerpt\";i:4;s:9:\"read-more\";}s:18:\"blog-post-per-page\";i:10;s:17:\"blog-hover-effect\";s:4:\"none\";s:11:\"blog-layout\";s:19:\"blog-layout-classic\";s:10:\"blog-width\";s:7:\"default\";s:19:\"blog-meta-date-type\";s:9:\"published\";s:21:\"blog-meta-date-format\";s:0:\"\";s:14:\"blog-max-width\";i:1200;s:17:\"blog-post-content\";s:7:\"excerpt\";s:9:\"blog-meta\";a:3:{i:0;s:8:\"comments\";i:1;s:8:\"category\";i:2;s:6:\"author\";}s:23:\"post-card-border-radius\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"post-card-featured-overlay\";s:0:\"\";s:19:\"blog-category-style\";s:7:\"default\";s:14:\"blog-tag-style\";s:7:\"default\";s:27:\"blog-post-meta-divider-type\";s:1:\"/\";s:24:\"blog-meta-category-style\";s:7:\"default\";s:19:\"blog-meta-tag-style\";s:7:\"default\";s:21:\"blog-image-ratio-type\";s:0:\"\";s:26:\"blog-image-ratio-pre-scale\";s:4:\"16/9\";s:29:\"blog-image-custom-scale-width\";i:16;s:30:\"blog-image-custom-scale-height\";i:9;s:10:\"text-color\";s:25:\"var(--ast-global-color-3)\";s:10:\"link-color\";s:7:\"#7dff12\";s:11:\"theme-color\";s:7:\"#7dff12\";s:12:\"link-h-color\";s:25:\"var(--ast-global-color-2)\";s:18:\"heading-base-color\";s:25:\"var(--ast-global-color-2)\";s:12:\"border-color\";s:0:\"\";s:13:\"footer-bg-obj\";a:11:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:4:\"none\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:12:\"footer-color\";s:0:\"\";s:17:\"footer-link-color\";s:0:\"\";s:19:\"footer-link-h-color\";s:0:\"\";s:17:\"footer-adv-bg-obj\";a:11:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:4:\"none\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:21:\"footer-adv-text-color\";s:0:\"\";s:21:\"footer-adv-link-color\";s:0:\"\";s:23:\"footer-adv-link-h-color\";s:0:\"\";s:26:\"footer-adv-wgt-title-color\";s:0:\"\";s:12:\"button-color\";s:25:\"var(--ast-global-color-4)\";s:14:\"button-h-color\";s:25:\"var(--ast-global-color-2)\";s:15:\"button-bg-color\";s:25:\"var(--ast-global-color-0)\";s:17:\"button-bg-h-color\";s:25:\"var(--ast-global-color-5)\";s:27:\"secondary-button-bg-h-color\";s:25:\"var(--ast-global-color-5)\";s:25:\"secondary-button-bg-color\";s:25:\"var(--ast-global-color-0)\";s:22:\"secondary-button-color\";s:0:\"\";s:24:\"secondary-button-h-color\";s:0:\"\";s:20:\"theme-button-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:2:\"16\";s:5:\"right\";s:2:\"24\";s:6:\"bottom\";s:2:\"16\";s:4:\"left\";s:2:\"24\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:30:\"secondary-theme-button-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:20:\"button-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:8;s:5:\"right\";i:8;s:6:\"bottom\";i:8;s:4:\"left\";i:8;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:30:\"secondary-button-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:8;s:5:\"right\";i:8;s:6:\"bottom\";i:8;s:4:\"left\";i:8;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:37:\"theme-button-border-group-border-size\";a:4:{s:3:\"top\";s:1:\"1\";s:5:\"right\";s:1:\"1\";s:6:\"bottom\";s:1:\"1\";s:4:\"left\";s:1:\"1\";}s:47:\"secondary-theme-button-border-group-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:17:\"footer-sml-layout\";s:8:\"disabled\";s:20:\"footer-sml-section-1\";s:6:\"custom\";s:27:\"footer-sml-section-1-credit\";s:72:\"Copyright &copy; [current_year] [site_title] | Powered by [theme_author]\";s:20:\"footer-sml-section-2\";s:0:\"\";s:27:\"footer-sml-section-2-credit\";s:72:\"Copyright &copy; [current_year] [site_title] | Powered by [theme_author]\";s:27:\"footer-sml-dist-equal-align\";b:1;s:18:\"footer-sml-divider\";i:1;s:24:\"footer-sml-divider-color\";s:7:\"#7a7a7a\";s:19:\"footer-layout-width\";s:7:\"content\";s:22:\"ast-header-retina-logo\";s:83:\"https://zaynventures.com/wp-content/uploads/2025/04/ZAYN-Health-Group-120x43-1.webp\";s:17:\"use-logo-svg-icon\";b:0;s:13:\"logo-svg-icon\";a:2:{s:4:\"type\";s:0:\"\";s:5:\"value\";s:0:\"\";}s:23:\"logo-svg-site-title-gap\";a:3:{s:7:\"desktop\";s:1:\"5\";s:6:\"tablet\";s:1:\"5\";s:6:\"mobile\";s:1:\"5\";}s:21:\"ast-header-logo-width\";s:0:\"\";s:32:\"ast-header-responsive-logo-width\";a:3:{s:7:\"desktop\";s:3:\"120\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:3:\"120\";}s:23:\"header-color-site-title\";s:25:\"var(--ast-global-color-2)\";s:25:\"header-color-h-site-title\";s:0:\"\";s:25:\"header-color-site-tagline\";s:0:\"\";s:29:\"display-site-title-responsive\";a:3:{s:7:\"desktop\";b:0;s:6:\"tablet\";b:0;s:6:\"mobile\";b:0;}s:31:\"display-site-tagline-responsive\";a:3:{s:7:\"desktop\";i:0;s:6:\"tablet\";i:0;s:6:\"mobile\";i:0;}s:17:\"logo-title-inline\";i:1;s:19:\"disable-primary-nav\";b:0;s:14:\"header-layouts\";s:20:\"header-main-layout-1\";s:22:\"header-main-rt-section\";s:6:\"button\";s:27:\"header-display-outside-menu\";b:0;s:27:\"header-main-rt-section-html\";s:27:\"<button>Contact Us</button>\";s:34:\"header-main-rt-section-button-text\";s:19:\"Make An Appointment\";s:34:\"header-main-rt-section-button-link\";s:23:\"https://www.wpastra.com\";s:41:\"header-main-rt-section-button-link-option\";a:3:{s:3:\"url\";s:1:\"#\";s:7:\"new_tab\";s:0:\"\";s:8:\"link_rel\";s:0:\"\";}s:35:\"header-main-rt-section-button-style\";s:12:\"theme-button\";s:40:\"header-main-rt-section-button-text-color\";s:0:\"\";s:40:\"header-main-rt-section-button-back-color\";s:0:\"\";s:42:\"header-main-rt-section-button-text-h-color\";s:0:\"\";s:42:\"header-main-rt-section-button-back-h-color\";s:0:\"\";s:37:\"header-main-rt-section-button-padding\";a:3:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}}s:41:\"header-main-rt-section-button-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:15:\"header-main-sep\";i:1;s:21:\"header-main-sep-color\";s:0:\"\";s:24:\"header-main-layout-width\";s:7:\"content\";s:22:\"primary-submenu-border\";a:4:{s:3:\"top\";s:1:\"2\";s:5:\"right\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";}s:27:\"primary-submenu-item-border\";b:0;s:23:\"primary-submenu-b-color\";s:0:\"\";s:28:\"primary-submenu-item-b-color\";s:0:\"\";s:33:\"primary-header-button-font-family\";s:7:\"inherit\";s:33:\"primary-header-button-font-weight\";s:7:\"inherit\";s:31:\"primary-header-button-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:36:\"primary-header-button-text-transform\";s:0:\"\";s:33:\"primary-header-button-line-height\";i:1;s:36:\"primary-header-button-letter-spacing\";s:0:\"\";s:22:\"header-main-menu-label\";s:0:\"\";s:22:\"header-main-menu-align\";s:6:\"inline\";s:39:\"header-main-submenu-container-animation\";s:4:\"fade\";s:24:\"mobile-header-breakpoint\";s:0:\"\";s:18:\"mobile-header-logo\";s:0:\"\";s:24:\"mobile-header-logo-width\";s:0:\"\";s:11:\"site-layout\";s:21:\"ast-full-width-layout\";s:18:\"site-content-width\";i:1200;s:26:\"narrow-container-max-width\";i:750;s:37:\"site-layout-outside-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:11:{s:16:\"background-color\";s:25:\"var(--ast-global-color-4)\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:5:\"color\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:11:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:11:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:25:\"content-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:11:{s:16:\"background-color\";s:25:\"var(--ast-global-color-5)\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:5:\"color\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:11:{s:16:\"background-color\";s:18:\"rgba(40,189,135,0)\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:5:\"color\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:11:{s:16:\"background-color\";s:18:\"rgba(40,189,135,0)\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:5:\"color\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:12:\"wp-blocks-ui\";s:7:\"comfort\";s:24:\"wp-blocks-global-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"em\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"em\";}s:20:\"enable-comments-area\";b:1;s:22:\"comments-box-placement\";s:0:\"\";s:21:\"comment-form-position\";s:5:\"below\";s:28:\"comments-box-container-width\";s:0:\"\";s:31:\"ast-sub-section-comments-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"em\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"em\";}s:32:\"ast-sub-section-comments-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";i:3;s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"em\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"em\";}s:30:\"single-page-ast-content-layout\";s:22:\"normal-width-container\";s:25:\"single-page-content-style\";s:5:\"boxed\";s:25:\"single-post-content-style\";s:7:\"default\";s:31:\"archive-post-ast-content-layout\";s:7:\"default\";s:23:\"ast-site-content-layout\";s:22:\"normal-width-container\";s:18:\"site-content-style\";s:5:\"boxed\";s:16:\"body-font-family\";s:23:\"\'Open Sans\', sans-serif\";s:17:\"body-font-variant\";s:3:\"400\";s:16:\"body-font-weight\";s:3:\"400\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";s:2:\"16\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:20:\"headings-font-extras\";a:6:{s:11:\"line-height\";s:3:\"1.1\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:10:\"capitalize\";s:15:\"text-decoration\";s:0:\"\";}s:18:\"para-margin-bottom\";s:1:\"1\";s:23:\"underline-content-links\";b:0;s:25:\"site-accessibility-toggle\";b:1;s:33:\"site-accessibility-highlight-type\";s:6:\"dotted\";s:39:\"site-accessibility-highlight-input-type\";s:7:\"disable\";s:19:\"body-text-transform\";s:0:\"\";s:20:\"headings-font-family\";s:19:\"\'Rubik\', sans-serif\";s:20:\"headings-font-weight\";s:3:\"500\";s:20:\"font-size-site-title\";a:6:{s:7:\"desktop\";i:35;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:22:\"font-size-site-tagline\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"single-post-outside-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:20:\"font-size-page-title\";a:6:{s:7:\"desktop\";i:40;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:18:\"font-size-post-tax\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"font-size-post-meta\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:12:\"font-size-h1\";a:6:{s:7:\"desktop\";s:2:\"72\";s:6:\"tablet\";s:2:\"40\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:12:\"font-size-h2\";a:6:{s:7:\"desktop\";s:2:\"48\";s:6:\"tablet\";s:2:\"32\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:12:\"font-size-h3\";a:6:{s:7:\"desktop\";s:2:\"24\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:12:\"font-size-h4\";a:6:{s:7:\"desktop\";i:20;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:12:\"font-size-h5\";a:6:{s:7:\"desktop\";s:2:\"16\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:12:\"font-size-h6\";a:6:{s:7:\"desktop\";s:2:\"14\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"site-sidebar-layout\";s:10:\"no-sidebar\";s:18:\"site-sidebar-width\";i:30;s:26:\"single-page-sidebar-layout\";s:7:\"default\";s:26:\"single-post-sidebar-layout\";s:7:\"default\";s:27:\"archive-post-sidebar-layout\";s:7:\"default\";s:19:\"site-sticky-sidebar\";b:0;s:18:\"site-sidebar-style\";s:5:\"boxed\";s:25:\"single-page-sidebar-style\";s:5:\"boxed\";s:26:\"archive-post-sidebar-style\";s:7:\"default\";s:10:\"footer-adv\";s:8:\"disabled\";s:23:\"footer-adv-border-width\";s:0:\"\";s:23:\"footer-adv-border-color\";s:7:\"#7a7a7a\";s:30:\"mobile-header-toggle-btn-style\";s:7:\"minimal\";s:23:\"hide-custom-menu-mobile\";i:1;s:27:\"mobile-header-toggle-target\";s:4:\"icon\";s:19:\"enable-scroll-to-id\";b:0;s:37:\"ast-dynamic-single-download-structure\";a:3:{i:0;s:33:\"ast-dynamic-single-download-title\";i:1;s:32:\"ast-dynamic-single-download-meta\";i:2;s:33:\"ast-dynamic-single-download-image\";}s:20:\"enable-related-posts\";b:0;s:19:\"related-posts-title\";s:13:\"Related Posts\";s:29:\"releted-posts-title-alignment\";s:4:\"left\";s:25:\"related-posts-total-count\";i:2;s:28:\"enable-related-posts-excerpt\";b:0;s:27:\"related-posts-box-placement\";s:7:\"default\";s:30:\"related-posts-outside-location\";s:5:\"above\";s:29:\"related-posts-container-width\";s:8:\"fallback\";s:27:\"related-posts-excerpt-count\";i:25;s:22:\"related-posts-based-on\";s:10:\"categories\";s:22:\"related-posts-order-by\";s:4:\"date\";s:19:\"related-posts-order\";s:3:\"asc\";s:29:\"related-posts-grid-responsive\";a:3:{s:7:\"desktop\";s:7:\"2-equal\";s:6:\"tablet\";s:7:\"2-equal\";s:6:\"mobile\";s:4:\"full\";}s:23:\"related-posts-structure\";a:2:{i:0;s:14:\"featured-image\";i:1;s:10:\"title-meta\";}s:23:\"related-posts-tag-style\";s:4:\"none\";s:28:\"related-posts-category-style\";s:4:\"none\";s:25:\"related-posts-date-format\";s:0:\"\";s:28:\"related-posts-meta-date-type\";s:9:\"published\";s:32:\"related-posts-author-avatar-size\";s:0:\"\";s:27:\"related-posts-author-avatar\";b:0;s:33:\"related-posts-author-prefix-label\";s:3:\"By \";s:24:\"related-posts-image-size\";s:0:\"\";s:38:\"related-posts-image-custom-scale-width\";i:16;s:39:\"related-posts-image-custom-scale-height\";i:9;s:35:\"related-posts-image-ratio-pre-scale\";s:4:\"16/9\";s:30:\"related-posts-image-ratio-type\";s:0:\"\";s:28:\"related-posts-meta-structure\";a:3:{i:0;s:8:\"comments\";i:1;s:8:\"category\";i:2;s:6:\"author\";}s:24:\"related-posts-text-color\";s:0:\"\";s:24:\"related-posts-link-color\";s:0:\"\";s:25:\"related-posts-title-color\";s:0:\"\";s:30:\"related-posts-background-color\";s:0:\"\";s:24:\"related-posts-meta-color\";s:0:\"\";s:30:\"related-posts-link-hover-color\";s:0:\"\";s:35:\"related-posts-meta-link-hover-color\";s:0:\"\";s:39:\"related-posts-section-title-font-family\";s:7:\"inherit\";s:39:\"related-posts-section-title-font-weight\";s:7:\"inherit\";s:42:\"related-posts-section-title-text-transform\";s:0:\"\";s:39:\"related-posts-section-title-line-height\";s:0:\"\";s:39:\"related-posts-section-title-font-extras\";a:6:{s:11:\"line-height\";s:3:\"1.6\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:37:\"related-posts-section-title-font-size\";a:6:{s:7:\"desktop\";s:2:\"30\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"related-posts-title-font-family\";s:7:\"inherit\";s:31:\"related-posts-title-font-weight\";s:7:\"inherit\";s:34:\"related-posts-title-text-transform\";s:0:\"\";s:31:\"related-posts-title-line-height\";s:1:\"1\";s:29:\"related-posts-title-font-size\";a:6:{s:7:\"desktop\";s:2:\"20\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"related-posts-title-font-extras\";a:6:{s:11:\"line-height\";s:1:\"1\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:30:\"related-posts-meta-font-family\";s:7:\"inherit\";s:30:\"related-posts-meta-font-weight\";s:7:\"inherit\";s:33:\"related-posts-meta-text-transform\";s:0:\"\";s:30:\"related-posts-meta-line-height\";s:0:\"\";s:28:\"related-posts-meta-font-size\";a:6:{s:7:\"desktop\";s:2:\"14\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:30:\"related-posts-meta-font-extras\";a:6:{s:11:\"line-height\";s:3:\"1.6\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"related-posts-content-font-family\";s:7:\"inherit\";s:33:\"related-posts-content-font-weight\";s:7:\"inherit\";s:33:\"related-posts-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:31:\"related-posts-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:37:\"ast-sub-section-related-posts-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";d:2.5;s:5:\"right\";d:2.5;s:6:\"bottom\";d:2.5;s:4:\"left\";d:2.5;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"em\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"em\";}s:36:\"ast-sub-section-related-posts-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:2;s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"em\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"em\";}s:23:\"transparent-header-logo\";s:0:\"\";s:30:\"transparent-header-retina-logo\";s:83:\"https://zaynventures.com/wp-content/uploads/2025/04/ZAYN-Health-Group-120x43-1.webp\";s:26:\"different-transparent-logo\";i:0;s:33:\"different-transparent-retina-logo\";b:0;s:29:\"transparent-header-logo-width\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"transparent-header-enable\";i:0;s:34:\"transparent-header-disable-archive\";i:1;s:45:\"transparent-header-disable-latest-posts-index\";i:1;s:29:\"transparent-header-on-devices\";s:6:\"mobile\";s:27:\"transparent-header-main-sep\";i:0;s:33:\"transparent-header-main-sep-color\";s:0:\"\";s:27:\"transparent-header-bg-color\";s:0:\"\";s:35:\"transparent-header-color-site-title\";s:0:\"\";s:37:\"transparent-header-color-h-site-title\";s:0:\"\";s:25:\"transparent-menu-bg-color\";s:0:\"\";s:22:\"transparent-menu-color\";s:0:\"\";s:24:\"transparent-menu-h-color\";s:0:\"\";s:28:\"transparent-submenu-bg-color\";s:0:\"\";s:25:\"transparent-submenu-color\";s:0:\"\";s:27:\"transparent-submenu-h-color\";s:0:\"\";s:29:\"transparent-header-logo-color\";s:0:\"\";s:38:\"transparent-header-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:42:\"hba-transparent-header-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:42:\"hbb-transparent-header-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:46:\"transparent-header-color-site-title-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:48:\"transparent-header-color-h-site-title-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:36:\"transparent-menu-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:25:\"var(--ast-global-color-4)\";s:6:\"mobile\";s:0:\"\";}s:33:\"transparent-menu-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-3)\";s:6:\"tablet\";s:25:\"var(--ast-global-color-3)\";s:6:\"mobile\";s:0:\"\";}s:35:\"transparent-menu-h-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-2)\";s:6:\"tablet\";s:25:\"var(--ast-global-color-0)\";s:6:\"mobile\";s:0:\"\";}s:39:\"transparent-submenu-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:36:\"transparent-submenu-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:38:\"transparent-submenu-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:49:\"transparent-content-section-text-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:49:\"transparent-content-section-link-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:51:\"transparent-content-section-link-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:32:\"breadcrumb-text-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"breadcrumb-active-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"breadcrumb-hover-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"breadcrumb-separator-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:19:\"breadcrumb-bg-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:18:\"breadcrumb-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:22:\"breadcrumb-font-family\";s:7:\"inherit\";s:22:\"breadcrumb-font-weight\";s:7:\"inherit\";s:20:\"breadcrumb-font-size\";s:0:\"\";s:22:\"breadcrumb-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:29:\"breadcrumb-separator-selector\";s:7:\"unicode\";s:20:\"breadcrumb-separator\";s:4:\"\00bb\";s:20:\"scroll-to-top-enable\";b:0;s:23:\"scroll-to-top-icon-size\";i:15;s:27:\"scroll-to-top-icon-position\";s:5:\"right\";s:24:\"scroll-to-top-on-devices\";s:4:\"both\";s:32:\"scroll-to-top-icon-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"scroll-to-top-icon-color\";s:0:\"\";s:26:\"scroll-to-top-icon-h-color\";s:0:\"\";s:27:\"scroll-to-top-icon-bg-color\";s:0:\"\";s:29:\"scroll-to-top-icon-h-bg-color\";s:0:\"\";s:8:\"h1-color\";s:0:\"\";s:8:\"h2-color\";s:0:\"\";s:8:\"h3-color\";s:0:\"\";s:8:\"h4-color\";s:0:\"\";s:8:\"h5-color\";s:0:\"\";s:8:\"h6-color\";s:0:\"\";s:14:\"font-family-h1\";s:7:\"inherit\";s:14:\"font-weight-h1\";s:7:\"inherit\";s:14:\"font-extras-h1\";a:2:{s:11:\"line-height\";s:3:\"1.4\";s:16:\"line-height-unit\";s:2:\"em\";}s:14:\"font-family-h2\";s:7:\"inherit\";s:14:\"font-weight-h2\";s:7:\"inherit\";s:14:\"font-extras-h2\";a:2:{s:11:\"line-height\";s:3:\"1.3\";s:16:\"line-height-unit\";s:2:\"em\";}s:14:\"font-family-h3\";s:7:\"inherit\";s:14:\"font-weight-h3\";s:7:\"inherit\";s:14:\"font-extras-h3\";a:2:{s:11:\"line-height\";s:3:\"1.3\";s:16:\"line-height-unit\";s:2:\"em\";}s:14:\"font-family-h4\";s:7:\"inherit\";s:14:\"font-weight-h4\";s:7:\"inherit\";s:14:\"font-extras-h4\";a:2:{s:11:\"line-height\";s:3:\"1.2\";s:16:\"line-height-unit\";s:2:\"em\";}s:14:\"font-family-h5\";s:7:\"inherit\";s:14:\"font-weight-h5\";s:7:\"inherit\";s:14:\"font-extras-h5\";a:2:{s:11:\"line-height\";s:3:\"1.2\";s:16:\"line-height-unit\";s:2:\"em\";}s:14:\"font-family-h6\";s:7:\"inherit\";s:14:\"font-weight-h6\";s:7:\"inherit\";s:14:\"font-extras-h6\";a:2:{s:11:\"line-height\";s:4:\"1.25\";s:16:\"line-height-unit\";s:2:\"em\";}s:18:\"font-weight-button\";s:3:\"500\";s:28:\"secondary-font-weight-button\";s:3:\"500\";s:18:\"font-family-button\";s:7:\"inherit\";s:28:\"secondary-font-family-button\";s:7:\"inherit\";s:16:\"font-size-button\";a:6:{s:7:\"desktop\";s:2:\"14\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"secondary-font-size-button\";a:6:{s:7:\"desktop\";s:2:\"14\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:18:\"font-extras-button\";a:6:{s:11:\"line-height\";i:1;s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:28:\"secondary-font-extras-button\";a:6:{s:11:\"line-height\";i:1;s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:20:\"header-desktop-items\";a:5:{s:5:\"popup\";a:1:{s:13:\"popup_content\";a:1:{i:0;s:11:\"mobile-menu\";}}s:5:\"above\";a:5:{s:10:\"above_left\";a:0:{}s:17:\"above_left_center\";a:0:{}s:12:\"above_center\";a:0:{}s:18:\"above_right_center\";a:0:{}s:11:\"above_right\";a:0:{}}s:7:\"primary\";a:5:{s:12:\"primary_left\";a:2:{i:0;s:4:\"logo\";i:1;s:6:\"menu-1\";}s:19:\"primary_left_center\";a:0:{}s:14:\"primary_center\";a:0:{}s:20:\"primary_right_center\";a:0:{}s:13:\"primary_right\";a:1:{i:0;s:8:\"button-1\";}}s:5:\"below\";a:5:{s:10:\"below_left\";a:0:{}s:17:\"below_left_center\";a:0:{}s:12:\"below_center\";a:0:{}s:18:\"below_right_center\";a:0:{}s:11:\"below_right\";a:0:{}}s:4:\"flag\";b:0;}s:19:\"header-mobile-items\";a:5:{s:5:\"popup\";a:1:{s:13:\"popup_content\";a:3:{i:0;s:11:\"mobile-menu\";i:1;s:6:\"html-1\";i:2;s:8:\"button-1\";}}s:5:\"above\";a:3:{s:10:\"above_left\";a:0:{}s:12:\"above_center\";a:0:{}s:11:\"above_right\";a:0:{}}s:7:\"primary\";a:3:{s:12:\"primary_left\";a:1:{i:0;s:4:\"logo\";}s:14:\"primary_center\";a:0:{}s:13:\"primary_right\";a:1:{i:0;s:14:\"mobile-trigger\";}}s:5:\"below\";a:3:{s:10:\"below_left\";a:0:{}s:12:\"below_center\";a:0:{}s:11:\"below_right\";a:0:{}}s:4:\"flag\";b:1;}s:27:\"hb-header-main-layout-width\";s:7:\"content\";s:16:\"hb-header-height\";a:3:{s:7:\"desktop\";i:80;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:8:\"hb-stack\";a:3:{s:7:\"desktop\";s:5:\"stack\";s:6:\"tablet\";s:5:\"stack\";s:6:\"mobile\";s:5:\"stack\";}s:18:\"hb-header-main-sep\";i:0;s:24:\"hb-header-main-sep-color\";s:0:\"\";s:25:\"hb-header-main-menu-align\";s:6:\"inline\";s:27:\"hb-header-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:7:\"#ffffff\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:5:\"color\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:9:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:9:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:17:\"hb-header-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:3:\"1.5\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:3:\"1.5\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:1:\"1\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:1:\"1\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"em\";}s:17:\"hba-header-layout\";s:21:\"above-header-layout-1\";s:17:\"hba-header-height\";a:3:{s:7:\"desktop\";i:50;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:9:\"hba-stack\";a:3:{s:7:\"desktop\";s:5:\"stack\";s:6:\"tablet\";s:5:\"stack\";s:6:\"mobile\";s:5:\"stack\";}s:20:\"hba-header-separator\";i:1;s:30:\"hba-header-bottom-border-color\";s:65:\"var( --ast-global-color-subtle-background, --ast-global-color-7 )\";s:28:\"hba-header-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:55:\"var( --ast-global-color-primary, --ast-global-color-4 )\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:32:\"hba-header-text-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:32:\"hba-header-link-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"hba-header-link-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:18:\"hba-header-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:1:\"0\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:3:\"0.5\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"em\";}s:17:\"hbb-header-layout\";s:21:\"below-header-layout-1\";s:17:\"hbb-header-height\";a:3:{s:7:\"desktop\";i:60;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:9:\"hbb-stack\";a:3:{s:7:\"desktop\";s:5:\"stack\";s:6:\"tablet\";s:5:\"stack\";s:6:\"mobile\";s:5:\"stack\";}s:20:\"hbb-header-separator\";i:1;s:30:\"hbb-header-bottom-border-color\";s:65:\"var( --ast-global-color-subtle-background, --ast-global-color-7 )\";s:28:\"hbb-header-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:7:\"#eeeeee\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:18:\"hbb-header-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:1:\"1\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:1:\"1\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"px\";}s:37:\"section-footer-builder-layout-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:36:\"section-footer-builder-layout-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:36:\"section-above-header-builder-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"section-above-header-builder-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:36:\"section-below-header-builder-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"section-below-header-builder-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:36:\"section-header-mobile-trigger-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:38:\"section-primary-header-builder-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:37:\"section-primary-header-builder-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:20:\"title_tagline-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"section-header-search-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-account-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"header-mobile-menu-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:33:\"section-header-mobile-menu-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:36:\"section-above-footer-builder-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"section-above-footer-builder-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"section-below-footer-builder-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"section-footer-copyright-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-footer-menu-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:38:\"section-primary-footer-builder-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:2:\"50\";s:5:\"right\";s:2:\"30\";s:6:\"bottom\";s:2:\"50\";s:4:\"left\";s:2:\"30\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:37:\"section-primary-footer-builder-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"section-header-woo-cart-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:30:\"section-header-woo-cart-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button1-text\";s:10:\"Contact Us\";s:26:\"header-button1-link-option\";a:3:{s:3:\"url\";s:1:\"#\";s:7:\"new_tab\";s:0:\"\";s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button1-font-family\";s:21:\"\'Poppins\', sans-serif\";s:26:\"header-button1-font-weight\";s:3:\"400\";s:26:\"header-button1-font-extras\";a:6:{s:11:\"line-height\";i:1;s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"header-button1-font-size\";a:6:{s:7:\"desktop\";i:14;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button1-text-color\";a:3:{s:7:\"desktop\";s:7:\"#ffffff\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button1-back-color\";a:3:{s:7:\"desktop\";s:7:\"#86f905\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button1-text-h-color\";a:3:{s:7:\"desktop\";s:7:\"#86f905\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button1-back-h-color\";a:3:{s:7:\"desktop\";s:7:\"#fffefe\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button1-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button1-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"header-button1-border-color\";a:3:{s:7:\"desktop\";s:7:\"#86f905\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"header-button1-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-button1-border-radius\";s:0:\"\";s:27:\"section-hb-button-1-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:2:\"15\";s:5:\"right\";s:2:\"25\";s:6:\"bottom\";s:2:\"15\";s:4:\"left\";s:2:\"25\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-hb-button-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button1-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button1-text\";s:6:\"Button\";s:26:\"footer-button1-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button1-font-family\";s:7:\"inherit\";s:26:\"footer-button1-font-weight\";s:7:\"inherit\";s:29:\"footer-button1-text-transform\";s:0:\"\";s:26:\"footer-button1-line-height\";s:0:\"\";s:24:\"footer-button1-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button1-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button1-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button1-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button1-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button1-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button1-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button1-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"footer-button1-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button-1-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-1-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-1\";s:0:\"\";s:18:\"header-html-1color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-1link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-1link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-1\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-1\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-1\";s:7:\"inherit\";s:29:\"font-extras-section-hb-html-1\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-hb-html-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-1\";s:359:\"<p style=\"text-align: left;\"><img class=\"alignnone wp-image-11\" src=\"https://websitedemos.net/diagnostics-lab-02/wp-content/uploads/sites/662/2020/08/diagnostic-lab-logo.png\" alt=\"\" width=\"185\" height=\"46\" /></p>\n<p style=\"text-align: left;\">Urna aliquet feugiat odio enim ut pharetra pretium velit viverra elementum pulvinar viverra diam urna rhoncus eu.</p>\";s:18:\"footer-html-1color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-1link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-1link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-1\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-1-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-1\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-1\";s:7:\"inherit\";s:29:\"font-extras-section-fb-html-1\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-fb-html-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-1-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-1-bg-space\";s:0:\"\";s:20:\"header-social-1-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"header-social-1-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-1-color\";s:0:\"\";s:23:\"header-social-1-h-color\";s:0:\"\";s:24:\"header-social-1-bg-color\";s:0:\"\";s:26:\"header-social-1-bg-h-color\";s:0:\"\";s:28:\"header-social-1-label-toggle\";b:0;s:26:\"header-social-1-color-type\";s:6:\"custom\";s:34:\"header-social-1-brand-hover-toggle\";b:0;s:35:\"font-size-section-hb-social-icons-1\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-1\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-1-space\";a:3:{s:7:\"desktop\";s:1:\"0\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-1-bg-space\";s:1:\"6\";s:20:\"footer-social-1-size\";a:3:{s:7:\"desktop\";i:25;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-1-radius\";s:0:\"\";s:21:\"footer-social-1-color\";a:1:{s:7:\"desktop\";s:7:\"#7dff12\";}s:23:\"footer-social-1-h-color\";s:0:\"\";s:24:\"footer-social-1-bg-color\";s:0:\"\";s:26:\"footer-social-1-bg-h-color\";s:0:\"\";s:28:\"footer-social-1-label-toggle\";b:0;s:26:\"footer-social-1-color-type\";s:6:\"custom\";s:27:\"footer-social-1-brand-color\";s:0:\"\";s:33:\"footer-social-1-brand-label-color\";s:0:\"\";s:34:\"footer-social-1-brand-hover-toggle\";b:0;s:35:\"font-size-section-fb-social-icons-1\";a:6:{s:7:\"desktop\";s:2:\"14\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-1\";a:2:{s:5:\"items\";a:5:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:1:\"#\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:1:\"#\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:1:\"#\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}i:3;a:7:{s:2:\"id\";s:7:\"youtube\";s:7:\"enabled\";b:1;s:3:\"url\";s:1:\"#\";s:5:\"color\";s:7:\"#e96651\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"youtube\";s:5:\"label\";s:7:\"YouTube\";}i:4;a:7:{s:2:\"id\";s:8:\"linkedin\";s:7:\"enabled\";b:1;s:3:\"url\";s:1:\"#\";s:5:\"color\";s:7:\"#1c86c6\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"linkedin\";s:5:\"label\";s:8:\"Linkedin\";}}s:4:\"flag\";b:0;}s:25:\"footer-social-1-alignment\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:4:\"left\";s:6:\"mobile\";s:4:\"left\";}s:32:\"section-fb-social-icons-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-1-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-1-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-1-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-1-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-1-font-family\";s:7:\"inherit\";s:27:\"header-widget-1-font-weight\";s:7:\"inherit\";s:25:\"header-widget-1-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-1-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:35:\"header-widget-1-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-1-content-font-weight\";s:7:\"inherit\";s:33:\"header-widget-1-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-1-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:38:\"sidebar-widgets-header-widget-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-1-title-color\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-2)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-1-color\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-3)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-1-link-color\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-3)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-1-link-h-color\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-5)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-1-font-family\";s:7:\"inherit\";s:27:\"footer-widget-1-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-1-text-transform\";s:0:\"\";s:27:\"footer-widget-1-line-height\";s:0:\"\";s:25:\"footer-widget-1-font-size\";a:6:{s:7:\"desktop\";s:2:\"20\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-1-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-1-content-font-weight\";s:7:\"inherit\";s:35:\"footer-widget-1-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"footer-widget-1-content-font-size\";a:6:{s:7:\"desktop\";s:2:\"15\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-1\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:4:\"left\";s:6:\"mobile\";s:4:\"left\";}s:38:\"sidebar-widgets-footer-widget-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:1:\"0\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu1-bg-color\";s:0:\"\";s:18:\"header-menu1-color\";s:0:\"\";s:23:\"header-menu1-h-bg-color\";s:0:\"\";s:20:\"header-menu1-h-color\";s:0:\"\";s:23:\"header-menu1-a-bg-color\";s:0:\"\";s:20:\"header-menu1-a-color\";s:0:\"\";s:30:\"header-menu1-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:9:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:25:\"var(--ast-global-color-5)\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:5:\"color\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:9:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:29:\"header-menu1-color-responsive\";a:3:{s:7:\"desktop\";s:7:\"#000000\";s:6:\"tablet\";s:25:\"var(--ast-global-color-2)\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu1-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu1-h-color-responsive\";a:3:{s:7:\"desktop\";s:7:\"#86fa04\";s:6:\"tablet\";s:25:\"var(--ast-global-color-0)\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu1-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu1-a-color-responsive\";a:3:{s:7:\"desktop\";s:7:\"#86fa04\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu1-menu-hover-animation\";s:9:\"underline\";s:40:\"header-menu1-submenu-container-animation\";s:4:\"fade\";s:24:\"section-hb-menu-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu1-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu1-submenu-item-border\";b:0;s:32:\"header-menu1-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu1-submenu-item-b-color\";s:0:\"\";s:41:\"header-menu1-submenu-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"header-menu1-submenu-top-offset\";s:0:\"\";s:26:\"header-menu1-submenu-width\";s:0:\"\";s:27:\"header-menu1-submenu-border\";a:4:{s:3:\"top\";s:1:\"2\";s:5:\"right\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";}s:33:\"header-menu1-menu-stack-on-mobile\";b:1;s:22:\"header-menu1-font-size\";a:6:{s:7:\"desktop\";i:14;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu1-font-weight\";s:3:\"300\";s:24:\"header-menu1-font-family\";s:21:\"\'Poppins\', sans-serif\";s:24:\"header-menu1-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:27:\"section-hb-divider-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button2-text\";s:6:\"Button\";s:26:\"header-button2-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button2-font-family\";s:7:\"inherit\";s:26:\"header-button2-font-weight\";s:7:\"inherit\";s:26:\"header-button2-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"header-button2-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button2-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button2-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button2-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button2-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button2-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button2-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"header-button2-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"header-button2-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-button2-border-radius\";s:0:\"\";s:27:\"section-hb-button-2-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-hb-button-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button2-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button2-text\";s:6:\"Button\";s:26:\"footer-button2-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button2-font-family\";s:7:\"inherit\";s:26:\"footer-button2-font-weight\";s:7:\"inherit\";s:29:\"footer-button2-text-transform\";s:0:\"\";s:26:\"footer-button2-line-height\";s:0:\"\";s:24:\"footer-button2-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button2-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button2-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button2-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button2-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button2-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button2-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button2-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"footer-button2-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button-2-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-2-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-2\";s:22:\"Insert HTML text here.\";s:18:\"header-html-2color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-2link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-2link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-2\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-2\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-2\";s:7:\"inherit\";s:29:\"font-extras-section-hb-html-2\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-hb-html-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-2\";s:22:\"Insert HTML text here.\";s:18:\"footer-html-2color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-2link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-2link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-2\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-2-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-2\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-2\";s:7:\"inherit\";s:29:\"font-extras-section-fb-html-2\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-fb-html-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-2-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-2-bg-space\";s:0:\"\";s:20:\"header-social-2-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"header-social-2-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-2-color\";s:0:\"\";s:23:\"header-social-2-h-color\";s:0:\"\";s:24:\"header-social-2-bg-color\";s:0:\"\";s:26:\"header-social-2-bg-h-color\";s:0:\"\";s:28:\"header-social-2-label-toggle\";b:0;s:26:\"header-social-2-color-type\";s:6:\"custom\";s:34:\"header-social-2-brand-hover-toggle\";b:0;s:35:\"font-size-section-hb-social-icons-2\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-2\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-2-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-2-bg-space\";s:0:\"\";s:20:\"footer-social-2-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-2-radius\";s:0:\"\";s:21:\"footer-social-2-color\";s:0:\"\";s:23:\"footer-social-2-h-color\";s:0:\"\";s:24:\"footer-social-2-bg-color\";s:0:\"\";s:26:\"footer-social-2-bg-h-color\";s:0:\"\";s:28:\"footer-social-2-label-toggle\";b:0;s:26:\"footer-social-2-color-type\";s:6:\"custom\";s:27:\"footer-social-2-brand-color\";s:0:\"\";s:33:\"footer-social-2-brand-label-color\";s:0:\"\";s:34:\"footer-social-2-brand-hover-toggle\";b:0;s:35:\"font-size-section-fb-social-icons-2\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-2\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:25:\"footer-social-2-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:32:\"section-fb-social-icons-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-2-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-2-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-2-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-2-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-2-font-family\";s:7:\"inherit\";s:27:\"header-widget-2-font-weight\";s:7:\"inherit\";s:25:\"header-widget-2-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-2-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:35:\"header-widget-2-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-2-content-font-weight\";s:7:\"inherit\";s:33:\"header-widget-2-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-2-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:38:\"sidebar-widgets-header-widget-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-2-title-color\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-2)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-2-color\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-3)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-2-link-color\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-3)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-2-link-h-color\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-2-font-family\";s:7:\"inherit\";s:27:\"footer-widget-2-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-2-text-transform\";s:0:\"\";s:27:\"footer-widget-2-line-height\";s:0:\"\";s:25:\"footer-widget-2-font-size\";a:6:{s:7:\"desktop\";s:2:\"20\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-2-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-2-content-font-weight\";s:7:\"inherit\";s:35:\"footer-widget-2-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"footer-widget-2-content-font-size\";a:6:{s:7:\"desktop\";s:2:\"16\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-2\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:4:\"left\";s:6:\"mobile\";s:4:\"left\";}s:38:\"sidebar-widgets-footer-widget-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu2-bg-color\";s:0:\"\";s:18:\"header-menu2-color\";s:0:\"\";s:23:\"header-menu2-h-bg-color\";s:0:\"\";s:20:\"header-menu2-h-color\";s:0:\"\";s:23:\"header-menu2-a-bg-color\";s:0:\"\";s:20:\"header-menu2-a-color\";s:0:\"\";s:30:\"header-menu2-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:29:\"header-menu2-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu2-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu2-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu2-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu2-a-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu2-menu-hover-animation\";s:0:\"\";s:40:\"header-menu2-submenu-container-animation\";s:0:\"\";s:24:\"section-hb-menu-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu2-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu2-submenu-item-border\";b:0;s:32:\"header-menu2-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu2-submenu-item-b-color\";s:7:\"#eaeaea\";s:41:\"header-menu2-submenu-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"header-menu2-submenu-top-offset\";s:0:\"\";s:26:\"header-menu2-submenu-width\";s:0:\"\";s:27:\"header-menu2-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:33:\"header-menu2-menu-stack-on-mobile\";b:1;s:22:\"header-menu2-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu2-font-weight\";s:7:\"inherit\";s:24:\"header-menu2-font-family\";s:7:\"inherit\";s:24:\"header-menu2-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:27:\"section-hb-divider-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button3-text\";s:6:\"Button\";s:26:\"header-button3-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button3-font-family\";s:7:\"inherit\";s:26:\"header-button3-font-weight\";s:7:\"inherit\";s:26:\"header-button3-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"header-button3-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button3-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button3-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button3-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button3-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button3-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button3-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"header-button3-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"header-button3-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-button3-border-radius\";s:0:\"\";s:27:\"section-hb-button-3-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-hb-button-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button3-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button3-text\";s:6:\"Button\";s:26:\"footer-button3-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button3-font-family\";s:7:\"inherit\";s:26:\"footer-button3-font-weight\";s:7:\"inherit\";s:29:\"footer-button3-text-transform\";s:0:\"\";s:26:\"footer-button3-line-height\";s:0:\"\";s:24:\"footer-button3-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button3-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button3-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button3-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button3-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button3-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button3-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button3-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"footer-button3-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button-3-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-3-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-3\";s:22:\"Insert HTML text here.\";s:18:\"header-html-3color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-3link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-3link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-3\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-3\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-3\";s:7:\"inherit\";s:29:\"font-extras-section-hb-html-3\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-hb-html-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-3\";s:22:\"Insert HTML text here.\";s:18:\"footer-html-3color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-3link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-3link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-3\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-3-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-3\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-3\";s:7:\"inherit\";s:29:\"font-extras-section-fb-html-3\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-fb-html-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-3-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-3-bg-space\";s:0:\"\";s:20:\"header-social-3-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"header-social-3-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-3-color\";s:0:\"\";s:23:\"header-social-3-h-color\";s:0:\"\";s:24:\"header-social-3-bg-color\";s:0:\"\";s:26:\"header-social-3-bg-h-color\";s:0:\"\";s:28:\"header-social-3-label-toggle\";b:0;s:26:\"header-social-3-color-type\";s:6:\"custom\";s:34:\"header-social-3-brand-hover-toggle\";b:0;s:35:\"font-size-section-hb-social-icons-3\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-3\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-3-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-3-bg-space\";s:0:\"\";s:20:\"footer-social-3-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-3-radius\";s:0:\"\";s:21:\"footer-social-3-color\";s:0:\"\";s:23:\"footer-social-3-h-color\";s:0:\"\";s:24:\"footer-social-3-bg-color\";s:0:\"\";s:26:\"footer-social-3-bg-h-color\";s:0:\"\";s:28:\"footer-social-3-label-toggle\";b:0;s:26:\"footer-social-3-color-type\";s:6:\"custom\";s:27:\"footer-social-3-brand-color\";s:0:\"\";s:33:\"footer-social-3-brand-label-color\";s:0:\"\";s:34:\"footer-social-3-brand-hover-toggle\";b:0;s:35:\"font-size-section-fb-social-icons-3\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-3\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:25:\"footer-social-3-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:32:\"section-fb-social-icons-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-3-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-3-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-3-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-3-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-3-font-family\";s:7:\"inherit\";s:27:\"header-widget-3-font-weight\";s:7:\"inherit\";s:25:\"header-widget-3-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-3-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:35:\"header-widget-3-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-3-content-font-weight\";s:7:\"inherit\";s:33:\"header-widget-3-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-3-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:38:\"sidebar-widgets-header-widget-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-3-title-color\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-8)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-3-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-3-link-color\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-3)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-3-link-h-color\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-3-font-family\";s:7:\"inherit\";s:27:\"footer-widget-3-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-3-text-transform\";s:0:\"\";s:27:\"footer-widget-3-line-height\";s:0:\"\";s:25:\"footer-widget-3-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-3-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-3-content-font-weight\";s:7:\"inherit\";s:35:\"footer-widget-3-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"footer-widget-3-content-font-size\";a:6:{s:7:\"desktop\";s:2:\"16\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-3\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:4:\"left\";s:6:\"mobile\";s:4:\"left\";}s:38:\"sidebar-widgets-footer-widget-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:2:\"20\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu3-bg-color\";s:0:\"\";s:18:\"header-menu3-color\";s:0:\"\";s:23:\"header-menu3-h-bg-color\";s:0:\"\";s:20:\"header-menu3-h-color\";s:0:\"\";s:23:\"header-menu3-a-bg-color\";s:0:\"\";s:20:\"header-menu3-a-color\";s:0:\"\";s:30:\"header-menu3-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:29:\"header-menu3-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu3-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu3-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu3-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu3-a-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu3-menu-hover-animation\";s:0:\"\";s:40:\"header-menu3-submenu-container-animation\";s:0:\"\";s:24:\"section-hb-menu-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu3-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu3-submenu-item-border\";b:0;s:32:\"header-menu3-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu3-submenu-item-b-color\";s:7:\"#eaeaea\";s:41:\"header-menu3-submenu-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"header-menu3-submenu-top-offset\";s:0:\"\";s:26:\"header-menu3-submenu-width\";s:0:\"\";s:27:\"header-menu3-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:33:\"header-menu3-menu-stack-on-mobile\";b:1;s:22:\"header-menu3-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu3-font-weight\";s:7:\"inherit\";s:24:\"header-menu3-font-family\";s:7:\"inherit\";s:24:\"header-menu3-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:27:\"section-hb-divider-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button4-text\";s:6:\"Button\";s:26:\"header-button4-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button4-font-family\";s:7:\"inherit\";s:26:\"header-button4-font-weight\";s:7:\"inherit\";s:26:\"header-button4-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"header-button4-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button4-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button4-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button4-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button4-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button4-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button4-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"header-button4-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"header-button4-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-button4-border-radius\";s:0:\"\";s:27:\"section-hb-button-4-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-hb-button-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button4-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button4-text\";s:6:\"Button\";s:26:\"footer-button4-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button4-font-family\";s:7:\"inherit\";s:26:\"footer-button4-font-weight\";s:7:\"inherit\";s:29:\"footer-button4-text-transform\";s:0:\"\";s:26:\"footer-button4-line-height\";s:0:\"\";s:24:\"footer-button4-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button4-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button4-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button4-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button4-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button4-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button4-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button4-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"footer-button4-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button-4-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-4-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-4\";s:22:\"Insert HTML text here.\";s:18:\"header-html-4color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-4link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-4link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-4\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-4\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-4\";s:7:\"inherit\";s:29:\"font-extras-section-hb-html-4\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-hb-html-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-4\";s:22:\"Insert HTML text here.\";s:18:\"footer-html-4color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-4link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-4link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-4\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-4-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-4\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-4\";s:7:\"inherit\";s:29:\"font-extras-section-fb-html-4\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-fb-html-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-4-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-4-bg-space\";s:0:\"\";s:20:\"header-social-4-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"header-social-4-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-4-color\";s:0:\"\";s:23:\"header-social-4-h-color\";s:0:\"\";s:24:\"header-social-4-bg-color\";s:0:\"\";s:26:\"header-social-4-bg-h-color\";s:0:\"\";s:28:\"header-social-4-label-toggle\";b:0;s:26:\"header-social-4-color-type\";s:6:\"custom\";s:34:\"header-social-4-brand-hover-toggle\";b:0;s:35:\"font-size-section-hb-social-icons-4\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-4\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-4-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-4-bg-space\";s:0:\"\";s:20:\"footer-social-4-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-4-radius\";s:0:\"\";s:21:\"footer-social-4-color\";s:0:\"\";s:23:\"footer-social-4-h-color\";s:0:\"\";s:24:\"footer-social-4-bg-color\";s:0:\"\";s:26:\"footer-social-4-bg-h-color\";s:0:\"\";s:28:\"footer-social-4-label-toggle\";b:0;s:26:\"footer-social-4-color-type\";s:6:\"custom\";s:27:\"footer-social-4-brand-color\";s:0:\"\";s:33:\"footer-social-4-brand-label-color\";s:0:\"\";s:34:\"footer-social-4-brand-hover-toggle\";b:0;s:35:\"font-size-section-fb-social-icons-4\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-4\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:25:\"footer-social-4-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:32:\"section-fb-social-icons-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-4-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-4-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-4-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-4-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-4-font-family\";s:7:\"inherit\";s:27:\"header-widget-4-font-weight\";s:7:\"inherit\";s:25:\"header-widget-4-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-4-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:35:\"header-widget-4-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-4-content-font-weight\";s:7:\"inherit\";s:33:\"header-widget-4-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-4-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:38:\"sidebar-widgets-header-widget-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-4-title-color\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-8)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-4-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-4-link-color\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-3)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-4-link-h-color\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-4-font-family\";s:7:\"inherit\";s:27:\"footer-widget-4-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-4-text-transform\";s:0:\"\";s:27:\"footer-widget-4-line-height\";s:0:\"\";s:25:\"footer-widget-4-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-4-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-4-content-font-weight\";s:7:\"inherit\";s:35:\"footer-widget-4-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"footer-widget-4-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-4\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:4:\"left\";s:6:\"mobile\";s:4:\"left\";}s:38:\"sidebar-widgets-footer-widget-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu4-bg-color\";s:0:\"\";s:18:\"header-menu4-color\";s:0:\"\";s:23:\"header-menu4-h-bg-color\";s:0:\"\";s:20:\"header-menu4-h-color\";s:0:\"\";s:23:\"header-menu4-a-bg-color\";s:0:\"\";s:20:\"header-menu4-a-color\";s:0:\"\";s:30:\"header-menu4-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:29:\"header-menu4-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu4-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu4-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu4-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu4-a-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu4-menu-hover-animation\";s:0:\"\";s:40:\"header-menu4-submenu-container-animation\";s:0:\"\";s:24:\"section-hb-menu-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu4-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu4-submenu-item-border\";b:0;s:32:\"header-menu4-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu4-submenu-item-b-color\";s:7:\"#eaeaea\";s:41:\"header-menu4-submenu-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"header-menu4-submenu-top-offset\";s:0:\"\";s:26:\"header-menu4-submenu-width\";s:0:\"\";s:27:\"header-menu4-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:33:\"header-menu4-menu-stack-on-mobile\";b:1;s:22:\"header-menu4-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu4-font-weight\";s:7:\"inherit\";s:24:\"header-menu4-font-family\";s:7:\"inherit\";s:24:\"header-menu4-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:27:\"section-hb-divider-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button5-text\";s:6:\"Button\";s:26:\"header-button5-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button5-font-family\";s:7:\"inherit\";s:26:\"header-button5-font-weight\";s:7:\"inherit\";s:26:\"header-button5-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"header-button5-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button5-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button5-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button5-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button5-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button5-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button5-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"header-button5-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"header-button5-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-button5-border-radius\";s:0:\"\";s:27:\"section-hb-button-5-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-hb-button-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button5-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button5-text\";s:6:\"Button\";s:26:\"footer-button5-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button5-font-family\";s:7:\"inherit\";s:26:\"footer-button5-font-weight\";s:7:\"inherit\";s:29:\"footer-button5-text-transform\";s:0:\"\";s:26:\"footer-button5-line-height\";s:0:\"\";s:24:\"footer-button5-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button5-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button5-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button5-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button5-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button5-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button5-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button5-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"footer-button5-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button-5-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-5-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-5\";s:22:\"Insert HTML text here.\";s:18:\"header-html-5color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-5link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-5link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-5\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-5\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-5\";s:7:\"inherit\";s:29:\"font-extras-section-hb-html-5\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-hb-html-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-5\";s:22:\"Insert HTML text here.\";s:18:\"footer-html-5color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-5link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-5link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-5\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-5-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-5\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-5\";s:7:\"inherit\";s:29:\"font-extras-section-fb-html-5\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-fb-html-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-5-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-5-bg-space\";s:0:\"\";s:20:\"header-social-5-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"header-social-5-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-5-color\";s:0:\"\";s:23:\"header-social-5-h-color\";s:0:\"\";s:24:\"header-social-5-bg-color\";s:0:\"\";s:26:\"header-social-5-bg-h-color\";s:0:\"\";s:28:\"header-social-5-label-toggle\";b:0;s:26:\"header-social-5-color-type\";s:6:\"custom\";s:34:\"header-social-5-brand-hover-toggle\";b:0;s:35:\"font-size-section-hb-social-icons-5\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-5\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-5-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-5-bg-space\";s:0:\"\";s:20:\"footer-social-5-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-5-radius\";s:0:\"\";s:21:\"footer-social-5-color\";s:0:\"\";s:23:\"footer-social-5-h-color\";s:0:\"\";s:24:\"footer-social-5-bg-color\";s:0:\"\";s:26:\"footer-social-5-bg-h-color\";s:0:\"\";s:28:\"footer-social-5-label-toggle\";b:0;s:26:\"footer-social-5-color-type\";s:6:\"custom\";s:27:\"footer-social-5-brand-color\";s:0:\"\";s:33:\"footer-social-5-brand-label-color\";s:0:\"\";s:34:\"footer-social-5-brand-hover-toggle\";b:0;s:35:\"font-size-section-fb-social-icons-5\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-5\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:25:\"footer-social-5-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:32:\"section-fb-social-icons-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-5-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-5-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-5-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-5-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-5-font-family\";s:7:\"inherit\";s:27:\"header-widget-5-font-weight\";s:7:\"inherit\";s:25:\"header-widget-5-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-5-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:35:\"header-widget-5-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-5-content-font-weight\";s:7:\"inherit\";s:33:\"header-widget-5-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-5-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:38:\"sidebar-widgets-header-widget-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-5-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-5-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-5-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-5-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-5-font-family\";s:7:\"inherit\";s:27:\"footer-widget-5-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-5-text-transform\";s:0:\"\";s:27:\"footer-widget-5-line-height\";s:0:\"\";s:25:\"footer-widget-5-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-5-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-5-content-font-weight\";s:7:\"inherit\";s:35:\"footer-widget-5-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"footer-widget-5-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-5\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:38:\"sidebar-widgets-footer-widget-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu5-bg-color\";s:0:\"\";s:18:\"header-menu5-color\";s:0:\"\";s:23:\"header-menu5-h-bg-color\";s:0:\"\";s:20:\"header-menu5-h-color\";s:0:\"\";s:23:\"header-menu5-a-bg-color\";s:0:\"\";s:20:\"header-menu5-a-color\";s:0:\"\";s:30:\"header-menu5-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:29:\"header-menu5-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu5-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu5-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu5-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu5-a-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu5-menu-hover-animation\";s:0:\"\";s:40:\"header-menu5-submenu-container-animation\";s:0:\"\";s:24:\"section-hb-menu-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu5-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu5-submenu-item-border\";b:0;s:32:\"header-menu5-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu5-submenu-item-b-color\";s:7:\"#eaeaea\";s:41:\"header-menu5-submenu-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"header-menu5-submenu-top-offset\";s:0:\"\";s:26:\"header-menu5-submenu-width\";s:0:\"\";s:27:\"header-menu5-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:33:\"header-menu5-menu-stack-on-mobile\";b:1;s:22:\"header-menu5-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu5-font-weight\";s:7:\"inherit\";s:24:\"header-menu5-font-family\";s:7:\"inherit\";s:24:\"header-menu5-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:27:\"section-hb-divider-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button6-text\";s:6:\"Button\";s:26:\"header-button6-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button6-font-family\";s:7:\"inherit\";s:26:\"header-button6-font-weight\";s:7:\"inherit\";s:26:\"header-button6-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"header-button6-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button6-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button6-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button6-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button6-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button6-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button6-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"header-button6-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"header-button6-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-button6-border-radius\";s:0:\"\";s:27:\"section-hb-button-6-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-hb-button-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button6-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button6-text\";s:6:\"Button\";s:26:\"footer-button6-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button6-font-family\";s:7:\"inherit\";s:26:\"footer-button6-font-weight\";s:7:\"inherit\";s:29:\"footer-button6-text-transform\";s:0:\"\";s:26:\"footer-button6-line-height\";s:0:\"\";s:24:\"footer-button6-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button6-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button6-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button6-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button6-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button6-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button6-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button6-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"footer-button6-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button-6-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-6-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-6\";s:22:\"Insert HTML text here.\";s:18:\"header-html-6color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-6link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-6link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-6\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-6\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-6\";s:7:\"inherit\";s:29:\"font-extras-section-hb-html-6\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-hb-html-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-6\";s:22:\"Insert HTML text here.\";s:18:\"footer-html-6color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-6link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-6link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-6\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-6-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-6\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-6\";s:7:\"inherit\";s:29:\"font-extras-section-fb-html-6\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-fb-html-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-6-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-6-bg-space\";s:0:\"\";s:20:\"header-social-6-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"header-social-6-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-6-color\";s:0:\"\";s:23:\"header-social-6-h-color\";s:0:\"\";s:24:\"header-social-6-bg-color\";s:0:\"\";s:26:\"header-social-6-bg-h-color\";s:0:\"\";s:28:\"header-social-6-label-toggle\";b:0;s:26:\"header-social-6-color-type\";s:6:\"custom\";s:34:\"header-social-6-brand-hover-toggle\";b:0;s:35:\"font-size-section-hb-social-icons-6\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-6\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-6-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-6-bg-space\";s:0:\"\";s:20:\"footer-social-6-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-6-radius\";s:0:\"\";s:21:\"footer-social-6-color\";s:0:\"\";s:23:\"footer-social-6-h-color\";s:0:\"\";s:24:\"footer-social-6-bg-color\";s:0:\"\";s:26:\"footer-social-6-bg-h-color\";s:0:\"\";s:28:\"footer-social-6-label-toggle\";b:0;s:26:\"footer-social-6-color-type\";s:6:\"custom\";s:27:\"footer-social-6-brand-color\";s:0:\"\";s:33:\"footer-social-6-brand-label-color\";s:0:\"\";s:34:\"footer-social-6-brand-hover-toggle\";b:0;s:35:\"font-size-section-fb-social-icons-6\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-6\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:25:\"footer-social-6-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:32:\"section-fb-social-icons-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-6-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-6-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-6-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-6-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-6-font-family\";s:7:\"inherit\";s:27:\"header-widget-6-font-weight\";s:7:\"inherit\";s:25:\"header-widget-6-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-6-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:35:\"header-widget-6-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-6-content-font-weight\";s:7:\"inherit\";s:33:\"header-widget-6-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-6-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:38:\"sidebar-widgets-header-widget-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-6-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-6-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-6-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-6-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-6-font-family\";s:7:\"inherit\";s:27:\"footer-widget-6-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-6-text-transform\";s:0:\"\";s:27:\"footer-widget-6-line-height\";s:0:\"\";s:25:\"footer-widget-6-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-6-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-6-content-font-weight\";s:7:\"inherit\";s:35:\"footer-widget-6-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"footer-widget-6-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-6\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:38:\"sidebar-widgets-footer-widget-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu6-bg-color\";s:0:\"\";s:18:\"header-menu6-color\";s:0:\"\";s:23:\"header-menu6-h-bg-color\";s:0:\"\";s:20:\"header-menu6-h-color\";s:0:\"\";s:23:\"header-menu6-a-bg-color\";s:0:\"\";s:20:\"header-menu6-a-color\";s:0:\"\";s:30:\"header-menu6-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:29:\"header-menu6-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu6-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu6-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu6-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu6-a-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu6-menu-hover-animation\";s:0:\"\";s:40:\"header-menu6-submenu-container-animation\";s:0:\"\";s:24:\"section-hb-menu-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu6-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu6-submenu-item-border\";b:0;s:32:\"header-menu6-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu6-submenu-item-b-color\";s:7:\"#eaeaea\";s:41:\"header-menu6-submenu-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"header-menu6-submenu-top-offset\";s:0:\"\";s:26:\"header-menu6-submenu-width\";s:0:\"\";s:27:\"header-menu6-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:33:\"header-menu6-menu-stack-on-mobile\";b:1;s:22:\"header-menu6-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu6-font-weight\";s:7:\"inherit\";s:24:\"header-menu6-font-family\";s:7:\"inherit\";s:24:\"header-menu6-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:27:\"section-hb-divider-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button7-text\";s:6:\"Button\";s:26:\"header-button7-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button7-font-family\";s:7:\"inherit\";s:26:\"header-button7-font-weight\";s:7:\"inherit\";s:26:\"header-button7-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"header-button7-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button7-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button7-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button7-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button7-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button7-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button7-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"header-button7-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"header-button7-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-button7-border-radius\";s:0:\"\";s:27:\"section-hb-button-7-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-hb-button-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button7-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button7-text\";s:6:\"Button\";s:26:\"footer-button7-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button7-font-family\";s:7:\"inherit\";s:26:\"footer-button7-font-weight\";s:7:\"inherit\";s:29:\"footer-button7-text-transform\";s:0:\"\";s:26:\"footer-button7-line-height\";s:0:\"\";s:24:\"footer-button7-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button7-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button7-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button7-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button7-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button7-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button7-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button7-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"footer-button7-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button-7-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-7-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-7\";s:22:\"Insert HTML text here.\";s:18:\"header-html-7color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-7link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-7link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-7\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-7\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-7\";s:7:\"inherit\";s:29:\"font-extras-section-hb-html-7\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-hb-html-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-7\";s:22:\"Insert HTML text here.\";s:18:\"footer-html-7color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-7link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-7link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-7\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-7-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-7\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-7\";s:7:\"inherit\";s:29:\"font-extras-section-fb-html-7\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-fb-html-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-7-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-7-bg-space\";s:0:\"\";s:20:\"header-social-7-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"header-social-7-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-7-color\";s:0:\"\";s:23:\"header-social-7-h-color\";s:0:\"\";s:24:\"header-social-7-bg-color\";s:0:\"\";s:26:\"header-social-7-bg-h-color\";s:0:\"\";s:28:\"header-social-7-label-toggle\";b:0;s:26:\"header-social-7-color-type\";s:6:\"custom\";s:34:\"header-social-7-brand-hover-toggle\";b:0;s:35:\"font-size-section-hb-social-icons-7\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-7\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-7-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-7-bg-space\";s:0:\"\";s:20:\"footer-social-7-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-7-radius\";s:0:\"\";s:21:\"footer-social-7-color\";s:0:\"\";s:23:\"footer-social-7-h-color\";s:0:\"\";s:24:\"footer-social-7-bg-color\";s:0:\"\";s:26:\"footer-social-7-bg-h-color\";s:0:\"\";s:28:\"footer-social-7-label-toggle\";b:0;s:26:\"footer-social-7-color-type\";s:6:\"custom\";s:27:\"footer-social-7-brand-color\";s:0:\"\";s:33:\"footer-social-7-brand-label-color\";s:0:\"\";s:34:\"footer-social-7-brand-hover-toggle\";b:0;s:35:\"font-size-section-fb-social-icons-7\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-7\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:25:\"footer-social-7-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:32:\"section-fb-social-icons-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-7-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-7-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-7-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-7-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-7-font-family\";s:7:\"inherit\";s:27:\"header-widget-7-font-weight\";s:7:\"inherit\";s:25:\"header-widget-7-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-7-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:35:\"header-widget-7-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-7-content-font-weight\";s:7:\"inherit\";s:33:\"header-widget-7-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-7-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:38:\"sidebar-widgets-header-widget-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-7-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-7-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-7-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-7-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-7-font-family\";s:7:\"inherit\";s:27:\"footer-widget-7-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-7-text-transform\";s:0:\"\";s:27:\"footer-widget-7-line-height\";s:0:\"\";s:25:\"footer-widget-7-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-7-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-7-content-font-weight\";s:7:\"inherit\";s:35:\"footer-widget-7-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"footer-widget-7-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-7\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:38:\"sidebar-widgets-footer-widget-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu7-bg-color\";s:0:\"\";s:18:\"header-menu7-color\";s:0:\"\";s:23:\"header-menu7-h-bg-color\";s:0:\"\";s:20:\"header-menu7-h-color\";s:0:\"\";s:23:\"header-menu7-a-bg-color\";s:0:\"\";s:20:\"header-menu7-a-color\";s:0:\"\";s:30:\"header-menu7-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:29:\"header-menu7-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu7-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu7-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu7-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu7-a-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu7-menu-hover-animation\";s:0:\"\";s:40:\"header-menu7-submenu-container-animation\";s:0:\"\";s:24:\"section-hb-menu-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu7-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu7-submenu-item-border\";b:0;s:32:\"header-menu7-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu7-submenu-item-b-color\";s:7:\"#eaeaea\";s:41:\"header-menu7-submenu-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"header-menu7-submenu-top-offset\";s:0:\"\";s:26:\"header-menu7-submenu-width\";s:0:\"\";s:27:\"header-menu7-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:33:\"header-menu7-menu-stack-on-mobile\";b:1;s:22:\"header-menu7-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu7-font-weight\";s:7:\"inherit\";s:24:\"header-menu7-font-family\";s:7:\"inherit\";s:24:\"header-menu7-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:27:\"section-hb-divider-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button8-text\";s:6:\"Button\";s:26:\"header-button8-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button8-font-family\";s:7:\"inherit\";s:26:\"header-button8-font-weight\";s:7:\"inherit\";s:26:\"header-button8-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"header-button8-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button8-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button8-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button8-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button8-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button8-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button8-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"header-button8-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"header-button8-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-button8-border-radius\";s:0:\"\";s:27:\"section-hb-button-8-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-hb-button-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button8-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button8-text\";s:6:\"Button\";s:26:\"footer-button8-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button8-font-family\";s:7:\"inherit\";s:26:\"footer-button8-font-weight\";s:7:\"inherit\";s:29:\"footer-button8-text-transform\";s:0:\"\";s:26:\"footer-button8-line-height\";s:0:\"\";s:24:\"footer-button8-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button8-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button8-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button8-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button8-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button8-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button8-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button8-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"footer-button8-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button-8-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-8-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-8\";s:22:\"Insert HTML text here.\";s:18:\"header-html-8color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-8link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-8link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-8\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-8\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-8\";s:7:\"inherit\";s:29:\"font-extras-section-hb-html-8\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-hb-html-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-8\";s:22:\"Insert HTML text here.\";s:18:\"footer-html-8color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-8link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-8link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-8\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-8-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-8\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-8\";s:7:\"inherit\";s:29:\"font-extras-section-fb-html-8\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-fb-html-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-8-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-8-bg-space\";s:0:\"\";s:20:\"header-social-8-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"header-social-8-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-8-color\";s:0:\"\";s:23:\"header-social-8-h-color\";s:0:\"\";s:24:\"header-social-8-bg-color\";s:0:\"\";s:26:\"header-social-8-bg-h-color\";s:0:\"\";s:28:\"header-social-8-label-toggle\";b:0;s:26:\"header-social-8-color-type\";s:6:\"custom\";s:34:\"header-social-8-brand-hover-toggle\";b:0;s:35:\"font-size-section-hb-social-icons-8\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-8\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-8-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-8-bg-space\";s:0:\"\";s:20:\"footer-social-8-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-8-radius\";s:0:\"\";s:21:\"footer-social-8-color\";s:0:\"\";s:23:\"footer-social-8-h-color\";s:0:\"\";s:24:\"footer-social-8-bg-color\";s:0:\"\";s:26:\"footer-social-8-bg-h-color\";s:0:\"\";s:28:\"footer-social-8-label-toggle\";b:0;s:26:\"footer-social-8-color-type\";s:6:\"custom\";s:27:\"footer-social-8-brand-color\";s:0:\"\";s:33:\"footer-social-8-brand-label-color\";s:0:\"\";s:34:\"footer-social-8-brand-hover-toggle\";b:0;s:35:\"font-size-section-fb-social-icons-8\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-8\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:25:\"footer-social-8-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:32:\"section-fb-social-icons-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-8-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-8-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-8-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-8-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-8-font-family\";s:7:\"inherit\";s:27:\"header-widget-8-font-weight\";s:7:\"inherit\";s:25:\"header-widget-8-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-8-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:35:\"header-widget-8-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-8-content-font-weight\";s:7:\"inherit\";s:33:\"header-widget-8-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-8-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:38:\"sidebar-widgets-header-widget-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-8-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-8-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-8-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-8-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-8-font-family\";s:7:\"inherit\";s:27:\"footer-widget-8-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-8-text-transform\";s:0:\"\";s:27:\"footer-widget-8-line-height\";s:0:\"\";s:25:\"footer-widget-8-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-8-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-8-content-font-weight\";s:7:\"inherit\";s:35:\"footer-widget-8-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"footer-widget-8-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-8\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:38:\"sidebar-widgets-footer-widget-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu8-bg-color\";s:0:\"\";s:18:\"header-menu8-color\";s:0:\"\";s:23:\"header-menu8-h-bg-color\";s:0:\"\";s:20:\"header-menu8-h-color\";s:0:\"\";s:23:\"header-menu8-a-bg-color\";s:0:\"\";s:20:\"header-menu8-a-color\";s:0:\"\";s:30:\"header-menu8-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:29:\"header-menu8-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu8-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu8-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu8-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu8-a-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu8-menu-hover-animation\";s:0:\"\";s:40:\"header-menu8-submenu-container-animation\";s:0:\"\";s:24:\"section-hb-menu-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu8-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu8-submenu-item-border\";b:0;s:32:\"header-menu8-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu8-submenu-item-b-color\";s:7:\"#eaeaea\";s:41:\"header-menu8-submenu-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"header-menu8-submenu-top-offset\";s:0:\"\";s:26:\"header-menu8-submenu-width\";s:0:\"\";s:27:\"header-menu8-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:33:\"header-menu8-menu-stack-on-mobile\";b:1;s:22:\"header-menu8-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu8-font-weight\";s:7:\"inherit\";s:24:\"header-menu8-font-family\";s:7:\"inherit\";s:24:\"header-menu8-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:27:\"section-hb-divider-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button9-text\";s:6:\"Button\";s:26:\"header-button9-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button9-font-family\";s:7:\"inherit\";s:26:\"header-button9-font-weight\";s:7:\"inherit\";s:26:\"header-button9-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"header-button9-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button9-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button9-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button9-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button9-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button9-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button9-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"header-button9-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"header-button9-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-button9-border-radius\";s:0:\"\";s:27:\"section-hb-button-9-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-hb-button-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button9-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button9-text\";s:6:\"Button\";s:26:\"footer-button9-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button9-font-family\";s:7:\"inherit\";s:26:\"footer-button9-font-weight\";s:7:\"inherit\";s:29:\"footer-button9-text-transform\";s:0:\"\";s:26:\"footer-button9-line-height\";s:0:\"\";s:24:\"footer-button9-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button9-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button9-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button9-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button9-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button9-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button9-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button9-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"footer-button9-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button-9-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-9-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-9\";s:22:\"Insert HTML text here.\";s:18:\"header-html-9color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-9link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-9link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-9\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-9\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-9\";s:7:\"inherit\";s:29:\"font-extras-section-hb-html-9\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-hb-html-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-9\";s:22:\"Insert HTML text here.\";s:18:\"footer-html-9color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-9link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-9link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-9\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-9-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-9\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-9\";s:7:\"inherit\";s:29:\"font-extras-section-fb-html-9\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-fb-html-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-9-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-9-bg-space\";s:0:\"\";s:20:\"header-social-9-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"header-social-9-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-9-color\";s:0:\"\";s:23:\"header-social-9-h-color\";s:0:\"\";s:24:\"header-social-9-bg-color\";s:0:\"\";s:26:\"header-social-9-bg-h-color\";s:0:\"\";s:28:\"header-social-9-label-toggle\";b:0;s:26:\"header-social-9-color-type\";s:6:\"custom\";s:34:\"header-social-9-brand-hover-toggle\";b:0;s:35:\"font-size-section-hb-social-icons-9\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-9\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-9-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-9-bg-space\";s:0:\"\";s:20:\"footer-social-9-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-9-radius\";s:0:\"\";s:21:\"footer-social-9-color\";s:0:\"\";s:23:\"footer-social-9-h-color\";s:0:\"\";s:24:\"footer-social-9-bg-color\";s:0:\"\";s:26:\"footer-social-9-bg-h-color\";s:0:\"\";s:28:\"footer-social-9-label-toggle\";b:0;s:26:\"footer-social-9-color-type\";s:6:\"custom\";s:27:\"footer-social-9-brand-color\";s:0:\"\";s:33:\"footer-social-9-brand-label-color\";s:0:\"\";s:34:\"footer-social-9-brand-hover-toggle\";b:0;s:35:\"font-size-section-fb-social-icons-9\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-9\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:25:\"footer-social-9-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:32:\"section-fb-social-icons-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-9-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-9-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-9-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-9-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-9-font-family\";s:7:\"inherit\";s:27:\"header-widget-9-font-weight\";s:7:\"inherit\";s:25:\"header-widget-9-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-9-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:35:\"header-widget-9-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-9-content-font-weight\";s:7:\"inherit\";s:33:\"header-widget-9-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-9-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:38:\"sidebar-widgets-header-widget-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-9-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-9-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-9-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-9-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-9-font-family\";s:7:\"inherit\";s:27:\"footer-widget-9-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-9-text-transform\";s:0:\"\";s:27:\"footer-widget-9-line-height\";s:0:\"\";s:25:\"footer-widget-9-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-9-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-9-content-font-weight\";s:7:\"inherit\";s:35:\"footer-widget-9-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"footer-widget-9-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-9\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:38:\"sidebar-widgets-footer-widget-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu9-bg-color\";s:0:\"\";s:18:\"header-menu9-color\";s:0:\"\";s:23:\"header-menu9-h-bg-color\";s:0:\"\";s:20:\"header-menu9-h-color\";s:0:\"\";s:23:\"header-menu9-a-bg-color\";s:0:\"\";s:20:\"header-menu9-a-color\";s:0:\"\";s:30:\"header-menu9-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:29:\"header-menu9-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu9-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu9-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu9-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu9-a-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu9-menu-hover-animation\";s:0:\"\";s:40:\"header-menu9-submenu-container-animation\";s:0:\"\";s:24:\"section-hb-menu-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu9-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu9-submenu-item-border\";b:0;s:32:\"header-menu9-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu9-submenu-item-b-color\";s:7:\"#eaeaea\";s:41:\"header-menu9-submenu-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"header-menu9-submenu-top-offset\";s:0:\"\";s:26:\"header-menu9-submenu-width\";s:0:\"\";s:27:\"header-menu9-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:33:\"header-menu9-menu-stack-on-mobile\";b:1;s:22:\"header-menu9-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu9-font-weight\";s:7:\"inherit\";s:24:\"header-menu9-font-family\";s:7:\"inherit\";s:24:\"header-menu9-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:27:\"section-hb-divider-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:20:\"header-button10-text\";s:6:\"Button\";s:27:\"header-button10-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:27:\"header-button10-font-family\";s:7:\"inherit\";s:27:\"header-button10-font-weight\";s:7:\"inherit\";s:27:\"header-button10-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:25:\"header-button10-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button10-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-button10-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-button10-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-button10-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-button10-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-button10-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:28:\"header-button10-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:36:\"header-button10-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"header-button10-border-radius\";s:0:\"\";s:28:\"section-hb-button-10-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-hb-button-10-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:30:\"sticky-header-button10-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:20:\"footer-button10-text\";s:6:\"Button\";s:27:\"footer-button10-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:27:\"footer-button10-font-family\";s:7:\"inherit\";s:27:\"footer-button10-font-weight\";s:7:\"inherit\";s:30:\"footer-button10-text-transform\";s:0:\"\";s:27:\"footer-button10-line-height\";s:0:\"\";s:25:\"footer-button10-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button10-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-button10-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-button10-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-button10-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-button10-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-button10-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:28:\"footer-button10-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:36:\"footer-button10-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button-10-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:28:\"section-fb-button-10-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-button-10-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:14:\"header-html-10\";s:22:\"Insert HTML text here.\";s:19:\"header-html-10color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-html-10link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-html-10link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"font-size-section-hb-html-10\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:30:\"font-weight-section-hb-html-10\";s:7:\"inherit\";s:30:\"font-family-section-hb-html-10\";s:7:\"inherit\";s:30:\"font-extras-section-hb-html-10\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:25:\"section-hb-html-10-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:14:\"footer-html-10\";s:22:\"Insert HTML text here.\";s:19:\"footer-html-10color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-html-10link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-html-10link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"font-size-section-fb-html-10\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"footer-html-10-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:30:\"font-weight-section-fb-html-10\";s:7:\"inherit\";s:30:\"font-family-section-fb-html-10\";s:7:\"inherit\";s:30:\"font-extras-section-fb-html-10\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:25:\"section-fb-html-10-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:22:\"header-social-10-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-social-10-bg-space\";s:0:\"\";s:21:\"header-social-10-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:30:\"header-social-10-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:22:\"header-social-10-color\";s:0:\"\";s:24:\"header-social-10-h-color\";s:0:\"\";s:25:\"header-social-10-bg-color\";s:0:\"\";s:27:\"header-social-10-bg-h-color\";s:0:\"\";s:29:\"header-social-10-label-toggle\";b:0;s:27:\"header-social-10-color-type\";s:6:\"custom\";s:35:\"header-social-10-brand-hover-toggle\";b:0;s:36:\"font-size-section-hb-social-icons-10\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:22:\"header-social-icons-10\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:33:\"section-hb-social-icons-10-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:22:\"footer-social-10-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-social-10-bg-space\";s:0:\"\";s:21:\"footer-social-10-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-social-10-radius\";s:0:\"\";s:22:\"footer-social-10-color\";s:0:\"\";s:24:\"footer-social-10-h-color\";s:0:\"\";s:25:\"footer-social-10-bg-color\";s:0:\"\";s:27:\"footer-social-10-bg-h-color\";s:0:\"\";s:29:\"footer-social-10-label-toggle\";b:0;s:27:\"footer-social-10-color-type\";s:6:\"custom\";s:28:\"footer-social-10-brand-color\";s:0:\"\";s:34:\"footer-social-10-brand-label-color\";s:0:\"\";s:35:\"footer-social-10-brand-hover-toggle\";b:0;s:36:\"font-size-section-fb-social-icons-10\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:22:\"footer-social-icons-10\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:26:\"footer-social-10-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:33:\"section-fb-social-icons-10-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-widget-10-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-widget-10-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-10-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"header-widget-10-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-10-font-family\";s:7:\"inherit\";s:28:\"header-widget-10-font-weight\";s:7:\"inherit\";s:26:\"header-widget-10-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-widget-10-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:36:\"header-widget-10-content-font-family\";s:7:\"inherit\";s:36:\"header-widget-10-content-font-weight\";s:7:\"inherit\";s:34:\"header-widget-10-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:36:\"header-widget-10-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:39:\"sidebar-widgets-header-widget-10-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"footer-widget-10-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-widget-10-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-10-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"footer-widget-10-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-10-font-family\";s:7:\"inherit\";s:28:\"footer-widget-10-font-weight\";s:7:\"inherit\";s:31:\"footer-widget-10-text-transform\";s:0:\"\";s:28:\"footer-widget-10-line-height\";s:0:\"\";s:26:\"footer-widget-10-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:36:\"footer-widget-10-content-font-family\";s:7:\"inherit\";s:36:\"footer-widget-10-content-font-weight\";s:7:\"inherit\";s:36:\"footer-widget-10-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:34:\"footer-widget-10-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-widget-alignment-10\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:39:\"sidebar-widgets-footer-widget-10-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:22:\"header-menu10-bg-color\";s:0:\"\";s:19:\"header-menu10-color\";s:0:\"\";s:24:\"header-menu10-h-bg-color\";s:0:\"\";s:21:\"header-menu10-h-color\";s:0:\"\";s:24:\"header-menu10-a-bg-color\";s:0:\"\";s:21:\"header-menu10-a-color\";s:0:\"\";s:31:\"header-menu10-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:30:\"header-menu10-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"header-menu10-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:32:\"header-menu10-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"header-menu10-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:32:\"header-menu10-a-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu10-menu-hover-animation\";s:0:\"\";s:41:\"header-menu10-submenu-container-animation\";s:0:\"\";s:25:\"section-hb-menu-10-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-menu10-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:33:\"header-menu10-submenu-item-border\";b:0;s:33:\"header-menu10-submenu-item-b-size\";s:1:\"1\";s:34:\"header-menu10-submenu-item-b-color\";s:7:\"#eaeaea\";s:42:\"header-menu10-submenu-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu10-submenu-top-offset\";s:0:\"\";s:27:\"header-menu10-submenu-width\";s:0:\"\";s:28:\"header-menu10-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:34:\"header-menu10-menu-stack-on-mobile\";b:1;s:23:\"header-menu10-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu10-font-weight\";s:7:\"inherit\";s:25:\"header-menu10-font-family\";s:7:\"inherit\";s:25:\"header-menu10-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:28:\"section-hb-divider-10-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"section-fb-divider-10-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"sticky-header-on-devices\";s:7:\"desktop\";s:19:\"sticky-header-style\";s:4:\"none\";s:20:\"footer-desktop-items\";a:10:{s:5:\"above\";a:6:{s:7:\"above_1\";a:0:{}s:7:\"above_2\";a:0:{}s:7:\"above_3\";a:0:{}s:7:\"above_4\";a:0:{}s:7:\"above_5\";a:0:{}s:7:\"above_6\";a:0:{}}s:7:\"primary\";a:6:{s:9:\"primary_1\";a:1:{i:0;s:8:\"widget-1\";}s:9:\"primary_2\";a:1:{i:0;s:8:\"widget-3\";}s:9:\"primary_3\";a:1:{i:0;s:8:\"widget-2\";}s:9:\"primary_4\";a:1:{i:0;s:8:\"widget-4\";}s:9:\"primary_5\";a:0:{}s:9:\"primary_6\";a:0:{}}s:5:\"below\";a:6:{s:7:\"below_1\";a:1:{i:0;s:9:\"copyright\";}s:7:\"below_2\";a:0:{}s:7:\"below_3\";a:0:{}s:7:\"below_4\";a:0:{}s:7:\"below_5\";a:0:{}s:7:\"below_6\";a:0:{}}s:5:\"group\";s:36:\"astra-settings[footer-desktop-items]\";s:4:\"rows\";a:3:{i:0;s:5:\"above\";i:1;s:7:\"primary\";i:2;s:5:\"below\";}s:5:\"zones\";a:3:{s:5:\"above\";a:6:{s:7:\"above_1\";s:15:\"Above Section 1\";s:7:\"above_2\";s:15:\"Above Section 2\";s:7:\"above_3\";s:15:\"Above Section 3\";s:7:\"above_4\";s:15:\"Above Section 4\";s:7:\"above_5\";s:15:\"Above Section 5\";s:7:\"above_6\";s:15:\"Above Section 6\";}s:7:\"primary\";a:6:{s:9:\"primary_1\";s:17:\"Primary Section 1\";s:9:\"primary_2\";s:17:\"Primary Section 2\";s:9:\"primary_3\";s:17:\"Primary Section 3\";s:9:\"primary_4\";s:17:\"Primary Section 4\";s:9:\"primary_5\";s:17:\"Primary Section 5\";s:9:\"primary_6\";s:17:\"Primary Section 6\";}s:5:\"below\";a:6:{s:7:\"below_1\";s:15:\"Below Section 1\";s:7:\"below_2\";s:15:\"Below Section 2\";s:7:\"below_3\";s:15:\"Below Section 3\";s:7:\"below_4\";s:15:\"Below Section 4\";s:7:\"below_5\";s:15:\"Below Section 5\";s:7:\"below_6\";s:15:\"Below Section 6\";}}s:7:\"layouts\";a:3:{s:5:\"above\";a:2:{s:6:\"column\";i:2;s:6:\"layout\";a:3:{s:7:\"desktop\";s:7:\"2-equal\";s:6:\"tablet\";s:7:\"2-equal\";s:6:\"mobile\";s:4:\"full\";}}s:7:\"primary\";a:2:{s:6:\"column\";i:4;s:6:\"layout\";a:4:{s:6:\"mobile\";s:4:\"full\";s:6:\"tablet\";s:7:\"4-equal\";s:7:\"desktop\";s:8:\"4-lheavy\";s:4:\"flag\";b:1;}}s:5:\"below\";a:2:{s:6:\"column\";s:1:\"1\";s:6:\"layout\";a:4:{s:7:\"desktop\";s:4:\"full\";s:6:\"tablet\";s:4:\"full\";s:6:\"mobile\";s:4:\"full\";s:4:\"flag\";b:0;}}}s:6:\"status\";a:3:{s:5:\"above\";b:1;s:7:\"primary\";b:1;s:5:\"below\";b:1;}s:4:\"flag\";b:0;s:5:\"popup\";a:1:{s:13:\"popup_content\";a:0:{}}}s:17:\"hba-footer-height\";i:60;s:17:\"hba-footer-column\";i:2;s:17:\"hba-footer-layout\";a:3:{s:7:\"desktop\";s:7:\"2-equal\";s:6:\"tablet\";s:7:\"2-equal\";s:6:\"mobile\";s:4:\"full\";}s:28:\"hba-footer-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:11:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"hbb-footer-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:11:{s:16:\"background-color\";s:25:\"var(--ast-global-color-5)\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:5:\"color\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"hb-footer-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:25:\"var(--ast-global-color-5)\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:5:\"color\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:9:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:9:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:27:\"hbb-footer-top-border-color\";s:22:\"rgba(122,122,122,0.13)\";s:20:\"hbb-footer-separator\";s:1:\"1\";s:36:\"section-header-builder-layout-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:17:\"hbb-footer-height\";i:80;s:17:\"hbb-footer-column\";s:1:\"1\";s:17:\"hbb-footer-layout\";a:4:{s:7:\"desktop\";s:4:\"full\";s:6:\"tablet\";s:4:\"full\";s:6:\"mobile\";s:4:\"full\";s:4:\"flag\";b:0;}s:24:\"hb-primary-footer-height\";s:0:\"\";s:23:\"hba-footer-layout-width\";s:7:\"content\";s:22:\"hb-footer-layout-width\";s:7:\"content\";s:23:\"hbb-footer-layout-width\";s:7:\"content\";s:29:\"hba-footer-vertical-alignment\";s:10:\"flex-start\";s:28:\"hb-footer-vertical-alignment\";s:10:\"flex-start\";s:29:\"hbb-footer-vertical-alignment\";s:6:\"center\";s:24:\"footer-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:16:\"hb-footer-column\";s:1:\"4\";s:19:\"hb-footer-separator\";i:1;s:29:\"hb-footer-bottom-border-color\";s:7:\"#e6e6e6\";s:16:\"hb-footer-layout\";a:4:{s:7:\"desktop\";s:8:\"4-lheavy\";s:6:\"tablet\";s:7:\"4-equal\";s:6:\"mobile\";s:4:\"full\";s:4:\"flag\";b:0;}s:18:\"hb-footer-main-sep\";s:1:\"0\";s:24:\"hb-footer-main-sep-color\";s:65:\"var( --ast-global-color-subtle-background, --ast-global-color-7 )\";s:24:\"live-search-result-count\";i:5;s:23:\"footer-copyright-editor\";s:102:\"<p style=\"text-align: center;\">Copyright © [current_year] [site_title] | Powered by Darkmode Labs</p>\";s:22:\"footer-copyright-color\";s:25:\"var(--ast-global-color-3)\";s:36:\"line-height-section-footer-copyright\";i:2;s:26:\"footer-copyright-alignment\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:4:\"left\";s:6:\"mobile\";s:6:\"center\";}s:34:\"font-size-section-footer-copyright\";a:6:{s:7:\"desktop\";s:2:\"14\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:36:\"font-weight-section-footer-copyright\";s:7:\"inherit\";s:36:\"font-family-section-footer-copyright\";s:7:\"inherit\";s:36:\"font-extras-section-footer-copyright\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:21:\"footer-menu-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:36:\"section-below-footer-builder-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:2:\"30\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:2:\"30\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:2:\"20\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:2:\"20\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-search-icon-space\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";i:18;s:6:\"mobile\";i:18;}s:24:\"header-search-icon-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:19:\"header-search-width\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:11:\"live-search\";b:0;s:22:\"live-search-post-types\";a:2:{s:4:\"post\";i:1;s:4:\"page\";i:1;}s:37:\"transparent-header-social-icons-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:39:\"transparent-header-social-icons-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:40:\"transparent-header-social-icons-bg-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:42:\"transparent-header-social-icons-bg-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"transparent-header-html-text-color\";s:0:\"\";s:34:\"transparent-header-html-link-color\";s:0:\"\";s:36:\"transparent-header-html-link-h-color\";s:0:\"\";s:37:\"transparent-header-widget-title-color\";s:0:\"\";s:39:\"transparent-header-widget-content-color\";s:0:\"\";s:36:\"transparent-header-widget-link-color\";s:0:\"\";s:38:\"transparent-header-widget-link-h-color\";s:0:\"\";s:36:\"transparent-header-button-text-color\";s:0:\"\";s:38:\"transparent-header-button-text-h-color\";s:0:\"\";s:34:\"transparent-header-button-bg-color\";s:0:\"\";s:36:\"transparent-header-button-bg-h-color\";s:0:\"\";s:17:\"off-canvas-layout\";s:10:\"side-panel\";s:16:\"off-canvas-slide\";s:5:\"right\";s:33:\"header-builder-menu-toggle-target\";s:4:\"icon\";s:34:\"header-offcanvas-content-alignment\";s:10:\"flex-start\";s:21:\"off-canvas-background\";a:11:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:16:\"background-media\";s:0:\"\";s:15:\"background-type\";s:5:\"color\";s:12:\"overlay-type\";s:4:\"none\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:22:\"off-canvas-close-color\";s:7:\"#3a3a3a\";s:18:\"mobile-header-type\";s:8:\"dropdown\";s:20:\"off-canvas-move-body\";b:1;s:24:\"off-canvas-inner-spacing\";s:0:\"\";s:18:\"footer-menu-layout\";a:3:{s:7:\"desktop\";s:10:\"horizontal\";s:6:\"tablet\";s:8:\"vertical\";s:6:\"mobile\";s:8:\"vertical\";}s:29:\"footer-menu-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:28:\"footer-menu-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"footer-menu-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:30:\"footer-menu-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"footer-menu-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:30:\"footer-menu-a-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-menu-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-menu-font-weight\";s:7:\"inherit\";s:23:\"footer-menu-font-family\";s:7:\"inherit\";s:23:\"footer-menu-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"footer-main-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:1:\"0\";s:5:\"right\";s:2:\"20\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:2:\"20\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-trigger-icon\";s:4:\"menu\";s:30:\"mobile-header-toggle-icon-size\";i:20;s:36:\"mobile-header-toggle-btn-border-size\";a:4:{s:3:\"top\";i:1;s:5:\"right\";i:1;s:6:\"bottom\";i:1;s:4:\"left\";i:1;}s:34:\"mobile-header-toggle-border-radius\";s:0:\"\";s:41:\"mobile-header-toggle-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"mobile-header-label-font-family\";s:7:\"inherit\";s:31:\"mobile-header-label-font-weight\";s:7:\"inherit\";s:34:\"mobile-header-label-text-transform\";s:0:\"\";s:31:\"mobile-header-label-line-height\";s:0:\"\";s:29:\"mobile-header-label-font-size\";s:0:\"\";s:20:\"global-color-palette\";a:3:{s:6:\"labels\";a:9:{i:0;s:11:\"Theme Color\";i:1;s:16:\"Link Hover Color\";i:2;s:13:\"Heading Color\";i:3;s:10:\"Text Color\";i:4;s:16:\"Background Color\";i:5;s:13:\"Extra Color 1\";i:6;s:13:\"Extra Color 2\";i:7;s:13:\"Extra Color 3\";i:8;s:13:\"Extra Color 4\";}s:7:\"palette\";a:9:{i:0;s:7:\"#7dff12\";i:1;s:7:\"#28bd86\";i:2;s:7:\"#0c122d\";i:3;s:7:\"#575c74\";i:4;s:7:\"#f7fdfb\";i:5;s:7:\"#ffffff\";i:6;s:7:\"#ffffff\";i:7;s:7:\"#424242\";i:8;s:7:\"#000000\";}s:4:\"flag\";b:1;}s:17:\"header-logo-color\";s:0:\"\";s:27:\"header-mobile-menu-bg-color\";s:0:\"\";s:24:\"header-mobile-menu-color\";s:0:\"\";s:29:\"header-mobile-menu-h-bg-color\";s:0:\"\";s:26:\"header-mobile-menu-h-color\";s:0:\"\";s:29:\"header-mobile-menu-a-bg-color\";s:0:\"\";s:26:\"header-mobile-menu-a-color\";s:0:\"\";s:36:\"header-mobile-menu-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:35:\"header-mobile-menu-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:37:\"header-mobile-menu-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:37:\"header-mobile-menu-a-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:40:\"header-mobile-menu-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:40:\"header-mobile-menu-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:46:\"header-mobile-menu-submenu-container-animation\";s:4:\"fade\";s:38:\"header-mobile-menu-submenu-item-border\";b:0;s:38:\"header-mobile-menu-submenu-item-b-size\";s:1:\"1\";s:39:\"header-mobile-menu-submenu-item-b-color\";s:7:\"#eaeaea\";s:33:\"header-mobile-menu-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:28:\"header-mobile-menu-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:30:\"font-extras-header-mobile-menu\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:28:\"woo-header-cart-click-action\";s:7:\"default\";s:28:\"responsive-cart-click-action\";s:6:\"flyout\";s:23:\"woo-slide-in-cart-width\";a:6:{s:7:\"desktop\";i:35;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:1:\"%\";s:11:\"tablet-unit\";s:1:\"%\";s:11:\"mobile-unit\";s:1:\"%\";}s:41:\"woo-header-cart-icon-total-label-position\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-woo-cart-icon-size\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:20:\"woo-header-cart-icon\";s:7:\"default\";s:26:\"woo-header-cart-icon-style\";s:7:\"outline\";s:41:\"woo-header-cart-product-count-color-group\";s:57:\"var( --ast-global-color-secondary, --ast-global-color-5 )\";s:33:\"woo-desktop-cart-flyout-direction\";s:5:\"right\";s:26:\"header-woo-cart-icon-color\";s:0:\"\";s:38:\"transparent-header-woo-cart-icon-color\";s:0:\"\";s:32:\"header-woo-cart-icon-hover-color\";s:0:\"\";s:28:\"woo-header-cart-border-width\";i:2;s:34:\"woo-header-cart-icon-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"woo-header-cart-badge-display\";b:1;s:29:\"woo-header-cart-label-display\";s:33:\"Cart/{cart_total_currency_symbol}\";s:26:\"header-woo-cart-text-color\";s:0:\"\";s:26:\"header-woo-cart-link-color\";s:0:\"\";s:32:\"header-woo-cart-background-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:38:\"header-woo-cart-background-hover-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-woo-cart-separator-color\";s:0:\"\";s:32:\"header-woo-cart-link-hover-color\";s:0:\"\";s:30:\"header-woo-cart-btn-text-color\";s:0:\"\";s:36:\"header-woo-cart-btn-background-color\";s:0:\"\";s:36:\"header-woo-cart-btn-text-hover-color\";s:0:\"\";s:34:\"header-woo-cart-btn-bg-hover-color\";s:0:\"\";s:34:\"header-woo-checkout-btn-text-color\";s:0:\"\";s:40:\"header-woo-checkout-btn-background-color\";s:0:\"\";s:40:\"header-woo-checkout-btn-text-hover-color\";s:0:\"\";s:38:\"header-woo-checkout-btn-bg-hover-color\";s:0:\"\";s:26:\"edd-header-cart-icon-style\";s:7:\"outline\";s:26:\"edd-header-cart-icon-color\";s:0:\"\";s:27:\"edd-header-cart-icon-radius\";i:3;s:38:\"transparent-header-edd-cart-icon-color\";s:0:\"\";s:29:\"edd-header-cart-total-display\";b:1;s:29:\"edd-header-cart-title-display\";b:1;s:26:\"header-edd-cart-text-color\";s:0:\"\";s:26:\"header-edd-cart-link-color\";s:0:\"\";s:32:\"header-edd-cart-background-color\";s:0:\"\";s:31:\"header-edd-cart-separator-color\";s:0:\"\";s:34:\"header-edd-checkout-btn-text-color\";s:0:\"\";s:40:\"header-edd-checkout-btn-background-color\";s:0:\"\";s:40:\"header-edd-checkout-btn-text-hover-color\";s:0:\"\";s:38:\"header-edd-checkout-btn-bg-hover-color\";s:0:\"\";s:19:\"header-account-type\";s:7:\"default\";s:26:\"header-account-login-style\";s:4:\"icon\";s:51:\"header-account-login-style-extend-text-profile-type\";s:7:\"default\";s:26:\"header-account-action-type\";s:4:\"link\";s:24:\"header-account-link-type\";s:7:\"default\";s:27:\"header-account-logout-style\";s:4:\"icon\";s:52:\"header-account-logout-style-extend-text-profile-type\";s:7:\"default\";s:30:\"header-account-logged-out-text\";s:6:\"Log In\";s:29:\"header-account-logged-in-text\";s:10:\"My Account\";s:28:\"header-account-logout-action\";s:4:\"link\";s:26:\"header-account-image-width\";a:3:{s:7:\"desktop\";s:2:\"40\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-account-icon-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";i:18;s:6:\"mobile\";i:18;}s:25:\"header-account-icon-color\";s:25:\"var(--ast-global-color-2)\";s:25:\"header-account-login-link\";a:3:{s:3:\"url\";s:0:\"\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"header-account-logout-link\";a:3:{s:3:\"url\";s:56:\"https://websitedemos.net/diagnostics-lab-02/wp-login.php\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:32:\"font-size-section-header-account\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:30:\"header-account-type-text-color\";s:0:\"\";s:23:\"header-account-woo-menu\";b:0;s:22:\"cloned-component-track\";a:12:{s:13:\"header-button\";i:2;s:13:\"footer-button\";i:2;s:11:\"header-html\";i:2;s:11:\"footer-html\";i:2;s:11:\"header-menu\";i:2;s:13:\"header-widget\";i:4;s:13:\"footer-widget\";i:4;s:19:\"header-social-icons\";i:1;s:19:\"footer-social-icons\";i:1;s:14:\"header-divider\";i:0;s:14:\"footer-divider\";i:0;s:13:\"removed-items\";a:0:{}}s:24:\"astra-addon-auto-version\";s:5:\"3.9.0\";s:28:\"is_astra_addon_queue_running\";b:0;s:18:\"theme-auto-version\";s:5:\"4.9.2\";s:28:\"button-color-styling-divider\";s:0:\"\";s:24:\"theme-button-color-group\";s:0:\"\";s:25:\"theme-button-border-group\";s:0:\"\";s:38:\"theme-button-border-group-border-color\";s:25:\"var(--ast-global-color-0)\";s:40:\"theme-button-border-group-border-h-color\";s:25:\"var(--ast-global-color-5)\";s:13:\"button-radius\";i:8;s:30:\"button-padding-styling-divider\";s:0:\"\";s:35:\"primary-header-button-color-divider\";s:0:\"\";s:33:\"primary-header-button-color-group\";s:0:\"\";s:34:\"primary-header-button-border-group\";s:0:\"\";s:37:\"primary-header-button-text-typography\";s:0:\"\";s:42:\"header-main-rt-section-button-border-color\";s:0:\"\";s:44:\"header-main-rt-section-button-border-h-color\";s:0:\"\";s:43:\"header-main-rt-section-button-border-radius\";s:0:\"\";s:39:\"transparent-header-button-color-divider\";s:0:\"\";s:37:\"transparent-header-button-color-group\";s:0:\"\";s:38:\"transparent-header-button-border-group\";s:0:\"\";s:46:\"header-main-rt-trans-section-button-text-color\";s:0:\"\";s:48:\"header-main-rt-trans-section-button-text-h-color\";s:0:\"\";s:46:\"header-main-rt-trans-section-button-back-color\";s:0:\"\";s:48:\"header-main-rt-trans-section-button-back-h-color\";s:0:\"\";s:43:\"header-main-rt-trans-section-button-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:47:\"header-main-rt-trans-section-button-border-size\";s:0:\"\";s:48:\"header-main-rt-trans-section-button-border-color\";s:0:\"\";s:50:\"header-main-rt-trans-section-button-border-h-color\";s:0:\"\";s:49:\"header-main-rt-trans-section-button-border-radius\";s:0:\"\";s:24:\"header-button-style-link\";s:0:\"\";s:30:\"header-main-menu-label-divider\";s:0:\"\";s:39:\"mobile-header-toggle-target-link-notice\";s:0:\"\";s:36:\"mobile-header-toggle-btn-style-color\";s:0:\"\";s:38:\"mobile-header-toggle-btn-border-radius\";s:0:\"\";s:37:\"header-transparent-header-logo-notice\";s:0:\"\";s:42:\"header-transparent-header-logo-notice-link\";s:0:\"\";s:34:\"divider-section-site-identity-logo\";s:0:\"\";s:21:\"different-retina-logo\";b:0;s:21:\"different-mobile-logo\";b:0;s:21:\"ast-site-logo-divider\";s:0:\"\";s:18:\"display-site-title\";b:0;s:20:\"display-site-tagline\";i:0;s:21:\"ast-site-icon-divider\";s:0:\"\";s:21:\"site-title-typography\";s:0:\"\";s:22:\"ast-site-title-divider\";s:0:\"\";s:23:\"site-tagline-typography\";s:0:\"\";s:30:\"ast-styling-section-blog-width\";s:0:\"\";s:34:\"ast-styling-section-blog-width-end\";s:0:\"\";s:37:\"ast-styling-section-blog-single-width\";s:0:\"\";s:26:\"blog-single-post-structure\";a:2:{i:0;s:12:\"single-image\";i:1;s:17:\"single-title-meta\";}s:16:\"blog-single-meta\";a:3:{i:0;s:8:\"comments\";i:1;s:8:\"category\";i:2;s:6:\"author\";}s:34:\"single-page-sidebar-layout-divider\";s:0:\"\";s:29:\"divider-section-sidebar-width\";s:0:\"\";s:30:\"site-sidebar-width-description\";s:0:\"\";s:27:\"site-content-layout-divider\";s:0:\"\";s:19:\"site-content-layout\";s:15:\"boxed-container\";s:26:\"single-page-content-layout\";s:15:\"boxed-container\";s:26:\"single-post-content-layout\";s:7:\"default\";s:27:\"archive-post-content-layout\";s:7:\"default\";s:36:\"section-ast-small-footer-layout-info\";s:0:\"\";s:35:\"section-ast-small-footer-typography\";s:0:\"\";s:43:\"footer-bar-color-background-heading-divider\";s:0:\"\";s:27:\"footer-bar-background-group\";s:0:\"\";s:24:\"footer-bar-content-group\";s:0:\"\";s:24:\"divider-outside-bg-color\";s:0:\"\";s:46:\"footer-widget-color-background-heading-divider\";s:0:\"\";s:30:\"footer-widget-background-group\";s:0:\"\";s:27:\"footer-widget-content-group\";s:0:\"\";s:23:\"blog-typography-divider\";s:0:\"\";s:33:\"blog-content-archive-summary-typo\";s:0:\"\";s:33:\"blog-content-blog-post-title-typo\";s:0:\"\";s:31:\"font-size-archive-summary-title\";a:6:{s:7:\"desktop\";i:40;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:17:\"divider-base-typo\";s:0:\"\";s:16:\"body-line-height\";s:0:\"\";s:21:\"divider-headings-typo\";s:0:\"\";s:21:\"headings-font-variant\";s:3:\"500\";s:23:\"headings-text-transform\";s:10:\"capitalize\";s:20:\"headings-line-height\";s:3:\"1.1\";s:18:\"divider-section-h1\";s:0:\"\";s:18:\"divider-section-h2\";s:0:\"\";s:18:\"divider-section-h3\";s:0:\"\";s:18:\"divider-section-h4\";s:0:\"\";s:18:\"divider-section-h5\";s:0:\"\";s:18:\"divider-section-h6\";s:0:\"\";s:32:\"divider-section-single-post-typo\";s:0:\"\";s:22:\"blog-single-title-typo\";s:0:\"\";s:21:\"font-size-entry-title\";a:6:{s:7:\"desktop\";i:30;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"transparent-header-disable-index\";s:0:\"\";s:31:\"transparent-header-disable-page\";s:0:\"\";s:32:\"transparent-header-disable-posts\";s:0:\"\";s:35:\"divider-section-transparent-display\";s:0:\"\";s:35:\"divider-section-transparent-styling\";s:0:\"\";s:42:\"divider-section-transparent-border-styling\";s:0:\"\";s:31:\"divider-sec-transparent-styling\";s:0:\"\";s:36:\"transparent-header-background-colors\";s:0:\"\";s:25:\"transparent-header-colors\";s:0:\"\";s:30:\"transparent-header-colors-menu\";s:0:\"\";s:33:\"transparent-header-colors-submenu\";s:0:\"\";s:33:\"transparent-header-colors-content\";s:0:\"\";s:19:\"breadcrumb-position\";s:4:\"none\";s:24:\"select-breadcrumb-source\";s:7:\"default\";s:28:\"breadcrumb-disable-home-page\";s:0:\"\";s:34:\"breadcrumb-disable-blog-posts-page\";s:0:\"\";s:25:\"breadcrumb-disable-search\";s:0:\"\";s:26:\"breadcrumb-disable-archive\";s:0:\"\";s:30:\"breadcrumb-disable-single-page\";s:0:\"\";s:30:\"breadcrumb-disable-single-post\";s:0:\"\";s:27:\"breadcrumb-disable-singular\";s:0:\"\";s:27:\"breadcrumb-disable-404-page\";s:0:\"\";s:20:\"breadcrumb-alignment\";s:4:\"left\";s:32:\"section-breadcrumb-color-divider\";s:0:\"\";s:24:\"section-breadcrumb-color\";s:0:\"\";s:37:\"section-breadcrumb-typography-divider\";s:0:\"\";s:23:\"section-breadcrumb-typo\";s:0:\"\";s:25:\"breadcrumb-text-transform\";s:0:\"\";s:22:\"breadcrumb-line-height\";s:0:\"\";s:17:\"text-transform-h1\";s:0:\"\";s:14:\"line-height-h1\";s:0:\"\";s:17:\"text-transform-h2\";s:0:\"\";s:14:\"line-height-h2\";s:0:\"\";s:17:\"text-transform-h3\";s:0:\"\";s:14:\"line-height-h3\";s:0:\"\";s:33:\"button-typography-styling-divider\";s:0:\"\";s:22:\"button-text-typography\";s:0:\"\";s:21:\"text-transform-button\";s:0:\"\";s:21:\"theme-btn-line-height\";i:1;s:24:\"theme-btn-letter-spacing\";s:0:\"\";s:38:\"header-main-rt-section-search-box-type\";s:12:\"slide-search\";s:38:\"above-header-section-1-search-box-type\";s:12:\"slide-search\";s:38:\"above-header-section-2-search-box-type\";s:12:\"slide-search\";s:38:\"below-header-section-1-search-box-type\";s:12:\"slide-search\";s:38:\"below-header-section-2-search-box-type\";s:12:\"slide-search\";s:33:\"_astra_pb_compatibility_completed\";b:1;s:31:\"guntenberg-core-blocks-comp-css\";b:0;s:39:\"guntenberg-media-text-block-padding-css\";b:0;s:24:\"is-header-footer-builder\";b:1;s:29:\"header-button1-border-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"header-button1-text-transform\";s:0:\"\";s:26:\"header-button1-line-height\";i:1;s:29:\"header-button1-letter-spacing\";s:0:\"\";s:27:\"footer-copyright-link-color\";s:0:\"\";s:29:\"footer-copyright-link-h-color\";s:0:\"\";s:20:\"hba-footer-separator\";s:0:\"\";s:27:\"hba-footer-top-border-color\";s:7:\"#7a7a7a\";s:28:\"header-menu1-submenu-b-color\";s:25:\"var(--ast-global-color-0)\";s:24:\"mobile-header-menu-label\";s:0:\"\";s:30:\"mobile-header-toggle-btn-color\";s:0:\"\";s:33:\"mobile-header-toggle-border-color\";s:0:\"\";s:19:\"v3-option-migration\";b:1;s:36:\"guntenberg-button-pattern-compat-css\";b:0;s:35:\"can-support-widget-and-editor-fonts\";b:0;s:29:\"can-remove-logo-max-width-css\";b:0;s:33:\"transparent-header-default-border\";b:0;s:27:\"btn-default-padding-updated\";b:0;s:34:\"support-footer-widget-right-margin\";b:0;s:31:\"remove-elementor-toc-margin-css\";b:0;s:28:\"remove-widget-design-options\";b:0;s:27:\"support-global-color-format\";b:0;s:20:\"improve-gb-editor-ui\";b:0;s:42:\"apply-content-background-fullwidth-layouts\";b:0;s:32:\"customizer-default-layout-update\";b:0;s:33:\"single-product-breadcrumb-disable\";b:0;s:43:\"woocommerce-single-product-fallback-default\";b:1;s:54:\"can-update-page-header-compatibility-to-header-builder\";b:1;s:36:\"can-reflect-cart-color-in-old-header\";b:0;s:30:\"add-outline-cart-bg-new-header\";b:0;s:41:\"remove-header-sections-deps-in-new-header\";b:0;s:35:\"support-swap-mobile-header-sections\";b:0;s:44:\"sticky-header-default-site-title-tagline-css\";b:0;s:19:\"shop-button-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:33:\"astra-product-gallery-layout-flag\";b:0;s:33:\"astra-woocommerce-cart-icons-flag\";b:0;s:22:\"shop-toolbar-structure\";a:2:{i:0;s:7:\"results\";i:1;s:7:\"sorting\";}s:37:\"shop-toolbar-structure-with-hiddenset\";a:4:{s:7:\"results\";b:1;s:7:\"filters\";b:0;s:7:\"sorting\";b:1;s:9:\"easy_view\";b:0;}s:22:\"is_theme_queue_running\";b:0;s:32:\"astra-old-global-sidebar-default\";b:0;s:20:\"dynamic-blog-layouts\";b:0;s:32:\"theme-dynamic-customizer-support\";b:1;s:41:\"ast-dynamic-single-elementor-hf-structure\";a:2:{i:0;s:37:\"ast-dynamic-single-elementor-hf-image\";i:1;s:37:\"ast-dynamic-single-elementor-hf-title\";}s:40:\"ast-dynamic-single-elementor-hf-metadata\";a:2:{i:0;s:8:\"comments\";i:1;s:6:\"author\";}s:30:\"ast-archive-elementor-hf-title\";b:1;s:29:\"ast-single-elementor-hf-title\";b:1;s:50:\"ast-dynamic-archive-elementor-hf-banner-image-type\";s:4:\"none\";s:49:\"ast-dynamic-archive-elementor-hf-banner-custom-bg\";a:3:{s:7:\"desktop\";a:11:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:11:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:11:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:50:\"ast-dynamic-archive-elementor-hf-title-font-family\";s:0:\"\";s:48:\"ast-dynamic-archive-elementor-hf-title-font-size\";a:6:{s:7:\"desktop\";i:40;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:50:\"ast-dynamic-archive-elementor-hf-title-font-weight\";s:0:\"\";s:50:\"ast-dynamic-archive-elementor-hf-title-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:51:\"ast-dynamic-archive-elementor-hf-banner-title-color\";s:0:\"\";s:50:\"ast-dynamic-archive-elementor-hf-banner-text-color\";s:0:\"\";s:50:\"ast-dynamic-single-elementor-hf-banner-title-color\";s:0:\"\";s:49:\"ast-dynamic-single-elementor-hf-title-font-family\";s:0:\"\";s:47:\"ast-dynamic-single-elementor-hf-title-font-size\";a:6:{s:7:\"desktop\";i:30;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:49:\"ast-dynamic-single-elementor-hf-title-font-weight\";s:0:\"\";s:49:\"ast-dynamic-single-elementor-hf-title-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:40:\"ast-dynamic-single-astra-sites-structure\";a:2:{i:0;s:36:\"ast-dynamic-single-astra-sites-image\";i:1;s:36:\"ast-dynamic-single-astra-sites-title\";}s:39:\"ast-dynamic-single-astra-sites-metadata\";a:2:{i:0;s:8:\"comments\";i:1;s:6:\"author\";}s:29:\"ast-archive-astra-sites-title\";b:1;s:28:\"ast-single-astra-sites-title\";b:1;s:49:\"ast-dynamic-archive-astra-sites-banner-image-type\";s:4:\"none\";s:48:\"ast-dynamic-archive-astra-sites-banner-custom-bg\";a:3:{s:7:\"desktop\";a:11:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:11:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:11:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:49:\"ast-dynamic-archive-astra-sites-title-font-family\";s:0:\"\";s:47:\"ast-dynamic-archive-astra-sites-title-font-size\";a:6:{s:7:\"desktop\";i:40;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:49:\"ast-dynamic-archive-astra-sites-title-font-weight\";s:0:\"\";s:49:\"ast-dynamic-archive-astra-sites-title-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:50:\"ast-dynamic-archive-astra-sites-banner-title-color\";s:0:\"\";s:49:\"ast-dynamic-archive-astra-sites-banner-text-color\";s:0:\"\";s:49:\"ast-dynamic-single-astra-sites-banner-title-color\";s:0:\"\";s:48:\"ast-dynamic-single-astra-sites-title-font-family\";s:0:\"\";s:46:\"ast-dynamic-single-astra-sites-title-font-size\";a:6:{s:7:\"desktop\";i:30;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:48:\"ast-dynamic-single-astra-sites-title-font-weight\";s:0:\"\";s:48:\"ast-dynamic-single-astra-sites-title-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:39:\"ast-dynamic-single-site-pages-structure\";a:2:{i:0;s:35:\"ast-dynamic-single-site-pages-image\";i:1;s:35:\"ast-dynamic-single-site-pages-title\";}s:38:\"ast-dynamic-single-site-pages-metadata\";a:2:{i:0;s:8:\"comments\";i:1;s:6:\"author\";}s:28:\"ast-archive-site-pages-title\";b:1;s:27:\"ast-single-site-pages-title\";b:1;s:48:\"ast-dynamic-archive-site-pages-banner-image-type\";s:4:\"none\";s:47:\"ast-dynamic-archive-site-pages-banner-custom-bg\";a:3:{s:7:\"desktop\";a:11:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:11:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:11:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:48:\"ast-dynamic-archive-site-pages-title-font-family\";s:0:\"\";s:46:\"ast-dynamic-archive-site-pages-title-font-size\";a:6:{s:7:\"desktop\";i:40;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:48:\"ast-dynamic-archive-site-pages-title-font-weight\";s:0:\"\";s:48:\"ast-dynamic-archive-site-pages-title-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:49:\"ast-dynamic-archive-site-pages-banner-title-color\";s:0:\"\";s:48:\"ast-dynamic-archive-site-pages-banner-text-color\";s:0:\"\";s:48:\"ast-dynamic-single-site-pages-banner-title-color\";s:0:\"\";s:47:\"ast-dynamic-single-site-pages-title-font-family\";s:0:\"\";s:45:\"ast-dynamic-single-site-pages-title-font-size\";a:6:{s:7:\"desktop\";i:30;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:47:\"ast-dynamic-single-site-pages-title-font-weight\";s:0:\"\";s:47:\"ast-dynamic-single-site-pages-title-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:41:\"ast-dynamic-single-astra-blocks-structure\";a:2:{i:0;s:37:\"ast-dynamic-single-astra-blocks-image\";i:1;s:37:\"ast-dynamic-single-astra-blocks-title\";}s:40:\"ast-dynamic-single-astra-blocks-metadata\";a:2:{i:0;s:8:\"comments\";i:1;s:6:\"author\";}s:30:\"ast-archive-astra-blocks-title\";b:1;s:29:\"ast-single-astra-blocks-title\";b:1;s:50:\"ast-dynamic-archive-astra-blocks-banner-image-type\";s:4:\"none\";s:49:\"ast-dynamic-archive-astra-blocks-banner-custom-bg\";a:3:{s:7:\"desktop\";a:11:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:11:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:11:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:50:\"ast-dynamic-archive-astra-blocks-title-font-family\";s:0:\"\";s:48:\"ast-dynamic-archive-astra-blocks-title-font-size\";a:6:{s:7:\"desktop\";i:40;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:50:\"ast-dynamic-archive-astra-blocks-title-font-weight\";s:0:\"\";s:50:\"ast-dynamic-archive-astra-blocks-title-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:51:\"ast-dynamic-archive-astra-blocks-banner-title-color\";s:0:\"\";s:50:\"ast-dynamic-archive-astra-blocks-banner-text-color\";s:0:\"\";s:50:\"ast-dynamic-single-astra-blocks-banner-title-color\";s:0:\"\";s:49:\"ast-dynamic-single-astra-blocks-title-font-family\";s:0:\"\";s:47:\"ast-dynamic-single-astra-blocks-title-font-size\";a:6:{s:7:\"desktop\";i:30;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:49:\"ast-dynamic-single-astra-blocks-title-font-weight\";s:0:\"\";s:49:\"ast-dynamic-single-astra-blocks-title-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"ast-dynamic-single-post-structure\";a:3:{i:0;s:29:\"ast-dynamic-single-post-image\";i:1;s:29:\"ast-dynamic-single-post-title\";i:2;s:28:\"ast-dynamic-single-post-meta\";}s:32:\"ast-dynamic-single-post-taxonomy\";s:8:\"category\";s:22:\"ast-archive-post-title\";b:1;s:21:\"ast-single-post-title\";b:1;s:42:\"ast-dynamic-archive-post-banner-image-type\";s:4:\"none\";s:41:\"ast-dynamic-archive-post-banner-custom-bg\";a:3:{s:7:\"desktop\";a:11:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:11:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:11:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:42:\"ast-dynamic-archive-post-title-font-family\";s:0:\"\";s:40:\"ast-dynamic-archive-post-title-font-size\";a:6:{s:7:\"desktop\";i:40;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:42:\"ast-dynamic-archive-post-title-font-weight\";s:0:\"\";s:42:\"ast-dynamic-archive-post-title-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:43:\"ast-dynamic-archive-post-banner-title-color\";s:0:\"\";s:42:\"ast-dynamic-archive-post-banner-text-color\";s:0:\"\";s:42:\"ast-dynamic-single-post-banner-title-color\";s:0:\"\";s:41:\"ast-dynamic-single-post-title-font-family\";s:0:\"\";s:39:\"ast-dynamic-single-post-title-font-size\";a:6:{s:7:\"desktop\";i:30;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:41:\"ast-dynamic-single-post-title-font-weight\";s:0:\"\";s:41:\"ast-dynamic-single-post-title-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"ast-dynamic-single-page-structure\";a:1:{i:0;s:29:\"ast-dynamic-single-page-title\";}s:32:\"ast-dynamic-single-page-metadata\";a:2:{i:0;s:8:\"comments\";i:1;s:6:\"author\";}s:22:\"ast-archive-page-title\";b:1;s:21:\"ast-single-page-title\";b:1;s:42:\"ast-dynamic-archive-page-banner-image-type\";s:4:\"none\";s:41:\"ast-dynamic-archive-page-banner-custom-bg\";a:3:{s:7:\"desktop\";a:11:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:11:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:11:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:42:\"ast-dynamic-archive-page-title-font-family\";s:0:\"\";s:40:\"ast-dynamic-archive-page-title-font-size\";a:6:{s:7:\"desktop\";i:40;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:42:\"ast-dynamic-archive-page-title-font-weight\";s:0:\"\";s:42:\"ast-dynamic-archive-page-title-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:43:\"ast-dynamic-archive-page-banner-title-color\";s:0:\"\";s:42:\"ast-dynamic-archive-page-banner-text-color\";s:0:\"\";s:42:\"ast-dynamic-single-page-banner-title-color\";s:0:\"\";s:41:\"ast-dynamic-single-page-title-font-family\";s:0:\"\";s:39:\"ast-dynamic-single-page-title-font-size\";a:6:{s:7:\"desktop\";i:30;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:41:\"ast-dynamic-single-page-title-font-weight\";s:0:\"\";s:41:\"ast-dynamic-single-page-title-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:31:\"archive-download-content-layout\";s:7:\"default\";s:31:\"archive-download-sidebar-layout\";s:10:\"no-sidebar\";s:30:\"single-download-content-layout\";s:7:\"default\";s:30:\"single-download-sidebar-layout\";s:7:\"default\";s:25:\"update-default-color-typo\";b:0;s:22:\"v4-block-editor-compat\";b:0;s:23:\"v4-1-0-update-migration\";b:1;s:27:\"single-product-payment-list\";a:1:{s:5:\"items\";a:4:{i:0;a:6:{s:2:\"id\";s:8:\"item-100\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:4:\"icon\";s:7:\"cc-visa\";s:5:\"image\";s:0:\"\";s:5:\"label\";s:4:\"Visa\";}i:1;a:6:{s:2:\"id\";s:8:\"item-101\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:4:\"icon\";s:13:\"cc-mastercard\";s:5:\"image\";s:0:\"\";s:5:\"label\";s:10:\"Mastercard\";}i:2;a:6:{s:2:\"id\";s:8:\"item-102\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:4:\"icon\";s:7:\"cc-amex\";s:5:\"image\";s:0:\"\";s:5:\"label\";s:4:\"Amex\";}i:3;a:6:{s:2:\"id\";s:8:\"item-103\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:4:\"icon\";s:11:\"cc-discover\";s:5:\"image\";s:0:\"\";s:5:\"label\";s:8:\"Discover\";}}}s:23:\"v4-1-4-update-migration\";b:1;s:27:\"list-block-vertical-spacing\";b:0;s:18:\"add-hr-styling-css\";b:0;s:32:\"astra-site-svg-logo-equal-height\";b:0;s:26:\"archive-post-content-style\";s:7:\"default\";s:25:\"fullwidth_sidebar_support\";b:0;s:23:\"v4-2-0-update-migration\";b:1;s:29:\"v4-2-2-core-form-btns-styling\";b:0;s:22:\"v4-4-0-backward-option\";b:0;s:48:\"secondary-theme-button-border-group-border-color\";s:25:\"var(--ast-global-color-0)\";s:50:\"secondary-theme-button-border-group-border-h-color\";s:25:\"var(--ast-global-color-5)\";s:69:\"ast-dynamic-single-templates-article-featured-image-position-layout-1\";s:4:\"none\";s:69:\"ast-dynamic-single-templates-article-featured-image-position-layout-2\";s:4:\"none\";s:62:\"ast-dynamic-single-templates-article-featured-image-ratio-type\";s:7:\"default\";s:72:\"ast-dynamic-single-elementor-hf-article-featured-image-position-layout-1\";s:4:\"none\";s:72:\"ast-dynamic-single-elementor-hf-article-featured-image-position-layout-2\";s:4:\"none\";s:65:\"ast-dynamic-single-elementor-hf-article-featured-image-ratio-type\";s:7:\"default\";s:71:\"ast-dynamic-single-astra-sites-article-featured-image-position-layout-1\";s:4:\"none\";s:71:\"ast-dynamic-single-astra-sites-article-featured-image-position-layout-2\";s:4:\"none\";s:64:\"ast-dynamic-single-astra-sites-article-featured-image-ratio-type\";s:7:\"default\";s:70:\"ast-dynamic-single-site-pages-article-featured-image-position-layout-1\";s:4:\"none\";s:70:\"ast-dynamic-single-site-pages-article-featured-image-position-layout-2\";s:4:\"none\";s:63:\"ast-dynamic-single-site-pages-article-featured-image-ratio-type\";s:7:\"default\";s:72:\"ast-dynamic-single-astra-blocks-article-featured-image-position-layout-1\";s:4:\"none\";s:72:\"ast-dynamic-single-astra-blocks-article-featured-image-position-layout-2\";s:4:\"none\";s:65:\"ast-dynamic-single-astra-blocks-article-featured-image-ratio-type\";s:7:\"default\";s:64:\"ast-dynamic-single-post-article-featured-image-position-layout-1\";s:4:\"none\";s:64:\"ast-dynamic-single-post-article-featured-image-position-layout-2\";s:4:\"none\";s:57:\"ast-dynamic-single-post-article-featured-image-ratio-type\";s:7:\"default\";s:64:\"ast-dynamic-single-page-article-featured-image-position-layout-1\";s:4:\"none\";s:64:\"ast-dynamic-single-page-article-featured-image-position-layout-2\";s:4:\"none\";s:57:\"ast-dynamic-single-page-article-featured-image-ratio-type\";s:7:\"default\";s:22:\"v4-5-0-backward-option\";b:0;s:26:\"scndry-btn-default-padding\";b:0;s:22:\"v4-6-0-backward-option\";b:0;s:21:\"ast-font-style-update\";b:0;s:22:\"v4-6-2-backward-option\";b:0;s:20:\"btn-stylings-upgrade\";b:0;s:24:\"elementor-headings-style\";b:0;s:33:\"elementor-container-padding-style\";b:0;s:34:\"global-headings-line-height-update\";b:1;s:37:\"single_posts_pages_heading_clear_none\";b:0;s:21:\"elementor-btn-styling\";b:1;s:52:\"remove_single_posts_navigation_mobile_device_padding\";b:1;s:27:\"enable-4-6-14-compatibility\";b:0;s:24:\"heading-widget-font-size\";b:0;s:26:\"enable-4-8-0-compatibility\";b:0;s:22:\"v4-8-2-backward-option\";b:0;s:26:\"enable-4-8-4-compatibility\";b:0;s:37:\"astra-heading-font-size-compatibility\";b:0;s:26:\"enable-4-8-9-compatibility\";b:0;s:16:\"star-rating-comp\";b:0;s:22:\"v4-9-0-backward-option\";b:0;s:19:\"header-preset-style\";s:8:\"preset_3\";s:16:\"hb-inner-spacing\";a:1:{s:7:\"desktop\";i:50;}}", "on");
INSERT INTO `wp_options` VALUES("2852", "elementor_onboarded", "1", "auto");
INSERT INTO `wp_options` VALUES("2853", "elementor_active_kit", "95", "auto");
INSERT INTO `wp_options` VALUES("2854", "elementor_font_display", "swap", "auto");
INSERT INTO `wp_options` VALUES("2857", "elementor_landing_pages_activation", "0", "auto");
INSERT INTO `wp_options` VALUES("2858", "elementor_version", "3.30.3", "auto");
INSERT INTO `wp_options` VALUES("2859", "elementor_install_history", "a:3:{s:6:\"3.28.3\";i:1744132814;s:6:\"3.29.2\";i:1750440791;s:6:\"3.30.3\";i:1753812596;}", "auto");
INSERT INTO `wp_options` VALUES("2860", "elementor_events_db_version", "1.0.0", "off");
INSERT INTO `wp_options` VALUES("2862", "elementor_checklist", "{\"last_opened_timestamp\":null,\"first_closed_checklist_in_editor\":true,\"is_popup_minimized\":false,\"steps\":{\"add_logo\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"set_fonts_and_colors\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"create_pages\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"setup_header\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"assign_homepage\":{\"is_marked_completed\":false,\"is_immutable_completed\":false}},\"should_open_in_editor\":false}", "auto");
INSERT INTO `wp_options` VALUES("2863", "_elementor_installed_time", "1744132814", "auto");
INSERT INTO `wp_options` VALUES("2864", "elementor_connect_site_key", "7053b9341fe3012df065ad3d11d0de5b", "auto");
INSERT INTO `wp_options` VALUES("2865", "elementor_remote_info_library", "a:3:{s:10:\"types_data\";a:4:{s:5:\"block\";a:2:{s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:4:\"sets\";a:5:{i:0;s:11:\"Boxing Club\";i:1;s:19:\"Business Consultant\";i:2;s:16:\"Marketing Agency\";i:3;s:9:\"Wireframe\";i:4;s:15:\"Workshop Center\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}s:2:\"lp\";a:1:{s:10:\"categories\";a:15:{i:0;s:8:\"Business\";i:1;s:16:\"Coming Soon Page\";i:2;s:9:\"eCommerce\";i:3;s:9:\"Education\";i:4;s:6:\"Events\";i:5;s:18:\"Health and Fitness\";i:6;s:3:\"NFT\";i:7;s:14:\"Online Service\";i:8;s:7:\"Product\";i:9;s:11:\"Real Estate\";i:10;s:18:\"Social Involvement\";i:11;s:14:\"Thank You Page\";i:12;s:6:\"Travel\";i:13;s:18:\"Under Construction\";i:14;s:9:\"Wireframe\";}}s:2:\"lb\";a:1:{s:10:\"categories\";a:2:{i:0;s:4:\"post\";i:1;s:7:\"product\";}}}s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:9:\"templates\";a:4:{i:0;a:20:{s:4:\"tmpl\";i:1254;s:2:\"id\";i:20472;s:5:\"title\";s:10:\"test ido f\";s:9:\"thumbnail\";s:153:\"https://library.stg.elementor.red/wp-content/uploads/2025/01/png-clipart-logo-harry-potter-literary-series-lord-voldemort-film-harry-potter-thumbnail.png\";s:12:\"tmpl_created\";i:1751356263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.stg.elementor.red/blocks/test-ido-f/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:1;a:20:{s:4:\"tmpl\";i:1227;s:2:\"id\";i:19968;s:5:\"title\";s:12:\"Zeyad Test 1\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_2.jpg\";s:12:\"tmpl_created\";i:1670765723;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.stg.elementor.red/blocks/zeyad-test-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:2;a:20:{s:4:\"tmpl\";i:1231;s:2:\"id\";i:19494;s:5:\"title\";s:5:\"test2\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_4.jpg\";s:12:\"tmpl_created\";i:1672308146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.stg.elementor.red/blocks/test2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:3;a:20:{s:4:\"tmpl\";i:1209;s:2:\"id\";i:9631;s:5:\"title\";s:38:\"Slide-in | Sale | Register | Subscribe\";s:9:\"thumbnail\";s:87:\"https://library.stg.elementor.red/wp-content/uploads/2019/01/Slide-in_Sale_small_01.png\";s:12:\"tmpl_created\";i:1660034300;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.stg.elementor.red/popups/slide-in-sale-01/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:142;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}}}", "off");
INSERT INTO `wp_options` VALUES("2866", "elementor_remote_info_feed_data", "a:3:{i:0;a:5:{s:5:\"title\";s:76:\"Introducing Elementor 3.32: Transitions, Transform, Size Variables, and More\";s:7:\"excerpt\";s:250:\"Elementor 3.32 is here, accelerating Editor V4 Alpha with transform controls and layered transitions, system-wide Size Variables and streamlined class management. This release empowers you to build more consistent, dynamic, and professional websites.\";s:7:\"created\";i:1759243152;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:138:\"https://elementor.com/blog/elementor-332-v4-transform-transitions/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:1;a:5:{s:5:\"title\";s:70:\"Introducing Elementor 3.31: New Editor V4 Variables, Filters, and More\";s:7:\"excerpt\";s:294:\"Elementor 3.31 is here, pushing Editor V4 forward with powerful design system enhancements and modern visual styling tools. From Variables and Filters to smarter editing workflows and semantic markup, this version makes it easier than ever to design beautiful, performant, and accessible sites.\";s:7:\"created\";i:1755094220;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:140:\"https://elementor.com/blog/elementor-331-v4-alpha-variables-filters/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:2;a:5:{s:5:\"title\";s:67:\"What Is an MCP? The AI Breakthrough Web Creators Shouldn’t Ignore\";s:7:\"excerpt\";s:143:\"Discover how Model Context Protocol (MCP) is shaping AI-tool interaction and redefining how pro web creators build, manage, and scale websites.\";s:7:\"created\";i:1754310811;s:5:\"badge\";s:0:\"\";s:3:\"url\";s:130:\"https://elementor.com/blog/mcp-explained-for-web-creators/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}}", "off");
INSERT INTO `wp_options` VALUES("2870", "_elementor_notifications_data", "a:2:{s:7:\"timeout\";i:1744655453;s:5:\"value\";s:12896:\"[{\"id\":\"hello-biz-contact\",\"title\":\"New Contact Widget, Visual Layout Presets & more\",\"description\":\"Hello Biz just got an update! Explore the new Contact Widget, Visual Layout Presets, Form Submissions integration, and fresh new kits.\",\"topic\":\"Hello Biz\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/hello-biz-contact.png\",\"chipTags\":[\"New Features\"],\"link\":\"https:\\/\\/go.elementor.com\\/hello-biz-updates\",\"readMoreText\":\"Learn More\"},{\"id\":\"ai-site-planner-colors\",\"title\":\"Style Your Wireframe, Speed Up Your Store Build\",\"description\":\"Site Planner now lets you style your wireframe with fonts and colors - instantly visualizing your site\\u2019s look and feel. Plus, it predesigns pages for WooCommerce like Cart and Checkout, so you can dive straight into customizations\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/site-planner-colors.png\",\"chipTags\":[\"New Feature\"],\"link\":\"http:\\/\\/www.elementor.com\\/ai-site-planner\",\"readMoreText\":\"Learn More\"},{\"id\":\"ally-notification\",\"title\":\"Just released! Ally - a new plugin for web accessibility & usability\",\"description\":\"Ally simplifies the complexities of making your website more accessible. With new regulations here and coming, making your website more usable and inclusive is no longer just an option, but a must.\",\"topic\":\"Ally by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/ally-notification.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Get it free\",\"ctaLink\":\"https:\\/\\/wordpress.org\\/plugins\\/pojo-accessibility\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"pojo-accessibility\\/pojo-accessibility.php\"}]]},{\"id\":\"send-notification\",\"title\":\"Grow your business with Send: an intuitive platform for Email & SMS, natively built for WooCommerce.\",\"description\":\"Deliver powerful, automated email & SMS campaigns with Send\\u2014built for WooCommerce to help you boost conversions, drive growth, and go beyond just building websites.\",\"topic\":\"Send by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/send-notification.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Explore Send\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/AHSfdh\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"send-app\\/send-app.php\"}]]},{\"id\":\"ai-site-planner\",\"title\":\"Instant Sitemaps & Wireframes\",\"description\":\"Get your website plan in minutes with AI Site Planner. Describe your desired site and AI will generate a sitemap, brief and wireframe populated with initial content, ready for you to customize.\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/aI-site-planner.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/ai-notification-site-planner\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"grid-span-3.27\",\"title\":\"Design Grid layouts that fit your exact vision\",\"description\":\"Advanced column and row span controls give you the power to design Grid Container layouts that fit your exact vision.\",\"topic\":\"Elementor 3.27\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/grid-span-3.27.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.27-grid-span-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"local-fonts-3.27\",\"title\":\"Load Google Fonts safer and faster\",\"description\":\"Once enabled, Google Fonts are served directly from your server, streamlining the loading process and enhancing security.\",\"topic\":\"Elementor 3.27\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/local-google-fonts-3.27.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.27-local-fonts-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"video-shorts-3.27\",\"title\":\"Showcase short-form, vertical videos\",\"description\":\"The Video widget now supports YouTube Shorts in a vertical 9:16 ratio, the go-to format for engaging audiences.\",\"topic\":\"Elementor 3.27\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/video-shorts-3.27.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.27-video-shorts-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"dynamic-off-canvas-3.26\",\"title\":\"Dynamic Off-Canvas for Loop Grids\",\"description\":\"Create richer, more interactive designs by linking Dynamic Content to the Off Canvas widget, delivering seamless user experiences.\",\"topic\":\"Elementor Pro 3.26\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/off-canvas-loop-grids.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.26-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"dynamic-off-canvas-3.26\",\"title\":\"Dynamic Off-Canvas for Loop Grids\",\"description\":\"Create richer, more interactive designs by linking Dynamic Content to the Off Canvas widget, delivering seamless user experiences.\",\"topic\":\"Elementor Pro 3.26\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/off-canvas-loop-grids.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.26-loop-off-canvas\\/\"},{\"id\":\"css-loading-3.25\",\"title\":\"Boost Performance with Conditional CSS Loading\",\"description\":\"Boost performance by conditionally loading only the styles that each page needs, reducing the page CSS size by up to 668kb.\",\"topic\":\"Elementor 3.25\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.25-css-Loading.png\",\"chipTags\":[\"Performance\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3-25-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"image-optimizer-3.19\",\"title\":\"Effortlessly optimize images for a stunning, high-speed website with the Image Optimizer plugin.\",\"description\":\"Image Optimizer perfectly balances between image quality and performance to boost your website.  Resize, compress, and convert images to WebP, for faster loading times and and better user experience.\",\"topic\":\"Image Optimizer Plugin by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/image-optimizer-3.19.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Get the Image Optimizer\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/io-notification-wp-dash-learn-more\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"image-optimization\\/image-optimization.php\"}]]},{\"id\":\"variable-fonts-3.24\",\"title\":\"Elevate text design with Variable Fonts\",\"description\":\"Experience unparalleled fluidity in your design with precise control over text width and weight.\",\"topic\":\"Elementor Pro 3.24\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.24-variable-fonts.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.24-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"variable-fonts-3.24\",\"title\":\"Elevate text design with Variable Fonts\",\"description\":\"Experience unparalleled fluidity in your design with precise control over text width and weight.\",\"topic\":\"Elementor Pro 3.24\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.24-variable-fonts.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.24-blog\\/\",\"readMoreText\":\"Learn More\",\"cta\":\"Upgrade\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3-24-variable-fonts\\/\"},{\"id\":\"floating-bars-3.24\",\"title\":\"Increase conversion with Floating Bars\",\"description\":\"Place your most important messages and promotions at the top or bottom of your page seamlessly with over 30 pre-made templates.\",\"topic\":\"Elementor 3.24\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.24-floating-bar.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.24-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"ai-featured-image\",\"title\":\"Featured Image: Let AI Do the Work\",\"description\":\"Say goodbye to image searches! Let AI craft stunning featured images with a click, perfectly matching your content. No prompts needed. Discover how easy it is.\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/featured_ai.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/ai-notification-featured-image-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"introduction_meta\",\"meta\":\"ai_get_started\"}]],\"cta\":\"Start Free Trial\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/ai-notification-featured-image\\/\"},{\"id\":\"ai-featured-image\",\"title\":\"Featured Image: Let AI Do the Work\",\"description\":\"Say goodbye to image searches! Let AI craft stunning featured images with a click, perfectly matching your content. No prompts needed. Discover how easy it is.\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/featured_ai.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Start Free Trial\",\"link\":\"https:\\/\\/go.elementor.com\\/ai-notification-featured-image-blog\\/\",\"readMoreText\":\"Learn More\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/ai-notification-featured-image\\/\\/\"},{\"id\":\"search-widget-3.23\",\"title\":\"Increases site exploration with AJAX loading & live results\",\"description\":\"Enabling faster, more accurate content discovery and helping visitors find what they\'re looking for.\",\"topic\":\"Elementor Pro 3.23\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/search-widget-3.23.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3-23-features\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"search-widget-3.23\",\"title\":\"Increases site exploration with AJAX loading & live results\",\"description\":\"Enabling faster, more accurate content discovery and helping visitors find what they\'re looking for.\",\"topic\":\"Elementor Pro 3.23\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/search-widget-3.23.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3-23-features\\/\",\"readMoreText\":\"Learn More\",\"cta\":\"Upgrade\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-search-widget\\/\"},{\"id\":\"floating-buttons-3.23\",\"title\":\"Get more leads with Floating Buttons\",\"description\":\"Empowering you to increase conversion by seamlessly integrating a direct link to a chat or different platforms in the form of a floating button.\",\"topic\":\"Elementor 3.23\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/floating-buttons-3.23.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3-23-features-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"link-in-bio-3.23\",\"title\":\"New Link in Bio Widgets for any Purpose\",\"description\":\"Create a polished and professional page with just a few clicks and effectively showcase all your important links. Choose from 7 unique widgets and over 60 templates!\",\"topic\":\"Elementor 3.23\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/link-in-bio-3.23.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-link-in-bio-3-23-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"nested-elements-3.23\",\"title\":\"Work faster on Nested Elements\",\"description\":\"Customize Nested Elements faster with version 3.23. Now every change to a Nested Element will only affect the relevant element and not require reloading the entire widget, improving Editor interaction time by 60%-98%.\",\"topic\":\"Elementor 3.23\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/nested-elements-3.23.png\",\"chipTags\":[\"Performance\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3-23-features-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"5-star-rating-prompt\",\"title\":\"Love the New Features? Let Us Know with 5 Stars!\",\"description\":\"Help spread the word by telling the world what you love about Elementor.\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/5-star-rating-prompt.png\",\"cta\":\"Leave a Review\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/wp-dash-notification-five-stars\\/\"},{\"id\":\"site-mailer-introducing\",\"title\":\"Introducing Site Mailer\",\"description\":\"Keep your WordPress emails out of the spam folder with improved deliverability and an easy setup\\u2014no need for an SMTP plugin or complicated configurations.\",\"topic\":\"Site Mailer Plugin by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/Site-mailer.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Start Free Trial\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/sm-wp-dash-whatsnew\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"site-mailer\\/site-mailer.php\"}]]}]\";}", "off");
INSERT INTO `wp_options` VALUES("2873", "_elementor_home_screen_data", "a:2:{s:7:\"timeout\";i:1744136445;s:5:\"value\";s:10665:\"{\"top_with_licences\":[{\"license\":[\"free\"],\"title_small\":\"Hi!\",\"title\":\"Unleash your imagination with Elementor\",\"description\":\"Start building your website with Elementor\'s no code drag & drop editor.\",\"button_create_page_title\":\"Create a Page\",\"button_watch_title\":\"Watch a guide\",\"button_watch_url\":\"https:\\/\\/www.youtube.com\\/watch?v=le72grP_Q6k&t=1s\",\"youtube_embed_id\":\"le72grP_Q6k?si=g2akyWNODL6usu6u\"},{\"license\":[\"pro\"],\"title_small\":\"Hi!\",\"title\":\"Unleash your imagination with Elementor\",\"description\":\"Now you\'ve got all the tools to start creating professional, high-performing websites - and that journey begins by creating your first page.\",\"button_create_page_title\":\"Create a Page\",\"button_watch_title\":\"Watch a guide\",\"button_watch_url\":\"https:\\/\\/www.youtube.com\\/watch?v=QdkDGrS8ZZs\",\"youtube_embed_id\":\"QdkDGrS8ZZs?si=s_VjZCQR6Fh1jgB5\"}],\"get_started\":[{\"license\":[\"free\"],\"header\":{\"title\":\"Jumpstart your web-creation\",\"description\":\"These quick actions will get your site airborne with a customized design.\"},\"repeater\":[{\"title\":\"Site Settings\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-settings.svg\"},{\"title\":\"Site Logo\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"tab_id\":\"settings-site-identity\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-logo.svg\"},{\"title\":\"Global Colors\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"tab_id\":\"global-colors\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/global-colors.svg\"},{\"title\":\"Global Fonts\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"tab_id\":\"global-typography\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/global-fonts.svg\"},{\"title\":\"Theme Builder\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor-app\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/theme-builder.svg\"},{\"title\":\"Popups\",\"title_small\":\"Customize\",\"url\":\"edit.php?post_type=elementor_library&page=popup_templates\",\"is_relative_url\":true,\"title_small_color\":\"text.tertiary\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/popups.svg\"},{\"title\":\"Custom Icons\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor_custom_icons\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/custom-icons.svg\"},{\"title\":\"Custom Fonts\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor_custom_fonts\",\"is_relative_url\":true,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/custom-fonts.svg\",\"title_small_color\":\"text.tertiary\"}]},{\"license\":[\"pro\"],\"header\":{\"title\":\"Jumpstart your web-creation\",\"description\":\"These quick actions will get your site airborne with a customized design.\"},\"repeater\":[{\"title\":\"Site Settings\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-settings.svg\"},{\"title\":\"Site Logo\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"tab_id\":\"settings-site-identity\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-logo.svg\"},{\"title\":\"Global Colors\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"tab_id\":\"global-colors\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/global-colors.svg\"},{\"title\":\"Global Fonts\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"tab_id\":\"global-typography\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/global-fonts.svg\"},{\"title\":\"Theme Builder\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor-app\",\"is_relative_url\":false,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/theme-builder.svg\"},{\"title\":\"Popups\",\"title_small\":\"Customize\",\"url\":\"edit.php?post_type=elementor_library&tabs_group=popup&elementor_library_type=popup\",\"is_relative_url\":true,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/popups.svg\"},{\"title\":\"Custom Icons\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor_custom_icons\",\"is_relative_url\":false,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/custom-icons.svg\"},{\"title\":\"Custom Fonts\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor_custom_fonts\",\"is_relative_url\":true,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/custom-fonts.svg\"}]}],\"add_ons\":{\"header\":{\"title\":\"Expand your design toolkit\",\"description\":\"These plugins, add-ons, and tools, have been selected to streamline your workflow and maximize your creativity.\"},\"repeater\":[{\"file_path\":\"send-app\\/send-app.php\",\"title\":\"Send \\u2013 Marketing Automation\",\"url\":\"\",\"description\":\"Supercharge your WooCommerce store with Send\\u2014an all-in-one toolkit for emails, popups & more. Built for WordPress. No plugins, no hassle.\",\"button_label\":\"Install\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/send-logo.svg\",\"type\":\"wporg\"},{\"file_path\":\"site-mailer\\/site-mailer.php\",\"title\":\"Site Mailer\",\"url\":\"\",\"description\":\"Keep your WordPress emails out of the spam folder with improved deliverability and an easy setup\\u2014no need for an SMTP plugin or complicated configurations.\",\"button_label\":\"Install\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-mailer.svg\",\"type\":\"wporg\"},{\"file_path\":\"image-optimization\\/image-optimization.php\",\"title\":\"Image Optimizer\",\"url\":\"https:\\/\\/go.elementor.com\\/wp-dash-apps-author-uri-elementor-io\\/\",\"description\":\"Check out this incredibly useful plugin that will compress and optimize your images, giving you leaner, faster websites.\",\"button_label\":\"Install\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/image-optimizer.svg\",\"type\":\"wporg\"},{\"title\":\"Elementor AI\",\"url\":\"https:\\/\\/go.elementor.com\\/wp-dash-apps-author-uri-elementor-ai\\/\",\"description\":\"Boost creativity with Elementor AI. Craft & enhance copy, create custom CSS & Code, and generate images to elevate your website.\",\"button_label\":\"Let\'s go\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/elementor.svg\",\"type\":\"link\",\"condition\":{\"key\":\"introduction_meta\",\"value\":\"ai_get_started\"}}],\"footer\":{\"label\":\"Explore more add-ons\",\"file_path\":\"wp-admin\\/admin.php?page=elementor-apps\"}},\"sidebar_upgrade\":[{\"license\":[\"free\"],\"show\":\"true\",\"header\":{\"title\":\"Bring your vision to life\",\"description\":\"Get complete design flexibility for your website with Elementor Pro\\u2019s advanced tools and premium features.\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"cta\":{\"label\":\"Upgrade Now\",\"url\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-upgrade\\/\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"repeater\":[{\"title\":\"Popup Builder\"},{\"title\":\"Custom Code & CSS\"},{\"title\":\"E-commerce Features\"},{\"title\":\"Collaborative Notes\"},{\"title\":\"Form Submission\"},{\"title\":\"Form Integrations\"},{\"title\":\"Custom Attributes\"},{\"title\":\"Role Manager\"}]},{\"license\":[\"pro\"],\"show\":\"false\",\"header\":{\"title\":\"Bring your vision to life\",\"description\":\"Get complete design flexibility for your website with Elementor Pro\\u2019s advanced tools and premium features.\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"cta\":{\"label\":\"Upgrade Now\",\"url\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-upgrade\\/\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"repeater\":[{\"title\":\"Popup Builder\"},{\"title\":\"Custom Code & CSS\"},{\"title\":\"E-commerce Features\"},{\"title\":\"Collaborative Notes\"},{\"title\":\"Form Submission\"},{\"title\":\"Form Integrations\"},{\"title\":\"Custom Attributes\"},{\"title\":\"Role Manager\"}]}],\"sidebar_promotion_variants\":[{\"license\":[\"essential\"],\"is_enabled\":\"true\",\"type\":\"banner\",\"data\":{\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/essential-upgrade.svg\",\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-advanced-home-sidebar-upgrade\\/\"}},{\"license\":[\"free\"],\"is_enabled\":\"true\",\"type\":\"banner\",\"data\":{\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/upgrade-free.svg\",\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-upgrade\\/\"}},{\"license\":[\"free\"],\"is_enabled\":\"false\",\"type\":\"default\",\"data\":{\"header\":{\"title\":\"Bring your vision to life\",\"description\":\"Get complete design flexibility for your website with Elementor Pro\\u2019s advanced tools and premium features.\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/update-sidebar.svg\"},\"cta\":{\"label\":\"Upgrade Now\",\"url\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-upgrade\\/\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"repeater\":[{\"title\":\"Popup Builder\"},{\"title\":\"Custom Code & CSS\"},{\"title\":\"E-commerce Features\"},{\"title\":\"Collaborative Notes\"},{\"title\":\"Form Submission\"},{\"title\":\"Form Integrations\"},{\"title\":\"Custom Attributes\"},{\"title\":\"Role Manager\"}]}},{\"license\":[\"pro\"],\"is_enabled\":\"false\",\"type\":\"default\",\"data\":{\"header\":{\"title\":\"Bring your vision to life\",\"description\":\"Get complete design flexibility for your website with Elementor Pro\\u2019s advanced tools and premium features.\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/update-sidebar.svg\"},\"cta\":{\"label\":\"Upgrade Now\",\"url\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-upgrade\\/\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"repeater\":[{\"title\":\"Popup Builder\"},{\"title\":\"Custom Code & CSS\"},{\"title\":\"E-commerce Features\"},{\"title\":\"Collaborative Notes\"},{\"title\":\"Form Submission\"},{\"title\":\"Form Integrations\"},{\"title\":\"Custom Attributes\"},{\"title\":\"Role Manager\"}]}}],\"external_links\":[{\"label\":\"Help Center\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-question-mark.svg\",\"url\":\"https:\\/\\/elementor.com\\/help\\/\"},{\"label\":\"Youtube\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-youtube.svg\",\"url\":\"https:\\/\\/www.youtube.com\\/@Elementor\"},{\"label\":\"Facebook Community\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-community.svg\",\"url\":\"https:\\/\\/www.facebook.com\\/groups\\/Elementors\"},{\"label\":\"Blog\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-academic-hat.svg\",\"url\":\"https:\\/\\/elementor.com\\/blog\\/\"}]}\";}", "off");
INSERT INTO `wp_options` VALUES("2876", "e_editor_counter", "26", "auto");
INSERT INTO `wp_options` VALUES("2877", "_elementor_free_to_pro_upsell", "a:2:{s:7:\"timeout\";i:1744655453;s:5:\"value\";s:593:\"[{\"id\":\"animated_headline\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/animated_headline.jpg\"},{\"id\":\"video_playlist\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/video_playlist.jpg\"},{\"id\":\"cta\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/cta.jpg\"},{\"id\":\"testimonial_widget\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/testimonial_widget.jpg\"},{\"id\":\"image_carousel\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/image_carousel.jpg\"}]\";}", "off");
INSERT INTO `wp_options` VALUES("2878", "_elementor_local_google_fonts", "a:4:{s:6:\"roboto\";a:2:{s:3:\"url\";s:81:\"https://zaynventures.com/wp-content/uploads/elementor/google-fonts/css/roboto.css\";s:7:\"version\";i:1744132913;}s:10:\"robotoslab\";a:2:{s:3:\"url\";s:85:\"https://zaynventures.com/wp-content/uploads/elementor/google-fonts/css/robotoslab.css\";s:7:\"version\";i:1744132918;}s:7:\"poppins\";a:2:{s:3:\"url\";s:82:\"https://zaynventures.com/wp-content/uploads/elementor/google-fonts/css/poppins.css\";s:7:\"version\";i:1744456513;}s:5:\"rubik\";a:2:{s:3:\"url\";s:80:\"https://zaynventures.com/wp-content/uploads/elementor/google-fonts/css/rubik.css\";s:7:\"version\";i:1744458103;}}", "auto");
INSERT INTO `wp_options` VALUES("3385", "elementor_allow_tracking", "yes", "auto");
INSERT INTO `wp_options` VALUES("3386", "elementor_tracker_last_send", "1764523645", "auto");
INSERT INTO `wp_options` VALUES("3405", "nps-survey-astra", "a:6:{s:13:\"dismiss_count\";i:0;s:19:\"dismiss_permanently\";b:0;s:12:\"dismiss_step\";s:0:\"\";s:12:\"dismiss_time\";s:0:\"\";s:16:\"dismiss_timespan\";N;s:17:\"first_render_time\";i:1744455658;}", "auto");
INSERT INTO `wp_options` VALUES("3413", "bsf_product_referers", "a:5:{s:29:\"ultimate-addons-for-gutenberg\";s:5:\"astra\";s:11:\"astra-sites\";s:29:\"ultimate-addons-for-gutenberg\";s:23:\"header-footer-elementor\";s:11:\"astra-sites\";s:9:\"suremails\";s:11:\"astra-sites\";s:9:\"latepoint\";s:11:\"astra-sites\";}", "auto");
INSERT INTO `wp_options` VALUES("3415", "__uagb_do_redirect", "", "auto");
INSERT INTO `wp_options` VALUES("3416", "__uagb_activated_before", "1", "auto");
INSERT INTO `wp_options` VALUES("3417", "__uagb_asset_version", "1764861635", "auto");
INSERT INTO `wp_options` VALUES("3418", "uagb_site_url", "zaynventures-com", "auto");
INSERT INTO `wp_options` VALUES("3419", "_uagb_allow_file_generation", "enabled", "auto");
INSERT INTO `wp_options` VALUES("3420", "uagb-version", "2.19.15", "auto");
INSERT INTO `wp_options` VALUES("3421", "spectra_analytics_installed_time", "1744455760", "off");
INSERT INTO `wp_options` VALUES("3422", "ast-block-templates-version", "2.4.8", "auto");
INSERT INTO `wp_options` VALUES("3425", "uag_content_width_set_by", "Astra Theme", "auto");
INSERT INTO `wp_options` VALUES("3426", "nps-survey-spectra", "a:6:{s:13:\"dismiss_count\";i:0;s:19:\"dismiss_permanently\";b:0;s:12:\"dismiss_step\";s:0:\"\";s:12:\"dismiss_time\";s:0:\"\";s:16:\"dismiss_timespan\";N;s:17:\"first_render_time\";i:1744455760;}", "auto");
INSERT INTO `wp_options` VALUES("3436", "astra-sites-last-export-checksums-latest", "6Ol^oi%&iJ)^", "off");
INSERT INTO `wp_options` VALUES("3439", "astra-sites-batch-status-string", "Complete storing data for page 56", "off");
INSERT INTO `wp_options` VALUES("3440", "astra-blocks-batch-status-string", "Complete storing data for page 4", "off");
INSERT INTO `wp_options` VALUES("3443", "astra-sites-fresh-site", "no", "off");
INSERT INTO `wp_options` VALUES("3444", "ai_builder_recent_import_log_file", "/home/u577685627/domains/zaynventures.com/public_html/wp-content/uploads/ai-builder/import-12-Apr-2025-11-03-38-d9b9304b1692c8415a6a9a75e6b65a95.log", "off");
INSERT INTO `wp_options` VALUES("3445", "bsf_analytics_installed_time", "1744455818", "off");
INSERT INTO `wp_options` VALUES("3450", "astra-sites-batch-is-complete", "yes", "off");
INSERT INTO `wp_options` VALUES("3451", "astra-sites-last-export-checksums", "6Ol^oi%&iJ)^", "off");
INSERT INTO `wp_options` VALUES("3452", "uag_container_global_padding", "10", "auto");
INSERT INTO `wp_options` VALUES("3453", "astra_sites_settings", "a:2:{s:12:\"page_builder\";s:9:\"elementor\";s:20:\"dismiss_ai_promotion\";s:4:\"true\";}", "off");
INSERT INTO `wp_options` VALUES("3479", "surecart_source", "starter_templates", "off");
INSERT INTO `wp_options` VALUES("3480", "wcf_setup_skipped", "1", "auto");
INSERT INTO `wp_options` VALUES("3483", "elementor_load_fa4_shim", "", "auto");
INSERT INTO `wp_options` VALUES("3487", "elementor_log", "a:13:{s:32:\"f99eb5ed417492ef28b6b3000203a316\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-04-12 11:14:59\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:61:\"Cannot read properties of undefined (reading &#039;get&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-12 11:14:59\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1744456499\";s:7:\"message\";s:51:\"Cannot read properties of undefined (reading \'get\')\";s:3:\"url\";s:88:\"https://zaynventures.com/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.28.3\";s:4:\"line\";s:1:\"3\";s:6:\"column\";s:6:\"797868\";}s:7:\"\0*\0file\";s:88:\"https://zaynventures.com/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.28.3\";s:7:\"\0*\0line\";s:1:\"3\";s:9:\"\0*\0column\";s:6:\"797868\";}s:32:\"aa486c98fc13de0395a551200067a567\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-04-14 11:32:16\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:62:\"Cannot read properties of undefined (reading &#039;html&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:2;s:14:\"\0*\0times_dates\";a:2:{i:0;s:19:\"2025-04-14 11:32:16\";i:1;s:19:\"2025-04-14 11:33:03\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1744630336\";s:7:\"message\";s:52:\"Cannot read properties of undefined (reading \'html\')\";s:3:\"url\";s:88:\"https://zaynventures.com/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.28.3\";s:4:\"line\";s:1:\"3\";s:6:\"column\";s:6:\"345568\";}s:7:\"\0*\0file\";s:88:\"https://zaynventures.com/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.28.3\";s:7:\"\0*\0line\";s:1:\"3\";s:9:\"\0*\0column\";s:6:\"345568\";}s:32:\"3deddd4b2bb8352e28072bf48586f7af\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-04-14 15:11:03\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:78:\"explode(): Passing null to parameter #2 ($string) of type string is deprecated\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:7;s:14:\"\0*\0times_dates\";a:7:{i:0;s:19:\"2025-04-14 15:11:03\";i:1;s:19:\"2025-04-14 15:11:04\";i:2;s:19:\"2025-04-14 15:11:06\";i:3;s:19:\"2025-04-14 15:11:08\";i:4;s:19:\"2025-04-14 15:11:32\";i:5;s:19:\"2025-04-14 15:11:38\";i:6;s:19:\"2025-04-14 15:11:43\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:78:\"explode(): Passing null to parameter #2 ($string) of type string is deprecated\";s:4:\"file\";s:112:\"/home/u577685627/domains/zaynventures.com/public_html/wp-content/plugins/elementor/core/files/file-types/svg.php\";s:4:\"line\";i:165;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:112:\"/home/u577685627/domains/zaynventures.com/public_html/wp-content/plugins/elementor/core/files/file-types/svg.php\";s:7:\"\0*\0line\";i:165;}s:32:\"8360d1ed1a2ee1fef3f74482fd3e9ce9\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-20 17:33:10\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-20 17:33:10\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"7e8c622672aafbef699ec6fb35e06100\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-20 17:33:10\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-20 17:33:10\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"fdc5c8725745fa5dfd10df048d39cea3\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-20 17:33:11\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-20 17:33:11\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"de5c471428b56ca93f68d8165db263d9\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-20 17:33:11\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.28.3\";s:2:\"to\";s:6:\"3.29.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-20 17:33:11\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.28.3\";s:2:\"to\";s:6:\"3.29.2\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"e4aeee7b8384dea72045cf34fb91bb6f\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-20 17:33:11\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.28.3\";s:2:\"to\";s:6:\"3.29.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-20 17:33:11\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.28.3\";s:2:\"to\";s:6:\"3.29.2\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"e7dd7c69dca73de05a2e5dba716e06b3\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-29 18:09:56\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-29 18:09:56\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"74ab97086e263c100d2400d7ec005abc\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-29 18:09:56\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-29 18:09:56\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"8c16b752db19fdd44a024afb1836638f\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-29 18:09:56\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-29 18:09:56\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"2afeb7cb031a7b1cde2c224135724a20\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-29 18:09:56\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.29.2\";s:2:\"to\";s:6:\"3.30.3\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-29 18:09:56\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.29.2\";s:2:\"to\";s:6:\"3.30.3\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"6115ab748c5712ad8595bd06da2c0799\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-29 18:09:56\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.29.2\";s:2:\"to\";s:6:\"3.30.3\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-29 18:09:56\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.29.2\";s:2:\"to\";s:6:\"3.30.3\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}}", "off");
INSERT INTO `wp_options` VALUES("3637", "allowed_astra_notices", "a:2:{i:0;s:26:\"astra-sites-welcome-notice\";i:1;s:20:\"spectra-optin-notice\";}", "auto");
INSERT INTO `wp_options` VALUES("3644", "astra_sites_current_import_template_type", "classic", "auto");
INSERT INTO `wp_options` VALUES("3649", "bsf_analytics_optin", "yes", "off");
INSERT INTO `wp_options` VALUES("3655", "uae_lite_is_activated", "yes", "auto");
INSERT INTO `wp_options` VALUES("3658", "hfe_is_theme_supported", "1", "auto");
INSERT INTO `wp_options` VALUES("3659", "_hfe_db_version", "2.5.2", "auto");
INSERT INTO `wp_options` VALUES("3660", "hfe_onboarding_triggered", "yes", "auto");
INSERT INTO `wp_options` VALUES("3661", "hfe_plugin_previous_version", "2.4.8", "auto");
INSERT INTO `wp_options` VALUES("3662", "hfe_plugin_version", "2.5.2", "auto");
INSERT INTO `wp_options` VALUES("3663", "action_scheduler_hybrid_store_demarkation", "69", "auto");
INSERT INTO `wp_options` VALUES("3664", "schema-ActionScheduler_StoreSchema", "7.0.1744460746", "auto");
INSERT INTO `wp_options` VALUES("3665", "schema-ActionScheduler_LoggerSchema", "3.0.1744460746", "auto");
INSERT INTO `wp_options` VALUES("3666", "wpforms_version", "1.9.4.2", "auto");
INSERT INTO `wp_options` VALUES("3667", "wpforms_version_lite", "1.9.4.2", "auto");
INSERT INTO `wp_options` VALUES("3668", "wpforms_activated", "a:1:{s:4:\"lite\";i:1744460746;}", "auto");
INSERT INTO `wp_options` VALUES("3673", "action_scheduler_lock_async-request-runner", "6931a9a05218d9.80592321|1764862428", "no");
INSERT INTO `wp_options` VALUES("3674", "wpforms_versions_lite", "a:15:{s:5:\"1.5.9\";i:0;s:7:\"1.6.7.2\";i:0;s:5:\"1.6.8\";i:0;s:5:\"1.7.5\";i:0;s:7:\"1.7.5.1\";i:0;s:5:\"1.7.7\";i:0;s:5:\"1.8.2\";i:0;s:5:\"1.8.3\";i:0;s:5:\"1.8.4\";i:0;s:5:\"1.8.6\";i:0;s:5:\"1.8.7\";i:0;s:5:\"1.9.1\";i:0;s:5:\"1.9.2\";i:0;s:7:\"1.9.4.2\";i:1744460747;s:7:\"1.9.5.2\";i:1746895037;}", "auto");
INSERT INTO `wp_options` VALUES("3675", "wpforms_constant_contact_version", "3", "auto");
INSERT INTO `wp_options` VALUES("3676", "widget_wpforms-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("3679", "wpforms_settings", "a:5:{s:11:\"disable-css\";s:1:\"2\";s:13:\"global-assets\";b:0;s:4:\"gdpr\";b:0;s:13:\"modern-markup\";s:1:\"0\";s:20:\"modern-markup-is-set\";b:1;}", "auto");
INSERT INTO `wp_options` VALUES("3682", "wpforms_admin_notices", "a:1:{s:14:\"review_request\";a:2:{s:4:\"time\";i:1744460747;s:9:\"dismissed\";b:0;}}", "auto");
INSERT INTO `wp_options` VALUES("3685", "wpforms_splash_version", "1.8.6", "auto");
INSERT INTO `wp_options` VALUES("3686", "nps-survey-header-footer-elementor", "a:6:{s:13:\"dismiss_count\";i:0;s:19:\"dismiss_permanently\";b:0;s:12:\"dismiss_step\";s:0:\"\";s:12:\"dismiss_time\";s:0:\"\";s:16:\"dismiss_timespan\";N;s:17:\"first_render_time\";i:1744460747;}", "auto");
INSERT INTO `wp_options` VALUES("3688", "suremails_do_redirect", "", "auto");
INSERT INTO `wp_options` VALUES("3691", "suremails_content_guard_hashes", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("3693", "action_scheduler_migration_status", "complete", "auto");
INSERT INTO `wp_options` VALUES("3694", "as_has_wp_comment_logs", "no", "on");
INSERT INTO `wp_options` VALUES("3696", "_wpforms_transient_wpforms_htaccess_file", "a:3:{s:4:\"size\";i:737;s:5:\"mtime\";i:1746895037;s:5:\"ctime\";i:1746895037;}", "on");
INSERT INTO `wp_options` VALUES("3697", "wpforms_email_summaries_fetch_info_blocks_last_run", "1764470020", "auto");
INSERT INTO `wp_options` VALUES("3698", "wpforms_process_forms_locator_status", "completed", "auto");
INSERT INTO `wp_options` VALUES("3713", "ai_import_logger", "a:2:{s:4:\"time\";s:19:\"2025-04-12 12:53:50\";s:4:\"data\";a:3:{s:10:\"user_agent\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36\";s:2:\"id\";i:47547;s:5:\"error\";a:8:{s:11:\"primaryText\";s:56:\"Importing LatePoint data failed due to parse JSON error.\";s:13:\"secondaryText\";s:0:\"\";s:9:\"errorCode\";s:0:\"\";s:9:\"errorText\";s:31:\"Empty file for Latepoint tables\";s:12:\"solutionText\";s:0:\"\";s:8:\"tryAgain\";b:1;s:5:\"stack\";s:58:\"{\"success\":false,\"data\":\"Empty file for Latepoint tables\"}\";s:13:\"tryAgainCount\";i:1;}}}", "auto");
INSERT INTO `wp_options` VALUES("3715", "astra_sites_import_failed_sites", "a:1:{i:0;a:2:{s:11:\"template_id\";i:47547;s:13:\"local_storage\";a:0:{}}}", "auto");
INSERT INTO `wp_options` VALUES("3719", "suremails-version", "1.9.1", "off");
INSERT INTO `wp_options` VALUES("3723", "wpforms_notifications", "a:4:{s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}s:6:\"update\";i:1764861636;}", "auto");
INSERT INTO `wp_options` VALUES("3731", "latepoint_db_version", "2.3.0", "auto");
INSERT INTO `wp_options` VALUES("3732", "latepoint_redirect_to_wizard", "", "auto");
INSERT INTO `wp_options` VALUES("3733", "latepoint_page_customer-cabinet", "69", "auto");
INSERT INTO `wp_options` VALUES("3735", "astra_sites_wpforms_ids_mapping", "a:2:{i:197;i:70;i:118;i:72;}", "off");
INSERT INTO `wp_options` VALUES("3736", "_astra_sites_old_customizer_data", "a:2:{s:14:\"astra-settings\";a:2340:{s:17:\"blog-single-width\";s:7:\"default\";s:21:\"blog-single-max-width\";i:1200;s:17:\"page-single-width\";s:7:\"default\";s:21:\"page-single-max-width\";i:1200;s:28:\"single-content-images-shadow\";b:0;s:30:\"single-post-ast-content-layout\";s:7:\"default\";s:25:\"single-post-sidebar-style\";s:7:\"default\";s:36:\"ast-dynamic-single-post-elements-gap\";i:10;s:38:\"ast-dynamic-single-post-meta-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:40:\"ast-dynamic-single-post-meta-font-weight\";s:0:\"\";s:32:\"ast-dynamic-single-post-metadata\";a:3:{i:0;s:8:\"comments\";i:1;s:32:\"ast-dynamic-single-post-taxonomy\";i:2;s:6:\"author\";}s:35:\"section-search-page-title-structure\";a:1:{i:0;s:31:\"section-search-page-title-title\";}s:38:\"section-search-page-title-custom-title\";s:19:\"Search Results for:\";s:50:\"section-search-page-title-found-custom-description\";s:44:\"Here are the search results for your search.\";s:54:\"section-search-page-title-not-found-custom-description\";s:85:\"Sorry, but we could not find anything related to your search terms. Please try again.\";s:43:\"section-search-page-title-title-font-weight\";s:0:\"\";s:41:\"section-search-page-title-title-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"ast-search-results-per-page\";i:10;s:46:\"section-search-page-title-horizontal-alignment\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"ast-search-live-search\";b:0;s:33:\"ast-search-live-search-post-types\";a:2:{s:4:\"post\";i:1;s:4:\"page\";i:1;}s:19:\"blog-post-structure\";a:5:{i:0;s:5:\"image\";i:1;s:5:\"title\";i:2;s:10:\"title-meta\";i:3;s:7:\"excerpt\";i:4;s:9:\"read-more\";}s:18:\"blog-post-per-page\";i:10;s:17:\"blog-hover-effect\";s:4:\"none\";s:11:\"blog-layout\";s:19:\"blog-layout-classic\";s:10:\"blog-width\";s:7:\"default\";s:19:\"blog-meta-date-type\";s:9:\"published\";s:21:\"blog-meta-date-format\";s:0:\"\";s:14:\"blog-max-width\";i:1200;s:17:\"blog-post-content\";s:7:\"excerpt\";s:9:\"blog-meta\";a:3:{i:0;s:8:\"comments\";i:1;s:8:\"category\";i:2;s:6:\"author\";}s:23:\"post-card-border-radius\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"post-card-featured-overlay\";s:0:\"\";s:19:\"blog-category-style\";s:7:\"default\";s:14:\"blog-tag-style\";s:7:\"default\";s:27:\"blog-post-meta-divider-type\";s:1:\"/\";s:24:\"blog-meta-category-style\";s:7:\"default\";s:19:\"blog-meta-tag-style\";s:7:\"default\";s:21:\"blog-image-ratio-type\";s:0:\"\";s:26:\"blog-image-ratio-pre-scale\";s:4:\"16/9\";s:29:\"blog-image-custom-scale-width\";i:16;s:30:\"blog-image-custom-scale-height\";i:9;s:10:\"text-color\";s:25:\"var(--ast-global-color-3)\";s:10:\"link-color\";s:25:\"var(--ast-global-color-1)\";s:11:\"theme-color\";s:25:\"var(--ast-global-color-0)\";s:12:\"link-h-color\";s:25:\"var(--ast-global-color-1)\";s:18:\"heading-base-color\";s:25:\"var(--ast-global-color-2)\";s:12:\"border-color\";s:0:\"\";s:13:\"footer-bg-obj\";a:11:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:4:\"none\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:12:\"footer-color\";s:0:\"\";s:17:\"footer-link-color\";s:0:\"\";s:19:\"footer-link-h-color\";s:0:\"\";s:17:\"footer-adv-bg-obj\";a:11:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:4:\"none\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:21:\"footer-adv-text-color\";s:0:\"\";s:21:\"footer-adv-link-color\";s:0:\"\";s:23:\"footer-adv-link-h-color\";s:0:\"\";s:26:\"footer-adv-wgt-title-color\";s:0:\"\";s:12:\"button-color\";s:25:\"var(--ast-global-color-4)\";s:14:\"button-h-color\";s:25:\"var(--ast-global-color-2)\";s:15:\"button-bg-color\";s:25:\"var(--ast-global-color-0)\";s:17:\"button-bg-h-color\";s:25:\"var(--ast-global-color-5)\";s:27:\"secondary-button-bg-h-color\";s:25:\"var(--ast-global-color-5)\";s:25:\"secondary-button-bg-color\";s:25:\"var(--ast-global-color-0)\";s:22:\"secondary-button-color\";s:0:\"\";s:24:\"secondary-button-h-color\";s:0:\"\";s:20:\"theme-button-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:2:\"16\";s:5:\"right\";s:2:\"24\";s:6:\"bottom\";s:2:\"16\";s:4:\"left\";s:2:\"24\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:30:\"secondary-theme-button-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:20:\"button-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:8;s:5:\"right\";i:8;s:6:\"bottom\";i:8;s:4:\"left\";i:8;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:30:\"secondary-button-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:8;s:5:\"right\";i:8;s:6:\"bottom\";i:8;s:4:\"left\";i:8;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:37:\"theme-button-border-group-border-size\";a:4:{s:3:\"top\";s:1:\"1\";s:5:\"right\";s:1:\"1\";s:6:\"bottom\";s:1:\"1\";s:4:\"left\";s:1:\"1\";}s:47:\"secondary-theme-button-border-group-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:17:\"footer-sml-layout\";s:8:\"disabled\";s:20:\"footer-sml-section-1\";s:6:\"custom\";s:27:\"footer-sml-section-1-credit\";s:72:\"Copyright &copy; [current_year] [site_title] | Powered by [theme_author]\";s:20:\"footer-sml-section-2\";s:0:\"\";s:27:\"footer-sml-section-2-credit\";s:72:\"Copyright &copy; [current_year] [site_title] | Powered by [theme_author]\";s:27:\"footer-sml-dist-equal-align\";b:1;s:18:\"footer-sml-divider\";i:1;s:24:\"footer-sml-divider-color\";s:7:\"#7a7a7a\";s:19:\"footer-layout-width\";s:7:\"content\";s:22:\"ast-header-retina-logo\";s:0:\"\";s:17:\"use-logo-svg-icon\";b:0;s:13:\"logo-svg-icon\";a:2:{s:4:\"type\";s:0:\"\";s:5:\"value\";s:0:\"\";}s:23:\"logo-svg-site-title-gap\";a:3:{s:7:\"desktop\";s:1:\"5\";s:6:\"tablet\";s:1:\"5\";s:6:\"mobile\";s:1:\"5\";}s:21:\"ast-header-logo-width\";s:0:\"\";s:32:\"ast-header-responsive-logo-width\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:3:\"120\";}s:23:\"header-color-site-title\";s:25:\"var(--ast-global-color-2)\";s:25:\"header-color-h-site-title\";s:0:\"\";s:25:\"header-color-site-tagline\";s:0:\"\";s:29:\"display-site-title-responsive\";a:3:{s:7:\"desktop\";b:0;s:6:\"tablet\";b:0;s:6:\"mobile\";b:0;}s:31:\"display-site-tagline-responsive\";a:3:{s:7:\"desktop\";i:0;s:6:\"tablet\";i:0;s:6:\"mobile\";i:0;}s:17:\"logo-title-inline\";i:1;s:19:\"disable-primary-nav\";b:0;s:14:\"header-layouts\";s:20:\"header-main-layout-1\";s:22:\"header-main-rt-section\";s:6:\"button\";s:27:\"header-display-outside-menu\";b:0;s:27:\"header-main-rt-section-html\";s:27:\"<button>Contact Us</button>\";s:34:\"header-main-rt-section-button-text\";s:19:\"Make An Appointment\";s:34:\"header-main-rt-section-button-link\";s:23:\"https://www.wpastra.com\";s:41:\"header-main-rt-section-button-link-option\";a:3:{s:3:\"url\";s:1:\"#\";s:7:\"new_tab\";s:0:\"\";s:8:\"link_rel\";s:0:\"\";}s:35:\"header-main-rt-section-button-style\";s:12:\"theme-button\";s:40:\"header-main-rt-section-button-text-color\";s:0:\"\";s:40:\"header-main-rt-section-button-back-color\";s:0:\"\";s:42:\"header-main-rt-section-button-text-h-color\";s:0:\"\";s:42:\"header-main-rt-section-button-back-h-color\";s:0:\"\";s:37:\"header-main-rt-section-button-padding\";a:3:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}}s:41:\"header-main-rt-section-button-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:15:\"header-main-sep\";i:1;s:21:\"header-main-sep-color\";s:0:\"\";s:24:\"header-main-layout-width\";s:7:\"content\";s:22:\"primary-submenu-border\";a:4:{s:3:\"top\";s:1:\"2\";s:5:\"right\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";}s:27:\"primary-submenu-item-border\";b:0;s:23:\"primary-submenu-b-color\";s:0:\"\";s:28:\"primary-submenu-item-b-color\";s:0:\"\";s:33:\"primary-header-button-font-family\";s:7:\"inherit\";s:33:\"primary-header-button-font-weight\";s:7:\"inherit\";s:31:\"primary-header-button-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:36:\"primary-header-button-text-transform\";s:0:\"\";s:33:\"primary-header-button-line-height\";i:1;s:36:\"primary-header-button-letter-spacing\";s:0:\"\";s:22:\"header-main-menu-label\";s:0:\"\";s:22:\"header-main-menu-align\";s:6:\"inline\";s:39:\"header-main-submenu-container-animation\";s:4:\"fade\";s:24:\"mobile-header-breakpoint\";s:0:\"\";s:18:\"mobile-header-logo\";s:0:\"\";s:24:\"mobile-header-logo-width\";s:0:\"\";s:11:\"site-layout\";s:21:\"ast-full-width-layout\";s:18:\"site-content-width\";i:1200;s:26:\"narrow-container-max-width\";i:750;s:37:\"site-layout-outside-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:11:{s:16:\"background-color\";s:25:\"var(--ast-global-color-4)\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:5:\"color\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:11:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:11:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:25:\"content-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:11:{s:16:\"background-color\";s:25:\"var(--ast-global-color-5)\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:5:\"color\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:11:{s:16:\"background-color\";s:18:\"rgba(40,189,135,0)\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:5:\"color\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:11:{s:16:\"background-color\";s:18:\"rgba(40,189,135,0)\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:5:\"color\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:12:\"wp-blocks-ui\";s:7:\"comfort\";s:24:\"wp-blocks-global-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"em\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"em\";}s:20:\"enable-comments-area\";b:1;s:22:\"comments-box-placement\";s:0:\"\";s:21:\"comment-form-position\";s:5:\"below\";s:28:\"comments-box-container-width\";s:0:\"\";s:31:\"ast-sub-section-comments-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"em\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"em\";}s:32:\"ast-sub-section-comments-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";i:3;s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"em\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"em\";}s:30:\"single-page-ast-content-layout\";s:22:\"normal-width-container\";s:25:\"single-page-content-style\";s:5:\"boxed\";s:25:\"single-post-content-style\";s:7:\"default\";s:31:\"archive-post-ast-content-layout\";s:7:\"default\";s:23:\"ast-site-content-layout\";s:22:\"normal-width-container\";s:18:\"site-content-style\";s:5:\"boxed\";s:16:\"body-font-family\";s:23:\"\'Open Sans\', sans-serif\";s:17:\"body-font-variant\";s:3:\"400\";s:16:\"body-font-weight\";s:3:\"400\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";s:2:\"16\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:20:\"headings-font-extras\";a:6:{s:11:\"line-height\";s:3:\"1.1\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:10:\"capitalize\";s:15:\"text-decoration\";s:0:\"\";}s:18:\"para-margin-bottom\";s:1:\"1\";s:23:\"underline-content-links\";b:0;s:25:\"site-accessibility-toggle\";b:1;s:33:\"site-accessibility-highlight-type\";s:6:\"dotted\";s:39:\"site-accessibility-highlight-input-type\";s:7:\"disable\";s:19:\"body-text-transform\";s:0:\"\";s:20:\"headings-font-family\";s:19:\"\'Rubik\', sans-serif\";s:20:\"headings-font-weight\";s:3:\"500\";s:20:\"font-size-site-title\";a:6:{s:7:\"desktop\";i:35;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:22:\"font-size-site-tagline\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"single-post-outside-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:20:\"font-size-page-title\";a:6:{s:7:\"desktop\";i:40;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:18:\"font-size-post-tax\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"font-size-post-meta\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:12:\"font-size-h1\";a:6:{s:7:\"desktop\";s:2:\"72\";s:6:\"tablet\";s:2:\"40\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:12:\"font-size-h2\";a:6:{s:7:\"desktop\";s:2:\"48\";s:6:\"tablet\";s:2:\"32\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:12:\"font-size-h3\";a:6:{s:7:\"desktop\";s:2:\"24\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:12:\"font-size-h4\";a:6:{s:7:\"desktop\";i:20;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:12:\"font-size-h5\";a:6:{s:7:\"desktop\";s:2:\"16\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:12:\"font-size-h6\";a:6:{s:7:\"desktop\";s:2:\"14\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"site-sidebar-layout\";s:10:\"no-sidebar\";s:18:\"site-sidebar-width\";i:30;s:26:\"single-page-sidebar-layout\";s:7:\"default\";s:26:\"single-post-sidebar-layout\";s:7:\"default\";s:27:\"archive-post-sidebar-layout\";s:7:\"default\";s:19:\"site-sticky-sidebar\";b:0;s:18:\"site-sidebar-style\";s:5:\"boxed\";s:25:\"single-page-sidebar-style\";s:5:\"boxed\";s:26:\"archive-post-sidebar-style\";s:7:\"default\";s:10:\"footer-adv\";s:8:\"disabled\";s:23:\"footer-adv-border-width\";s:0:\"\";s:23:\"footer-adv-border-color\";s:7:\"#7a7a7a\";s:30:\"mobile-header-toggle-btn-style\";s:7:\"minimal\";s:23:\"hide-custom-menu-mobile\";i:1;s:27:\"mobile-header-toggle-target\";s:4:\"icon\";s:19:\"enable-scroll-to-id\";b:0;s:37:\"ast-dynamic-single-download-structure\";a:3:{i:0;s:33:\"ast-dynamic-single-download-title\";i:1;s:32:\"ast-dynamic-single-download-meta\";i:2;s:33:\"ast-dynamic-single-download-image\";}s:20:\"enable-related-posts\";b:0;s:19:\"related-posts-title\";s:13:\"Related Posts\";s:29:\"releted-posts-title-alignment\";s:4:\"left\";s:25:\"related-posts-total-count\";i:2;s:28:\"enable-related-posts-excerpt\";b:0;s:27:\"related-posts-box-placement\";s:7:\"default\";s:30:\"related-posts-outside-location\";s:5:\"above\";s:29:\"related-posts-container-width\";s:8:\"fallback\";s:27:\"related-posts-excerpt-count\";i:25;s:22:\"related-posts-based-on\";s:10:\"categories\";s:22:\"related-posts-order-by\";s:4:\"date\";s:19:\"related-posts-order\";s:3:\"asc\";s:29:\"related-posts-grid-responsive\";a:3:{s:7:\"desktop\";s:7:\"2-equal\";s:6:\"tablet\";s:7:\"2-equal\";s:6:\"mobile\";s:4:\"full\";}s:23:\"related-posts-structure\";a:2:{i:0;s:14:\"featured-image\";i:1;s:10:\"title-meta\";}s:23:\"related-posts-tag-style\";s:4:\"none\";s:28:\"related-posts-category-style\";s:4:\"none\";s:25:\"related-posts-date-format\";s:0:\"\";s:28:\"related-posts-meta-date-type\";s:9:\"published\";s:32:\"related-posts-author-avatar-size\";s:0:\"\";s:27:\"related-posts-author-avatar\";b:0;s:33:\"related-posts-author-prefix-label\";s:3:\"By \";s:24:\"related-posts-image-size\";s:0:\"\";s:38:\"related-posts-image-custom-scale-width\";i:16;s:39:\"related-posts-image-custom-scale-height\";i:9;s:35:\"related-posts-image-ratio-pre-scale\";s:4:\"16/9\";s:30:\"related-posts-image-ratio-type\";s:0:\"\";s:28:\"related-posts-meta-structure\";a:3:{i:0;s:8:\"comments\";i:1;s:8:\"category\";i:2;s:6:\"author\";}s:24:\"related-posts-text-color\";s:0:\"\";s:24:\"related-posts-link-color\";s:0:\"\";s:25:\"related-posts-title-color\";s:0:\"\";s:30:\"related-posts-background-color\";s:0:\"\";s:24:\"related-posts-meta-color\";s:0:\"\";s:30:\"related-posts-link-hover-color\";s:0:\"\";s:35:\"related-posts-meta-link-hover-color\";s:0:\"\";s:39:\"related-posts-section-title-font-family\";s:7:\"inherit\";s:39:\"related-posts-section-title-font-weight\";s:7:\"inherit\";s:42:\"related-posts-section-title-text-transform\";s:0:\"\";s:39:\"related-posts-section-title-line-height\";s:0:\"\";s:39:\"related-posts-section-title-font-extras\";a:6:{s:11:\"line-height\";s:3:\"1.6\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:37:\"related-posts-section-title-font-size\";a:6:{s:7:\"desktop\";s:2:\"30\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"related-posts-title-font-family\";s:7:\"inherit\";s:31:\"related-posts-title-font-weight\";s:7:\"inherit\";s:34:\"related-posts-title-text-transform\";s:0:\"\";s:31:\"related-posts-title-line-height\";s:1:\"1\";s:29:\"related-posts-title-font-size\";a:6:{s:7:\"desktop\";s:2:\"20\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"related-posts-title-font-extras\";a:6:{s:11:\"line-height\";s:1:\"1\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:30:\"related-posts-meta-font-family\";s:7:\"inherit\";s:30:\"related-posts-meta-font-weight\";s:7:\"inherit\";s:33:\"related-posts-meta-text-transform\";s:0:\"\";s:30:\"related-posts-meta-line-height\";s:0:\"\";s:28:\"related-posts-meta-font-size\";a:6:{s:7:\"desktop\";s:2:\"14\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:30:\"related-posts-meta-font-extras\";a:6:{s:11:\"line-height\";s:3:\"1.6\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"related-posts-content-font-family\";s:7:\"inherit\";s:33:\"related-posts-content-font-weight\";s:7:\"inherit\";s:33:\"related-posts-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:31:\"related-posts-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:37:\"ast-sub-section-related-posts-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";d:2.5;s:5:\"right\";d:2.5;s:6:\"bottom\";d:2.5;s:4:\"left\";d:2.5;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"em\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"em\";}s:36:\"ast-sub-section-related-posts-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:2;s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"em\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"em\";}s:23:\"transparent-header-logo\";s:0:\"\";s:30:\"transparent-header-retina-logo\";s:0:\"\";s:26:\"different-transparent-logo\";i:0;s:33:\"different-transparent-retina-logo\";b:0;s:29:\"transparent-header-logo-width\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"transparent-header-enable\";i:0;s:34:\"transparent-header-disable-archive\";i:1;s:45:\"transparent-header-disable-latest-posts-index\";i:1;s:29:\"transparent-header-on-devices\";s:4:\"both\";s:27:\"transparent-header-main-sep\";i:0;s:33:\"transparent-header-main-sep-color\";s:0:\"\";s:27:\"transparent-header-bg-color\";s:0:\"\";s:35:\"transparent-header-color-site-title\";s:0:\"\";s:37:\"transparent-header-color-h-site-title\";s:0:\"\";s:25:\"transparent-menu-bg-color\";s:0:\"\";s:22:\"transparent-menu-color\";s:0:\"\";s:24:\"transparent-menu-h-color\";s:0:\"\";s:28:\"transparent-submenu-bg-color\";s:0:\"\";s:25:\"transparent-submenu-color\";s:0:\"\";s:27:\"transparent-submenu-h-color\";s:0:\"\";s:29:\"transparent-header-logo-color\";s:0:\"\";s:38:\"transparent-header-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:42:\"hba-transparent-header-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:42:\"hbb-transparent-header-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:46:\"transparent-header-color-site-title-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:48:\"transparent-header-color-h-site-title-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:36:\"transparent-menu-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:25:\"var(--ast-global-color-4)\";s:6:\"mobile\";s:0:\"\";}s:33:\"transparent-menu-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-3)\";s:6:\"tablet\";s:25:\"var(--ast-global-color-3)\";s:6:\"mobile\";s:0:\"\";}s:35:\"transparent-menu-h-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-2)\";s:6:\"tablet\";s:25:\"var(--ast-global-color-0)\";s:6:\"mobile\";s:0:\"\";}s:39:\"transparent-submenu-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:36:\"transparent-submenu-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:38:\"transparent-submenu-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:49:\"transparent-content-section-text-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:49:\"transparent-content-section-link-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:51:\"transparent-content-section-link-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:32:\"breadcrumb-text-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"breadcrumb-active-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"breadcrumb-hover-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"breadcrumb-separator-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:19:\"breadcrumb-bg-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:18:\"breadcrumb-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:22:\"breadcrumb-font-family\";s:7:\"inherit\";s:22:\"breadcrumb-font-weight\";s:7:\"inherit\";s:20:\"breadcrumb-font-size\";s:0:\"\";s:22:\"breadcrumb-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:29:\"breadcrumb-separator-selector\";s:7:\"unicode\";s:20:\"breadcrumb-separator\";s:4:\"\00bb\";s:20:\"scroll-to-top-enable\";b:0;s:23:\"scroll-to-top-icon-size\";i:15;s:27:\"scroll-to-top-icon-position\";s:5:\"right\";s:24:\"scroll-to-top-on-devices\";s:4:\"both\";s:32:\"scroll-to-top-icon-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"scroll-to-top-icon-color\";s:0:\"\";s:26:\"scroll-to-top-icon-h-color\";s:0:\"\";s:27:\"scroll-to-top-icon-bg-color\";s:0:\"\";s:29:\"scroll-to-top-icon-h-bg-color\";s:0:\"\";s:8:\"h1-color\";s:0:\"\";s:8:\"h2-color\";s:0:\"\";s:8:\"h3-color\";s:0:\"\";s:8:\"h4-color\";s:0:\"\";s:8:\"h5-color\";s:0:\"\";s:8:\"h6-color\";s:0:\"\";s:14:\"font-family-h1\";s:7:\"inherit\";s:14:\"font-weight-h1\";s:7:\"inherit\";s:14:\"font-extras-h1\";a:2:{s:11:\"line-height\";s:3:\"1.4\";s:16:\"line-height-unit\";s:2:\"em\";}s:14:\"font-family-h2\";s:7:\"inherit\";s:14:\"font-weight-h2\";s:7:\"inherit\";s:14:\"font-extras-h2\";a:2:{s:11:\"line-height\";s:3:\"1.3\";s:16:\"line-height-unit\";s:2:\"em\";}s:14:\"font-family-h3\";s:7:\"inherit\";s:14:\"font-weight-h3\";s:7:\"inherit\";s:14:\"font-extras-h3\";a:2:{s:11:\"line-height\";s:3:\"1.3\";s:16:\"line-height-unit\";s:2:\"em\";}s:14:\"font-family-h4\";s:7:\"inherit\";s:14:\"font-weight-h4\";s:7:\"inherit\";s:14:\"font-extras-h4\";a:2:{s:11:\"line-height\";s:3:\"1.2\";s:16:\"line-height-unit\";s:2:\"em\";}s:14:\"font-family-h5\";s:7:\"inherit\";s:14:\"font-weight-h5\";s:7:\"inherit\";s:14:\"font-extras-h5\";a:2:{s:11:\"line-height\";s:3:\"1.2\";s:16:\"line-height-unit\";s:2:\"em\";}s:14:\"font-family-h6\";s:7:\"inherit\";s:14:\"font-weight-h6\";s:7:\"inherit\";s:14:\"font-extras-h6\";a:2:{s:11:\"line-height\";s:4:\"1.25\";s:16:\"line-height-unit\";s:2:\"em\";}s:18:\"font-weight-button\";s:3:\"500\";s:28:\"secondary-font-weight-button\";s:3:\"500\";s:18:\"font-family-button\";s:7:\"inherit\";s:28:\"secondary-font-family-button\";s:7:\"inherit\";s:16:\"font-size-button\";a:6:{s:7:\"desktop\";s:2:\"14\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"secondary-font-size-button\";a:6:{s:7:\"desktop\";s:2:\"14\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:18:\"font-extras-button\";a:6:{s:11:\"line-height\";i:1;s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:28:\"secondary-font-extras-button\";a:6:{s:11:\"line-height\";i:1;s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:20:\"header-desktop-items\";a:5:{s:5:\"above\";a:5:{s:10:\"above_left\";a:0:{}s:17:\"above_left_center\";a:0:{}s:12:\"above_center\";a:0:{}s:18:\"above_right_center\";a:0:{}s:11:\"above_right\";a:0:{}}s:5:\"below\";a:5:{s:10:\"below_left\";a:0:{}s:17:\"below_left_center\";a:0:{}s:12:\"below_center\";a:0:{}s:18:\"below_right_center\";a:0:{}s:11:\"below_right\";a:0:{}}s:7:\"primary\";a:5:{s:12:\"primary_left\";a:1:{i:0;s:4:\"logo\";}s:19:\"primary_left_center\";a:0:{}s:14:\"primary_center\";a:0:{}s:20:\"primary_right_center\";a:0:{}s:13:\"primary_right\";a:2:{i:0;s:6:\"menu-1\";i:1;s:6:\"html-1\";}}s:4:\"flag\";b:1;s:5:\"popup\";a:1:{s:13:\"popup_content\";a:0:{}}}s:19:\"header-mobile-items\";a:5:{s:5:\"above\";a:3:{s:10:\"above_left\";a:0:{}s:12:\"above_center\";a:0:{}s:11:\"above_right\";a:0:{}}s:5:\"below\";a:3:{s:10:\"below_left\";a:0:{}s:12:\"below_center\";a:0:{}s:11:\"below_right\";a:0:{}}s:5:\"popup\";a:1:{s:13:\"popup_content\";a:1:{i:0;s:6:\"menu-1\";}}s:7:\"primary\";a:3:{s:12:\"primary_left\";a:1:{i:0;s:4:\"logo\";}s:14:\"primary_center\";a:0:{}s:13:\"primary_right\";a:1:{i:0;s:14:\"mobile-trigger\";}}s:4:\"flag\";b:0;}s:27:\"hb-header-main-layout-width\";s:7:\"content\";s:16:\"hb-header-height\";a:3:{s:7:\"desktop\";i:70;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:8:\"hb-stack\";a:3:{s:7:\"desktop\";s:5:\"stack\";s:6:\"tablet\";s:5:\"stack\";s:6:\"mobile\";s:5:\"stack\";}s:18:\"hb-header-main-sep\";i:0;s:24:\"hb-header-main-sep-color\";s:0:\"\";s:25:\"hb-header-main-menu-align\";s:6:\"inline\";s:27:\"hb-header-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:7:\"#ffffff\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:5:\"color\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:9:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:9:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:17:\"hb-header-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:3:\"1.5\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:3:\"1.5\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:1:\"1\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:1:\"1\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"em\";}s:17:\"hba-header-layout\";s:21:\"above-header-layout-1\";s:17:\"hba-header-height\";a:3:{s:7:\"desktop\";i:50;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:9:\"hba-stack\";a:3:{s:7:\"desktop\";s:5:\"stack\";s:6:\"tablet\";s:5:\"stack\";s:6:\"mobile\";s:5:\"stack\";}s:20:\"hba-header-separator\";i:1;s:30:\"hba-header-bottom-border-color\";s:65:\"var( --ast-global-color-subtle-background, --ast-global-color-7 )\";s:28:\"hba-header-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:55:\"var( --ast-global-color-primary, --ast-global-color-4 )\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:32:\"hba-header-text-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:32:\"hba-header-link-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"hba-header-link-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:18:\"hba-header-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:1:\"0\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:3:\"0.5\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"em\";}s:17:\"hbb-header-layout\";s:21:\"below-header-layout-1\";s:17:\"hbb-header-height\";a:3:{s:7:\"desktop\";i:60;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:9:\"hbb-stack\";a:3:{s:7:\"desktop\";s:5:\"stack\";s:6:\"tablet\";s:5:\"stack\";s:6:\"mobile\";s:5:\"stack\";}s:20:\"hbb-header-separator\";i:1;s:30:\"hbb-header-bottom-border-color\";s:65:\"var( --ast-global-color-subtle-background, --ast-global-color-7 )\";s:28:\"hbb-header-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:7:\"#eeeeee\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:18:\"hbb-header-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:1:\"1\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:1:\"1\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"px\";}s:37:\"section-footer-builder-layout-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:36:\"section-footer-builder-layout-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:36:\"section-above-header-builder-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"section-above-header-builder-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:36:\"section-below-header-builder-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"section-below-header-builder-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:36:\"section-header-mobile-trigger-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:38:\"section-primary-header-builder-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:37:\"section-primary-header-builder-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:20:\"title_tagline-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"section-header-search-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-account-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"header-mobile-menu-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:33:\"section-header-mobile-menu-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:36:\"section-above-footer-builder-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"section-above-footer-builder-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"section-below-footer-builder-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"section-footer-copyright-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-footer-menu-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:38:\"section-primary-footer-builder-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:2:\"80\";s:5:\"right\";s:2:\"30\";s:6:\"bottom\";s:2:\"80\";s:4:\"left\";s:2:\"30\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:37:\"section-primary-footer-builder-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"section-header-woo-cart-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:30:\"section-header-woo-cart-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button1-text\";s:19:\"Make An Appointment\";s:26:\"header-button1-link-option\";a:3:{s:3:\"url\";s:1:\"#\";s:7:\"new_tab\";s:0:\"\";s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button1-font-family\";s:7:\"inherit\";s:26:\"header-button1-font-weight\";s:7:\"inherit\";s:26:\"header-button1-font-extras\";a:6:{s:11:\"line-height\";i:1;s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"header-button1-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button1-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button1-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button1-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button1-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button1-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button1-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"header-button1-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"header-button1-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-button1-border-radius\";s:0:\"\";s:27:\"section-hb-button-1-padding\";a:3:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}}s:26:\"section-hb-button-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button1-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button1-text\";s:6:\"Button\";s:26:\"footer-button1-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button1-font-family\";s:7:\"inherit\";s:26:\"footer-button1-font-weight\";s:7:\"inherit\";s:29:\"footer-button1-text-transform\";s:0:\"\";s:26:\"footer-button1-line-height\";s:0:\"\";s:24:\"footer-button1-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button1-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button1-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button1-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button1-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button1-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button1-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button1-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"footer-button1-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button-1-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-1-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-1\";s:24:\"[latepoint_book_button]\n\";s:18:\"header-html-1color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-1link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-1link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-1\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-1\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-1\";s:7:\"inherit\";s:29:\"font-extras-section-hb-html-1\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-hb-html-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-1\";s:359:\"<p style=\"text-align: left;\"><img class=\"alignnone wp-image-11\" src=\"https://websitedemos.net/diagnostics-lab-02/wp-content/uploads/sites/662/2020/08/diagnostic-lab-logo.png\" alt=\"\" width=\"185\" height=\"46\" /></p>\n<p style=\"text-align: left;\">Urna aliquet feugiat odio enim ut pharetra pretium velit viverra elementum pulvinar viverra diam urna rhoncus eu.</p>\";s:18:\"footer-html-1color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-1link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-1link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-1\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-1-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-1\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-1\";s:7:\"inherit\";s:29:\"font-extras-section-fb-html-1\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-fb-html-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-1-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-1-bg-space\";s:0:\"\";s:20:\"header-social-1-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"header-social-1-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-1-color\";s:0:\"\";s:23:\"header-social-1-h-color\";s:0:\"\";s:24:\"header-social-1-bg-color\";s:0:\"\";s:26:\"header-social-1-bg-h-color\";s:0:\"\";s:28:\"header-social-1-label-toggle\";b:0;s:26:\"header-social-1-color-type\";s:6:\"custom\";s:34:\"header-social-1-brand-hover-toggle\";b:0;s:35:\"font-size-section-hb-social-icons-1\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-1\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-1-space\";a:3:{s:7:\"desktop\";s:1:\"0\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-1-bg-space\";s:1:\"6\";s:20:\"footer-social-1-size\";a:3:{s:7:\"desktop\";s:2:\"15\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-1-radius\";s:0:\"\";s:21:\"footer-social-1-color\";a:1:{s:7:\"desktop\";s:25:\"var(--ast-global-color-5)\";}s:23:\"footer-social-1-h-color\";s:0:\"\";s:24:\"footer-social-1-bg-color\";s:0:\"\";s:26:\"footer-social-1-bg-h-color\";s:0:\"\";s:28:\"footer-social-1-label-toggle\";b:0;s:26:\"footer-social-1-color-type\";s:6:\"custom\";s:27:\"footer-social-1-brand-color\";s:0:\"\";s:33:\"footer-social-1-brand-label-color\";s:0:\"\";s:34:\"footer-social-1-brand-hover-toggle\";b:0;s:35:\"font-size-section-fb-social-icons-1\";a:6:{s:7:\"desktop\";s:2:\"14\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-1\";a:2:{s:5:\"items\";a:5:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:1:\"#\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:1:\"#\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:1:\"#\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}i:3;a:7:{s:2:\"id\";s:7:\"youtube\";s:7:\"enabled\";b:1;s:3:\"url\";s:1:\"#\";s:5:\"color\";s:7:\"#e96651\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"youtube\";s:5:\"label\";s:7:\"YouTube\";}i:4;a:7:{s:2:\"id\";s:8:\"linkedin\";s:7:\"enabled\";b:1;s:3:\"url\";s:1:\"#\";s:5:\"color\";s:7:\"#1c86c6\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"linkedin\";s:5:\"label\";s:8:\"Linkedin\";}}s:4:\"flag\";b:1;}s:25:\"footer-social-1-alignment\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:4:\"left\";s:6:\"mobile\";s:4:\"left\";}s:32:\"section-fb-social-icons-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-1-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-1-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-1-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-1-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-1-font-family\";s:7:\"inherit\";s:27:\"header-widget-1-font-weight\";s:7:\"inherit\";s:25:\"header-widget-1-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-1-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:35:\"header-widget-1-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-1-content-font-weight\";s:7:\"inherit\";s:33:\"header-widget-1-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-1-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:38:\"sidebar-widgets-header-widget-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-1-title-color\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-2)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-1-color\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-3)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-1-link-color\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-3)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-1-link-h-color\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-5)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-1-font-family\";s:7:\"inherit\";s:27:\"footer-widget-1-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-1-text-transform\";s:0:\"\";s:27:\"footer-widget-1-line-height\";s:0:\"\";s:25:\"footer-widget-1-font-size\";a:6:{s:7:\"desktop\";s:2:\"20\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-1-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-1-content-font-weight\";s:7:\"inherit\";s:35:\"footer-widget-1-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"footer-widget-1-content-font-size\";a:6:{s:7:\"desktop\";s:2:\"15\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-1\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:4:\"left\";s:6:\"mobile\";s:4:\"left\";}s:38:\"sidebar-widgets-footer-widget-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:1:\"0\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu1-bg-color\";s:0:\"\";s:18:\"header-menu1-color\";s:0:\"\";s:23:\"header-menu1-h-bg-color\";s:0:\"\";s:20:\"header-menu1-h-color\";s:0:\"\";s:23:\"header-menu1-a-bg-color\";s:0:\"\";s:20:\"header-menu1-a-color\";s:0:\"\";s:30:\"header-menu1-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:9:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:25:\"var(--ast-global-color-5)\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:5:\"color\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:9:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:29:\"header-menu1-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:25:\"var(--ast-global-color-2)\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu1-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu1-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:25:\"var(--ast-global-color-0)\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu1-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu1-a-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu1-menu-hover-animation\";s:0:\"\";s:40:\"header-menu1-submenu-container-animation\";s:4:\"fade\";s:24:\"section-hb-menu-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu1-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu1-submenu-item-border\";b:0;s:32:\"header-menu1-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu1-submenu-item-b-color\";s:0:\"\";s:41:\"header-menu1-submenu-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"header-menu1-submenu-top-offset\";s:0:\"\";s:26:\"header-menu1-submenu-width\";s:0:\"\";s:27:\"header-menu1-submenu-border\";a:4:{s:3:\"top\";s:1:\"2\";s:5:\"right\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";}s:33:\"header-menu1-menu-stack-on-mobile\";b:1;s:22:\"header-menu1-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu1-font-weight\";s:7:\"inherit\";s:24:\"header-menu1-font-family\";s:7:\"inherit\";s:24:\"header-menu1-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:27:\"section-hb-divider-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button2-text\";s:6:\"Button\";s:26:\"header-button2-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button2-font-family\";s:7:\"inherit\";s:26:\"header-button2-font-weight\";s:7:\"inherit\";s:26:\"header-button2-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"header-button2-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button2-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button2-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button2-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button2-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button2-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button2-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"header-button2-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"header-button2-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-button2-border-radius\";s:0:\"\";s:27:\"section-hb-button-2-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-hb-button-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button2-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button2-text\";s:6:\"Button\";s:26:\"footer-button2-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button2-font-family\";s:7:\"inherit\";s:26:\"footer-button2-font-weight\";s:7:\"inherit\";s:29:\"footer-button2-text-transform\";s:0:\"\";s:26:\"footer-button2-line-height\";s:0:\"\";s:24:\"footer-button2-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button2-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button2-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button2-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button2-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button2-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button2-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button2-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"footer-button2-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button-2-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-2-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-2\";s:22:\"Insert HTML text here.\";s:18:\"header-html-2color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-2link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-2link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-2\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-2\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-2\";s:7:\"inherit\";s:29:\"font-extras-section-hb-html-2\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-hb-html-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-2\";s:22:\"Insert HTML text here.\";s:18:\"footer-html-2color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-2link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-2link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-2\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-2-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-2\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-2\";s:7:\"inherit\";s:29:\"font-extras-section-fb-html-2\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-fb-html-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-2-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-2-bg-space\";s:0:\"\";s:20:\"header-social-2-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"header-social-2-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-2-color\";s:0:\"\";s:23:\"header-social-2-h-color\";s:0:\"\";s:24:\"header-social-2-bg-color\";s:0:\"\";s:26:\"header-social-2-bg-h-color\";s:0:\"\";s:28:\"header-social-2-label-toggle\";b:0;s:26:\"header-social-2-color-type\";s:6:\"custom\";s:34:\"header-social-2-brand-hover-toggle\";b:0;s:35:\"font-size-section-hb-social-icons-2\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-2\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-2-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-2-bg-space\";s:0:\"\";s:20:\"footer-social-2-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-2-radius\";s:0:\"\";s:21:\"footer-social-2-color\";s:0:\"\";s:23:\"footer-social-2-h-color\";s:0:\"\";s:24:\"footer-social-2-bg-color\";s:0:\"\";s:26:\"footer-social-2-bg-h-color\";s:0:\"\";s:28:\"footer-social-2-label-toggle\";b:0;s:26:\"footer-social-2-color-type\";s:6:\"custom\";s:27:\"footer-social-2-brand-color\";s:0:\"\";s:33:\"footer-social-2-brand-label-color\";s:0:\"\";s:34:\"footer-social-2-brand-hover-toggle\";b:0;s:35:\"font-size-section-fb-social-icons-2\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-2\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:25:\"footer-social-2-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:32:\"section-fb-social-icons-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-2-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-2-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-2-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-2-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-2-font-family\";s:7:\"inherit\";s:27:\"header-widget-2-font-weight\";s:7:\"inherit\";s:25:\"header-widget-2-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-2-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:35:\"header-widget-2-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-2-content-font-weight\";s:7:\"inherit\";s:33:\"header-widget-2-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-2-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:38:\"sidebar-widgets-header-widget-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-2-title-color\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-2)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-2-color\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-3)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-2-link-color\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-3)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-2-link-h-color\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-2-font-family\";s:7:\"inherit\";s:27:\"footer-widget-2-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-2-text-transform\";s:0:\"\";s:27:\"footer-widget-2-line-height\";s:0:\"\";s:25:\"footer-widget-2-font-size\";a:6:{s:7:\"desktop\";s:2:\"20\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-2-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-2-content-font-weight\";s:7:\"inherit\";s:35:\"footer-widget-2-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"footer-widget-2-content-font-size\";a:6:{s:7:\"desktop\";s:2:\"16\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-2\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:4:\"left\";s:6:\"mobile\";s:4:\"left\";}s:38:\"sidebar-widgets-footer-widget-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu2-bg-color\";s:0:\"\";s:18:\"header-menu2-color\";s:0:\"\";s:23:\"header-menu2-h-bg-color\";s:0:\"\";s:20:\"header-menu2-h-color\";s:0:\"\";s:23:\"header-menu2-a-bg-color\";s:0:\"\";s:20:\"header-menu2-a-color\";s:0:\"\";s:30:\"header-menu2-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:29:\"header-menu2-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu2-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu2-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu2-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu2-a-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu2-menu-hover-animation\";s:0:\"\";s:40:\"header-menu2-submenu-container-animation\";s:0:\"\";s:24:\"section-hb-menu-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu2-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu2-submenu-item-border\";b:0;s:32:\"header-menu2-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu2-submenu-item-b-color\";s:7:\"#eaeaea\";s:41:\"header-menu2-submenu-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"header-menu2-submenu-top-offset\";s:0:\"\";s:26:\"header-menu2-submenu-width\";s:0:\"\";s:27:\"header-menu2-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:33:\"header-menu2-menu-stack-on-mobile\";b:1;s:22:\"header-menu2-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu2-font-weight\";s:7:\"inherit\";s:24:\"header-menu2-font-family\";s:7:\"inherit\";s:24:\"header-menu2-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:27:\"section-hb-divider-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button3-text\";s:6:\"Button\";s:26:\"header-button3-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button3-font-family\";s:7:\"inherit\";s:26:\"header-button3-font-weight\";s:7:\"inherit\";s:26:\"header-button3-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"header-button3-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button3-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button3-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button3-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button3-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button3-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button3-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"header-button3-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"header-button3-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-button3-border-radius\";s:0:\"\";s:27:\"section-hb-button-3-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-hb-button-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button3-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button3-text\";s:6:\"Button\";s:26:\"footer-button3-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button3-font-family\";s:7:\"inherit\";s:26:\"footer-button3-font-weight\";s:7:\"inherit\";s:29:\"footer-button3-text-transform\";s:0:\"\";s:26:\"footer-button3-line-height\";s:0:\"\";s:24:\"footer-button3-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button3-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button3-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button3-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button3-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button3-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button3-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button3-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"footer-button3-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button-3-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-3-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-3\";s:22:\"Insert HTML text here.\";s:18:\"header-html-3color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-3link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-3link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-3\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-3\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-3\";s:7:\"inherit\";s:29:\"font-extras-section-hb-html-3\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-hb-html-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-3\";s:22:\"Insert HTML text here.\";s:18:\"footer-html-3color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-3link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-3link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-3\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-3-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-3\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-3\";s:7:\"inherit\";s:29:\"font-extras-section-fb-html-3\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-fb-html-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-3-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-3-bg-space\";s:0:\"\";s:20:\"header-social-3-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"header-social-3-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-3-color\";s:0:\"\";s:23:\"header-social-3-h-color\";s:0:\"\";s:24:\"header-social-3-bg-color\";s:0:\"\";s:26:\"header-social-3-bg-h-color\";s:0:\"\";s:28:\"header-social-3-label-toggle\";b:0;s:26:\"header-social-3-color-type\";s:6:\"custom\";s:34:\"header-social-3-brand-hover-toggle\";b:0;s:35:\"font-size-section-hb-social-icons-3\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-3\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-3-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-3-bg-space\";s:0:\"\";s:20:\"footer-social-3-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-3-radius\";s:0:\"\";s:21:\"footer-social-3-color\";s:0:\"\";s:23:\"footer-social-3-h-color\";s:0:\"\";s:24:\"footer-social-3-bg-color\";s:0:\"\";s:26:\"footer-social-3-bg-h-color\";s:0:\"\";s:28:\"footer-social-3-label-toggle\";b:0;s:26:\"footer-social-3-color-type\";s:6:\"custom\";s:27:\"footer-social-3-brand-color\";s:0:\"\";s:33:\"footer-social-3-brand-label-color\";s:0:\"\";s:34:\"footer-social-3-brand-hover-toggle\";b:0;s:35:\"font-size-section-fb-social-icons-3\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-3\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:25:\"footer-social-3-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:32:\"section-fb-social-icons-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-3-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-3-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-3-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-3-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-3-font-family\";s:7:\"inherit\";s:27:\"header-widget-3-font-weight\";s:7:\"inherit\";s:25:\"header-widget-3-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-3-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:35:\"header-widget-3-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-3-content-font-weight\";s:7:\"inherit\";s:33:\"header-widget-3-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-3-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:38:\"sidebar-widgets-header-widget-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-3-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-3-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-3-link-color\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-3)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-3-link-h-color\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-3-font-family\";s:7:\"inherit\";s:27:\"footer-widget-3-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-3-text-transform\";s:0:\"\";s:27:\"footer-widget-3-line-height\";s:0:\"\";s:25:\"footer-widget-3-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-3-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-3-content-font-weight\";s:7:\"inherit\";s:35:\"footer-widget-3-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"footer-widget-3-content-font-size\";a:6:{s:7:\"desktop\";s:2:\"16\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-3\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:4:\"left\";s:6:\"mobile\";s:4:\"left\";}s:38:\"sidebar-widgets-footer-widget-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:2:\"20\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu3-bg-color\";s:0:\"\";s:18:\"header-menu3-color\";s:0:\"\";s:23:\"header-menu3-h-bg-color\";s:0:\"\";s:20:\"header-menu3-h-color\";s:0:\"\";s:23:\"header-menu3-a-bg-color\";s:0:\"\";s:20:\"header-menu3-a-color\";s:0:\"\";s:30:\"header-menu3-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:29:\"header-menu3-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu3-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu3-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu3-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu3-a-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu3-menu-hover-animation\";s:0:\"\";s:40:\"header-menu3-submenu-container-animation\";s:0:\"\";s:24:\"section-hb-menu-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu3-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu3-submenu-item-border\";b:0;s:32:\"header-menu3-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu3-submenu-item-b-color\";s:7:\"#eaeaea\";s:41:\"header-menu3-submenu-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"header-menu3-submenu-top-offset\";s:0:\"\";s:26:\"header-menu3-submenu-width\";s:0:\"\";s:27:\"header-menu3-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:33:\"header-menu3-menu-stack-on-mobile\";b:1;s:22:\"header-menu3-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu3-font-weight\";s:7:\"inherit\";s:24:\"header-menu3-font-family\";s:7:\"inherit\";s:24:\"header-menu3-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:27:\"section-hb-divider-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button4-text\";s:6:\"Button\";s:26:\"header-button4-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button4-font-family\";s:7:\"inherit\";s:26:\"header-button4-font-weight\";s:7:\"inherit\";s:26:\"header-button4-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"header-button4-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button4-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button4-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button4-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button4-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button4-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button4-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"header-button4-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"header-button4-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-button4-border-radius\";s:0:\"\";s:27:\"section-hb-button-4-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-hb-button-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button4-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button4-text\";s:6:\"Button\";s:26:\"footer-button4-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button4-font-family\";s:7:\"inherit\";s:26:\"footer-button4-font-weight\";s:7:\"inherit\";s:29:\"footer-button4-text-transform\";s:0:\"\";s:26:\"footer-button4-line-height\";s:0:\"\";s:24:\"footer-button4-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button4-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button4-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button4-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button4-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button4-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button4-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button4-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"footer-button4-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button-4-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-4-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-4\";s:22:\"Insert HTML text here.\";s:18:\"header-html-4color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-4link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-4link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-4\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-4\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-4\";s:7:\"inherit\";s:29:\"font-extras-section-hb-html-4\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-hb-html-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-4\";s:22:\"Insert HTML text here.\";s:18:\"footer-html-4color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-4link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-4link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-4\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-4-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-4\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-4\";s:7:\"inherit\";s:29:\"font-extras-section-fb-html-4\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-fb-html-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-4-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-4-bg-space\";s:0:\"\";s:20:\"header-social-4-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"header-social-4-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-4-color\";s:0:\"\";s:23:\"header-social-4-h-color\";s:0:\"\";s:24:\"header-social-4-bg-color\";s:0:\"\";s:26:\"header-social-4-bg-h-color\";s:0:\"\";s:28:\"header-social-4-label-toggle\";b:0;s:26:\"header-social-4-color-type\";s:6:\"custom\";s:34:\"header-social-4-brand-hover-toggle\";b:0;s:35:\"font-size-section-hb-social-icons-4\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-4\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-4-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-4-bg-space\";s:0:\"\";s:20:\"footer-social-4-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-4-radius\";s:0:\"\";s:21:\"footer-social-4-color\";s:0:\"\";s:23:\"footer-social-4-h-color\";s:0:\"\";s:24:\"footer-social-4-bg-color\";s:0:\"\";s:26:\"footer-social-4-bg-h-color\";s:0:\"\";s:28:\"footer-social-4-label-toggle\";b:0;s:26:\"footer-social-4-color-type\";s:6:\"custom\";s:27:\"footer-social-4-brand-color\";s:0:\"\";s:33:\"footer-social-4-brand-label-color\";s:0:\"\";s:34:\"footer-social-4-brand-hover-toggle\";b:0;s:35:\"font-size-section-fb-social-icons-4\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-4\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:25:\"footer-social-4-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:32:\"section-fb-social-icons-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-4-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-4-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-4-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-4-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-4-font-family\";s:7:\"inherit\";s:27:\"header-widget-4-font-weight\";s:7:\"inherit\";s:25:\"header-widget-4-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-4-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:35:\"header-widget-4-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-4-content-font-weight\";s:7:\"inherit\";s:33:\"header-widget-4-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-4-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:38:\"sidebar-widgets-header-widget-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-4-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-4-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-4-link-color\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-3)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-4-link-h-color\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-4-font-family\";s:7:\"inherit\";s:27:\"footer-widget-4-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-4-text-transform\";s:0:\"\";s:27:\"footer-widget-4-line-height\";s:0:\"\";s:25:\"footer-widget-4-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-4-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-4-content-font-weight\";s:7:\"inherit\";s:35:\"footer-widget-4-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"footer-widget-4-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-4\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:4:\"left\";s:6:\"mobile\";s:4:\"left\";}s:38:\"sidebar-widgets-footer-widget-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu4-bg-color\";s:0:\"\";s:18:\"header-menu4-color\";s:0:\"\";s:23:\"header-menu4-h-bg-color\";s:0:\"\";s:20:\"header-menu4-h-color\";s:0:\"\";s:23:\"header-menu4-a-bg-color\";s:0:\"\";s:20:\"header-menu4-a-color\";s:0:\"\";s:30:\"header-menu4-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:29:\"header-menu4-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu4-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu4-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu4-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu4-a-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu4-menu-hover-animation\";s:0:\"\";s:40:\"header-menu4-submenu-container-animation\";s:0:\"\";s:24:\"section-hb-menu-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu4-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu4-submenu-item-border\";b:0;s:32:\"header-menu4-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu4-submenu-item-b-color\";s:7:\"#eaeaea\";s:41:\"header-menu4-submenu-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"header-menu4-submenu-top-offset\";s:0:\"\";s:26:\"header-menu4-submenu-width\";s:0:\"\";s:27:\"header-menu4-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:33:\"header-menu4-menu-stack-on-mobile\";b:1;s:22:\"header-menu4-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu4-font-weight\";s:7:\"inherit\";s:24:\"header-menu4-font-family\";s:7:\"inherit\";s:24:\"header-menu4-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:27:\"section-hb-divider-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button5-text\";s:6:\"Button\";s:26:\"header-button5-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button5-font-family\";s:7:\"inherit\";s:26:\"header-button5-font-weight\";s:7:\"inherit\";s:26:\"header-button5-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"header-button5-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button5-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button5-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button5-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button5-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button5-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button5-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"header-button5-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"header-button5-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-button5-border-radius\";s:0:\"\";s:27:\"section-hb-button-5-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-hb-button-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button5-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button5-text\";s:6:\"Button\";s:26:\"footer-button5-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button5-font-family\";s:7:\"inherit\";s:26:\"footer-button5-font-weight\";s:7:\"inherit\";s:29:\"footer-button5-text-transform\";s:0:\"\";s:26:\"footer-button5-line-height\";s:0:\"\";s:24:\"footer-button5-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button5-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button5-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button5-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button5-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button5-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button5-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button5-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"footer-button5-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button-5-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-5-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-5\";s:22:\"Insert HTML text here.\";s:18:\"header-html-5color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-5link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-5link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-5\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-5\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-5\";s:7:\"inherit\";s:29:\"font-extras-section-hb-html-5\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-hb-html-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-5\";s:22:\"Insert HTML text here.\";s:18:\"footer-html-5color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-5link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-5link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-5\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-5-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-5\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-5\";s:7:\"inherit\";s:29:\"font-extras-section-fb-html-5\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-fb-html-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-5-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-5-bg-space\";s:0:\"\";s:20:\"header-social-5-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"header-social-5-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-5-color\";s:0:\"\";s:23:\"header-social-5-h-color\";s:0:\"\";s:24:\"header-social-5-bg-color\";s:0:\"\";s:26:\"header-social-5-bg-h-color\";s:0:\"\";s:28:\"header-social-5-label-toggle\";b:0;s:26:\"header-social-5-color-type\";s:6:\"custom\";s:34:\"header-social-5-brand-hover-toggle\";b:0;s:35:\"font-size-section-hb-social-icons-5\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-5\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-5-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-5-bg-space\";s:0:\"\";s:20:\"footer-social-5-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-5-radius\";s:0:\"\";s:21:\"footer-social-5-color\";s:0:\"\";s:23:\"footer-social-5-h-color\";s:0:\"\";s:24:\"footer-social-5-bg-color\";s:0:\"\";s:26:\"footer-social-5-bg-h-color\";s:0:\"\";s:28:\"footer-social-5-label-toggle\";b:0;s:26:\"footer-social-5-color-type\";s:6:\"custom\";s:27:\"footer-social-5-brand-color\";s:0:\"\";s:33:\"footer-social-5-brand-label-color\";s:0:\"\";s:34:\"footer-social-5-brand-hover-toggle\";b:0;s:35:\"font-size-section-fb-social-icons-5\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-5\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:25:\"footer-social-5-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:32:\"section-fb-social-icons-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-5-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-5-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-5-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-5-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-5-font-family\";s:7:\"inherit\";s:27:\"header-widget-5-font-weight\";s:7:\"inherit\";s:25:\"header-widget-5-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-5-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:35:\"header-widget-5-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-5-content-font-weight\";s:7:\"inherit\";s:33:\"header-widget-5-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-5-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:38:\"sidebar-widgets-header-widget-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-5-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-5-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-5-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-5-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-5-font-family\";s:7:\"inherit\";s:27:\"footer-widget-5-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-5-text-transform\";s:0:\"\";s:27:\"footer-widget-5-line-height\";s:0:\"\";s:25:\"footer-widget-5-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-5-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-5-content-font-weight\";s:7:\"inherit\";s:35:\"footer-widget-5-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"footer-widget-5-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-5\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:38:\"sidebar-widgets-footer-widget-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu5-bg-color\";s:0:\"\";s:18:\"header-menu5-color\";s:0:\"\";s:23:\"header-menu5-h-bg-color\";s:0:\"\";s:20:\"header-menu5-h-color\";s:0:\"\";s:23:\"header-menu5-a-bg-color\";s:0:\"\";s:20:\"header-menu5-a-color\";s:0:\"\";s:30:\"header-menu5-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:29:\"header-menu5-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu5-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu5-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu5-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu5-a-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu5-menu-hover-animation\";s:0:\"\";s:40:\"header-menu5-submenu-container-animation\";s:0:\"\";s:24:\"section-hb-menu-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu5-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu5-submenu-item-border\";b:0;s:32:\"header-menu5-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu5-submenu-item-b-color\";s:7:\"#eaeaea\";s:41:\"header-menu5-submenu-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"header-menu5-submenu-top-offset\";s:0:\"\";s:26:\"header-menu5-submenu-width\";s:0:\"\";s:27:\"header-menu5-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:33:\"header-menu5-menu-stack-on-mobile\";b:1;s:22:\"header-menu5-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu5-font-weight\";s:7:\"inherit\";s:24:\"header-menu5-font-family\";s:7:\"inherit\";s:24:\"header-menu5-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:27:\"section-hb-divider-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button6-text\";s:6:\"Button\";s:26:\"header-button6-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button6-font-family\";s:7:\"inherit\";s:26:\"header-button6-font-weight\";s:7:\"inherit\";s:26:\"header-button6-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"header-button6-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button6-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button6-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button6-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button6-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button6-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button6-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"header-button6-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"header-button6-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-button6-border-radius\";s:0:\"\";s:27:\"section-hb-button-6-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-hb-button-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button6-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button6-text\";s:6:\"Button\";s:26:\"footer-button6-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button6-font-family\";s:7:\"inherit\";s:26:\"footer-button6-font-weight\";s:7:\"inherit\";s:29:\"footer-button6-text-transform\";s:0:\"\";s:26:\"footer-button6-line-height\";s:0:\"\";s:24:\"footer-button6-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button6-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button6-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button6-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button6-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button6-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button6-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button6-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"footer-button6-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button-6-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-6-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-6\";s:22:\"Insert HTML text here.\";s:18:\"header-html-6color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-6link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-6link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-6\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-6\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-6\";s:7:\"inherit\";s:29:\"font-extras-section-hb-html-6\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-hb-html-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-6\";s:22:\"Insert HTML text here.\";s:18:\"footer-html-6color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-6link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-6link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-6\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-6-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-6\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-6\";s:7:\"inherit\";s:29:\"font-extras-section-fb-html-6\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-fb-html-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-6-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-6-bg-space\";s:0:\"\";s:20:\"header-social-6-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"header-social-6-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-6-color\";s:0:\"\";s:23:\"header-social-6-h-color\";s:0:\"\";s:24:\"header-social-6-bg-color\";s:0:\"\";s:26:\"header-social-6-bg-h-color\";s:0:\"\";s:28:\"header-social-6-label-toggle\";b:0;s:26:\"header-social-6-color-type\";s:6:\"custom\";s:34:\"header-social-6-brand-hover-toggle\";b:0;s:35:\"font-size-section-hb-social-icons-6\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-6\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-6-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-6-bg-space\";s:0:\"\";s:20:\"footer-social-6-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-6-radius\";s:0:\"\";s:21:\"footer-social-6-color\";s:0:\"\";s:23:\"footer-social-6-h-color\";s:0:\"\";s:24:\"footer-social-6-bg-color\";s:0:\"\";s:26:\"footer-social-6-bg-h-color\";s:0:\"\";s:28:\"footer-social-6-label-toggle\";b:0;s:26:\"footer-social-6-color-type\";s:6:\"custom\";s:27:\"footer-social-6-brand-color\";s:0:\"\";s:33:\"footer-social-6-brand-label-color\";s:0:\"\";s:34:\"footer-social-6-brand-hover-toggle\";b:0;s:35:\"font-size-section-fb-social-icons-6\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-6\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:25:\"footer-social-6-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:32:\"section-fb-social-icons-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-6-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-6-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-6-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-6-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-6-font-family\";s:7:\"inherit\";s:27:\"header-widget-6-font-weight\";s:7:\"inherit\";s:25:\"header-widget-6-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-6-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:35:\"header-widget-6-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-6-content-font-weight\";s:7:\"inherit\";s:33:\"header-widget-6-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-6-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:38:\"sidebar-widgets-header-widget-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-6-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-6-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-6-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-6-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-6-font-family\";s:7:\"inherit\";s:27:\"footer-widget-6-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-6-text-transform\";s:0:\"\";s:27:\"footer-widget-6-line-height\";s:0:\"\";s:25:\"footer-widget-6-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-6-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-6-content-font-weight\";s:7:\"inherit\";s:35:\"footer-widget-6-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"footer-widget-6-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-6\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:38:\"sidebar-widgets-footer-widget-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu6-bg-color\";s:0:\"\";s:18:\"header-menu6-color\";s:0:\"\";s:23:\"header-menu6-h-bg-color\";s:0:\"\";s:20:\"header-menu6-h-color\";s:0:\"\";s:23:\"header-menu6-a-bg-color\";s:0:\"\";s:20:\"header-menu6-a-color\";s:0:\"\";s:30:\"header-menu6-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:29:\"header-menu6-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu6-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu6-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu6-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu6-a-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu6-menu-hover-animation\";s:0:\"\";s:40:\"header-menu6-submenu-container-animation\";s:0:\"\";s:24:\"section-hb-menu-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu6-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu6-submenu-item-border\";b:0;s:32:\"header-menu6-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu6-submenu-item-b-color\";s:7:\"#eaeaea\";s:41:\"header-menu6-submenu-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"header-menu6-submenu-top-offset\";s:0:\"\";s:26:\"header-menu6-submenu-width\";s:0:\"\";s:27:\"header-menu6-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:33:\"header-menu6-menu-stack-on-mobile\";b:1;s:22:\"header-menu6-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu6-font-weight\";s:7:\"inherit\";s:24:\"header-menu6-font-family\";s:7:\"inherit\";s:24:\"header-menu6-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:27:\"section-hb-divider-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button7-text\";s:6:\"Button\";s:26:\"header-button7-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button7-font-family\";s:7:\"inherit\";s:26:\"header-button7-font-weight\";s:7:\"inherit\";s:26:\"header-button7-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"header-button7-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button7-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button7-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button7-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button7-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button7-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button7-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"header-button7-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"header-button7-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-button7-border-radius\";s:0:\"\";s:27:\"section-hb-button-7-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-hb-button-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button7-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button7-text\";s:6:\"Button\";s:26:\"footer-button7-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button7-font-family\";s:7:\"inherit\";s:26:\"footer-button7-font-weight\";s:7:\"inherit\";s:29:\"footer-button7-text-transform\";s:0:\"\";s:26:\"footer-button7-line-height\";s:0:\"\";s:24:\"footer-button7-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button7-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button7-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button7-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button7-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button7-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button7-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button7-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"footer-button7-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button-7-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-7-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-7\";s:22:\"Insert HTML text here.\";s:18:\"header-html-7color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-7link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-7link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-7\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-7\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-7\";s:7:\"inherit\";s:29:\"font-extras-section-hb-html-7\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-hb-html-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-7\";s:22:\"Insert HTML text here.\";s:18:\"footer-html-7color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-7link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-7link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-7\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-7-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-7\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-7\";s:7:\"inherit\";s:29:\"font-extras-section-fb-html-7\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-fb-html-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-7-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-7-bg-space\";s:0:\"\";s:20:\"header-social-7-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"header-social-7-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-7-color\";s:0:\"\";s:23:\"header-social-7-h-color\";s:0:\"\";s:24:\"header-social-7-bg-color\";s:0:\"\";s:26:\"header-social-7-bg-h-color\";s:0:\"\";s:28:\"header-social-7-label-toggle\";b:0;s:26:\"header-social-7-color-type\";s:6:\"custom\";s:34:\"header-social-7-brand-hover-toggle\";b:0;s:35:\"font-size-section-hb-social-icons-7\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-7\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-7-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-7-bg-space\";s:0:\"\";s:20:\"footer-social-7-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-7-radius\";s:0:\"\";s:21:\"footer-social-7-color\";s:0:\"\";s:23:\"footer-social-7-h-color\";s:0:\"\";s:24:\"footer-social-7-bg-color\";s:0:\"\";s:26:\"footer-social-7-bg-h-color\";s:0:\"\";s:28:\"footer-social-7-label-toggle\";b:0;s:26:\"footer-social-7-color-type\";s:6:\"custom\";s:27:\"footer-social-7-brand-color\";s:0:\"\";s:33:\"footer-social-7-brand-label-color\";s:0:\"\";s:34:\"footer-social-7-brand-hover-toggle\";b:0;s:35:\"font-size-section-fb-social-icons-7\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-7\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:25:\"footer-social-7-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:32:\"section-fb-social-icons-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-7-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-7-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-7-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-7-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-7-font-family\";s:7:\"inherit\";s:27:\"header-widget-7-font-weight\";s:7:\"inherit\";s:25:\"header-widget-7-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-7-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:35:\"header-widget-7-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-7-content-font-weight\";s:7:\"inherit\";s:33:\"header-widget-7-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-7-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:38:\"sidebar-widgets-header-widget-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-7-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-7-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-7-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-7-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-7-font-family\";s:7:\"inherit\";s:27:\"footer-widget-7-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-7-text-transform\";s:0:\"\";s:27:\"footer-widget-7-line-height\";s:0:\"\";s:25:\"footer-widget-7-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-7-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-7-content-font-weight\";s:7:\"inherit\";s:35:\"footer-widget-7-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"footer-widget-7-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-7\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:38:\"sidebar-widgets-footer-widget-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu7-bg-color\";s:0:\"\";s:18:\"header-menu7-color\";s:0:\"\";s:23:\"header-menu7-h-bg-color\";s:0:\"\";s:20:\"header-menu7-h-color\";s:0:\"\";s:23:\"header-menu7-a-bg-color\";s:0:\"\";s:20:\"header-menu7-a-color\";s:0:\"\";s:30:\"header-menu7-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:29:\"header-menu7-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu7-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu7-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu7-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu7-a-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu7-menu-hover-animation\";s:0:\"\";s:40:\"header-menu7-submenu-container-animation\";s:0:\"\";s:24:\"section-hb-menu-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu7-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu7-submenu-item-border\";b:0;s:32:\"header-menu7-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu7-submenu-item-b-color\";s:7:\"#eaeaea\";s:41:\"header-menu7-submenu-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"header-menu7-submenu-top-offset\";s:0:\"\";s:26:\"header-menu7-submenu-width\";s:0:\"\";s:27:\"header-menu7-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:33:\"header-menu7-menu-stack-on-mobile\";b:1;s:22:\"header-menu7-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu7-font-weight\";s:7:\"inherit\";s:24:\"header-menu7-font-family\";s:7:\"inherit\";s:24:\"header-menu7-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:27:\"section-hb-divider-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button8-text\";s:6:\"Button\";s:26:\"header-button8-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button8-font-family\";s:7:\"inherit\";s:26:\"header-button8-font-weight\";s:7:\"inherit\";s:26:\"header-button8-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"header-button8-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button8-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button8-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button8-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button8-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button8-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button8-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"header-button8-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"header-button8-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-button8-border-radius\";s:0:\"\";s:27:\"section-hb-button-8-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-hb-button-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button8-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button8-text\";s:6:\"Button\";s:26:\"footer-button8-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button8-font-family\";s:7:\"inherit\";s:26:\"footer-button8-font-weight\";s:7:\"inherit\";s:29:\"footer-button8-text-transform\";s:0:\"\";s:26:\"footer-button8-line-height\";s:0:\"\";s:24:\"footer-button8-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button8-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button8-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button8-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button8-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button8-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button8-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button8-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"footer-button8-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button-8-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-8-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-8\";s:22:\"Insert HTML text here.\";s:18:\"header-html-8color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-8link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-8link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-8\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-8\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-8\";s:7:\"inherit\";s:29:\"font-extras-section-hb-html-8\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-hb-html-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-8\";s:22:\"Insert HTML text here.\";s:18:\"footer-html-8color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-8link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-8link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-8\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-8-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-8\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-8\";s:7:\"inherit\";s:29:\"font-extras-section-fb-html-8\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-fb-html-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-8-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-8-bg-space\";s:0:\"\";s:20:\"header-social-8-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"header-social-8-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-8-color\";s:0:\"\";s:23:\"header-social-8-h-color\";s:0:\"\";s:24:\"header-social-8-bg-color\";s:0:\"\";s:26:\"header-social-8-bg-h-color\";s:0:\"\";s:28:\"header-social-8-label-toggle\";b:0;s:26:\"header-social-8-color-type\";s:6:\"custom\";s:34:\"header-social-8-brand-hover-toggle\";b:0;s:35:\"font-size-section-hb-social-icons-8\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-8\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-8-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-8-bg-space\";s:0:\"\";s:20:\"footer-social-8-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-8-radius\";s:0:\"\";s:21:\"footer-social-8-color\";s:0:\"\";s:23:\"footer-social-8-h-color\";s:0:\"\";s:24:\"footer-social-8-bg-color\";s:0:\"\";s:26:\"footer-social-8-bg-h-color\";s:0:\"\";s:28:\"footer-social-8-label-toggle\";b:0;s:26:\"footer-social-8-color-type\";s:6:\"custom\";s:27:\"footer-social-8-brand-color\";s:0:\"\";s:33:\"footer-social-8-brand-label-color\";s:0:\"\";s:34:\"footer-social-8-brand-hover-toggle\";b:0;s:35:\"font-size-section-fb-social-icons-8\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-8\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:25:\"footer-social-8-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:32:\"section-fb-social-icons-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-8-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-8-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-8-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-8-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-8-font-family\";s:7:\"inherit\";s:27:\"header-widget-8-font-weight\";s:7:\"inherit\";s:25:\"header-widget-8-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-8-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:35:\"header-widget-8-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-8-content-font-weight\";s:7:\"inherit\";s:33:\"header-widget-8-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-8-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:38:\"sidebar-widgets-header-widget-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-8-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-8-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-8-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-8-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-8-font-family\";s:7:\"inherit\";s:27:\"footer-widget-8-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-8-text-transform\";s:0:\"\";s:27:\"footer-widget-8-line-height\";s:0:\"\";s:25:\"footer-widget-8-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-8-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-8-content-font-weight\";s:7:\"inherit\";s:35:\"footer-widget-8-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"footer-widget-8-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-8\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:38:\"sidebar-widgets-footer-widget-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu8-bg-color\";s:0:\"\";s:18:\"header-menu8-color\";s:0:\"\";s:23:\"header-menu8-h-bg-color\";s:0:\"\";s:20:\"header-menu8-h-color\";s:0:\"\";s:23:\"header-menu8-a-bg-color\";s:0:\"\";s:20:\"header-menu8-a-color\";s:0:\"\";s:30:\"header-menu8-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:29:\"header-menu8-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu8-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu8-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu8-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu8-a-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu8-menu-hover-animation\";s:0:\"\";s:40:\"header-menu8-submenu-container-animation\";s:0:\"\";s:24:\"section-hb-menu-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu8-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu8-submenu-item-border\";b:0;s:32:\"header-menu8-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu8-submenu-item-b-color\";s:7:\"#eaeaea\";s:41:\"header-menu8-submenu-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"header-menu8-submenu-top-offset\";s:0:\"\";s:26:\"header-menu8-submenu-width\";s:0:\"\";s:27:\"header-menu8-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:33:\"header-menu8-menu-stack-on-mobile\";b:1;s:22:\"header-menu8-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu8-font-weight\";s:7:\"inherit\";s:24:\"header-menu8-font-family\";s:7:\"inherit\";s:24:\"header-menu8-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:27:\"section-hb-divider-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button9-text\";s:6:\"Button\";s:26:\"header-button9-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button9-font-family\";s:7:\"inherit\";s:26:\"header-button9-font-weight\";s:7:\"inherit\";s:26:\"header-button9-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"header-button9-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button9-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button9-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button9-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button9-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button9-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button9-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"header-button9-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"header-button9-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-button9-border-radius\";s:0:\"\";s:27:\"section-hb-button-9-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-hb-button-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button9-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button9-text\";s:6:\"Button\";s:26:\"footer-button9-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button9-font-family\";s:7:\"inherit\";s:26:\"footer-button9-font-weight\";s:7:\"inherit\";s:29:\"footer-button9-text-transform\";s:0:\"\";s:26:\"footer-button9-line-height\";s:0:\"\";s:24:\"footer-button9-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button9-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button9-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button9-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button9-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button9-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button9-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button9-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"footer-button9-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button-9-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-9-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-9\";s:22:\"Insert HTML text here.\";s:18:\"header-html-9color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-9link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-9link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-9\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-9\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-9\";s:7:\"inherit\";s:29:\"font-extras-section-hb-html-9\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-hb-html-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-9\";s:22:\"Insert HTML text here.\";s:18:\"footer-html-9color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-9link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-9link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-9\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-9-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-9\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-9\";s:7:\"inherit\";s:29:\"font-extras-section-fb-html-9\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-fb-html-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-9-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-9-bg-space\";s:0:\"\";s:20:\"header-social-9-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"header-social-9-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-9-color\";s:0:\"\";s:23:\"header-social-9-h-color\";s:0:\"\";s:24:\"header-social-9-bg-color\";s:0:\"\";s:26:\"header-social-9-bg-h-color\";s:0:\"\";s:28:\"header-social-9-label-toggle\";b:0;s:26:\"header-social-9-color-type\";s:6:\"custom\";s:34:\"header-social-9-brand-hover-toggle\";b:0;s:35:\"font-size-section-hb-social-icons-9\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-9\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-9-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-9-bg-space\";s:0:\"\";s:20:\"footer-social-9-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-9-radius\";s:0:\"\";s:21:\"footer-social-9-color\";s:0:\"\";s:23:\"footer-social-9-h-color\";s:0:\"\";s:24:\"footer-social-9-bg-color\";s:0:\"\";s:26:\"footer-social-9-bg-h-color\";s:0:\"\";s:28:\"footer-social-9-label-toggle\";b:0;s:26:\"footer-social-9-color-type\";s:6:\"custom\";s:27:\"footer-social-9-brand-color\";s:0:\"\";s:33:\"footer-social-9-brand-label-color\";s:0:\"\";s:34:\"footer-social-9-brand-hover-toggle\";b:0;s:35:\"font-size-section-fb-social-icons-9\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-9\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:25:\"footer-social-9-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:32:\"section-fb-social-icons-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-9-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-9-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-9-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-9-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-9-font-family\";s:7:\"inherit\";s:27:\"header-widget-9-font-weight\";s:7:\"inherit\";s:25:\"header-widget-9-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-9-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:35:\"header-widget-9-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-9-content-font-weight\";s:7:\"inherit\";s:33:\"header-widget-9-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-9-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:38:\"sidebar-widgets-header-widget-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-9-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-9-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-9-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-9-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-9-font-family\";s:7:\"inherit\";s:27:\"footer-widget-9-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-9-text-transform\";s:0:\"\";s:27:\"footer-widget-9-line-height\";s:0:\"\";s:25:\"footer-widget-9-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-9-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-9-content-font-weight\";s:7:\"inherit\";s:35:\"footer-widget-9-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"footer-widget-9-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-9\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:38:\"sidebar-widgets-footer-widget-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu9-bg-color\";s:0:\"\";s:18:\"header-menu9-color\";s:0:\"\";s:23:\"header-menu9-h-bg-color\";s:0:\"\";s:20:\"header-menu9-h-color\";s:0:\"\";s:23:\"header-menu9-a-bg-color\";s:0:\"\";s:20:\"header-menu9-a-color\";s:0:\"\";s:30:\"header-menu9-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:29:\"header-menu9-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu9-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu9-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu9-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu9-a-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu9-menu-hover-animation\";s:0:\"\";s:40:\"header-menu9-submenu-container-animation\";s:0:\"\";s:24:\"section-hb-menu-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu9-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu9-submenu-item-border\";b:0;s:32:\"header-menu9-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu9-submenu-item-b-color\";s:7:\"#eaeaea\";s:41:\"header-menu9-submenu-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"header-menu9-submenu-top-offset\";s:0:\"\";s:26:\"header-menu9-submenu-width\";s:0:\"\";s:27:\"header-menu9-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:33:\"header-menu9-menu-stack-on-mobile\";b:1;s:22:\"header-menu9-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu9-font-weight\";s:7:\"inherit\";s:24:\"header-menu9-font-family\";s:7:\"inherit\";s:24:\"header-menu9-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:27:\"section-hb-divider-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:20:\"header-button10-text\";s:6:\"Button\";s:27:\"header-button10-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:27:\"header-button10-font-family\";s:7:\"inherit\";s:27:\"header-button10-font-weight\";s:7:\"inherit\";s:27:\"header-button10-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:25:\"header-button10-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button10-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-button10-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-button10-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-button10-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-button10-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-button10-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:28:\"header-button10-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:36:\"header-button10-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"header-button10-border-radius\";s:0:\"\";s:28:\"section-hb-button-10-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-hb-button-10-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:30:\"sticky-header-button10-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:20:\"footer-button10-text\";s:6:\"Button\";s:27:\"footer-button10-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:27:\"footer-button10-font-family\";s:7:\"inherit\";s:27:\"footer-button10-font-weight\";s:7:\"inherit\";s:30:\"footer-button10-text-transform\";s:0:\"\";s:27:\"footer-button10-line-height\";s:0:\"\";s:25:\"footer-button10-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button10-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-button10-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-button10-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-button10-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-button10-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-button10-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:28:\"footer-button10-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:36:\"footer-button10-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button-10-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:28:\"section-fb-button-10-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-button-10-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:14:\"header-html-10\";s:22:\"Insert HTML text here.\";s:19:\"header-html-10color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-html-10link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-html-10link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"font-size-section-hb-html-10\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:30:\"font-weight-section-hb-html-10\";s:7:\"inherit\";s:30:\"font-family-section-hb-html-10\";s:7:\"inherit\";s:30:\"font-extras-section-hb-html-10\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:25:\"section-hb-html-10-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:14:\"footer-html-10\";s:22:\"Insert HTML text here.\";s:19:\"footer-html-10color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-html-10link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-html-10link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"font-size-section-fb-html-10\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"footer-html-10-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:30:\"font-weight-section-fb-html-10\";s:7:\"inherit\";s:30:\"font-family-section-fb-html-10\";s:7:\"inherit\";s:30:\"font-extras-section-fb-html-10\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:25:\"section-fb-html-10-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:22:\"header-social-10-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-social-10-bg-space\";s:0:\"\";s:21:\"header-social-10-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:30:\"header-social-10-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:22:\"header-social-10-color\";s:0:\"\";s:24:\"header-social-10-h-color\";s:0:\"\";s:25:\"header-social-10-bg-color\";s:0:\"\";s:27:\"header-social-10-bg-h-color\";s:0:\"\";s:29:\"header-social-10-label-toggle\";b:0;s:27:\"header-social-10-color-type\";s:6:\"custom\";s:35:\"header-social-10-brand-hover-toggle\";b:0;s:36:\"font-size-section-hb-social-icons-10\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:22:\"header-social-icons-10\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:33:\"section-hb-social-icons-10-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:22:\"footer-social-10-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-social-10-bg-space\";s:0:\"\";s:21:\"footer-social-10-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-social-10-radius\";s:0:\"\";s:22:\"footer-social-10-color\";s:0:\"\";s:24:\"footer-social-10-h-color\";s:0:\"\";s:25:\"footer-social-10-bg-color\";s:0:\"\";s:27:\"footer-social-10-bg-h-color\";s:0:\"\";s:29:\"footer-social-10-label-toggle\";b:0;s:27:\"footer-social-10-color-type\";s:6:\"custom\";s:28:\"footer-social-10-brand-color\";s:0:\"\";s:34:\"footer-social-10-brand-label-color\";s:0:\"\";s:35:\"footer-social-10-brand-hover-toggle\";b:0;s:36:\"font-size-section-fb-social-icons-10\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:22:\"footer-social-icons-10\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:26:\"footer-social-10-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:33:\"section-fb-social-icons-10-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-widget-10-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-widget-10-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-10-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"header-widget-10-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-10-font-family\";s:7:\"inherit\";s:28:\"header-widget-10-font-weight\";s:7:\"inherit\";s:26:\"header-widget-10-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-widget-10-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:36:\"header-widget-10-content-font-family\";s:7:\"inherit\";s:36:\"header-widget-10-content-font-weight\";s:7:\"inherit\";s:34:\"header-widget-10-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:36:\"header-widget-10-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:39:\"sidebar-widgets-header-widget-10-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"footer-widget-10-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-widget-10-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-10-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"footer-widget-10-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-10-font-family\";s:7:\"inherit\";s:28:\"footer-widget-10-font-weight\";s:7:\"inherit\";s:31:\"footer-widget-10-text-transform\";s:0:\"\";s:28:\"footer-widget-10-line-height\";s:0:\"\";s:26:\"footer-widget-10-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:36:\"footer-widget-10-content-font-family\";s:7:\"inherit\";s:36:\"footer-widget-10-content-font-weight\";s:7:\"inherit\";s:36:\"footer-widget-10-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:34:\"footer-widget-10-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-widget-alignment-10\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:39:\"sidebar-widgets-footer-widget-10-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:22:\"header-menu10-bg-color\";s:0:\"\";s:19:\"header-menu10-color\";s:0:\"\";s:24:\"header-menu10-h-bg-color\";s:0:\"\";s:21:\"header-menu10-h-color\";s:0:\"\";s:24:\"header-menu10-a-bg-color\";s:0:\"\";s:21:\"header-menu10-a-color\";s:0:\"\";s:31:\"header-menu10-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scr